/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx.model;

import java.util.Set;
import javax.management.ObjectName;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.jmx.model.ResourceAccessControlUtil;

class RootResourceIterator<T> {
    private final ResourceAccessControlUtil accessControlUtil;
    private final Resource rootResource;
    private final ResourceAction<T> action;

    RootResourceIterator(ResourceAccessControlUtil accessControlUtil, Resource rootResource, ResourceAction<T> action) {
        this.accessControlUtil = accessControlUtil;
        this.rootResource = rootResource;
        this.action = action;
    }

    T iterate() {
        this.doIterate(this.rootResource, PathAddress.EMPTY_ADDRESS);
        return this.action.getResult();
    }

    private void doIterate(Resource current, PathAddress address) {
        boolean handleChildren = false;
        ObjectName resourceObjectName = this.action.onAddress(address);
        if (resourceObjectName != null && this.accessControlUtil.getResourceAccess(address, false).isAccessibleResource()) {
            handleChildren = this.action.onResource(resourceObjectName);
        }
        if (handleChildren) {
            for (String type : current.getChildTypes()) {
                Set children = current.getChildren(type);
                if (children == null) continue;
                for (Resource.ResourceEntry entry : children) {
                    PathElement pathElement = entry.getPathElement();
                    PathAddress childAddress = address.append(new PathElement[]{pathElement});
                    this.doIterate((Resource)entry, childAddress);
                }
            }
        }
    }

    static interface ResourceAction<T> {
        public ObjectName onAddress(PathAddress var1);

        public boolean onResource(ObjectName var1);

        public T getResult();
    }
}

