package org.wildfly.core.launcher.logger;

import java.util.Locale;
import java.nio.file.Path;
import java.io.Serializable;
import javax.annotation.Generated;
import java.lang.CharSequence;
import java.lang.String;
import java.util.Arrays;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageBundleImplementor", date = "2020-01-08T13:18:10+0000")
public class LauncherMessages_$bundle implements LauncherMessages, Serializable {
    private static final long serialVersionUID = 1L;
    protected LauncherMessages_$bundle() {}
    public static final LauncherMessages_$bundle INSTANCE = new LauncherMessages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String pathDoesNotExist$str() {
        return "WFLYLNCHR0001: The path '%s' does not exist";
    }
    @Override
    public final IllegalArgumentException pathDoesNotExist(final Path path) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), pathDoesNotExist$str(), path));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String invalidDirectory1$str() {
        return "WFLYLNCHR0002: The directory '%s' is not a valid directory";
    }
    @Override
    public final IllegalArgumentException invalidDirectory(final Path dir) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidDirectory1$str(), dir));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidDirectory2$str() {
        return "WFLYLNCHR0003: Invalid directory, could not find '%s' in '%s'";
    }
    @Override
    public final IllegalArgumentException invalidDirectory(final String filename, final Path dir) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidDirectory2$str(), filename, dir));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String pathNotAFile$str() {
        return "WFLYLNCHR0004: Path '%s' is not a regular file.";
    }
    @Override
    public final IllegalArgumentException pathNotAFile(final Path path) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), pathNotAFile$str(), path));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullParam$str() {
        return "WFLYLNCHR0005: The parameter %s cannot be null.";
    }
    @Override
    public final IllegalArgumentException nullParam(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullParam$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidHostname$str() {
        return "WFLYLNCHR0006: Invalid hostname: %s";
    }
    @Override
    public final IllegalArgumentException invalidHostname(final CharSequence hostname) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidHostname$str(), hostname));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
