/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.launcher;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.wildfly.core.launcher.AbstractCommandBuilder;
import org.wildfly.core.launcher.Arguments;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.logger.LauncherMessages;

public class StandaloneCommandBuilder
extends AbstractCommandBuilder<StandaloneCommandBuilder>
implements CommandBuilder {
    static final String DEBUG_FORMAT = "-agentlib:jdwp=transport=dt_socket,server=y,suspend=%s,address=%d";
    private static final String SERVER_BASE_DIR = "jboss.server.base.dir";
    private static final String SERVER_CONFIG_DIR = "jboss.server.config.dir";
    private static final String SERVER_LOG_DIR = "jboss.server.log.dir";
    private Path baseDir;
    private final Arguments javaOpts = new Arguments();
    private String debugArg;
    private String modulesLocklessArg;
    private String modulesMetricsArg;
    private final Map<String, String> securityProperties;

    private StandaloneCommandBuilder(Path wildflyHome) {
        super(wildflyHome);
        this.javaOpts.addAll(DEFAULT_VM_ARGUMENTS);
        this.securityProperties = new LinkedHashMap<String, String>();
    }

    public static StandaloneCommandBuilder of(Path wildflyHome) {
        return new StandaloneCommandBuilder(StandaloneCommandBuilder.validateWildFlyDir(wildflyHome));
    }

    public static StandaloneCommandBuilder of(String wildflyHome) {
        return new StandaloneCommandBuilder(StandaloneCommandBuilder.validateWildFlyDir(wildflyHome));
    }

    public StandaloneCommandBuilder addJavaOption(String jvmArg) {
        if (jvmArg != null && !jvmArg.trim().isEmpty()) {
            Arguments.Argument argument = Arguments.parse(jvmArg);
            switch (argument.getKey()) {
                case "jboss.server.base.dir": {
                    if (argument.getValue() == null) break;
                    this.setBaseDirectory(argument.getValue());
                    break;
                }
                case "jboss.server.config.dir": {
                    if (argument.getValue() == null) break;
                    this.setConfigurationDirectory(argument.getValue());
                    break;
                }
                case "jboss.server.log.dir": {
                    if (argument.getValue() == null) break;
                    this.setLogDirectory(argument.getValue());
                    break;
                }
                case "java.security.manager": {
                    this.setUseSecurityManager(true);
                    break;
                }
                default: {
                    this.javaOpts.add(argument);
                }
            }
        }
        return this;
    }

    public StandaloneCommandBuilder addJavaOptions(String ... javaOpts) {
        if (javaOpts != null) {
            for (String javaOpt : javaOpts) {
                this.addJavaOption(javaOpt);
            }
        }
        return this;
    }

    public StandaloneCommandBuilder addJavaOptions(Iterable<String> javaOpts) {
        if (javaOpts != null) {
            for (String javaOpt : javaOpts) {
                this.addJavaOption(javaOpt);
            }
        }
        return this;
    }

    public StandaloneCommandBuilder setJavaOptions(Iterable<String> javaOpts) {
        this.javaOpts.clear();
        return this.addJavaOptions(javaOpts);
    }

    public StandaloneCommandBuilder setJavaOptions(String ... javaOpts) {
        this.javaOpts.clear();
        return this.addJavaOptions(javaOpts);
    }

    public List<String> getJavaOptions() {
        return this.javaOpts.asList();
    }

    public StandaloneCommandBuilder setDebug() {
        return this.setDebug(false, 8787);
    }

    public StandaloneCommandBuilder setDebug(int port) {
        return this.setDebug(false, port);
    }

    public StandaloneCommandBuilder setDebug(boolean suspend, int port) {
        this.debugArg = String.format(DEBUG_FORMAT, suspend ? "y" : "n", port);
        return this;
    }

    public StandaloneCommandBuilder setBaseDirectory(String baseDir) {
        this.baseDir = StandaloneCommandBuilder.validateAndNormalizeDir(baseDir, true);
        return this;
    }

    public StandaloneCommandBuilder setBaseDirectory(Path baseDir) {
        this.baseDir = StandaloneCommandBuilder.validateAndNormalizeDir(baseDir, true);
        return this;
    }

    public StandaloneCommandBuilder setJavaHome(String javaHome) {
        this.environment.setJavaHome(javaHome);
        return this;
    }

    public StandaloneCommandBuilder setJavaHome(Path javaHome) {
        this.environment.setJavaHome(javaHome);
        return this;
    }

    public StandaloneCommandBuilder setModulesLockless(boolean b) {
        this.modulesLocklessArg = b ? "-Djboss.modules.lockless=true" : null;
        return this;
    }

    public StandaloneCommandBuilder setModulesMetrics(boolean b) {
        this.modulesMetricsArg = b ? "-Djboss.modules.metrics=true" : null;
        return this;
    }

    public StandaloneCommandBuilder setServerConfiguration(String configFile) {
        this.setSingleServerArg("-c", configFile);
        return this;
    }

    public String getServerConfiguration() {
        return this.getServerArg("-c");
    }

    public StandaloneCommandBuilder setServerReadOnlyConfiguration(String configFile) {
        this.setSingleServerArg("--read-only-server-config", configFile);
        return this;
    }

    public String getReadOnlyServerConfiguration() {
        return this.getServerArg("--read-only-server-config");
    }

    public StandaloneCommandBuilder addSecurityProperty(String key) {
        this.securityProperties.put(key, null);
        return this;
    }

    public StandaloneCommandBuilder addSecurityProperty(String key, String value) {
        this.securityProperties.put(key, value);
        return this;
    }

    public StandaloneCommandBuilder addSecurityProperties(Map<String, String> properties) {
        this.securityProperties.putAll(properties);
        return this;
    }

    public StandaloneCommandBuilder setGitRepository(String gitRepository, String gitBranch, String gitAuthentication) {
        if (gitRepository == null) {
            throw LauncherMessages.MESSAGES.nullParam("git-repo");
        }
        this.addServerArg("--git-repo", gitRepository);
        if (gitBranch != null) {
            this.addServerArg("--git-branch", gitBranch);
        }
        if (gitAuthentication != null) {
            this.addServerArg("--git-auth", gitAuthentication);
        }
        return this;
    }

    @Override
    public List<String> buildArguments() {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("-D[Standalone]");
        cmd.addAll(this.getJavaOptions());
        if (this.modulesLocklessArg != null) {
            cmd.add(this.modulesLocklessArg);
        }
        if (this.modulesMetricsArg != null) {
            cmd.add(this.modulesMetricsArg);
        }
        if (this.debugArg != null) {
            cmd.add(this.debugArg);
        }
        cmd.add(this.getBootLogArgument("server.log"));
        cmd.add(this.getLoggingPropertiesArgument("logging.properties"));
        cmd.add("-jar");
        cmd.add(this.getModulesJarName());
        if (this.useSecurityManager()) {
            cmd.add("-secmgr");
        }
        cmd.add("-mp");
        cmd.add(this.getModulePaths());
        cmd.add("org.jboss.as.standalone");
        StandaloneCommandBuilder.addSystemPropertyArg(cmd, "jboss.home.dir", this.getWildFlyHome());
        StandaloneCommandBuilder.addSystemPropertyArg(cmd, SERVER_BASE_DIR, this.getBaseDirectory());
        StandaloneCommandBuilder.addSystemPropertyArg(cmd, SERVER_LOG_DIR, this.getLogDirectory());
        StandaloneCommandBuilder.addSystemPropertyArg(cmd, SERVER_CONFIG_DIR, this.getConfigurationDirectory());
        StringBuilder sb = new StringBuilder(64);
        for (Map.Entry<String, String> entry : this.securityProperties.entrySet()) {
            sb.append("-S").append(entry.getKey());
            if (entry.getValue() != null) {
                sb.append('=').append(entry.getValue());
            }
            cmd.add(sb.toString());
            sb.setLength(0);
        }
        cmd.addAll(this.getServerArguments());
        return cmd;
    }

    @Override
    public List<String> build() {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.getJavaCommand());
        cmd.addAll(this.buildArguments());
        return cmd;
    }

    @Override
    public Path getJavaHome() {
        return this.environment.getJavaHome();
    }

    @Override
    public Path getBaseDirectory() {
        if (this.baseDir == null) {
            return this.normalizePath("standalone");
        }
        return this.baseDir;
    }

    @Override
    protected StandaloneCommandBuilder getThis() {
        return this;
    }

    @Override
    boolean addServerArgument(Arguments.Argument argument) {
        switch (argument.getKey()) {
            case "jboss.server.base.dir": {
                if (argument.getValue() == null) break;
                this.setBaseDirectory(argument.getValue());
                return false;
            }
            case "jboss.server.config.dir": {
                if (argument.getValue() == null) break;
                this.setConfigurationDirectory(argument.getValue());
                return false;
            }
            case "jboss.server.log.dir": {
                if (argument.getValue() == null) break;
                this.setLogDirectory(argument.getValue());
                return false;
            }
        }
        return true;
    }
}

