/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model.test;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.persistence.AbstractConfigurationPersister;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.ModelMarshallingContext;
import org.jboss.as.controller.persistence.NullConfigurationPersister;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementWriter;

public class StringConfigurationPersister
extends AbstractConfigurationPersister {
    private final List<ModelNode> bootOperations;
    private final boolean persistXml;
    volatile String marshalled;

    public StringConfigurationPersister(List<ModelNode> bootOperations, XMLElementWriter<ModelMarshallingContext> rootDeparser, boolean persistXml) {
        super(rootDeparser);
        this.bootOperations = bootOperations;
        this.persistXml = persistXml;
    }

    public ConfigurationPersister.PersistenceResource store(ModelNode model, Set<PathAddress> affectedAddresses) throws ConfigurationPersistenceException {
        if (!this.persistXml) {
            return new NullConfigurationPersister().store(model, affectedAddresses);
        }
        return new StringPersistenceResource(model, this);
    }

    public List<ModelNode> load() throws ConfigurationPersistenceException {
        return this.bootOperations;
    }

    public List<ModelNode> getBootOperations() {
        return this.bootOperations;
    }

    public String getMarshalled() {
        return this.marshalled;
    }

    private class StringPersistenceResource
    implements ConfigurationPersister.PersistenceResource {
        private byte[] bytes;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        StringPersistenceResource(ModelNode model, AbstractConfigurationPersister persister) throws ConfigurationPersistenceException {
            ByteArrayOutputStream output = new ByteArrayOutputStream(8192);
            try {
                try {
                    persister.marshallAsXml(model, (OutputStream)output);
                }
                finally {
                    try {
                        output.close();
                    }
                    catch (Exception exception) {}
                    this.bytes = output.toByteArray();
                }
            }
            catch (Exception e) {
                throw new ConfigurationPersistenceException("Failed to marshal configuration", (Throwable)e);
            }
        }

        public void commit() {
            StringConfigurationPersister.this.marshalled = new String(this.bytes, StandardCharsets.UTF_8);
        }

        public void rollback() {
            StringConfigurationPersister.this.marshalled = null;
        }
    }
}

