/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol.mgmt;

import java.io.Closeable;
import java.io.DataInput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.logging.ProtocolLogger;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.ActiveOperationSupport;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.FlushableDataOutputImpl;
import org.jboss.as.protocol.mgmt.ManagementMessageHandler;
import org.jboss.as.protocol.mgmt.ManagementProtocolHeader;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import org.jboss.as.protocol.mgmt.ManagementResponseHandler;
import org.jboss.as.protocol.mgmt.ManagementResponseHeader;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.MessageOutputStream;
import org.jboss.threads.AsyncFuture;
import org.xnio.Cancellable;

public abstract class AbstractMessageHandler
extends ActiveOperationSupport
implements ManagementMessageHandler,
CloseHandler<Channel> {
    private final ExecutorService executorService;
    private final AtomicInteger requestID = new AtomicInteger();
    private final Map<Integer, ActiveRequest<?, ?>> requests = new ConcurrentHashMap(16, 0.75f, Runtime.getRuntime().availableProcessors());

    protected AbstractMessageHandler(ExecutorService executorService) {
        if (executorService == null) {
            throw ProtocolLogger.ROOT_LOGGER.nullExecutor();
        }
        this.executorService = executorService;
    }

    protected ExecutorService getExecutor() {
        return this.executorService;
    }

    protected ManagementRequestHandler<?, ?> getRequestHandler(ManagementRequestHeader header) {
        return this.getFallbackHandler(header);
    }

    protected ManagementRequestHeader validateRequest(ManagementProtocolHeader header) throws IOException {
        return (ManagementRequestHeader)header;
    }

    @Override
    public void handleMessage(Channel channel, DataInput input, ManagementProtocolHeader header) throws IOException {
        byte type = header.getType();
        if (type == 3) {
            ManagementResponseHeader response = (ManagementResponseHeader)header;
            ActiveRequest<?, ?> request = this.requests.remove(response.getResponseId());
            if (request == null) {
                ProtocolLogger.CONNECTION_LOGGER.noSuchRequest(response.getResponseId(), channel);
                AbstractMessageHandler.safeWriteErrorResponse(channel, header, ProtocolLogger.ROOT_LOGGER.responseHandlerNotFound(response.getResponseId()));
            } else if (response.getError() != null) {
                request.handleFailed(response);
            } else {
                this.handleRequest(channel, input, header, request);
            }
        } else {
            try {
                ManagementRequestHeader requestHeader = this.validateRequest(header);
                ManagementRequestHandler<?, ?> handler = this.getRequestHandler(requestHeader);
                if (handler == null) {
                    AbstractMessageHandler.safeWriteErrorResponse(channel, header, ProtocolLogger.ROOT_LOGGER.responseHandlerNotFound(requestHeader.getBatchId()));
                } else {
                    this.handleMessage(channel, input, requestHeader, handler);
                }
            }
            catch (Exception e) {
                AbstractMessageHandler.safeWriteErrorResponse(channel, header, e);
            }
        }
    }

    protected <T, A> AsyncFuture<T> executeRequest(ManagementRequest<T, A> request, final Channel channel, final ActiveOperation<T, A> support) {
        assert (support != null);
        AbstractMessageHandler.updateChannelRef(support, channel);
        final Integer requestId = this.requestID.incrementAndGet();
        ActiveRequest<T, A> ar = new ActiveRequest<T, A>(support, request, channel);
        this.requests.put(requestId, ar);
        final ManagementRequestHeader header = new ManagementRequestHeader(2, requestId, support.getOperationId(), request.getOperationType());
        final ActiveOperation.ResultHandler<T> resultHandler = support.getResultHandler();
        try {
            request.sendRequest(resultHandler, new ManagementRequestContext<A>(){

                @Override
                public Integer getOperationId() {
                    return support.getOperationId();
                }

                @Override
                public A getAttachment() {
                    return support.getAttachment();
                }

                @Override
                public Channel getChannel() {
                    return channel;
                }

                @Override
                public ManagementProtocolHeader getRequestHeader() {
                    return header;
                }

                Runnable createAsyncTaskRunner(final ManagementRequestContext.AsyncTask<A> task, boolean cancellable) {
                    final 1 context = this;
                    AsyncTaskRunner runner = new AsyncTaskRunner(cancellable){

                        @Override
                        protected void doExecute() {
                            block2: {
                                try {
                                    task.execute(context);
                                }
                                catch (Exception e) {
                                    resultHandler.failed(e);
                                    AbstractMessageHandler.this.requests.remove(requestId);
                                    if (!(e instanceof InterruptedException)) break block2;
                                    Thread.currentThread().interrupt();
                                }
                            }
                        }
                    };
                    if (cancellable) {
                        support.addCancellable(runner);
                    }
                    return runner;
                }

                @Override
                public void executeAsync(ManagementRequestContext.AsyncTask<A> task) {
                    this.executeAsync(task, true, AbstractMessageHandler.this.getExecutor());
                }

                @Override
                public void executeAsync(ManagementRequestContext.AsyncTask<A> task, boolean cancellable) {
                    this.executeAsync(task, cancellable, AbstractMessageHandler.this.getExecutor());
                }

                @Override
                public void executeAsync(ManagementRequestContext.AsyncTask<A> task, Executor executor) {
                    this.executeAsync(task, true, executor);
                }

                @Override
                public void executeAsync(ManagementRequestContext.AsyncTask<A> task, boolean cancellable, Executor executor) {
                    executor.execute(this.createAsyncTaskRunner(task, cancellable));
                }

                @Override
                public FlushableDataOutput writeMessage(ManagementProtocolHeader header2) throws IOException {
                    MessageOutputStream os = channel.writeMessage();
                    return AbstractMessageHandler.writeHeader(header2, (OutputStream)os);
                }
            });
        }
        catch (Exception e) {
            resultHandler.failed(e);
            this.requests.remove(requestId);
        }
        return support.getResult();
    }

    protected <T, A> void handleRequest(Channel channel, DataInput message, ManagementProtocolHeader header, ActiveRequest<T, A> activeRequest) {
        this.handleMessage(channel, message, header, ((ActiveRequest)activeRequest).context, ((ActiveRequest)activeRequest).handler);
    }

    protected <T, A> void handleMessage(Channel channel, DataInput message, ManagementRequestHeader header, ManagementRequestHandler<T, A> handler) throws IOException {
        ActiveOperation support = this.getActiveOperation(header);
        if (support == null) {
            throw ProtocolLogger.ROOT_LOGGER.responseHandlerNotFound(header.getBatchId());
        }
        this.handleMessage(channel, message, header, support, handler);
    }

    protected <T, A> void handleMessage(final Channel channel, DataInput message, final ManagementProtocolHeader header, final ActiveOperation<T, A> support, ManagementRequestHandler<T, A> handler) {
        assert (support != null);
        AbstractMessageHandler.updateChannelRef(support, channel);
        final ActiveOperation.ResultHandler<T> resultHandler = support.getResultHandler();
        try {
            handler.handleRequest(message, resultHandler, new ManagementRequestContext<A>(){

                @Override
                public Integer getOperationId() {
                    return support.getOperationId();
                }

                @Override
                public A getAttachment() {
                    return support.getAttachment();
                }

                @Override
                public Channel getChannel() {
                    return channel;
                }

                @Override
                public ManagementProtocolHeader getRequestHeader() {
                    return header;
                }

                Runnable createAsyncTaskRunner(final ManagementRequestContext.AsyncTask<A> task, boolean cancellable) {
                    final 2 context = this;
                    AsyncTaskRunner runner = new AsyncTaskRunner(cancellable){

                        @Override
                        protected void doExecute() {
                            block2: {
                                try {
                                    task.execute(context);
                                }
                                catch (Exception e) {
                                    ProtocolLogger.ROOT_LOGGER.debugf(e, " failed to process async request for %s on channel %s", task, channel);
                                    if (!resultHandler.failed(e)) break block2;
                                    AbstractMessageHandler.safeWriteErrorResponse(channel, header, e);
                                }
                            }
                        }
                    };
                    if (cancellable) {
                        support.addCancellable(runner);
                    }
                    return runner;
                }

                @Override
                public void executeAsync(ManagementRequestContext.AsyncTask<A> task) {
                    this.executeAsync(task, true, AbstractMessageHandler.this.getExecutor());
                }

                @Override
                public void executeAsync(ManagementRequestContext.AsyncTask<A> task, boolean cancellable) {
                    this.executeAsync(task, cancellable, AbstractMessageHandler.this.getExecutor());
                }

                @Override
                public void executeAsync(ManagementRequestContext.AsyncTask<A> task, Executor executor) {
                    this.executeAsync(task, true, executor);
                }

                @Override
                public void executeAsync(ManagementRequestContext.AsyncTask<A> task, boolean cancellable, Executor executor) {
                    block2: {
                        try {
                            executor.execute(this.createAsyncTaskRunner(task, cancellable));
                        }
                        catch (RejectedExecutionException e) {
                            if (!resultHandler.failed(e)) break block2;
                            AbstractMessageHandler.safeWriteErrorResponse(channel, header, e);
                        }
                    }
                }

                @Override
                public FlushableDataOutput writeMessage(ManagementProtocolHeader header2) throws IOException {
                    MessageOutputStream os = channel.writeMessage();
                    return AbstractMessageHandler.writeHeader(header2, (OutputStream)os);
                }
            });
        }
        catch (Exception e) {
            resultHandler.failed(e);
            AbstractMessageHandler.safeWriteErrorResponse(channel, header, e);
        }
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }

    @Override
    public void shutdownNow() {
        this.shutdown();
        this.cancelAllActiveOperations();
    }

    @Override
    public boolean awaitCompletion(long timeout, TimeUnit unit) throws InterruptedException {
        return super.awaitCompletion(timeout, unit);
    }

    public void handleClose(Channel closed, IOException exception) {
        this.handleChannelClosed(closed, exception);
    }

    @Override
    protected <T, A> ActiveOperation<T, A> removeActiveOperation(Integer id) {
        ActiveOperation removed = super.removeActiveOperation(id);
        if (removed != null) {
            for (Map.Entry<Integer, ActiveRequest<?, ?>> requestEntry : this.requests.entrySet()) {
                ActiveRequest<?, ?> request = requestEntry.getValue();
                if (((ActiveRequest)request).context != removed) continue;
                this.requests.remove(requestEntry.getKey());
            }
        }
        return removed;
    }

    protected static void safeWriteErrorResponse(Channel channel, ManagementProtocolHeader header, Exception error) {
        if (header.getType() == 2) {
            try {
                AbstractMessageHandler.writeErrorResponse(channel, (ManagementRequestHeader)header, error);
            }
            catch (IOException ioe) {
                ProtocolLogger.ROOT_LOGGER.tracef(ioe, "failed to write error response for %s on channel: %s", header, channel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeErrorResponse(Channel channel, ManagementRequestHeader header, Exception error) throws IOException {
        ManagementResponseHeader response = ManagementResponseHeader.create(header, error);
        MessageOutputStream output = channel.writeMessage();
        try {
            AbstractMessageHandler.writeHeader(response, (OutputStream)output);
            output.close();
        }
        finally {
            StreamUtils.safeClose((Closeable)output);
        }
    }

    protected static FlushableDataOutput writeHeader(ManagementProtocolHeader header, OutputStream os) throws IOException {
        FlushableDataOutput output = FlushableDataOutputImpl.create(os);
        header.write(output);
        return output;
    }

    protected <T, A> ManagementRequestHandler<T, A> getFallbackHandler(final ManagementRequestHeader header) {
        return new ManagementRequestHandler<T, A>(){

            @Override
            public void handleRequest(DataInput input, ActiveOperation.ResultHandler<T> resultHandler, ManagementRequestContext<A> context) throws IOException {
                IOException error = ProtocolLogger.ROOT_LOGGER.noSuchResponseHandler(Integer.toHexString(header.getRequestId()));
                if (resultHandler.failed(error)) {
                    AbstractMessageHandler.safeWriteErrorResponse(context.getChannel(), context.getRequestHeader(), error);
                }
            }
        };
    }

    private static abstract class AsyncTaskRunner
    implements Runnable,
    Cancellable {
        private final boolean cancellable;
        private final AtomicBoolean cancelled = new AtomicBoolean(false);
        private volatile Thread thread;

        private AsyncTaskRunner(boolean cancellable) {
            this.cancellable = cancellable;
        }

        public Cancellable cancel() {
            Thread thread;
            if (this.cancellable && this.cancelled.compareAndSet(false, true) && (thread = this.thread) != null) {
                thread.interrupt();
                ProtocolLogger.ROOT_LOGGER.cancelledAsyncTask(this.getClass().getSimpleName(), thread);
            }
            return this;
        }

        protected abstract void doExecute();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.cancellable && this.cancelled.get()) {
                Thread.currentThread().interrupt();
                ProtocolLogger.ROOT_LOGGER.cancelledAsyncTaskBeforeRun(this.getClass().getSimpleName());
            }
            this.thread = Thread.currentThread();
            try {
                this.doExecute();
            }
            finally {
                this.thread = null;
            }
        }

        final boolean isCancelled() {
            return this.cancelled.get();
        }
    }

    private static class ActiveRequest<T, A> {
        private final Channel channel;
        private final ActiveOperation<T, A> context;
        private final ManagementResponseHandler<T, A> handler;

        ActiveRequest(ActiveOperation<T, A> context, ManagementResponseHandler<T, A> handler, Channel channel) {
            this.context = context;
            this.handler = handler;
            this.channel = channel;
        }

        protected void handleFailed(ManagementResponseHeader header) {
            this.handler.handleFailed(header, this.context.getResultHandler());
        }
    }
}

