package org.jboss.as.protocol.logging;

import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.remoting3.Channel;
import java.net.ServerSocket;
import java.lang.String;
import java.io.IOException;
import org.jboss.logging.Logger;
import java.net.URI;
import java.lang.Exception;
import java.lang.Thread;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import java.util.Arrays;
import java.lang.IllegalArgumentException;
import java.net.ConnectException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2017-03-24T16:10:26-0500")
public class ProtocolLogger_$logger extends DelegatingBasicLogger implements ProtocolLogger,BasicLogger,Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ProtocolLogger_$logger.class.getName();
    public ProtocolLogger_$logger(final Logger log) {
        super(log);
    }
    @Override
    public final void errorClosingChannel(final String message) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, errorClosingChannel$str(), message);
    }
    private static final String errorClosingChannel = "WFLYPRT0001: Got error closing channel %s";
    protected String errorClosingChannel$str() {
        return errorClosingChannel;
    }
    @Override
    public final void failedToCloseResource(final Throwable cause, final Object resource) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, cause, failedToCloseResource$str(), resource);
    }
    private static final String failedToCloseResource = "WFLYPRT0003: Failed to close resource %s";
    protected String failedToCloseResource$str() {
        return failedToCloseResource;
    }
    @Override
    public final void failedToCloseServerSocket(final Throwable cause, final ServerSocket socket) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, cause, failedToCloseServerSocket$str(), socket);
    }
    private static final String failedToCloseServerSocket = "WFLYPRT0004: Failed to close the server socket %s";
    protected String failedToCloseServerSocket$str() {
        return failedToCloseServerSocket;
    }
    @Override
    public final void executorNotNeeded() {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, executorNotNeeded$str());
    }
    private static final String executorNotNeeded = "WFLYPRT0015: Executor is not needed for client";
    protected String executorNotNeeded$str() {
        return executorNotNeeded;
    }
    @Override
    public final void noSuchRequest(final int requestId, final Channel channel) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, noSuchRequest$str(), requestId, channel);
    }
    private static final String noSuchRequest = "WFLYPRT0018: No such request (%d) associated with channel %s";
    protected String noSuchRequest$str() {
        return noSuchRequest;
    }
    private static final String couldNotConnect = "WFLYPRT0023: Could not connect to %s. The connection timed out";
    protected String couldNotConnect$str() {
        return couldNotConnect;
    }
    @Override
    public final ConnectException couldNotConnect(final URI uri) {
        final ConnectException result = new ConnectException(String.format(couldNotConnect$str(), uri));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidByteToken = "WFLYPRT0030: Invalid byte token.  Expecting '%d' received '%d'";
    protected String invalidByteToken$str() {
        return invalidByteToken;
    }
    @Override
    public final IOException invalidByteToken(final int expected, final byte actual) {
        final IOException result = new IOException(String.format(invalidByteToken$str(), expected, actual));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidSignature = "WFLYPRT0032: Invalid signature [%s]";
    protected String invalidSignature$str() {
        return invalidSignature;
    }
    @Override
    public final IOException invalidSignature(final String signature) {
        final IOException result = new IOException(String.format(invalidSignature$str(), signature));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidType1 = "WFLYPRT0034: Invalid type: %s";
    protected String invalidType1$str() {
        return invalidType1;
    }
    @Override
    public final IOException invalidType(final String type) {
        final IOException result = new IOException(String.format(invalidType1$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidType3 = "WFLYPRT0035: Type is neither %s or %s: %s";
    protected String invalidType3$str() {
        return invalidType3;
    }
    @Override
    public final IllegalArgumentException invalidType(final String validType1, final String validType2, final byte providedType) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidType3$str(), validType1, validType2, providedType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String operationIdAlreadyExists = "WFLYPRT0051: Operation with id %d already registered";
    protected String operationIdAlreadyExists$str() {
        return operationIdAlreadyExists;
    }
    @Override
    public final IllegalStateException operationIdAlreadyExists(final int operationId) {
        final IllegalStateException result = new IllegalStateException(String.format(operationIdAlreadyExists$str(), operationId));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullExecutor = "WFLYPRT0052: Null executor";
    protected String nullExecutor$str() {
        return nullExecutor;
    }
    @Override
    public final IllegalArgumentException nullExecutor() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(nullExecutor$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToConnect = "WFLYPRT0053: Could not connect to %s. The connection failed";
    protected String failedToConnect$str() {
        return failedToConnect;
    }
    @Override
    public final ConnectException failedToConnect(final URI uri, final Exception cause) {
        final ConnectException result = new ConnectException(String.format(failedToConnect$str(), uri));
        result.initCause(cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String channelClosed = "WFLYPRT0054: Channel closed";
    protected String channelClosed$str() {
        return channelClosed;
    }
    @Override
    public final IOException channelClosed() {
        final IOException result = new IOException(String.format(channelClosed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSuchResponseHandler = "WFLYPRT0055: no handler registered for request type '%s'.";
    protected String noSuchResponseHandler$str() {
        return noSuchResponseHandler;
    }
    @Override
    public final IOException noSuchResponseHandler(final String type) {
        final IOException result = new IOException(String.format(noSuchResponseHandler$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String responseHandlerNotFound = "WFLYPRT0056: No response handler for request %s";
    protected String responseHandlerNotFound$str() {
        return responseHandlerNotFound;
    }
    @Override
    public final IOException responseHandlerNotFound(final int id) {
        final IOException result = new IOException(String.format(responseHandlerNotFound$str(), id));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void cancelledAsyncTask(final String asyncTaskRunner, final Thread thread) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, cancelledAsyncTask$str(), asyncTaskRunner, thread);
    }
    private static final String cancelledAsyncTask = "WFLYPRT0057: %s cancelled task by interrupting thread %s";
    protected String cancelledAsyncTask$str() {
        return cancelledAsyncTask;
    }
    @Override
    public final void cancelledAsyncTaskBeforeRun(final String asyncTaskRunner) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, cancelledAsyncTaskBeforeRun$str(), asyncTaskRunner);
    }
    private static final String cancelledAsyncTaskBeforeRun = "WFLYPRT0058: %s cancelled task before execution began";
    protected String cancelledAsyncTaskBeforeRun$str() {
        return cancelledAsyncTaskBeforeRun;
    }
    @Override
    public final void deprecatedCLIConfiguration(final String systemPropName) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, deprecatedCLIConfiguration$str(), systemPropName);
    }
    private static final String deprecatedCLIConfiguration = "WFLYPRT0059: You are using a deprecated way to set the client bind address. Please use the \"--bind\" parameter on the CLI instead of the %s system property.";
    protected String deprecatedCLIConfiguration$str() {
        return deprecatedCLIConfiguration;
    }
    private static final String channelTimedOut = "WFLYPRT0060: Channel open request timed out";
    protected String channelTimedOut$str() {
        return channelTimedOut;
    }
    @Override
    public final IOException channelTimedOut() {
        final IOException result = new IOException(String.format(channelTimedOut$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
