/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.operations.validation.AllowedValuesValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.remoting.Attribute;
import org.jboss.as.remoting.Element;
import org.jboss.as.remoting.RemotingExtension;
import org.jboss.as.remoting.SaslAdd;
import org.jboss.as.remoting.SaslRemove;
import org.jboss.as.remoting.WrappedAttributeMarshaller;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.xnio.sasl.SaslQop;
import org.xnio.sasl.SaslStrength;

public class SaslResource
extends SimpleResourceDefinition {
    static final PathElement SASL_CONFIG_PATH = PathElement.pathElement((String)"security", (String)"sasl");
    static final SaslResource INSTANCE = new SaslResource();
    static final AttributeDefinition INCLUDE_MECHANISMS_ATTRIBUTE = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("include-mechanisms").setAllowNull(true)).setAttributeMarshaller((AttributeMarshaller)new SaslAttributeMarshaller(Element.INCLUDE_MECHANISMS))).build();
    static final AttributeDefinition QOP_ATTRIBUTE = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("qop").setAllowNull(true)).setAttributeMarshaller((AttributeMarshaller)new SaslAttributeMarshaller(Element.QOP))).setElementValidator((ParameterValidator)QopParameterValidation.INSTANCE)).build();
    static final AttributeDefinition STRENGTH_ATTRIBUTE = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("strength").setAllowNull(true)).setAttributeMarshaller((AttributeMarshaller)new SaslAttributeMarshaller(Element.STRENGTH))).setElementValidator((ParameterValidator)StrengthParameterValidation.INSTANCE)).build();
    static final SimpleAttributeDefinition SERVER_AUTH_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"server-auth", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(false))).setAllowNull(true)).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)new WrappedAttributeMarshaller(Attribute.VALUE))).build();
    static final SimpleAttributeDefinition REUSE_SESSION_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"reuse-session", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(false))).setAllowNull(true)).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)new WrappedAttributeMarshaller(Attribute.VALUE))).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{INCLUDE_MECHANISMS_ATTRIBUTE, QOP_ATTRIBUTE, STRENGTH_ATTRIBUTE, SERVER_AUTH_ATTRIBUTE, REUSE_SESSION_ATTRIBUTE};
    private final List<AccessConstraintDefinition> accessConstraints = RemotingExtension.REMOTING_SECURITY_DEF.wrapAsList();

    private SaslResource() {
        super(SASL_CONFIG_PATH, RemotingExtension.getResourceDescriptionResolver("sasl"), (OperationStepHandler)SaslAdd.INSTANCE, (OperationStepHandler)SaslRemove.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ReloadRequiredWriteAttributeHandler writeHandler = new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{INCLUDE_MECHANISMS_ATTRIBUTE, QOP_ATTRIBUTE, STRENGTH_ATTRIBUTE, REUSE_SESSION_ATTRIBUTE, SERVER_AUTH_ATTRIBUTE});
        resourceRegistration.registerReadWriteAttribute(INCLUDE_MECHANISMS_ATTRIBUTE, null, (OperationStepHandler)writeHandler);
        resourceRegistration.registerReadWriteAttribute(QOP_ATTRIBUTE, null, (OperationStepHandler)writeHandler);
        resourceRegistration.registerReadWriteAttribute(STRENGTH_ATTRIBUTE, null, (OperationStepHandler)writeHandler);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)REUSE_SESSION_ATTRIBUTE, null, (OperationStepHandler)writeHandler);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)SERVER_AUTH_ATTRIBUTE, null, (OperationStepHandler)writeHandler);
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.accessConstraints;
    }

    private static class StrengthParameterValidation
    extends SaslEnumValidator
    implements AllowedValuesValidator {
        static final StrengthParameterValidation INSTANCE = new StrengthParameterValidation();

        public StrengthParameterValidation() {
            super((Enum<?>[])SaslStrength.values(), true);
        }
    }

    private static class QopParameterValidation
    extends SaslEnumValidator
    implements AllowedValuesValidator {
        static final QopParameterValidation INSTANCE = new QopParameterValidation();

        public QopParameterValidation() {
            super((Enum<?>[])SaslQop.values(), false);
        }
    }

    private static abstract class SaslEnumValidator
    extends StringLengthValidator
    implements AllowedValuesValidator {
        final List<ModelNode> allowedValues = new ArrayList<ModelNode>();

        SaslEnumValidator(Enum<?>[] src, boolean toLowerCase) {
            super(1);
            for (Enum<?> e : src) {
                this.allowedValues.add(new ModelNode().set(toLowerCase ? e.name().toLowerCase(Locale.ENGLISH) : e.name()));
            }
        }

        public List<ModelNode> getAllowedValues() {
            return this.allowedValues;
        }
    }

    private static class SaslAttributeMarshaller
    extends AttributeMarshaller {
        private final Element element;

        SaslAttributeMarshaller(Element element) {
            this.element = element;
        }

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            List list;
            if (resourceModel.hasDefined(attribute.getName()) && (list = resourceModel.get(attribute.getName()).asList()).size() > 0) {
                writer.writeEmptyElement(this.element.getLocalName());
                StringBuilder sb = new StringBuilder();
                for (ModelNode child : list) {
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append(child.asString());
                }
                writer.writeAttribute(Attribute.VALUE.getLocalName(), sb.toString());
            }
        }
    }
}

