/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.net.ssl.SSLContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.as.controller.security.InetAddressPrincipal;
import org.jboss.as.core.security.RealmUser;
import org.jboss.as.core.security.SubjectUserInfo;
import org.jboss.as.core.security.UniqueIdUserInfo;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.remoting.RemotingSecurityProvider;
import org.jboss.as.remoting.logging.RemotingLogger;
import org.jboss.remoting3.Remoting;
import org.jboss.remoting3.security.AuthorizingCallbackHandler;
import org.jboss.remoting3.security.ServerAuthenticationProvider;
import org.jboss.remoting3.security.SimpleUserInfo;
import org.jboss.remoting3.security.UserInfo;
import org.jboss.remoting3.security.UserPrincipal;
import org.jboss.sasl.callback.DigestHashCallback;
import org.jboss.sasl.callback.VerifyPasswordCallback;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Property;
import org.xnio.Sequence;
import org.xnio.SslClientAuthMode;
import org.xnio.Xnio;
import org.xnio.ssl.JsseXnioSsl;
import org.xnio.ssl.XnioSsl;

class RealmSecurityProvider
implements RemotingSecurityProvider {
    static final String SASL_OPT_REALM_PROPERTY = "com.sun.security.sasl.digest.realm";
    static final String SASL_OPT_ALT_PROTO_PROPERTY = "org.jboss.sasl.digest.alternative_protocols";
    static final String SASL_OPT_PRE_DIGESTED_PROPERTY = "org.jboss.sasl.digest.pre_digested";
    static final String SASL_OPT_LOCAL_DEFAULT_USER = "jboss.sasl.local-user.default-user";
    static final String SASL_OPT_LOCAL_USER_CHALLENGE_PATH = "jboss.sasl.local-user.challenge-path";
    static final String ANONYMOUS = "ANONYMOUS";
    static final String DIGEST_MD5 = "DIGEST-MD5";
    static final String EXTERNAL = "EXTERNAL";
    static final String JBOSS_LOCAL_USER = "JBOSS-LOCAL-USER";
    static final String PLAIN = "PLAIN";
    private final SecurityRealm realm;
    private final CallbackHandler serverCallbackHandler;
    private final String tokensDir;

    RealmSecurityProvider(SecurityRealm realm, CallbackHandler serverCallbackHandler, String tokensDir) {
        this.realm = realm;
        this.serverCallbackHandler = serverCallbackHandler;
        this.tokensDir = tokensDir;
    }

    @Override
    public OptionMap getOptionMap() {
        LinkedList<String> mechanisms = new LinkedList<String>();
        HashSet<Property> properties = new HashSet<Property>();
        OptionMap.Builder builder = OptionMap.builder();
        if (this.realm == null) {
            mechanisms.add(ANONYMOUS);
            builder.set(Options.SASL_POLICY_NOANONYMOUS, false);
            builder.set(Options.SSL_ENABLED, false);
        } else {
            Map mechConfig;
            Set authMechs = this.realm.getSupportedAuthenticationMechanisms();
            if (authMechs.contains(AuthMechanism.LOCAL)) {
                mechanisms.add(JBOSS_LOCAL_USER);
                mechConfig = this.realm.getMechanismConfig(AuthMechanism.LOCAL);
                if (mechConfig.containsKey("org.jboss.as.domain.management.local.default_user")) {
                    properties.add(Property.of((String)SASL_OPT_LOCAL_DEFAULT_USER, (String)((String)mechConfig.get("org.jboss.as.domain.management.local.default_user"))));
                }
                if (this.tokensDir != null) {
                    properties.add(Property.of((String)SASL_OPT_LOCAL_USER_CHALLENGE_PATH, (String)this.tokensDir));
                }
            }
            if (authMechs.contains(AuthMechanism.DIGEST)) {
                mechanisms.add(DIGEST_MD5);
                properties.add(Property.of((String)SASL_OPT_REALM_PROPERTY, (String)this.realm.getName()));
                properties.add(Property.of((String)SASL_OPT_ALT_PROTO_PROPERTY, (String)"remote"));
                mechConfig = this.realm.getMechanismConfig(AuthMechanism.DIGEST);
                boolean plainTextDigest = true;
                if (mechConfig.containsKey("org.jboss.as.domain.management.digest.plain_text")) {
                    plainTextDigest = Boolean.parseBoolean((String)mechConfig.get("org.jboss.as.domain.management.digest.plain_text"));
                }
                if (!plainTextDigest) {
                    properties.add(Property.of((String)SASL_OPT_PRE_DIGESTED_PROPERTY, (String)Boolean.TRUE.toString()));
                }
            }
            if (authMechs.contains(AuthMechanism.PLAIN)) {
                mechanisms.add(PLAIN);
                builder.set(Options.SASL_POLICY_NOPLAINTEXT, false);
            }
            if (this.realm.getSSLContext() == null) {
                builder.set(Options.SSL_ENABLED, false);
            } else if (authMechs.contains(AuthMechanism.CLIENT_CERT)) {
                builder.set(Options.SSL_ENABLED, true);
                builder.set(Options.SSL_STARTTLS, true);
                mechanisms.add(0, EXTERNAL);
                builder.set(Options.SSL_CLIENT_AUTH_MODE, (Object)SslClientAuthMode.REQUESTED);
            } else {
                builder.set(Options.SSL_ENABLED, true);
                builder.set(Options.SSL_STARTTLS, true);
            }
        }
        if (mechanisms.size() == 0) {
            throw RemotingLogger.ROOT_LOGGER.noSupportingMechanismsForRealm();
        }
        builder.set(Options.SASL_MECHANISMS, (Object)Sequence.of(mechanisms));
        builder.set(Options.SASL_PROPERTIES, (Object)Sequence.of(properties));
        return builder.getMap();
    }

    @Override
    public ServerAuthenticationProvider getServerAuthenticationProvider() {
        return new ServerAuthenticationProvider(){

            public AuthorizingCallbackHandler getCallbackHandler(String mechanismName) {
                final CallbackHandler cbh = RealmSecurityProvider.this.getCallbackHandler(mechanismName);
                if (cbh instanceof AuthorizingCallbackHandler) {
                    return (AuthorizingCallbackHandler)cbh;
                }
                return new AuthorizingCallbackHandler(){

                    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                        cbh.handle(callbacks);
                    }

                    public UserInfo createUserInfo(Collection<Principal> remotingPrincipals) {
                        return new SimpleUserInfo(remotingPrincipals);
                    }
                };
            }
        };
    }

    @Override
    public XnioSsl getXnioSsl() {
        SSLContext sslContext;
        if (this.realm == null || (sslContext = this.realm.getSSLContext()) == null) {
            return null;
        }
        return new JsseXnioSsl(Xnio.getInstance((ClassLoader)Remoting.class.getClassLoader()), OptionMap.EMPTY, sslContext);
    }

    public CallbackHandler getCallbackHandler(String mechanismName) {
        RealmCallbackHandler realmCallbackHandler;
        if (ANONYMOUS.equals(mechanismName) && this.realm == null) {
            return new RealmCallbackHandler(new org.jboss.as.domain.management.AuthorizingCallbackHandler(){

                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    int i$ = 0;
                    Callback[] arr$ = callbacks;
                    int len$ = arr$.length;
                    if (i$ < len$) {
                        Callback current = arr$[i$];
                        throw RemotingLogger.ROOT_LOGGER.anonymousMechanismNotExpected(current);
                    }
                }

                public SubjectUserInfo createSubjectUserInfo(Collection<Principal> remotingPrincipals) throws IOException {
                    final Subject subject = new Subject();
                    Set<Principal> allPrincipals = subject.getPrincipals();
                    for (Principal userPrincipal : remotingPrincipals) {
                        allPrincipals.add(userPrincipal);
                        if (userPrincipal instanceof UserPrincipal) {
                            allPrincipals.add((Principal)new RealmUser(userPrincipal.getName()));
                            continue;
                        }
                        if (!(userPrincipal instanceof org.jboss.remoting3.security.InetAddressPrincipal)) continue;
                        allPrincipals.add((Principal)new InetAddressPrincipal(((org.jboss.remoting3.security.InetAddressPrincipal)userPrincipal).getInetAddress()));
                    }
                    final String userName = subject.getPrincipals(RealmUser.class).iterator().next().getName();
                    return new SubjectUserInfo(){

                        public String getUserName() {
                            return userName;
                        }

                        public Subject getSubject() {
                            return subject;
                        }

                        public Collection<Principal> getPrincipals() {
                            return subject.getPrincipals();
                        }
                    };
                }
            });
        }
        if (JBOSS_LOCAL_USER.equals(mechanismName)) {
            return new RealmCallbackHandler(this.realm.getAuthorizingCallbackHandler(AuthMechanism.LOCAL));
        }
        if (EXTERNAL.equals(mechanismName)) {
            return new RealmCallbackHandler(this.realm.getAuthorizingCallbackHandler(AuthMechanism.CLIENT_CERT));
        }
        if (DIGEST_MD5.equals(mechanismName)) {
            realmCallbackHandler = new RealmCallbackHandler(this.realm.getAuthorizingCallbackHandler(AuthMechanism.DIGEST));
        } else if (PLAIN.equals(mechanismName)) {
            realmCallbackHandler = new RealmCallbackHandler(this.realm.getAuthorizingCallbackHandler(AuthMechanism.PLAIN));
        } else {
            return null;
        }
        if (this.serverCallbackHandler == null) {
            return realmCallbackHandler;
        }
        return new AuthorizingCallbackHandler(){
            private boolean serverHandled = false;

            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                RealmSecurityProvider.this.serverCallbackHandler.handle(callbacks);
                if (this.handled(callbacks)) {
                    this.serverHandled = true;
                } else {
                    realmCallbackHandler.handle(callbacks);
                }
            }

            private boolean handled(Callback[] callbacks) {
                for (Callback current : callbacks) {
                    if (current instanceof PasswordCallback) {
                        PasswordCallback pcb = (PasswordCallback)current;
                        char[] password = pcb.getPassword();
                        return password != null && password.length > 0;
                    }
                    if (current instanceof VerifyPasswordCallback) {
                        return ((VerifyPasswordCallback)current).isVerified();
                    }
                    if (!(current instanceof DigestHashCallback)) continue;
                    return ((DigestHashCallback)current).getHash() != null;
                }
                return false;
            }

            public UserInfo createUserInfo(Collection<Principal> remotingPrincipals) throws IOException {
                if (this.serverHandled) {
                    final Subject subject = new Subject();
                    Set<Principal> allPrincipals = subject.getPrincipals();
                    for (Principal userPrincipal : remotingPrincipals) {
                        allPrincipals.add(userPrincipal);
                        allPrincipals.add((Principal)new RealmUser(userPrincipal.getName()));
                    }
                    return new RealmSubjectUserInfo(new SubjectUserInfo(){

                        public String getUserName() {
                            return subject.getPrincipals(RealmUser.class).iterator().next().getName();
                        }

                        public Subject getSubject() {
                            return subject;
                        }

                        public Collection<Principal> getPrincipals() {
                            return subject.getPrincipals();
                        }
                    });
                }
                return realmCallbackHandler.createUserInfo(remotingPrincipals);
            }
        };
    }

    private static class RealmSubjectUserInfo
    implements SubjectUserInfo,
    UserInfo,
    UniqueIdUserInfo {
        private final SubjectUserInfo subjectUserInfo;
        private final String id;

        private RealmSubjectUserInfo(SubjectUserInfo subjectUserInfo) {
            this.subjectUserInfo = subjectUserInfo;
            this.id = UUID.randomUUID().toString();
        }

        public String getUserName() {
            return this.subjectUserInfo.getUserName();
        }

        public Collection<Principal> getPrincipals() {
            return this.subjectUserInfo.getPrincipals();
        }

        public Subject getSubject() {
            return this.subjectUserInfo.getSubject();
        }

        public String getId() {
            return this.id;
        }
    }

    private class RealmCallbackHandler
    implements AuthorizingCallbackHandler {
        private final org.jboss.as.domain.management.AuthorizingCallbackHandler innerHandler;

        RealmCallbackHandler(org.jboss.as.domain.management.AuthorizingCallbackHandler innerHandler) {
            this.innerHandler = innerHandler;
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            this.innerHandler.handle(callbacks);
        }

        public UserInfo createUserInfo(Collection<Principal> remotingPrincipals) throws IOException {
            ArrayList<RealmUser> converted = new ArrayList<RealmUser>(remotingPrincipals.size());
            InetAddressPrincipal inetAddressPrincipal = null;
            for (Principal current : remotingPrincipals) {
                if (current instanceof UserPrincipal) {
                    if (RealmSecurityProvider.this.realm != null) {
                        converted.add(new RealmUser(RealmSecurityProvider.this.realm.getName(), current.getName()));
                        continue;
                    }
                    converted.add(new RealmUser(current.getName()));
                    continue;
                }
                if (!(current instanceof org.jboss.remoting3.security.InetAddressPrincipal)) continue;
                inetAddressPrincipal = new InetAddressPrincipal(((org.jboss.remoting3.security.InetAddressPrincipal)current).getInetAddress());
            }
            SubjectUserInfo sui = this.innerHandler.createSubjectUserInfo(converted);
            Subject subject = sui.getSubject();
            subject.getPrincipals().addAll(remotingPrincipals);
            if (inetAddressPrincipal != null) {
                subject.getPrincipals().add((Principal)inetAddressPrincipal);
            }
            return new RealmSubjectUserInfo(sui);
        }
    }
}

