/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.jboss.as.network.ManagedBinding;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.remoting.RemotingSecurityProvider;
import org.jboss.as.remoting.logging.RemotingLogger;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.security.ServerAuthenticationProvider;
import org.jboss.remoting3.spi.NetworkServerProvider;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.ConnectedStreamChannel;

public abstract class AbstractStreamServerService
implements Service<AcceptingChannel<? extends ConnectedStreamChannel>> {
    private final Logger log = Logger.getLogger((String)"org.jboss.as.remoting");
    private final InjectedValue<RemotingSecurityProvider> securityProviderValue = new InjectedValue();
    private final InjectedValue<Endpoint> endpointValue = new InjectedValue();
    private final InjectedValue<SocketBindingManager> socketBindingManagerValue = new InjectedValue();
    private final OptionMap connectorPropertiesOptionMap;
    private volatile AcceptingChannel<? extends ConnectedStreamChannel> streamServer;
    private volatile ManagedBinding managedBinding;

    AbstractStreamServerService(OptionMap connectorPropertiesOptionMap) {
        this.connectorPropertiesOptionMap = connectorPropertiesOptionMap;
    }

    public AcceptingChannel<? extends ConnectedStreamChannel> getValue() throws IllegalStateException, IllegalArgumentException {
        return this.streamServer;
    }

    public InjectedValue<RemotingSecurityProvider> getSecurityProviderInjector() {
        return this.securityProviderValue;
    }

    public InjectedValue<Endpoint> getEndpointInjector() {
        return this.endpointValue;
    }

    public InjectedValue<SocketBindingManager> getSocketBindingManagerInjector() {
        return this.socketBindingManagerValue;
    }

    public void start(StartContext context) throws StartException {
        try {
            NetworkServerProvider networkServerProvider = (NetworkServerProvider)((Endpoint)this.endpointValue.getValue()).getConnectionProviderInterface("remote", NetworkServerProvider.class);
            RemotingSecurityProvider rsp = (RemotingSecurityProvider)this.securityProviderValue.getValue();
            ServerAuthenticationProvider sap = rsp.getServerAuthenticationProvider();
            OptionMap.Builder builder = OptionMap.builder();
            builder.addAll(rsp.getOptionMap());
            if (this.connectorPropertiesOptionMap != null) {
                builder.addAll(this.connectorPropertiesOptionMap);
            }
            OptionMap resultingMap = builder.getMap();
            if (this.log.isTraceEnabled()) {
                this.log.tracef("Resulting OptionMap %s", (Object)resultingMap.toString());
            }
            this.streamServer = networkServerProvider.createServer((SocketAddress)this.getSocketAddress(), resultingMap, sap, rsp.getXnioSsl());
            SocketBindingManager sbm = (SocketBindingManager)this.socketBindingManagerValue.getOptionalValue();
            if (sbm != null) {
                this.managedBinding = this.registerSocketBinding(sbm);
            }
            RemotingLogger.ROOT_LOGGER.listeningOnSocket(NetworkUtils.formatAddress((InetSocketAddress)this.getSocketAddress()));
        }
        catch (BindException e) {
            throw RemotingLogger.ROOT_LOGGER.couldNotBindToSocket(e.getMessage() + " " + NetworkUtils.formatAddress((InetSocketAddress)this.getSocketAddress()), e);
        }
        catch (Exception e) {
            throw RemotingLogger.ROOT_LOGGER.couldNotStart(e);
        }
    }

    public void stop(StopContext context) {
        IoUtils.safeClose(this.streamServer);
        SocketBindingManager sbm = (SocketBindingManager)this.socketBindingManagerValue.getOptionalValue();
        if (sbm != null && this.managedBinding != null) {
            this.unregisterSocketBinding(this.managedBinding, sbm);
        }
    }

    abstract InetSocketAddress getSocketAddress();

    abstract ManagedBinding registerSocketBinding(SocketBindingManager var1);

    abstract void unregisterSocketBinding(ManagedBinding var1, SocketBindingManager var2);
}

