/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.jboss.as.domain.management.CallbackHandlerFactory;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.remoting.AbstractOutboundConnectionService;
import org.jboss.as.remoting.Protocol;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.logging.RemotingLogger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.remoting3.RemotingOptions;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.sasl.SaslMechanismSelector;
import org.xnio.OptionMap;

final class RemoteOutboundConnectionService
extends AbstractOutboundConnectionService
implements Service<RemoteOutboundConnectionService> {
    static final ServiceName REMOTE_OUTBOUND_CONNECTION_BASE_SERVICE_NAME = RemotingServices.SUBSYSTEM_ENDPOINT.append(new String[]{"remote-outbound-connection"});
    private static final String JBOSS_LOCAL_USER = "JBOSS-LOCAL-USER";
    private static final AuthenticationContextConfigurationClient AUTH_CONFIGURATION_CLIENT = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
    private final Consumer<RemoteOutboundConnectionService> serviceConsumer;
    private final Supplier<OutboundSocketBinding> outboundSocketBindingSupplier;
    private final Supplier<SecurityRealm> securityRealmSupplier;
    private final Supplier<AuthenticationContext> authenticationContextSupplier;
    private final OptionMap connectionCreationOptions;
    private final String username;
    private final String protocol;
    private volatile URI destination;
    private volatile SSLContext sslContext;
    private volatile Supplier<AuthenticationConfiguration> authenticationConfiguration;

    RemoteOutboundConnectionService(Consumer<RemoteOutboundConnectionService> serviceConsumer, Supplier<OutboundSocketBinding> outboundSocketBindingSupplier, Supplier<SecurityRealm> securityRealmSupplier, Supplier<AuthenticationContext> authenticationContextSupplier, OptionMap connectionCreationOptions, String username, String protocol) {
        this.serviceConsumer = serviceConsumer;
        this.outboundSocketBindingSupplier = outboundSocketBindingSupplier;
        this.securityRealmSupplier = securityRealmSupplier;
        this.authenticationContextSupplier = authenticationContextSupplier;
        this.connectionCreationOptions = connectionCreationOptions;
        this.username = username;
        this.protocol = protocol;
    }

    public void start(StartContext context) throws StartException {
        SSLContext sslContext;
        AuthenticationContext injectedContext;
        URI uri;
        OutboundSocketBinding binding = this.outboundSocketBindingSupplier.get();
        String hostName = NetworkUtils.formatPossibleIpv6Address((String)binding.getUnresolvedDestinationAddress());
        int port = binding.getDestinationPort();
        String username = this.username;
        try {
            uri = new URI(this.protocol, username, hostName, port, null, null, null);
        }
        catch (URISyntaxException e) {
            throw new StartException((Throwable)e);
        }
        AuthenticationContext authenticationContext = injectedContext = this.authenticationContextSupplier != null ? this.authenticationContextSupplier.get() : null;
        if (injectedContext != null) {
            AuthenticationConfiguration configuration = AUTH_CONFIGURATION_CLIENT.getAuthenticationConfiguration(uri, injectedContext, -1, null, null);
            try {
                sslContext = AUTH_CONFIGURATION_CLIENT.getSSLContext(uri, injectedContext);
            }
            catch (GeneralSecurityException e) {
                throw RemotingLogger.ROOT_LOGGER.failedToObtainSSLContext(e);
            }
            String realProtocol = AUTH_CONFIGURATION_CLIENT.getRealProtocol(configuration);
            try {
                uri = new URI(realProtocol == null ? Protocol.REMOTE_HTTP.toString() : realProtocol, username, hostName, port, null, null, null);
            }
            catch (URISyntaxException e) {
                throw new StartException((Throwable)e);
            }
            URI finalUri = uri;
            this.authenticationConfiguration = () -> AUTH_CONFIGURATION_CLIENT.getAuthenticationConfiguration(finalUri, injectedContext);
        } else {
            SecurityRealm securityRealm = this.securityRealmSupplier != null ? this.securityRealmSupplier.get() : null;
            AuthenticationConfiguration configuration = AuthenticationConfiguration.empty();
            if (securityRealm != null) {
                if (username != null) {
                    configuration = configuration.useName(username).setSaslMechanismSelector(SaslMechanismSelector.DEFAULT.forbidMechanism(JBOSS_LOCAL_USER));
                    CallbackHandlerFactory callbackHandlerFactory = securityRealm.getSecretCallbackHandlerFactory();
                    if (callbackHandlerFactory != null) {
                        configuration = configuration.useCallbackHandler(callbackHandlerFactory.getCallbackHandler(username));
                    }
                }
                sslContext = securityRealm.getSSLContext();
            } else {
                sslContext = null;
            }
            AuthenticationConfiguration finalConfiguration = configuration;
            this.authenticationConfiguration = () -> finalConfiguration;
        }
        this.destination = uri;
        this.sslContext = sslContext;
        this.serviceConsumer.accept(this);
    }

    public void stop(StopContext context) {
        this.serviceConsumer.accept(null);
        this.authenticationConfiguration = null;
        this.destination = null;
        this.sslContext = null;
    }

    @Override
    public AuthenticationConfiguration getAuthenticationConfiguration() {
        AuthenticationConfiguration authenticationConfiguration = this.authenticationConfiguration.get();
        OptionMap optionMap = this.connectionCreationOptions;
        if (optionMap != null) {
            return RemotingOptions.mergeOptionsIntoAuthenticationConfiguration((OptionMap)optionMap, (AuthenticationConfiguration)authenticationConfiguration);
        }
        return authenticationConfiguration;
    }

    @Override
    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    @Override
    public URI getDestinationUri() {
        return this.destination;
    }

    public RemoteOutboundConnectionService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }
}

