/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.net.InetSocketAddress;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.network.ManagedBinding;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.remoting.AbstractStreamServerService;
import org.jboss.remoting3.Endpoint;
import org.wildfly.security.auth.server.SaslAuthenticationFactory;
import org.xnio.OptionMap;
import org.xnio.StreamConnection;
import org.xnio.channels.AcceptingChannel;

final class InjectedNetworkBindingStreamServerService
extends AbstractStreamServerService {
    private final Supplier<NetworkInterfaceBinding> interfaceBindingSupplier;
    private final int port;

    InjectedNetworkBindingStreamServerService(Consumer<AcceptingChannel<StreamConnection>> streamServerConsumer, Supplier<Endpoint> endpointSupplier, Supplier<SecurityRealm> securityRealmSupplier, Supplier<SaslAuthenticationFactory> saslAuthenticationFactorySupplier, Supplier<SSLContext> sslContextSupplier, Supplier<SocketBindingManager> socketBindingManagerSupplier, Supplier<NetworkInterfaceBinding> interfaceBindingSupplier, OptionMap connectorPropertiesOptionMap, int port) {
        super(streamServerConsumer, endpointSupplier, securityRealmSupplier, saslAuthenticationFactorySupplier, sslContextSupplier, socketBindingManagerSupplier, connectorPropertiesOptionMap);
        this.interfaceBindingSupplier = interfaceBindingSupplier;
        this.port = port;
    }

    @Override
    InetSocketAddress getSocketAddress() {
        return new InetSocketAddress(this.interfaceBindingSupplier.get().getAddress(), this.port);
    }

    @Override
    ManagedBinding registerSocketBinding(SocketBindingManager socketBindingManager) {
        InetSocketAddress address = new InetSocketAddress(this.interfaceBindingSupplier.get().getAddress(), this.port);
        ManagedBinding binding = ManagedBinding.Factory.createSimpleManagedBinding((String)"management-native", (InetSocketAddress)address, null);
        socketBindingManager.getUnnamedRegistry().registerBinding(binding);
        return binding;
    }

    @Override
    void unregisterSocketBinding(ManagedBinding managedBinding, SocketBindingManager socketBindingManager) {
        socketBindingManager.getUnnamedRegistry().unregisterBinding(managedBinding);
    }
}

