/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.operations.common.OrderedChildTypesAttachment;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ProfileParsingCompletionHandler;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.remoting.ConnectorResource;
import org.jboss.as.remoting.GenericOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.HttpConnectorResource;
import org.jboss.as.remoting.LocalOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.Namespace;
import org.jboss.as.remoting.PropertyResource;
import org.jboss.as.remoting.RemoteOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.RemotingEndpointResource;
import org.jboss.as.remoting.RemotingSubsystem10Parser;
import org.jboss.as.remoting.RemotingSubsystem11Parser;
import org.jboss.as.remoting.RemotingSubsystem12Parser;
import org.jboss.as.remoting.RemotingSubsystem20Parser;
import org.jboss.as.remoting.RemotingSubsystem30Parser;
import org.jboss.as.remoting.RemotingSubsystem40Parser;
import org.jboss.as.remoting.RemotingSubsystem50Parser;
import org.jboss.as.remoting.RemotingSubsystemRootResource;
import org.jboss.as.remoting.RemotingSubsystemXMLPersister;
import org.jboss.as.remoting.SaslPolicyResource;
import org.jboss.as.remoting.SaslResource;
import org.jboss.as.remoting.logging.RemotingLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class RemotingExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "remoting";
    private static final String RESOURCE_NAME = RemotingExtension.class.getPackage().getName() + ".LocalDescriptions";
    static final String NODE_NAME_PROPERTY = "jboss.node.name";
    static final SensitivityClassification REMOTING_SECURITY = new SensitivityClassification("remoting", "remoting-security", false, true, true);
    static final SensitiveTargetAccessConstraintDefinition REMOTING_SECURITY_DEF = new SensitiveTargetAccessConstraintDefinition(REMOTING_SECURITY);
    private static final int MANAGEMENT_API_MAJOR_VERSION = 4;
    private static final int MANAGEMENT_API_MINOR_VERSION = 0;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;
    private static final ModelVersion CURRENT_VERSION = ModelVersion.create((int)4, (int)0, (int)0);
    private static final String IO_EXTENSION_MODULE = "org.wildfly.extension.io";

    static ResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        return new StandardResourceDescriptionResolver(keyPrefix, RESOURCE_NAME, RemotingExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration registration = context.registerSubsystem(SUBSYSTEM_NAME, CURRENT_VERSION);
        registration.registerXMLElementWriter((XMLElementWriter)RemotingSubsystemXMLPersister.INSTANCE);
        ManagementResourceRegistration subsystem = registration.registerSubsystemModel((ResourceDefinition)new RemotingSubsystemRootResource());
        subsystem.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)new DescribeHandler());
        subsystem.registerSubModel((ResourceDefinition)RemotingEndpointResource.INSTANCE);
        ManagementResourceRegistration connector = subsystem.registerSubModel((ResourceDefinition)ConnectorResource.INSTANCE);
        connector.registerSubModel((ResourceDefinition)PropertyResource.INSTANCE_CONNECTOR);
        ManagementResourceRegistration sasl = connector.registerSubModel((ResourceDefinition)SaslResource.INSTANCE_CONNECTOR);
        sasl.registerSubModel((ResourceDefinition)SaslPolicyResource.INSTANCE_CONNECTOR);
        sasl.registerSubModel((ResourceDefinition)PropertyResource.INSTANCE_CONNECTOR);
        ManagementResourceRegistration httpConnector = subsystem.registerSubModel((ResourceDefinition)HttpConnectorResource.INSTANCE);
        httpConnector.registerSubModel((ResourceDefinition)PropertyResource.INSTANCE_HTTP_CONNECTOR);
        ManagementResourceRegistration httpSasl = httpConnector.registerSubModel((ResourceDefinition)SaslResource.INSTANCE_HTTP_CONNECTOR);
        httpSasl.registerSubModel((ResourceDefinition)SaslPolicyResource.INSTANCE_HTTP_CONNECTOR);
        httpSasl.registerSubModel((ResourceDefinition)PropertyResource.INSTANCE_HTTP_CONNECTOR);
        subsystem.registerSubModel((ResourceDefinition)RemoteOutboundConnectionResourceDefinition.INSTANCE);
        subsystem.registerSubModel((ResourceDefinition)LocalOutboundConnectionResourceDefinition.INSTANCE);
        subsystem.registerSubModel((ResourceDefinition)new GenericOutboundConnectionResourceDefinition());
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.REMOTING_1_0.getUriString(), (XMLElementReader)RemotingSubsystem10Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.REMOTING_1_1.getUriString(), (XMLElementReader)RemotingSubsystem11Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.REMOTING_1_2.getUriString(), (XMLElementReader)RemotingSubsystem12Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.REMOTING_2_0.getUriString(), (XMLElementReader)RemotingSubsystem20Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.REMOTING_3_0.getUriString(), (XMLElementReader)RemotingSubsystem30Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.REMOTING_4_0.getUriString(), (XMLElementReader)RemotingSubsystem40Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.REMOTING_5_0.getUriString(), (XMLElementReader)RemotingSubsystem50Parser.INSTANCE);
        if (context.getProcessType().isServer()) {
            context.setProfileParsingCompletionHandler((ProfileParsingCompletionHandler)new IOCompletionHandler());
        }
    }

    private static class DescribeHandler
    extends GenericSubsystemDescribeHandler {
        private DescribeHandler() {
        }

        protected void describe(OrderedChildTypesAttachment orderedChildTypesAttachment, Resource resource, ModelNode address, ModelNode result, ImmutableManagementResourceRegistration registration) {
            boolean describe = true;
            PathElement pe = registration.getPathAddress().getLastElement();
            if (pe.equals(RemotingEndpointResource.ENDPOINT_PATH)) {
                ModelNode model;
                describe = false;
                if (resource != null && (model = resource.getModel()).isDefined()) {
                    for (AttributeDefinition ad : RemotingEndpointResource.INSTANCE.getAttributes()) {
                        if (!model.hasDefined(ad.getName())) continue;
                        describe = true;
                        break;
                    }
                }
            }
            if (describe) {
                super.describe(orderedChildTypesAttachment, resource, address, result, registration);
            }
        }
    }

    private static class IOCompletionHandler
    implements ProfileParsingCompletionHandler {
        private IOCompletionHandler() {
        }

        public void handleProfileParsingCompletion(Map<String, List<ModelNode>> profileBootOperations, List<ModelNode> otherBootOperations) {
            String legacyNS = null;
            List<ModelNode> legacyRemotingOps = null;
            for (Namespace ns : Namespace.values()) {
                String nsString = ns.getUriString();
                if (nsString == null || !nsString.startsWith("urn:jboss:domain:remoting:1.") || (legacyRemotingOps = profileBootOperations.get(nsString)) == null) continue;
                legacyNS = nsString;
                break;
            }
            if (legacyRemotingOps != null) {
                boolean foundIO = false;
                for (String ns : profileBootOperations.keySet()) {
                    if (!ns.startsWith("urn:jboss:domain:io:")) continue;
                    foundIO = true;
                    break;
                }
                if (!foundIO) {
                    boolean hasIoExtension = false;
                    for (ModelNode op : otherBootOperations) {
                        PathAddress pa = PathAddress.pathAddress((ModelNode)op.get("address"));
                        if (pa.size() != 1 || !"extension".equals(pa.getElement(0).getKey()) || !RemotingExtension.IO_EXTENSION_MODULE.equals(pa.getElement(0).getValue())) continue;
                        hasIoExtension = true;
                        break;
                    }
                    if (!hasIoExtension) {
                        ModelNode addIoExtensionOp = Util.createAddOperation((PathAddress)PathAddress.pathAddress((String)"extension", (String)RemotingExtension.IO_EXTENSION_MODULE));
                        addIoExtensionOp.get("module").set(RemotingExtension.IO_EXTENSION_MODULE);
                        otherBootOperations.add(addIoExtensionOp);
                    }
                    PathAddress subsystemAddress = PathAddress.pathAddress((String)"subsystem", (String)"io");
                    legacyRemotingOps.add(Util.createAddOperation((PathAddress)subsystemAddress));
                    legacyRemotingOps.add(Util.createAddOperation((PathAddress)subsystemAddress.append("worker", "default")));
                    legacyRemotingOps.add(Util.createAddOperation((PathAddress)subsystemAddress.append("buffer-pool", "default")));
                    RemotingLogger.ROOT_LOGGER.addingIOSubsystem(legacyNS);
                }
            }
        }
    }
}

