package org.jboss.as.remoting.logging;

import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.as.controller.OperationFailedException;
import java.net.BindException;
import java.lang.String;
import java.net.URISyntaxException;
import java.io.IOException;
import org.jboss.logging.Logger;
import java.lang.Exception;
import javax.security.auth.callback.Callback;
import java.lang.RuntimeException;
import org.jboss.logging.BasicLogger;
import org.jboss.as.controller.PathAddress;
import org.jboss.msc.service.StartException;
import javax.security.auth.callback.UnsupportedCallbackException;
import java.util.Arrays;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2016-12-01T18:08:28-0600")
public class RemotingLogger_$logger extends DelegatingBasicLogger implements RemotingLogger,BasicLogger,Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = RemotingLogger_$logger.class.getName();
    public RemotingLogger_$logger(final Logger log) {
        super(log);
    }
    @Override
    public final void listeningOnSocket(final String address) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, listeningOnSocket$str(), address);
    }
    private static final String listeningOnSocket = "WFLYRMT0001: Listening on %s";
    protected String listeningOnSocket$str() {
        return listeningOnSocket;
    }
    private static final String couldNotStartChanelListener = "WFLYRMT0002: Could not start channel listener";
    protected String couldNotStartChanelListener$str() {
        return couldNotStartChanelListener;
    }
    @Override
    public final StartException couldNotStartChanelListener(final Exception e) {
        final StartException result = new StartException(String.format(couldNotStartChanelListener$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotBindToSocket = "WFLYRMT0004: %s";
    protected String couldNotBindToSocket$str() {
        return couldNotBindToSocket;
    }
    @Override
    public final StartException couldNotBindToSocket(final String message, final BindException e) {
        final StartException result = new StartException(String.format(couldNotBindToSocket$str(), message), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotStart = "WFLYRMT0005: Failed to start service";
    protected String couldNotStart$str() {
        return couldNotStart;
    }
    @Override
    public final StartException couldNotStart(final Exception e) {
        final StartException result = new StartException(String.format(couldNotStart$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String endpointEmpty = "WFLYRMT0006: Endpoint is null";
    protected String endpointEmpty$str() {
        return endpointEmpty;
    }
    @Override
    public final IllegalStateException endpointEmpty() {
        final IllegalStateException result = new IllegalStateException(String.format(endpointEmpty$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSupportingMechanismsForRealm = "WFLYRMT0011: A security realm has been specified but no supported mechanism identified";
    protected String noSupportingMechanismsForRealm$str() {
        return noSupportingMechanismsForRealm;
    }
    @Override
    public final IllegalStateException noSupportingMechanismsForRealm() {
        final IllegalStateException result = new IllegalStateException(String.format(noSupportingMechanismsForRealm$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String anonymousMechanismNotExpected = "WFLYRMT0012: ANONYMOUS mechanism so not expecting a callback";
    protected String anonymousMechanismNotExpected$str() {
        return anonymousMechanismNotExpected;
    }
    @Override
    public final UnsupportedCallbackException anonymousMechanismNotExpected(final Callback current) {
        final UnsupportedCallbackException result = new UnsupportedCallbackException(current, String.format(anonymousMechanismNotExpected$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotConnect = "WFLYRMT0015: Could not connect";
    protected String couldNotConnect$str() {
        return couldNotConnect;
    }
    @Override
    public final RuntimeException couldNotConnect(final URISyntaxException e) {
        final RuntimeException result = new RuntimeException(String.format(couldNotConnect$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidQOPV = "WFLYRMT0016: Invalid QOP value: %s";
    protected String invalidQOPV$str() {
        return invalidQOPV;
    }
    @Override
    public final IllegalStateException invalidQOPV(final String qop) {
        final IllegalStateException result = new IllegalStateException(String.format(invalidQOPV$str(), qop));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidStrength = "WFLYRMT0017: Invalid Strength value: %s";
    protected String invalidStrength$str() {
        return invalidStrength;
    }
    @Override
    public final IllegalStateException invalidStrength(final String strengthValue) {
        final IllegalStateException result = new IllegalStateException(String.format(invalidStrength$str(), strengthValue));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotCreateURI = "WFLYRMT0018: Cannot create a valid URI from %s -- %s";
    protected String couldNotCreateURI$str() {
        return couldNotCreateURI;
    }
    @Override
    public final OperationFailedException couldNotCreateURI(final String uri, final String msg) {
        final OperationFailedException result = new OperationFailedException(String.format(couldNotCreateURI$str(), uri, msg));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedCallback = "WFLYRMT0019: Unsupported Callback";
    protected String unsupportedCallback$str() {
        return unsupportedCallback;
    }
    @Override
    public final UnsupportedCallbackException unsupportedCallback(final Callback current) {
        final UnsupportedCallbackException result = new UnsupportedCallbackException(current, String.format(unsupportedCallback$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String illegalStrength = "WFLYRMT0020: Invalid Strength '%s' string given";
    protected String illegalStrength$str() {
        return illegalStrength;
    }
    @Override
    public final IllegalArgumentException illegalStrength(final String strength) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(illegalStrength$str(), strength));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String upgradeRequestMissingKey = "WFLYRMT0021: HTTP Upgrade request missing Sec-JbossRemoting-Key header";
    protected String upgradeRequestMissingKey$str() {
        return upgradeRequestMissingKey;
    }
    @Override
    public final IOException upgradeRequestMissingKey() {
        final IOException result = new IOException(String.format(upgradeRequestMissingKey$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String workerConfigurationIgnored = "WFLYRMT0022: Worker configuration is no longer used, please use endpoint worker configuration";
    protected String workerConfigurationIgnored$str() {
        return workerConfigurationIgnored;
    }
    @Override
    public final OperationFailedException workerConfigurationIgnored() {
        final OperationFailedException result = new OperationFailedException(String.format(workerConfigurationIgnored$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String workerThreadsEndpointConfigurationChoiceRequired = "WFLYRMT0023: Only one of '%s' configuration or '%s' configuration is allowed";
    protected String workerThreadsEndpointConfigurationChoiceRequired$str() {
        return workerThreadsEndpointConfigurationChoiceRequired;
    }
    @Override
    public final String workerThreadsEndpointConfigurationChoiceRequired(final String workerThreads, final String endpoint) {
        return String.format(workerThreadsEndpointConfigurationChoiceRequired$str(), workerThreads, endpoint);
    }
    @Override
    public final void addingIOSubsystem(final String legacyNS) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, addingIOSubsystem$str(), legacyNS);
    }
    private static final String addingIOSubsystem = "WFLYRMT0024: The remoting subsystem is present but no io subsystem was found. An io subsystem was not required when remoting schema '%s' was current but now is, so a default subsystem is being added.";
    protected String addingIOSubsystem$str() {
        return addingIOSubsystem;
    }
    private static final String couldNotRemoveResource = "WFLYRMT0025: Can't remove %s as JMX uses it as a remoting endpoint";
    protected String couldNotRemoveResource$str() {
        return couldNotRemoveResource;
    }
    @Override
    public final OperationFailedException couldNotRemoveResource(final PathAddress address) {
        final OperationFailedException result = new OperationFailedException(String.format(couldNotRemoveResource$str(), address));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
