/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.remoting.Attribute;
import org.jboss.as.remoting.ConnectorCommon;
import org.jboss.as.remoting.Element;
import org.jboss.as.remoting.RemotingSubsystem20Parser;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class RemotingSubsystem30Parser
extends RemotingSubsystem20Parser {
    static final RemotingSubsystem30Parser INSTANCE = new RemotingSubsystem30Parser();

    @Override
    void parseConnector(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        this.parseConnector(false, reader, address, list);
    }

    @Override
    void parseHttpConnector(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        this.parseConnector(true, reader, address, list);
    }

    void parseConnector(boolean http, XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ModelNode connector = new ModelNode();
        connector.get("operation").set("add");
        String name = null;
        String securityRealm = null;
        String socketBinding = null;
        String connectorRef = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, http ? Attribute.CONNECTOR_REF : Attribute.SOCKET_BINDING);
        int count = reader.getAttributeCount();
        block13: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block13;
                }
                case SASL_PROTOCOL: {
                    ConnectorCommon.SASL_PROTOCOL.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block13;
                }
                case SECURITY_REALM: {
                    securityRealm = value;
                    continue block13;
                }
                case SERVER_NAME: {
                    ConnectorCommon.SERVER_NAME.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block13;
                }
                case SOCKET_BINDING: {
                    if (http) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    socketBinding = value;
                    continue block13;
                }
                case CONNECTOR_REF: {
                    if (!http) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    connectorRef = value;
                    continue block13;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        assert (name != null);
        if (http ? !$assertionsDisabled && connectorRef == null : !$assertionsDisabled && socketBinding == null) {
            throw new AssertionError();
        }
        connector.get("address").set(address).add(http ? "http-connector" : "connector", name);
        if (http) {
            connector.get("connector-ref").set(connectorRef);
        } else {
            connector.get("socket-binding").set(socketBinding);
        }
        if (securityRealm != null) {
            connector.get("security-realm").set(securityRealm);
        }
        list.add(connector);
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block14: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (visited.contains((Object)element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            visited.add(element);
            switch (element) {
                case SASL: {
                    this.parseSaslElement(reader, connector.get("address"), list);
                    continue block14;
                }
                case PROPERTIES: {
                    this.parseProperties(reader, connector.get("address"), list);
                    continue block14;
                }
                case AUTHENTICATION_PROVIDER: {
                    connector.get("authentication-provider").set(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name"));
                    continue block14;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }
}

