/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.repository.ContentReference;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.deployment.DeploymentHandlerUtil;
import org.jboss.as.server.deployment.DeploymentHandlerUtils;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.ModelContentReference;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.dmr.ModelNode;

public class DeploymentAddHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "add";
    protected final ContentRepository contentRepository;
    private final AbstractVaultReader vaultReader;

    protected DeploymentAddHandler(ContentRepository contentRepository, AbstractVaultReader vaultReader) {
        assert (contentRepository != null) : "Null contentRepository";
        this.contentRepository = contentRepository;
        this.vaultReader = vaultReader;
    }

    public static DeploymentAddHandler create(ContentRepository contentRepository, AbstractVaultReader vaultReader) {
        return new DeploymentAddHandler(contentRepository, vaultReader);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        DeploymentHandlerUtil.ContentItem contentItem;
        boolean persistent;
        if (!operation.hasDefined(DeploymentAttributes.PERSISTENT.getName())) {
            operation.get(DeploymentAttributes.PERSISTENT.getName()).set(true);
        }
        Resource resource = Resource.Factory.create((!(persistent = DeploymentAttributes.PERSISTENT.resolveModelAttribute(context, operation).asBoolean()) ? 1 : 0) != 0);
        context.addResource(PathAddress.EMPTY_ADDRESS, resource);
        ModelNode newModel = resource.getModel();
        DeploymentAttributes.PERSISTENT.validateAndSet(operation, newModel);
        for (AttributeDefinition def : DeploymentAttributes.SERVER_ADD_ATTRIBUTES) {
            def.validateAndSet(operation, newModel);
        }
        ModelNode content = newModel.require(DeploymentAttributes.CONTENT_ALL.getName());
        ModelNode contentItemNode = content.require(0);
        ModelNode opAddr = operation.get("address");
        final PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
        final String name = address.getLastElement().getValue();
        String runtimeName = operation.hasDefined(DeploymentAttributes.RUNTIME_NAME.getName()) ? operation.get(DeploymentAttributes.RUNTIME_NAME.getName()).asString() : name;
        newModel.get(DeploymentAttributes.RUNTIME_NAME.getName()).set(runtimeName);
        if (contentItemNode.hasDefined(DeploymentAttributes.CONTENT_HASH.getName())) {
            byte[] hash = contentItemNode.require(DeploymentAttributes.CONTENT_HASH.getName()).asBytes();
            contentItem = this.addFromHash(hash, name, address, context);
        } else if (DeploymentHandlerUtils.hasValidContentAdditionParameterDefined(contentItemNode)) {
            contentItem = this.addFromContentAdditionParameter(context, contentItemNode);
            contentItemNode = new ModelNode();
            contentItemNode.get(DeploymentAttributes.CONTENT_HASH.getName()).set(contentItem.getHash());
            content = new ModelNode();
            content.add(contentItemNode);
            newModel.get(DeploymentAttributes.CONTENT_ALL.getName()).set(content);
        } else {
            contentItem = this.addUnmanaged(contentItemNode);
        }
        if (context.getProcessType() == ProcessType.STANDALONE_SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    DeploymentAddHandler.this.validateRuntimeNames(name, context);
                }
            }, OperationContext.Stage.MODEL);
        }
        if (DeploymentAttributes.ENABLED.resolveModelAttribute(context, newModel).asBoolean() && context.isNormalServer()) {
            DeploymentHandlerUtil.deploy(context, runtimeName, name, this.vaultReader, contentItem);
            DeploymentUtils.enableAttribute(newModel);
        }
        if (contentItem.getHash() != null) {
            final byte[] contentHash = contentItem.getHash();
            context.completeStep(new OperationContext.ResultHandler(){

                public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                    if (resultAction == OperationContext.ResultAction.KEEP) {
                        DeploymentAddHandler.this.contentRepository.addContentReference(ModelContentReference.fromModelAddress(address, contentHash));
                    }
                }
            });
        }
    }

    private void validateRuntimeNames(String deploymentName, OperationContext context) throws OperationFailedException {
        ModelNode deployment = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        if (DeploymentAttributes.ENABLED.resolveModelAttribute(context, deployment).asBoolean()) {
            String runtimeName = DeploymentAddHandler.getRuntimeName(deploymentName, deployment);
            Resource root = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS);
            for (Resource.ResourceEntry re : root.getChildren("deployment")) {
                String otherRuntimeName;
                ModelNode otherDepl;
                String reName = re.getName();
                if (deploymentName.equals(reName) || !DeploymentAttributes.ENABLED.resolveModelAttribute(context, otherDepl = re.getModel()).asBoolean() || !runtimeName.equals(otherRuntimeName = DeploymentAddHandler.getRuntimeName(reName, otherDepl))) continue;
                throw ServerLogger.ROOT_LOGGER.runtimeNameMustBeUnique(reName, runtimeName);
            }
        }
    }

    private static String getRuntimeName(String name, ModelNode deployment) {
        return deployment.hasDefined("runtime-name") ? deployment.get("runtime-name").asString() : name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    DeploymentHandlerUtil.ContentItem addFromHash(byte[] hash, String deploymentName, PathAddress address, OperationContext context) throws OperationFailedException {
        ContentReference reference = ModelContentReference.fromModelAddress(address, hash);
        if (this.contentRepository.syncContent(reference)) return new DeploymentHandlerUtil.ContentItem(hash);
        if (!context.isBooting()) throw ServerLogger.ROOT_LOGGER.noSuchDeploymentContent(reference.getHexHash());
        if (context.getRunningMode() != RunningMode.ADMIN_ONLY) throw ServerLogger.ROOT_LOGGER.noSuchDeploymentContentAtBoot(reference.getHexHash(), deploymentName);
        ServerLogger.DEPLOYMENT_LOGGER.reportAdminOnlyMissingDeploymentContent(reference.getHexHash(), deploymentName);
        return new DeploymentHandlerUtil.ContentItem(hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DeploymentHandlerUtil.ContentItem addFromContentAdditionParameter(OperationContext context, ModelNode contentItemNode) throws OperationFailedException {
        byte[] hash;
        InputStream in = DeploymentHandlerUtils.getInputStream(context, contentItemNode);
        try {
            try {
                hash = this.contentRepository.addContent(in);
            }
            catch (IOException e) {
                throw DeploymentHandlerUtils.createFailureException(e.toString());
            }
        }
        finally {
            StreamUtils.safeClose((Closeable)in);
        }
        return new DeploymentHandlerUtil.ContentItem(hash);
    }

    DeploymentHandlerUtil.ContentItem addUnmanaged(ModelNode contentItemNode) throws OperationFailedException {
        String path = contentItemNode.require(DeploymentAttributes.CONTENT_PATH.getName()).asString();
        String relativeTo = DeploymentHandlerUtils.asString(contentItemNode, DeploymentAttributes.CONTENT_RELATIVE_TO.getName());
        boolean archive = contentItemNode.require(DeploymentAttributes.CONTENT_ARCHIVE.getName()).asBoolean();
        return new DeploymentHandlerUtil.ContentItem(path, relativeTo, archive);
    }
}

