/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import io.undertow.server.ListenerRegistry;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.http.server.ConsoleMode;
import org.jboss.as.domain.http.server.ManagementHttpRequestProcessor;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.network.SocketBindingManagerImpl;
import org.jboss.as.remoting.HttpListenerRegistryService;
import org.jboss.as.remoting.RemotingHttpUpgradeService;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.management.ManagementChannelRegistryService;
import org.jboss.as.remoting.management.ManagementRemotingServices;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.as.server.Services;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.mgmt.HttpManagementRequestsService;
import org.jboss.as.server.mgmt.HttpManagementResourceDefinition;
import org.jboss.as.server.mgmt.HttpShutdownService;
import org.jboss.as.server.mgmt.UndertowHttpManagementService;
import org.jboss.as.server.operations.NativeManagementServices;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.remoting3.RemotingOptions;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.xnio.OptionMap;

public class HttpManagementAddHandler
extends AbstractAddStepHandler {
    public static final HttpManagementAddHandler INSTANCE = new HttpManagementAddHandler();
    public static final String OPERATION_NAME = "add";

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        ModelNode model = resource.getModel();
        for (AttributeDefinition definition : HttpManagementResourceDefinition.ATTRIBUTE_DEFINITIONS) {
            HttpManagementAddHandler.validateAndSet(definition, operation, model);
        }
        HttpManagementResourceDefinition.addValidatingHandler(context, operation);
    }

    protected boolean requiresRuntime(OperationContext context) {
        return WildFlySecurityManager.getPropertyPrivileged((String)"jboss.as.test.disable.runtime", null) == null;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        boolean httpUpgrade = HttpManagementResourceDefinition.HTTP_UPGRADE_ENABLED.resolveModelAttribute(context, model).asBoolean();
        HttpManagementAddHandler.installHttpManagementConnector(context, model, context.getServiceTarget(), httpUpgrade);
    }

    private static void validateAndSet(AttributeDefinition definition, ModelNode operation, ModelNode subModel) throws OperationFailedException {
        String attributeName = definition.getName();
        boolean has = operation.has(attributeName);
        if (!has && definition.isRequired(operation)) {
            throw ServerLogger.ROOT_LOGGER.attributeIsRequired(attributeName);
        }
        if (has) {
            if (!definition.isAllowed(operation)) {
                throw ServerLogger.ROOT_LOGGER.attributeIsInvalid(attributeName);
            }
            definition.validateAndSet(operation, subModel);
        } else {
            subModel.get(definition.getName());
        }
    }

    private static ModelNode validateResolvedModel(AttributeDefinition definition, OperationContext context, ModelNode subModel) throws OperationFailedException {
        ModelNode result;
        String attributeName = definition.getName();
        boolean has = subModel.has(attributeName);
        if (!has && definition.isRequired(subModel)) {
            throw ServerLogger.ROOT_LOGGER.attributeIsRequired(attributeName);
        }
        if (has) {
            if (!definition.isAllowed(subModel)) {
                if (subModel.hasDefined(attributeName)) {
                    throw ServerLogger.ROOT_LOGGER.attributeNotAllowedWhenAlternativeIsPresent(attributeName, Arrays.asList(definition.getAlternatives()));
                }
                result = new ModelNode();
            } else {
                result = definition.resolveModelAttribute(context, subModel);
            }
        } else {
            result = new ModelNode();
        }
        return result;
    }

    static void installHttpManagementConnector(OperationContext context, ModelNode model, ServiceTarget serviceTarget, boolean httpUpgrade) throws OperationFailedException {
        ServiceName socketBindingServiceName = null;
        ServiceName secureSocketBindingServiceName = null;
        ServiceName interfaceSvcName = null;
        int port = -1;
        int securePort = -1;
        ModelNode interfaceModelNode = HttpManagementAddHandler.validateResolvedModel((AttributeDefinition)HttpManagementResourceDefinition.INTERFACE, context, model);
        List allowedOrigins = HttpManagementResourceDefinition.ALLOWED_ORIGINS.unwrap((ExpressionResolver)context, model);
        if (interfaceModelNode.isDefined()) {
            String interfaceName = interfaceModelNode.asString();
            interfaceSvcName = NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{interfaceName});
            ModelNode portNode = HttpManagementResourceDefinition.HTTP_PORT.resolveModelAttribute(context, model);
            port = portNode.isDefined() ? portNode.asInt() : -1;
            ModelNode securePortNode = HttpManagementResourceDefinition.HTTPS_PORT.resolveModelAttribute(context, model);
            int n = securePort = securePortNode.isDefined() ? securePortNode.asInt() : -1;
            if (securePort > -1) {
                if (port > -1) {
                    ServerLogger.ROOT_LOGGER.creatingHttpManagementServiceOnPortAndSecurePort(interfaceName, port, securePort);
                } else {
                    ServerLogger.ROOT_LOGGER.creatingHttpManagementServiceOnSecurePort(interfaceName, securePort);
                }
            } else if (port > -1) {
                ServerLogger.ROOT_LOGGER.creatingHttpManagementServiceOnPort(interfaceName, port);
            }
        } else {
            ModelNode secureSocketBindingNode;
            ModelNode socketBindingNode = HttpManagementResourceDefinition.SOCKET_BINDING.resolveModelAttribute(context, model);
            if (socketBindingNode.isDefined()) {
                String bindingName = socketBindingNode.asString();
                socketBindingServiceName = SocketBinding.JBOSS_BINDING_NAME.append(new String[]{bindingName});
            }
            if ((secureSocketBindingNode = HttpManagementResourceDefinition.SECURE_SOCKET_BINDING.resolveModelAttribute(context, model)).isDefined()) {
                String bindingName = secureSocketBindingNode.asString();
                secureSocketBindingServiceName = SocketBinding.JBOSS_BINDING_NAME.append(new String[]{bindingName});
            }
            if (socketBindingServiceName != null) {
                if (secureSocketBindingServiceName != null) {
                    ServerLogger.ROOT_LOGGER.creatingHttpManagementServiceOnSocketAndSecureSocket(socketBindingServiceName.getSimpleName(), secureSocketBindingServiceName.getSimpleName());
                } else {
                    ServerLogger.ROOT_LOGGER.creatingHttpManagementServiceOnSocket(socketBindingServiceName.getSimpleName());
                }
            } else if (secureSocketBindingServiceName != null) {
                ServerLogger.ROOT_LOGGER.creatingHttpManagementServiceOnSecureSocket(secureSocketBindingServiceName.getSimpleName());
            }
        }
        String securityRealm = null;
        ModelNode realmNode = HttpManagementResourceDefinition.SECURITY_REALM.resolveModelAttribute(context, model);
        if (realmNode.isDefined()) {
            securityRealm = realmNode.asString();
        } else {
            ServerLogger.ROOT_LOGGER.httpManagementInterfaceIsUnsecured();
        }
        boolean consoleEnabled = model.get("console-enabled").asBoolean(true);
        ConsoleMode consoleMode = consoleEnabled ? (context.getRunningMode() == RunningMode.ADMIN_ONLY ? ConsoleMode.ADMIN_ONLY : ConsoleMode.CONSOLE) : ConsoleMode.NO_CONSOLE;
        ServiceName requestProcessorName = UndertowHttpManagementService.SERVICE_NAME.append(new String[]{"requests"});
        HttpManagementRequestsService.installService(requestProcessorName, serviceTarget);
        ServerEnvironment environment = (ServerEnvironment)context.getServiceRegistry(false).getRequiredService(ServerEnvironmentService.SERVICE_NAME).getValue();
        UndertowHttpManagementService undertowService = new UndertowHttpManagementService(consoleMode, environment.getProductConfig().getConsoleSlot());
        ServiceBuilder undertowBuilder = serviceTarget.addService(UndertowHttpManagementService.SERVICE_NAME, (Service)undertowService).addDependency(Services.JBOSS_SERVER_CONTROLLER, ModelController.class, undertowService.getModelControllerInjector()).addDependency(SocketBindingManagerImpl.SOCKET_BINDING_MANAGER, SocketBindingManager.class, undertowService.getSocketBindingManagerInjector()).addDependency(ControlledProcessStateService.SERVICE_NAME, ControlledProcessStateService.class, undertowService.getControlledProcessStateServiceInjector()).addDependency(HttpListenerRegistryService.SERVICE_NAME, ListenerRegistry.class, undertowService.getListenerRegistry()).addDependency(requestProcessorName, ManagementHttpRequestProcessor.class, undertowService.getRequestProcessorValue()).addInjection(undertowService.getAllowedOriginsInjector(), (Object)allowedOrigins);
        if (interfaceSvcName != null) {
            undertowBuilder.addDependency(interfaceSvcName, NetworkInterfaceBinding.class, undertowService.getInterfaceInjector()).addInjection(undertowService.getPortInjector(), (Object)port).addInjection(undertowService.getSecurePortInjector(), (Object)securePort);
        } else {
            if (socketBindingServiceName != null) {
                undertowBuilder.addDependency(socketBindingServiceName, SocketBinding.class, undertowService.getSocketBindingInjector());
            }
            if (secureSocketBindingServiceName != null) {
                undertowBuilder.addDependency(secureSocketBindingServiceName, SocketBinding.class, undertowService.getSecureSocketBindingInjector());
            }
        }
        if (securityRealm != null) {
            SecurityRealm.ServiceUtil.addDependency((ServiceBuilder)undertowBuilder, undertowService.getSecurityRealmInjector(), (String)securityRealm, (boolean)false);
        }
        undertowBuilder.install();
        HttpShutdownService shutdownService = new HttpShutdownService();
        ServiceName shutdownName = UndertowHttpManagementService.SERVICE_NAME.append(new String[]{"shutdown"});
        serviceTarget.addService(shutdownName, (Service)shutdownService).addDependency(requestProcessorName, ManagementHttpRequestProcessor.class, shutdownService.getProcessorValue()).addDependency(Services.JBOSS_SERVER_EXECUTOR, Executor.class, shutdownService.getExecutorValue()).addDependency(ManagementChannelRegistryService.SERVICE_NAME, ManagementChannelRegistryService.class, shutdownService.getMgmtChannelRegistry()).addDependency(UndertowHttpManagementService.SERVICE_NAME).setInitialMode(ServiceController.Mode.ACTIVE).install();
        if (httpUpgrade) {
            String hostName = WildFlySecurityManager.getPropertyPrivileged((String)"jboss.node.name", null);
            ServiceName tmpDirPath = ServiceName.JBOSS.append(new String[]{"server", "path", "jboss.server.temp.dir"});
            RemotingServices.installSecurityServices((ServiceTarget)serviceTarget, (String)"http-management", (String)securityRealm, null, (ServiceName)tmpDirPath);
            NativeManagementServices.installRemotingServicesIfNotInstalled(serviceTarget, hostName, context.getServiceRegistry(false));
            String httpConnectorName = port > -1 || socketBindingServiceName != null || securePort < 0 && secureSocketBindingServiceName == null ? "http-management" : "https-management";
            OptionMap options = HttpManagementAddHandler.createConnectorOptions(context, model);
            RemotingHttpUpgradeService.installServices((ServiceTarget)serviceTarget, (String)"http-management", (String)httpConnectorName, (ServiceName)ManagementRemotingServices.MANAGEMENT_ENDPOINT, (OptionMap)options);
        }
    }

    private static OptionMap createConnectorOptions(OperationContext context, ModelNode model) throws OperationFailedException {
        OptionMap.Builder builder = OptionMap.builder();
        builder.set(RemotingOptions.SASL_PROTOCOL, (Object)HttpManagementResourceDefinition.SASL_PROTOCOL.resolveModelAttribute(context, model).asString());
        ModelNode serverName = HttpManagementResourceDefinition.SERVER_NAME.resolveModelAttribute(context, model);
        if (serverName.isDefined()) {
            builder.set(RemotingOptions.SERVER_NAME, (Object)serverName.asString());
        }
        return builder.getMap();
    }
}

