/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.requestcontroller;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.requestcontroller.GlobalRequestController;
import org.jboss.as.server.requestcontroller.RunResult;
import org.jboss.as.server.shutdown.ServerActivityListener;

public class ControlPoint {
    private static final AtomicIntegerFieldUpdater<ControlPoint> activeRequestCountUpdater = AtomicIntegerFieldUpdater.newUpdater(ControlPoint.class, "activeRequestCount");
    private static final AtomicReferenceFieldUpdater<ControlPoint, ServerActivityListener> listenerUpdater = AtomicReferenceFieldUpdater.newUpdater(ControlPoint.class, ServerActivityListener.class, "listener");
    private final GlobalRequestController controller;
    private final String deployment;
    private final String entryPoint;
    private volatile int activeRequestCount = 0;
    private volatile boolean paused = false;
    private volatile ServerActivityListener listener = null;
    private int referenceCount = 0;

    ControlPoint(GlobalRequestController controller, String deployment, String entryPoint) {
        this.controller = controller;
        this.deployment = deployment;
        this.entryPoint = entryPoint;
    }

    public String getEntryPoint() {
        return this.entryPoint;
    }

    public String getDeployment() {
        return this.deployment;
    }

    public void pause(ServerActivityListener requestCountListener) {
        if (this.paused) {
            throw ServerLogger.ROOT_LOGGER.serverAlreadyPaused();
        }
        this.paused = true;
        listenerUpdater.set(this, requestCountListener);
        if (activeRequestCountUpdater.get(this) == 0 && listenerUpdater.compareAndSet(this, requestCountListener, null)) {
            requestCountListener.requestsComplete();
        }
    }

    public void resume() {
        this.paused = false;
        ServerActivityListener listener = listenerUpdater.get(this);
        if (listener != null && listenerUpdater.compareAndSet(this, listener, null)) {
            listener.unPaused();
        }
    }

    public RunResult beginRequest() throws Exception {
        if (this.paused) {
            return RunResult.REJECTED;
        }
        activeRequestCountUpdater.incrementAndGet(this);
        RunResult runResult = this.controller.beginRequest();
        if (runResult == RunResult.REJECTED) {
            this.decreaseRequestCount();
        }
        return runResult;
    }

    public void requestComplete() {
        this.decreaseRequestCount();
        this.controller.requestComplete();
    }

    private void decreaseRequestCount() {
        ServerActivityListener listener;
        int result = activeRequestCountUpdater.decrementAndGet(this);
        if (this.paused && result == 0 && (listener = listenerUpdater.get(this)) != null && listenerUpdater.compareAndSet(this, listener, null)) {
            listener.requestsComplete();
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public int getActiveRequestCount() {
        return activeRequestCountUpdater.get(this);
    }

    synchronized int increaseReferenceCount() {
        return ++this.referenceCount;
    }

    synchronized int decreaseReferenceCount() {
        return --this.referenceCount;
    }
}

