/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.requestcontroller;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.server.shutdown.ServerActivityListener;

class CountingRequestCountListener
implements ServerActivityListener {
    private final AtomicInteger count;
    private final ServerActivityListener delegate;
    private final AtomicBoolean canceled = new AtomicBoolean(false);

    CountingRequestCountListener(int count, ServerActivityListener delegate) {
        this.count = new AtomicInteger(count);
        this.delegate = delegate;
    }

    @Override
    public void requestsComplete() {
        if (this.count.decrementAndGet() == 0) {
            this.delegate.requestsComplete();
        }
    }

    @Override
    public void unPaused() {
        if (this.canceled.compareAndSet(false, true)) {
            this.delegate.unPaused();
        }
    }
}

