/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.requestcontroller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.as.server.requestcontroller.ControlPoint;
import org.jboss.as.server.requestcontroller.CountingRequestCountListener;
import org.jboss.as.server.requestcontroller.RequestControllerState;
import org.jboss.as.server.requestcontroller.RunResult;
import org.jboss.as.server.shutdown.ServerActivity;
import org.jboss.as.server.shutdown.ServerActivityListener;
import org.jboss.as.server.shutdown.SuspendController;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class GlobalRequestController
implements Service<GlobalRequestController>,
ServerActivity {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"server", "global-request-controller"});
    private static final AtomicIntegerFieldUpdater<GlobalRequestController> activeRequestCountUpdater = AtomicIntegerFieldUpdater.newUpdater(GlobalRequestController.class, "activeRequestCount");
    private static final AtomicReferenceFieldUpdater<GlobalRequestController, ServerActivityListener> listenerUpdater = AtomicReferenceFieldUpdater.newUpdater(GlobalRequestController.class, ServerActivityListener.class, "listener");
    private volatile int maxRequestCount = 0;
    private volatile int activeRequestCount = 0;
    private volatile boolean paused = false;
    private final Map<EntryPointIdentifier, ControlPoint> entryPoints = new HashMap<EntryPointIdentifier, ControlPoint>();
    private final InjectedValue<SuspendController> shutdownControllerInjectedValue = new InjectedValue();
    private volatile ServerActivityListener listener = null;

    @Override
    public synchronized void pause(ServerActivityListener requestCountListener) {
        this.paused = true;
        listenerUpdater.set(this, requestCountListener);
        if (activeRequestCountUpdater.get(this) == 0 && listenerUpdater.compareAndSet(this, requestCountListener, null)) {
            requestCountListener.requestsComplete();
        }
    }

    @Override
    public synchronized void resume() {
        this.paused = false;
        ServerActivityListener listener = listenerUpdater.get(this);
        if (listener != null && listenerUpdater.compareAndSet(this, listener, null)) {
            listener.unPaused();
        }
    }

    public synchronized void pauseDeployment(String deployment, ServerActivityListener listener) {
        ArrayList<ControlPoint> eps = new ArrayList<ControlPoint>();
        for (ControlPoint ep : this.entryPoints.values()) {
            if (!ep.getDeployment().equals(deployment)) continue;
            eps.add(ep);
        }
        CountingRequestCountListener realListener = new CountingRequestCountListener(eps.size(), listener);
        for (ControlPoint ep : eps) {
            ep.pause(realListener);
        }
    }

    public synchronized void resumeDeployment(String deployment) {
        ArrayList eps = new ArrayList();
        for (ControlPoint ep : this.entryPoints.values()) {
            if (!ep.getDeployment().equals(deployment)) continue;
            ep.resume();
        }
    }

    public synchronized void pauseEntryPoint(String entryPoint, ServerActivityListener listener) {
        ArrayList<ControlPoint> eps = new ArrayList<ControlPoint>();
        for (ControlPoint ep : this.entryPoints.values()) {
            if (!ep.getEntryPoint().equals(entryPoint)) continue;
            eps.add(ep);
        }
        CountingRequestCountListener realListener = new CountingRequestCountListener(eps.size(), listener);
        for (ControlPoint ep : eps) {
            ep.pause(realListener);
        }
    }

    public synchronized void resumeEntryPoint(String entryPoint) {
        ArrayList eps = new ArrayList();
        for (ControlPoint ep : this.entryPoints.values()) {
            if (!ep.getEntryPoint().equals(entryPoint)) continue;
            ep.resume();
        }
    }

    public synchronized RequestControllerState getState() {
        ArrayList<RequestControllerState.EntryPointState> eps = new ArrayList<RequestControllerState.EntryPointState>();
        for (ControlPoint controlPoint : this.entryPoints.values()) {
            eps.add(new RequestControllerState.EntryPointState(controlPoint.getDeployment(), controlPoint.getEntryPoint(), controlPoint.isPaused(), controlPoint.getActiveRequestCount()));
        }
        return new RequestControllerState(this.paused, this.activeRequestCount, this.maxRequestCount, eps);
    }

    RunResult beginRequest() {
        int maxRequests = this.maxRequestCount;
        int active = activeRequestCountUpdater.get(this);
        boolean success = false;
        while (!(maxRequests > 0 && active >= maxRequests || this.paused)) {
            if (activeRequestCountUpdater.compareAndSet(this, active, active + 1)) {
                success = true;
                break;
            }
            active = activeRequestCountUpdater.get(this);
        }
        if (success) {
            if (this.paused) {
                this.requestComplete();
                return RunResult.REJECTED;
            }
            return RunResult.RUN;
        }
        return RunResult.REJECTED;
    }

    void requestComplete() {
        ServerActivityListener listener;
        int result = activeRequestCountUpdater.decrementAndGet(this);
        if (this.paused && this.paused && result == 0 && (listener = listenerUpdater.get(this)) != null && listenerUpdater.compareAndSet(this, listener, null)) {
            listener.requestsComplete();
        }
    }

    public synchronized ControlPoint getEntryPoint(String deploymentName, String entryPointName) {
        EntryPointIdentifier id = new EntryPointIdentifier(deploymentName, entryPointName);
        ControlPoint ep = this.entryPoints.get(id);
        if (ep == null) {
            ep = new ControlPoint(this, deploymentName, entryPointName);
            this.entryPoints.put(id, ep);
        }
        ep.increaseReferenceCount();
        return ep;
    }

    public synchronized void removeEntryPoint(ControlPoint controlPoint) {
        if (controlPoint.decreaseReferenceCount() == 0) {
            EntryPointIdentifier id = new EntryPointIdentifier(controlPoint.getDeployment(), controlPoint.getEntryPoint());
            this.entryPoints.remove(id);
        }
    }

    public int getMaxRequestCount() {
        return this.maxRequestCount;
    }

    public void setMaxRequestCount(int maxRequestCount) {
        this.maxRequestCount = maxRequestCount;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void start(StartContext startContext) throws StartException {
        ((SuspendController)this.shutdownControllerInjectedValue.getValue()).registerActivity(this);
    }

    public void stop(StopContext stopContext) {
        ((SuspendController)this.shutdownControllerInjectedValue.getValue()).unRegisterActivity(this);
    }

    public GlobalRequestController getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<SuspendController> getShutdownControllerInjectedValue() {
        return this.shutdownControllerInjectedValue;
    }

    private static final class EntryPointIdentifier {
        private final String deployment;
        private final String name;

        private EntryPointIdentifier(String deployment, String name) {
            this.deployment = deployment;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EntryPointIdentifier that = (EntryPointIdentifier)o;
            if (this.deployment != null ? !this.deployment.equals(that.deployment) : that.deployment != null) {
                return false;
            }
            return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
        }

        public int hashCode() {
            int result = this.deployment != null ? this.deployment.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }
}

