/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.UnauthorizedException;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.NotificationEntry;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.dmr.ModelNode;

public class RootResourceHack
implements OperationStepHandler {
    public static final RootResourceHack INSTANCE = new RootResourceHack();
    public static final String NAME = "root-resource-hack";
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("root-resource-hack", null).setPrivateEntry().setRuntimeOnly().build();
    private static final ModelNode OPERATION = new ModelNode();
    private ThreadLocal<ResourceAndRegistration> resource = new ThreadLocal();

    private RootResourceHack() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ResourceAndRegistration threadResource = this.resource.get();
        if (threadResource == null || threadResource != ResourceAndRegistration.NULL) {
            throw ServerLogger.ROOT_LOGGER.internalUseOnly();
        }
        try {
            this.resource.set(new ResourceAndRegistration(context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, true), context.getResourceRegistration()));
        }
        catch (UnauthorizedException e) {
            this.resource.set(new ResourceAndRegistration(Resource.Factory.create(), new EmptyResourceRegistration()));
        }
        context.stepCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceAndRegistration getRootResource(ModelController controller) {
        this.resource.set(ResourceAndRegistration.NULL);
        ResourceAndRegistration reg = null;
        try {
            controller.execute(OPERATION, null, ModelController.OperationTransactionControl.COMMIT, null);
        }
        finally {
            reg = this.resource.get();
            this.resource.remove();
            if (ResourceAndRegistration.NULL == reg) {
                throw ServerLogger.ROOT_LOGGER.cannotGetRootResource();
            }
        }
        return reg;
    }

    static {
        OPERATION.get("operation").set(NAME);
    }

    private static class EmptyResourceRegistration
    implements ImmutableManagementResourceRegistration {
        private EmptyResourceRegistration() {
        }

        public boolean isRuntimeOnly() {
            return false;
        }

        public boolean isRemote() {
            return false;
        }

        public boolean isAlias() {
            return false;
        }

        public AliasEntry getAliasEntry() {
            return null;
        }

        public OperationStepHandler getOperationHandler(PathAddress address, String operationName) {
            return null;
        }

        public DescriptionProvider getOperationDescription(PathAddress address, String operationName) {
            return null;
        }

        public Set<OperationEntry.Flag> getOperationFlags(PathAddress address, String operationName) {
            return null;
        }

        public OperationEntry getOperationEntry(PathAddress address, String operationName) {
            return null;
        }

        public Set<String> getAttributeNames(PathAddress address) {
            return Collections.emptySet();
        }

        public AttributeAccess getAttributeAccess(PathAddress address, String attributeName) {
            return null;
        }

        public Set<String> getChildNames(PathAddress address) {
            return Collections.emptySet();
        }

        public Set<PathElement> getChildAddresses(PathAddress address) {
            return Collections.emptySet();
        }

        public DescriptionProvider getModelDescription(PathAddress address) {
            return null;
        }

        public Map<String, OperationEntry> getOperationDescriptions(PathAddress address, boolean inherited) {
            return Collections.emptyMap();
        }

        public Map<String, NotificationEntry> getNotificationDescriptions(PathAddress address, boolean inherited) {
            return Collections.emptyMap();
        }

        public ProxyController getProxyController(PathAddress address) {
            return null;
        }

        public Set<ProxyController> getProxyControllers(PathAddress address) {
            return Collections.emptySet();
        }

        public ImmutableManagementResourceRegistration getSubModel(PathAddress address) {
            return null;
        }

        public List<AccessConstraintDefinition> getAccessConstraints() {
            return Collections.emptyList();
        }
    }

    public static class ResourceAndRegistration {
        private static final ResourceAndRegistration NULL = new ResourceAndRegistration(null, null);
        private final Resource resource;
        private final ImmutableManagementResourceRegistration registry;

        private ResourceAndRegistration(Resource resource, ImmutableManagementResourceRegistration registry) {
            this.resource = resource;
            this.registry = registry;
        }

        public Resource getResource() {
            return this.resource;
        }

        public ImmutableManagementResourceRegistration getRegistration() {
            return this.registry;
        }
    }
}

