/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractControllerService;
import org.jboss.as.controller.BootContext;
import org.jboss.as.controller.CapabilityRegistry;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.DelegatingResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ManagementModel;
import org.jboss.as.controller.ModelControllerServiceInitialization;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.access.management.AccessConstraintUtilizationRegistry;
import org.jboss.as.controller.access.management.DelegatingConfigurableAuthorizer;
import org.jboss.as.controller.access.management.ManagementSecurityIdentitySupplier;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.capability.registry.CapabilityScope;
import org.jboss.as.controller.capability.registry.RegistrationPoint;
import org.jboss.as.controller.capability.registry.RuntimeCapabilityRegistration;
import org.jboss.as.controller.capability.registry.RuntimeCapabilityRegistry;
import org.jboss.as.controller.notification.Notification;
import org.jboss.as.controller.notification.NotificationHandlerRegistry;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.domain.management.access.AccessAuthorizationResourceDefinition;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.RootPlatformMBeanResource;
import org.jboss.as.remoting.HttpListenerRegistryService;
import org.jboss.as.remoting.management.ManagementRemotingServices;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.server.Bootstrap;
import org.jboss.as.server.BootstrapListener;
import org.jboss.as.server.DeployerChainAddHandler;
import org.jboss.as.server.DomainServerCommunicationServices;
import org.jboss.as.server.ExternalManagementRequestExecutor;
import org.jboss.as.server.GracefulShutdownService;
import org.jboss.as.server.RuntimeExpressionResolver;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentResourceDescription;
import org.jboss.as.server.Services;
import org.jboss.as.server.SystemExiter;
import org.jboss.as.server.controller.resources.ServerRootResourceDefinition;
import org.jboss.as.server.controller.resources.VersionModelInitializer;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeferredDeploymentOverlayDeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentCompleteServiceProcessor;
import org.jboss.as.server.deployment.DeploymentMountProvider;
import org.jboss.as.server.deployment.DeploymentOverlayDeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.ServiceLoaderProcessor;
import org.jboss.as.server.deployment.SubDeploymentProcessor;
import org.jboss.as.server.deployment.annotation.AnnotationIndexProcessor;
import org.jboss.as.server.deployment.annotation.CleanupAnnotationIndexProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndexProcessor;
import org.jboss.as.server.deployment.dependencies.DeploymentDependenciesProcessor;
import org.jboss.as.server.deployment.integration.Seam2Processor;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXMLParsingProcessor;
import org.jboss.as.server.deployment.module.ClassFileTransformerProcessor;
import org.jboss.as.server.deployment.module.DeploymentRootMountProcessor;
import org.jboss.as.server.deployment.module.DeploymentVisibilityProcessor;
import org.jboss.as.server.deployment.module.DriverDependenciesProcessor;
import org.jboss.as.server.deployment.module.ManifestAttachmentProcessor;
import org.jboss.as.server.deployment.module.ManifestClassPathProcessor;
import org.jboss.as.server.deployment.module.ManifestDependencyProcessor;
import org.jboss.as.server.deployment.module.ManifestExtensionListProcessor;
import org.jboss.as.server.deployment.module.ManifestExtensionNameProcessor;
import org.jboss.as.server.deployment.module.ModuleClassPathProcessor;
import org.jboss.as.server.deployment.module.ModuleDependencyProcessor;
import org.jboss.as.server.deployment.module.ModuleExtensionListProcessor;
import org.jboss.as.server.deployment.module.ModuleExtensionNameProcessor;
import org.jboss.as.server.deployment.module.ModuleIdentifierProcessor;
import org.jboss.as.server.deployment.module.ModuleSpecProcessor;
import org.jboss.as.server.deployment.module.ServerDependenciesProcessor;
import org.jboss.as.server.deployment.module.SubDeploymentDependencyProcessor;
import org.jboss.as.server.deployment.module.descriptor.DeploymentStructureDescriptorParser;
import org.jboss.as.server.deployment.reflect.CleanupReflectionIndexProcessor;
import org.jboss.as.server.deployment.reflect.InstallReflectionIndexProcessor;
import org.jboss.as.server.deployment.service.ServiceActivatorDependencyProcessor;
import org.jboss.as.server.deployment.service.ServiceActivatorProcessor;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.mgmt.domain.HostControllerConnectionService;
import org.jboss.as.server.moduleservice.ExtensionIndexService;
import org.jboss.as.server.moduleservice.ExternalModuleService;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.EnhancedQueueExecutor;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.security.manager.WildFlySecurityManager;

public final class ServerService
extends AbstractControllerService {
    public static final ServiceName JBOSS_SERVER_CLIENT_FACTORY = CLIENT_FACTORY_CAPABILITY.getCapabilityServiceName();
    public static final ServiceName JBOSS_SERVER_NOTIFICATION_REGISTRY = NOTIFICATION_REGISTRY_CAPABILITY.getCapabilityServiceName();
    public static final ServiceName JBOSS_SERVER_SCHEDULED_EXECUTOR = EXECUTOR_CAPABILITY.getCapabilityServiceName().append(new String[]{"scheduled"});
    static final ServiceName MANAGEMENT_EXECUTOR = EXECUTOR_CAPABILITY.getCapabilityServiceName();
    private final InjectedValue<DeploymentMountProvider> injectedDeploymentRepository = new InjectedValue();
    private final InjectedValue<ContentRepository> injectedContentRepository = new InjectedValue();
    private final InjectedValue<ServiceModuleLoader> injectedModuleLoader = new InjectedValue();
    private final InjectedValue<ExternalModuleService> injectedExternalModuleService = new InjectedValue();
    private final InjectedValue<PathManager> injectedPathManagerService = new InjectedValue();
    private final Bootstrap.Configuration configuration;
    private final BootstrapListener bootstrapListener;
    private final ControlledProcessState processState;
    private final RunningModeControl runningModeControl;
    private volatile ExtensibleConfigurationPersister extensibleConfigurationPersister;
    private final AbstractVaultReader vaultReader;
    private final ServerDelegatingResourceDefinition rootResourceDefinition;
    private final SuspendController suspendController;
    public static final String SERVER_NAME = "server";
    static final String SUSPEND_CONTROLLER_CAPABILITY_NAME = "org.wildfly.server.suspend-controller";
    static final RuntimeCapability<Void> SUSPEND_CONTROLLER_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.server.suspend-controller", SuspendController.class).build();

    private ServerService(Supplier<ExecutorService> executorService, Supplier<AbstractControllerService.ControllerInstabilityListener> instabilityListener, Bootstrap.Configuration configuration, ControlledProcessState processState, OperationStepHandler prepareStep, BootstrapListener bootstrapListener, ServerDelegatingResourceDefinition rootResourceDefinition, RunningModeControl runningModeControl, AbstractVaultReader vaultReader, ManagedAuditLogger auditLogger, DelegatingConfigurableAuthorizer authorizer, ManagementSecurityIdentitySupplier securityIdentitySupplier, CapabilityRegistry capabilityRegistry, SuspendController suspendController) {
        super(executorService, instabilityListener, ServerService.getProcessType(configuration.getServerEnvironment()), runningModeControl, null, processState, (ResourceDefinition)rootResourceDefinition, prepareStep, (ExpressionResolver)new RuntimeExpressionResolver(vaultReader), auditLogger, authorizer, securityIdentitySupplier, capabilityRegistry);
        this.configuration = configuration;
        this.bootstrapListener = bootstrapListener;
        this.processState = processState;
        this.runningModeControl = runningModeControl;
        this.vaultReader = vaultReader;
        this.rootResourceDefinition = rootResourceDefinition;
        this.suspendController = suspendController;
    }

    static ProcessType getProcessType(ServerEnvironment serverEnvironment) {
        return serverEnvironment != null ? serverEnvironment.getLaunchType().getProcessType() : ProcessType.EMBEDDED_SERVER;
    }

    public static void addService(ServiceTarget serviceTarget, Bootstrap.Configuration configuration, ControlledProcessState processState, BootstrapListener bootstrapListener, RunningModeControl runningModeControl, AbstractVaultReader vaultReader, ManagedAuditLogger auditLogger, DelegatingConfigurableAuthorizer authorizer, ManagementSecurityIdentitySupplier securityIdentitySupplier, SuspendController suspendController) {
        final ThreadGroup threadGroup = new ThreadGroup("ServerService ThreadGroup");
        String namePattern = "ServerService Thread Pool -- %t";
        ThreadFactory threadFactory = AccessController.doPrivileged(new PrivilegedAction<ThreadFactory>(){

            @Override
            public ThreadFactory run() {
                return new JBossThreadFactory(threadGroup, Boolean.FALSE, null, "ServerService Thread Pool -- %t", null, null);
            }
        });
        boolean forDomain = ProcessType.DOMAIN_SERVER == ServerService.getProcessType(configuration.getServerEnvironment());
        ServerExecutorService serverExecutorService = new ServerExecutorService(threadFactory, forDomain);
        serviceTarget.addService(MANAGEMENT_EXECUTOR, (Service)serverExecutorService).addAliases(new ServiceName[]{Services.JBOSS_SERVER_EXECUTOR, ManagementRemotingServices.SHUTDOWN_EXECUTOR_NAME}).install();
        ServerScheduledExecutorService serverScheduledExecutorService = new ServerScheduledExecutorService(threadFactory);
        serviceTarget.addService(JBOSS_SERVER_SCHEDULED_EXECUTOR, (Service)serverScheduledExecutorService).addAliases(new ServiceName[]{JBOSS_SERVER_SCHEDULED_EXECUTOR}).addDependency(MANAGEMENT_EXECUTOR, ExecutorService.class, (Injector)serverScheduledExecutorService.executorInjector).install();
        CapabilityRegistry capabilityRegistry = configuration.getCapabilityRegistry();
        ServiceBuilder serviceBuilder = serviceTarget.addService(Services.JBOSS_SERVER_CONTROLLER);
        boolean allowMCE = configuration.getServerEnvironment().isAllowModelControllerExecutor();
        Supplier esSupplier = allowMCE ? serviceBuilder.requires(MANAGEMENT_EXECUTOR) : null;
        boolean isDomainEnv = configuration.getServerEnvironment().getLaunchType() == ServerEnvironment.LaunchType.DOMAIN;
        Supplier cilSupplier = isDomainEnv ? serviceBuilder.requires(HostControllerConnectionService.SERVICE_NAME) : null;
        ServerService service = new ServerService(esSupplier, cilSupplier, configuration, processState, null, bootstrapListener, new ServerDelegatingResourceDefinition(), runningModeControl, vaultReader, auditLogger, authorizer, securityIdentitySupplier, capabilityRegistry, suspendController);
        serviceBuilder.setInstance((org.jboss.msc.Service)service);
        serviceBuilder.addDependency(DeploymentMountProvider.SERVICE_NAME, DeploymentMountProvider.class, service.injectedDeploymentRepository);
        serviceBuilder.addDependency(ContentRepository.SERVICE_NAME, ContentRepository.class, service.injectedContentRepository);
        serviceBuilder.addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ServiceModuleLoader.class, service.injectedModuleLoader);
        serviceBuilder.addDependency(Services.JBOSS_EXTERNAL_MODULE_SERVICE, ExternalModuleService.class, service.injectedExternalModuleService);
        serviceBuilder.addDependency(PATH_MANAGER_CAPABILITY.getCapabilityServiceName(), PathManager.class, service.injectedPathManagerService);
        serviceBuilder.install();
        ExternalManagementRequestExecutor.install(serviceTarget, threadGroup, EXECUTOR_CAPABILITY.getCapabilityServiceName(), service.getStabilityMonitor());
    }

    public synchronized void start(StartContext context) throws StartException {
        ServerEnvironment serverEnvironment = this.configuration.getServerEnvironment();
        Bootstrap.ConfigurationPersisterFactory configurationPersisterFactory = this.configuration.getConfigurationPersisterFactory();
        this.extensibleConfigurationPersister = configurationPersisterFactory.createConfigurationPersister(serverEnvironment, this.getExecutorService());
        this.setConfigurationPersister((ConfigurationPersister)this.extensibleConfigurationPersister);
        this.rootResourceDefinition.setDelegate((ResourceDefinition)new ServerRootResourceDefinition((ContentRepository)this.injectedContentRepository.getValue(), this.extensibleConfigurationPersister, this.configuration.getServerEnvironment(), this.processState, this.runningModeControl, this.vaultReader, this.configuration.getExtensionRegistry(), this.getExecutorService() != null, (PathManagerService)this.injectedPathManagerService.getValue(), new DomainServerCommunicationServices.OperationIDUpdater(){

            @Override
            public void updateOperationID(int operationID) {
                DomainServerCommunicationServices.updateOperationID(operationID);
            }
        }, this.authorizer, this.securityIdentitySupplier, super.getAuditLogger(), this.getMutableRootResourceRegistrationProvider(), super.getBootErrorCollector(), this.configuration.getCapabilityRegistry()));
        super.start(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void boot(BootContext context) throws ConfigurationPersistenceException {
        boolean ok;
        try {
            ServerEnvironment serverEnvironment = this.configuration.getServerEnvironment();
            final ServiceTarget serviceTarget = context.getServiceTarget();
            File[] extDirs = serverEnvironment.getJavaExtDirs();
            File[] newExtDirs = Arrays.copyOf(extDirs, extDirs.length + 1);
            newExtDirs[extDirs.length] = new File(serverEnvironment.getServerBaseDir(), "lib/ext");
            serviceTarget.addService(org.jboss.as.server.deployment.Services.JBOSS_DEPLOYMENT_EXTENSION_INDEX, (Service)new ExtensionIndexService(newExtDirs)).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
            Boolean suspend = this.runningModeControl.getSuspend() != null ? this.runningModeControl.getSuspend().booleanValue() : serverEnvironment.isStartSuspended();
            this.suspendController.setStartSuspended(suspend);
            this.runningModeControl.setSuspend(Boolean.valueOf(false));
            context.getServiceTarget().addService(SUSPEND_CONTROLLER_CAPABILITY.getCapabilityServiceName(), (Service)this.suspendController).addAliases(new ServiceName[]{SuspendController.SERVICE_NAME}).addDependency(JBOSS_SERVER_NOTIFICATION_REGISTRY, NotificationHandlerRegistry.class, this.suspendController.getNotificationHandlerRegistry()).install();
            GracefulShutdownService gracefulShutdownService = new GracefulShutdownService();
            context.getServiceTarget().addService(GracefulShutdownService.SERVICE_NAME, (Service)gracefulShutdownService).addDependency(SUSPEND_CONTROLLER_CAPABILITY.getCapabilityServiceName(), SuspendController.class, gracefulShutdownService.getSuspendControllerInjectedValue()).install();
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.STRUCTURE, 4096, new DeploymentUnitProcessor(){

                @Override
                public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
                    phaseContext.getDeploymentUnit().putAttachment(Attachments.SERVICE_MODULE_LOADER, ServerService.this.injectedModuleLoader.getValue());
                    phaseContext.getDeploymentUnit().putAttachment(Attachments.EXTERNAL_MODULE_SERVICE, ServerService.this.injectedExternalModuleService.getValue());
                    phaseContext.getDeploymentUnit().putAttachment(Attachments.EXTERNAL_SERVICE_TARGET, serviceTarget);
                }

                @Override
                public void undeploy(DeploymentUnit context) {
                    context.removeAttachment(Attachments.SERVICE_MODULE_LOADER);
                }
            });
            HttpListenerRegistryService.install((ServiceTarget)serviceTarget);
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.STRUCTURE, 512, new DeploymentRootMountProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.STRUCTURE, 768, new ManifestAttachmentProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.STRUCTURE, 5632, new ManifestAttachmentProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.STRUCTURE, 640, new DeploymentOverlayDeploymentUnitProcessor((ContentRepository)this.injectedContentRepository.getValue()));
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.STRUCTURE, 61440, new DeferredDeploymentOverlayDeploymentUnitProcessor((ContentRepository)this.injectedContentRepository.getValue()));
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.STRUCTURE, 5888, new SubDeploymentProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.STRUCTURE, 6656, new ModuleIdentifierProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.STRUCTURE, 4352, new AnnotationIndexProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.STRUCTURE, 2784, new JBossAllXMLParsingProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.STRUCTURE, 6272, new DeploymentStructureDescriptorParser());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.STRUCTURE, 6400, new ManifestClassPathProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.STRUCTURE, 7424, new DeploymentDependenciesProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.STRUCTURE, 8704, new ManifestDependencyProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.PARSE, 769, new CompositeIndexProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.PARSE, 1792, new ManifestExtensionListProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.PARSE, 2048, new ManifestExtensionNameProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.PARSE, 8704, new ServiceLoaderProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.DEPENDENCIES, 768, new ModuleDependencyProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.DEPENDENCIES, 1536, new ServiceActivatorDependencyProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.DEPENDENCIES, 2048, new ModuleClassPathProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.DEPENDENCIES, 2304, new ModuleExtensionListProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.DEPENDENCIES, 3584, new SubDeploymentDependencyProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.DEPENDENCIES, 4608, new ServerDependenciesProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.DEPENDENCIES, 8448, new DeploymentVisibilityProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.DEPENDENCIES, 5888, new DriverDependenciesProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.CONFIGURE_MODULE, 512, new ModuleSpecProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.POST_MODULE, 2560, new ModuleExtensionNameProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.POST_MODULE, 512, new InstallReflectionIndexProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.FIRST_MODULE_USE, 1280, new ClassFileTransformerProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.INSTALL, 1280, new ServiceActivatorProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.INSTALL, 8448, new DeploymentCompleteServiceProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.CLEANUP, 256, new CleanupReflectionIndexProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.CLEANUP, 1024, new CleanupAnnotationIndexProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(SERVER_NAME, Phase.DEPENDENCIES, 2561, new Seam2Processor(serviceTarget));
            DeploymentStructureDescriptorParser.registerJBossXMLParsers();
            DeploymentDependenciesProcessor.registerJBossXMLParsers();
            try {
                boolean failOnRuntime = Boolean.valueOf(WildFlySecurityManager.getPropertyPrivileged((String)"jboss.unsupported.fail-boot-on-runtime-failure", (String)"false"));
                ArrayList<ModelNode> bootOps = this.extensibleConfigurationPersister.load();
                ModelNode controllerInitOp = this.registerModelControllerServiceInitializationBootStep(context);
                if (controllerInitOp != null) {
                    bootOps = new ArrayList<ModelNode>(bootOps);
                    bootOps.add(controllerInitOp);
                }
                if (ok = this.boot((List<ModelNode>)bootOps, failOnRuntime)) {
                    this.finishBoot(suspend);
                }
            }
            finally {
                DeployerChainAddHandler.INSTANCE.clearDeployerMap();
            }
        }
        catch (Exception e) {
            ServerLogger.ROOT_LOGGER.caughtExceptionDuringBoot(e);
            ok = false;
        }
        if (ok) {
            Notification notification = new Notification("boot-complete", PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"core-service", (String)"management"), PathElement.pathElement((String)"service", (String)"management-operations")}), ServerLogger.AS_ROOT_LOGGER.bootComplete());
            this.getNotificationSupport().emit(new Notification[]{notification});
            this.bootstrapListener.printBootStatistics();
        } else {
            final String message = ServerLogger.ROOT_LOGGER.unsuccessfulBoot();
            this.bootstrapListener.bootFailure(message);
            SystemExiter.logAndExit(new SystemExiter.ExitLogger(){

                @Override
                public void logExit() {
                    ServerLogger.ROOT_LOGGER.fatal(message);
                }
            }, 1);
        }
    }

    protected void finishBoot(boolean suspend) throws ConfigurationPersistenceException {
        super.finishBoot();
        if (!suspend) {
            this.suspendController.resume();
        }
    }

    protected boolean boot(List<ModelNode> bootOperations, boolean rollbackOnRuntimeFailure) throws ConfigurationPersistenceException {
        ArrayList<ModelNode> operations = new ArrayList<ModelNode>(bootOperations);
        operations.add(DeployerChainAddHandler.OPERATION);
        return super.boot(operations, rollbackOnRuntimeFailure);
    }

    public void stop(StopContext context) {
        this.configuration.getExtensionRegistry().clear();
        this.configuration.getServerEnvironment().resetProvidedProperties();
        super.stop(context);
    }

    protected void initModel(ManagementModel managementModel, Resource modelControllerResource) {
        Resource rootResource = managementModel.getRootResource();
        Resource managementResource = Resource.Factory.create();
        managementResource.registerChild(PathElement.pathElement((String)"service", (String)"management-operations"), modelControllerResource);
        rootResource.registerChild(PathElement.pathElement((String)"core-service", (String)"management"), managementResource);
        rootResource.registerChild(PathElement.pathElement((String)"core-service", (String)"service-container"), Resource.Factory.create());
        rootResource.registerChild(PathElement.pathElement((String)"core-service", (String)"module-loading"), (Resource)PlaceholderResource.INSTANCE);
        rootResource.registerChild(PathElement.pathElement((String)"core-service", (String)"capability-registry"), Resource.Factory.create());
        managementResource.registerChild(AccessAuthorizationResourceDefinition.PATH_ELEMENT, AccessAuthorizationResourceDefinition.createResource((AccessConstraintUtilizationRegistry)this.authorizer.getWritableAuthorizerConfiguration()));
        rootResource.registerChild(ServerEnvironmentResourceDescription.RESOURCE_PATH, Resource.Factory.create());
        ((PathManagerService)this.injectedPathManagerService.getValue()).addPathManagerResources(rootResource);
        VersionModelInitializer.registerRootResource(rootResource, this.configuration.getServerEnvironment() != null ? this.configuration.getServerEnvironment().getProductConfig() : null);
        rootResource.registerChild(PlatformMBeanConstants.ROOT_PATH, (Resource)new RootPlatformMBeanResource());
        RuntimeCapabilityRegistry capabilityRegistry = managementModel.getCapabilityRegistry();
        capabilityRegistry.registerCapability(new RuntimeCapabilityRegistration(PATH_MANAGER_CAPABILITY, CapabilityScope.GLOBAL, new RegistrationPoint(PathAddress.EMPTY_ADDRESS, null)));
        capabilityRegistry.registerCapability(new RuntimeCapabilityRegistration(EXECUTOR_CAPABILITY, CapabilityScope.GLOBAL, new RegistrationPoint(PathAddress.EMPTY_ADDRESS, null)));
        capabilityRegistry.registerCapability(new RuntimeCapabilityRegistration(SUSPEND_CONTROLLER_CAPABILITY, CapabilityScope.GLOBAL, new RegistrationPoint(PathAddress.EMPTY_ADDRESS, null)));
        capabilityRegistry.registerCapability(new RuntimeCapabilityRegistration(PROCESS_STATE_NOTIFIER_CAPABILITY, CapabilityScope.GLOBAL, new RegistrationPoint(PathAddress.EMPTY_ADDRESS, null)));
        ManagementResourceRegistration rootRegistration = managementModel.getRootResourceRegistration();
        rootRegistration.registerCapability(PATH_MANAGER_CAPABILITY);
        rootRegistration.registerCapability(EXECUTOR_CAPABILITY);
        rootRegistration.registerCapability(SUSPEND_CONTROLLER_CAPABILITY);
        rootRegistration.registerCapability(PROCESS_STATE_NOTIFIER_CAPABILITY);
    }

    protected AbstractControllerService.ModelControllerServiceInitializationParams getModelControllerServiceInitializationParams() {
        ServiceLoader<ModelControllerServiceInitialization> sl = ServiceLoader.load(ModelControllerServiceInitialization.class);
        return new AbstractControllerService.ModelControllerServiceInitializationParams(sl){

            public String getHostName() {
                return null;
            }
        };
    }

    static final class ServerScheduledExecutorService
    implements Service<ScheduledExecutorService> {
        private final ThreadFactory threadFactory;
        private ScheduledThreadPoolExecutor scheduledExecutorService;
        private final InjectedValue<ExecutorService> executorInjector = new InjectedValue();

        private ServerScheduledExecutorService(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
        }

        public synchronized void start(StartContext context) throws StartException {
            this.scheduledExecutorService = new ScheduledThreadPoolExecutor(4, this.threadFactory);
            this.scheduledExecutorService.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void stop(final StopContext context) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        scheduledExecutorService.shutdown();
                    }
                    finally {
                        scheduledExecutorService = null;
                        context.complete();
                    }
                }
            };
            try {
                ((ExecutorService)this.executorInjector.getValue()).execute(r);
            }
            catch (RejectedExecutionException e) {
                r.run();
            }
            finally {
                context.asynchronous();
            }
        }

        public synchronized ScheduledExecutorService getValue() throws IllegalStateException {
            return this.scheduledExecutorService;
        }
    }

    static final class ServerDelegatingResourceDefinition
    extends DelegatingResourceDefinition {
        ServerDelegatingResourceDefinition() {
        }

        public void setDelegate(ResourceDefinition delegate) {
            super.setDelegate(delegate);
        }
    }

    private static class ServerExecutorService
    implements Service<ExecutorService> {
        private static final int DEFAULT_CORE_POOL_SIZE = 1;
        private static final int DEFAULT_DOMAIN_CORE_POOL_SIZE = 3;
        private static final String CONFIG_SYS_PROP = "org.jboss.as.server-service.core.threads";
        private final ThreadFactory threadFactory;
        private final boolean forDomain;
        private ExecutorService executorService;

        private ServerExecutorService(ThreadFactory threadFactory, boolean forDomain) {
            this.threadFactory = threadFactory;
            this.forDomain = forDomain;
        }

        public synchronized void start(StartContext context) throws StartException {
            this.executorService = EnhancedQueueExecutor.DISABLE_HINT ? new ThreadPoolExecutor(ServerExecutorService.getCorePoolSize(this.forDomain), Integer.MAX_VALUE, 20L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), this.threadFactory) : new EnhancedQueueExecutor.Builder().setCorePoolSize(ServerExecutorService.getCorePoolSize(this.forDomain)).setMaximumPoolSize(1024).setKeepAliveTime(20L, TimeUnit.SECONDS).setThreadFactory(this.threadFactory).build();
        }

        public synchronized void stop(final StopContext context) {
            if (this.executorService != null) {
                context.asynchronous();
                Thread executorShutdown = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        boolean interrupted = false;
                        try {
                            executorService.shutdown();
                            executorService.awaitTermination(100L, TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                        }
                        finally {
                            try {
                                List<Runnable> tasks = executorService.shutdownNow();
                                executorService = null;
                                if (!interrupted) {
                                    for (Runnable task : tasks) {
                                        ServerLogger.AS_ROOT_LOGGER.debugf("%s -- Discarding unexecuted task %s", this.getClass().getSimpleName(), task);
                                    }
                                }
                            }
                            finally {
                                context.complete();
                            }
                        }
                    }
                }, "ServerExecutorService Shutdown Thread");
                executorShutdown.start();
            }
        }

        public synchronized ExecutorService getValue() throws IllegalStateException, IllegalArgumentException {
            return this.executorService;
        }

        private static int getCorePoolSize(boolean forDomain) {
            String val = WildFlySecurityManager.getPropertyPrivileged((String)CONFIG_SYS_PROP, null);
            if (val != null) {
                try {
                    int result = Integer.parseInt(val);
                    if (result >= 0) {
                        return result;
                    }
                    ServerLogger.ROOT_LOGGER.invalidPoolCoreSize(val, CONFIG_SYS_PROP);
                }
                catch (NumberFormatException nfe) {
                    ServerLogger.ROOT_LOGGER.invalidPoolCoreSize(val, CONFIG_SYS_PROP);
                }
            }
            return forDomain ? 3 : 1;
        }
    }
}

