/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.logging;

import java.io.File;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.zip.ZipException;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.MountType;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.module.ExtensionListEntry;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.services.security.VaultReaderException;
import org.jboss.as.server.suspend.ServerActivity;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.ServiceNotFoundException;
import org.jboss.msc.service.StartException;
import org.jboss.vfs.VirtualFile;

public class ServerLogger_$logger
extends DelegatingBasicLogger
implements ServerLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ServerLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ServerLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void jbossDeploymentStructureIgnored(String file) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.jbossDeploymentStructureIgnored$str(), (Object)file);
    }

    protected String jbossDeploymentStructureIgnored$str() {
        return "WFLYSRV0001: %s in subdeployment ignored. jboss-deployment-structure.xml is only parsed for top level deployments.";
    }

    @Override
    public final void cannotLoadAnnotationIndex(String index, String message) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.cannotLoadAnnotationIndex$str(), (Object)index, (Object)message);
    }

    protected String cannotLoadAnnotationIndex$str() {
        return "WFLYSRV0002: Loading failed for the annotation index \"%s\" with the following exception: %s";
    }

    @Override
    public final void cannotIndexClass(String className, String resourceRoot, Throwable throwable) {
        this.log.logf(FQCN, Logger.Level.WARN, throwable, this.cannotIndexClass$str(), (Object)className, (Object)resourceRoot);
    }

    protected String cannotIndexClass$str() {
        return "WFLYSRV0003: Could not index class %s at %s";
    }

    @Override
    public final void undeploymentRolledBack(String deployment, String message) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.undeploymentRolledBack$str(), (Object)deployment, (Object)message);
    }

    protected String undeploymentRolledBack$str() {
        return "WFLYSRV0007: Undeploy of deployment \"%s\" was rolled back with the following failure message: %s";
    }

    @Override
    public final void undeploymentRolledBackWithNoMessage(String deployment) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.undeploymentRolledBackWithNoMessage$str(), (Object)deployment);
    }

    protected String undeploymentRolledBackWithNoMessage$str() {
        return "WFLYSRV0008: Undeploy of deployment \"%s\" was rolled back with no failure message";
    }

    @Override
    public final void deploymentUndeployed(String managementName, String deploymentUnitName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.deploymentUndeployed$str(), (Object)managementName, (Object)deploymentUnitName);
    }

    protected String deploymentUndeployed$str() {
        return "WFLYSRV0009: Undeployed \"%s\" (runtime-name: \"%s\")";
    }

    @Override
    public final void deploymentDeployed(String managementName, String deploymentUnitName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.deploymentDeployed$str(), (Object)managementName, (Object)deploymentUnitName);
    }

    protected String deploymentDeployed$str() {
        return "WFLYSRV0010: Deployed \"%s\" (runtime-name : \"%s\")";
    }

    @Override
    public final void redeployRolledBack(String deployment, String message) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.redeployRolledBack$str(), (Object)deployment, (Object)message);
    }

    protected String redeployRolledBack$str() {
        return "WFLYSRV0011: Redeploy of deployment \"%s\" was rolled back with the following failure message: %s";
    }

    @Override
    public final void redeployRolledBackWithNoMessage(String deployment) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.redeployRolledBackWithNoMessage$str(), (Object)deployment);
    }

    protected String redeployRolledBackWithNoMessage$str() {
        return "WFLYSRV0012: Redeploy of deployment \"%s\" was rolled back with no failure message";
    }

    @Override
    public final void deploymentRedeployed(String deploymentName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.deploymentRedeployed$str(), (Object)deploymentName);
    }

    protected String deploymentRedeployed$str() {
        return "WFLYSRV0013: Redeployed \"%s\"";
    }

    @Override
    public final void replaceRolledBack(String replaced, String deployment, String message) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.replaceRolledBack$str(), (Object)replaced, (Object)deployment, (Object)message);
    }

    protected String replaceRolledBack$str() {
        return "WFLYSRV0014: Replacement of deployment \"%s\" by deployment \"%s\" was rolled back with the following failure message: %s";
    }

    @Override
    public final void replaceRolledBackWithNoMessage(String replaced, String deployment) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.replaceRolledBackWithNoMessage$str(), (Object)replaced, (Object)deployment);
    }

    protected String replaceRolledBackWithNoMessage$str() {
        return "WFLYSRV0015: Replacement of deployment \"%s\" by deployment \"%s\" was rolled back with no failure message";
    }

    @Override
    public final void deploymentReplaced(String replaced, String deployment) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.deploymentReplaced$str(), (Object)replaced, (Object)deployment);
    }

    protected String deploymentReplaced$str() {
        return "WFLYSRV0016: Replaced deployment \"%s\" with deployment \"%s\"";
    }

    @Override
    public final void annotationImportIgnored(ModuleIdentifier annotationModuleId, ModuleIdentifier additionalModuleId) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.annotationImportIgnored$str(), (Object)annotationModuleId, (Object)additionalModuleId);
    }

    protected String annotationImportIgnored$str() {
        return "WFLYSRV0017: Annotations import option %s specified in jboss-deployment-structure.xml for additional module %s has been ignored. Additional modules cannot import annotations.";
    }

    @Override
    public final void privateApiUsed(String deployment, ModuleIdentifier dependency) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.privateApiUsed$str(), (Object)deployment, (Object)dependency);
    }

    protected String privateApiUsed$str() {
        return "WFLYSRV0018: Deployment \"%s\" is using a private module (\"%s\") which may be changed or removed in future versions without notice.";
    }

    @Override
    public final void unsupportedApiUsed(String deployment, ModuleIdentifier dependency) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unsupportedApiUsed$str(), (Object)deployment, (Object)dependency);
    }

    protected String unsupportedApiUsed$str() {
        return "WFLYSRV0019: Deployment \"%s\" is using an unsupported module (\"%s\") which may be changed or removed in future versions without notice.";
    }

    @Override
    public final void failedToRemoveDeploymentContent(Throwable cause, String hash) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.failedToRemoveDeploymentContent$str(), (Object)hash);
    }

    protected String failedToRemoveDeploymentContent$str() {
        return "WFLYSRV0020: Exception occurred removing deployment content %s";
    }

    @Override
    public final void deploymentRolledBack(String deployment, String message) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.deploymentRolledBack$str(), (Object)deployment, (Object)message);
    }

    protected String deploymentRolledBack$str() {
        return "WFLYSRV0021: Deploy of deployment \"%s\" was rolled back with the following failure message: %s";
    }

    @Override
    public final void deploymentRolledBackWithNoMessage(String deployment) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.deploymentRolledBackWithNoMessage$str(), (Object)deployment);
    }

    protected String deploymentRolledBackWithNoMessage$str() {
        return "WFLYSRV0022: Deploy of deployment \"%s\" was rolled back with no failure message";
    }

    @Override
    public final void failedToParseCommandLineInteger(String property, String value) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.failedToParseCommandLineInteger$str(), (Object)property, (Object)value);
    }

    protected String failedToParseCommandLineInteger$str() {
        return "WFLYSRV0023: Failed to parse property (%s), value (%s) as an integer";
    }

    @Override
    public final void cannotAddURLStreamHandlerFactory(Exception cause, String moduleID) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)cause, this.cannotAddURLStreamHandlerFactory$str(), (Object)moduleID);
    }

    protected String cannotAddURLStreamHandlerFactory$str() {
        return "WFLYSRV0024: Cannot add module '%s' as URLStreamHandlerFactory provider";
    }

    @Override
    public final void startedClean(String prettyVersionString, long time, int startedServices, int allServices, int passiveOnDemandServices) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.startedClean$str(), new Object[]{prettyVersionString, time, startedServices, allServices, passiveOnDemandServices});
    }

    protected String startedClean$str() {
        return "WFLYSRV0025: %s started in %dms - Started %d of %d services (%d services are lazy, passive or on-demand)";
    }

    @Override
    public final void startedWitErrors(String prettyVersionString, long time, int startedServices, int allServices, int problemServices, int passiveOnDemandServices) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.startedWitErrors$str(), new Object[]{prettyVersionString, time, startedServices, allServices, problemServices, passiveOnDemandServices});
    }

    protected String startedWitErrors$str() {
        return "WFLYSRV0026: %s started (with errors) in %dms - Started %d of %d services (%d services failed or missing dependencies, %d services are lazy, passive or on-demand)";
    }

    @Override
    public final void startingDeployment(String managementName, String deploymentUnitName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.startingDeployment$str(), (Object)managementName, (Object)deploymentUnitName);
    }

    protected String startingDeployment$str() {
        return "WFLYSRV0027: Starting deployment of \"%s\" (runtime-name: \"%s\")";
    }

    @Override
    public final void stoppedDeployment(String managementName, String deploymentUnitName, int elapsedTime) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.stoppedDeployment$str(), (Object)managementName, (Object)deploymentUnitName, (Object)elapsedTime);
    }

    protected String stoppedDeployment$str() {
        return "WFLYSRV0028: Stopped deployment %s (runtime-name: %s) in %dms";
    }

    @Override
    public final void nativeManagementInterfaceIsUnsecured() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.nativeManagementInterfaceIsUnsecured$str(), new Object[0]);
    }

    protected String nativeManagementInterfaceIsUnsecured$str() {
        return "WFLYSRV0034: No security realm or sasl server authentication defined for native management service; all access will be unrestricted.";
    }

    @Override
    public final void httpManagementInterfaceIsUnsecured() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.httpManagementInterfaceIsUnsecured$str(), new Object[0]);
    }

    protected String httpManagementInterfaceIsUnsecured$str() {
        return "WFLYSRV0035: No security realm or http server authentication defined for http management service; all access will be unrestricted.";
    }

    @Override
    public final void creatingHttpManagementServiceOnSocket(String socketName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.creatingHttpManagementServiceOnSocket$str(), (Object)socketName);
    }

    protected String creatingHttpManagementServiceOnSocket$str() {
        return "WFLYSRV0039: Creating http management service using socket-binding (%s)";
    }

    @Override
    public final void creatingHttpManagementServiceOnSecureSocket(String secureSocketName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.creatingHttpManagementServiceOnSecureSocket$str(), (Object)secureSocketName);
    }

    protected String creatingHttpManagementServiceOnSecureSocket$str() {
        return "WFLYSRV0040: Creating http management service using secure-socket-binding (%s)";
    }

    @Override
    public final void creatingHttpManagementServiceOnSocketAndSecureSocket(String socketName, String secureSocketName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.creatingHttpManagementServiceOnSocketAndSecureSocket$str(), (Object)socketName, (Object)secureSocketName);
    }

    protected String creatingHttpManagementServiceOnSocketAndSecureSocket$str() {
        return "WFLYSRV0041: Creating http management service using socket-binding (%s) and secure-socket-binding (%s)";
    }

    @Override
    public final void caughtExceptionClosingContentInputStream(Exception cause) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)cause, this.caughtExceptionClosingContentInputStream$str(), new Object[0]);
    }

    protected String caughtExceptionClosingContentInputStream$str() {
        return "WFLYSRV0042: Caught exception closing input stream for uploaded deployment content";
    }

    @Override
    public final void caughtExceptionUndeploying(Throwable cause, DeploymentUnitProcessor dup, Phase phase, DeploymentUnit unit) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.caughtExceptionUndeploying$str(), (Object)dup, (Object)phase, (Object)unit);
    }

    protected String caughtExceptionUndeploying$str() {
        return "WFLYSRV0043: Deployment unit processor %s unexpectedly threw an exception during undeploy phase %s of %s";
    }

    @Override
    public final void extensionMissingManifestAttribute(String item, String again, Attributes.Name suffix) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.extensionMissingManifestAttribute$str(), (Object)item, (Object)again, (Object)suffix);
    }

    protected String extensionMissingManifestAttribute$str() {
        return "WFLYSRV0045: Extension %s is missing the required manifest attribute %s-%s (skipping extension)";
    }

    @Override
    public final void invalidExtensionURI(String item, URISyntaxException e) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.invalidExtensionURI$str(), (Object)item, (Object)e);
    }

    protected String invalidExtensionURI$str() {
        return "WFLYSRV0046: Extension %s URI syntax is invalid: %s";
    }

    @Override
    public final void cannotFindExtensionListEntry(ExtensionListEntry entry, ResourceRoot resourceRoot) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.cannotFindExtensionListEntry$str(), (Object)entry, (Object)resourceRoot);
    }

    protected String cannotFindExtensionListEntry$str() {
        return "WFLYSRV0047: Could not find Extension-List entry %s referenced from %s";
    }

    @Override
    public final void duplicateServerNameConfiguration(String systemProperty, String rawServerProp, String processName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.duplicateServerNameConfiguration$str(), (Object)systemProperty, (Object)rawServerProp, (Object)processName);
    }

    protected String duplicateServerNameConfiguration$str() {
        return "WFLYSRV0048: A server name configuration was provided both via system property %s ('%s') and via the xml configuration ('%s'). The xml configuration value will be used.";
    }

    @Override
    public final void serverStarting(String prettyVersion) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.serverStarting$str(), (Object)prettyVersion);
    }

    protected String serverStarting$str() {
        return "WFLYSRV0049: %s starting";
    }

    @Override
    public final void serverStopped(String prettyVersion, int time) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.serverStopped$str(), (Object)prettyVersion, (Object)time);
    }

    protected String serverStopped$str() {
        return "WFLYSRV0050: %s stopped in %dms";
    }

    @Override
    public final void logHttpConsole(String httpAddr, int httpPort) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.logHttpConsole$str(), (Object)httpAddr, (Object)httpPort);
    }

    protected String logHttpConsole$str() {
        return "WFLYSRV0051: Admin console listening on http://%s:%d";
    }

    @Override
    public final void logHttpsConsole(String httpsAddr, int httpsPort) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.logHttpsConsole$str(), (Object)httpsAddr, (Object)httpsPort);
    }

    protected String logHttpsConsole$str() {
        return "WFLYSRV0052: Admin console listening on https://%s:%d";
    }

    @Override
    public final void logHttpAndHttpsConsole(String httpAddr, int httpPort, String httpsAddr, int httpsPort) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.logHttpAndHttpsConsole$str(), new Object[]{httpAddr, httpPort, httpsAddr, httpsPort});
    }

    protected String logHttpAndHttpsConsole$str() {
        return "WFLYSRV0053: Admin console listening on http://%s:%d and https://%s:%d";
    }

    @Override
    public final void logNoConsole() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.logNoConsole$str(), new Object[0]);
    }

    protected String logNoConsole$str() {
        return "WFLYSRV0054: Admin console is not enabled";
    }

    @Override
    public final void caughtExceptionDuringBoot(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.caughtExceptionDuringBoot$str(), new Object[0]);
    }

    protected String caughtExceptionDuringBoot$str() {
        return "WFLYSRV0055: Caught exception during boot";
    }

    protected String unsuccessfulBoot$str() {
        return "WFLYSRV0056: Server boot has failed in an unrecoverable manner; exiting. See previous messages for details.";
    }

    @Override
    public final String unsuccessfulBoot() {
        return String.format(this.getLoggingLocale(), this.unsuccessfulBoot$str(), new Object[0]);
    }

    @Override
    public final void reportAdminOnlyMissingDeploymentContent(String contentHash, String deploymentName) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.reportAdminOnlyMissingDeploymentContent$str(), (Object)contentHash, (Object)deploymentName);
    }

    protected String reportAdminOnlyMissingDeploymentContent$str() {
        return "WFLYSRV0057: No deployment content with hash %s is available in the deployment content repository for deployment %s. Because this Host Controller is booting in ADMIN-ONLY mode, boot will be allowed to proceed to provide administrators an opportunity to correct this problem. If this Host Controller were not in ADMIN-ONLY mode this would be a fatal boot failure.";
    }

    @Override
    public final void additionalResourceRootDoesNotExist(String resourceRoot) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.additionalResourceRootDoesNotExist$str(), (Object)resourceRoot);
    }

    protected String additionalResourceRootDoesNotExist$str() {
        return "WFLYSRV0058: Additional resource root %s added via jboss-deployment-structure.xml does not exist";
    }

    @Override
    public final void classPathEntryNotValid(String classPathEntry, String resourceRoot) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.classPathEntryNotValid$str(), (Object)classPathEntry, (Object)resourceRoot);
    }

    protected String classPathEntryNotValid$str() {
        return "WFLYSRV0059: Class Path entry %s in %s  does not point to a valid jar for a Class-Path reference.";
    }

    @Override
    public final void logHttpManagement(String httpAddr, int httpPort) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.logHttpManagement$str(), (Object)httpAddr, (Object)httpPort);
    }

    protected String logHttpManagement$str() {
        return "WFLYSRV0060: Http management interface listening on http://%s:%d/management";
    }

    @Override
    public final void logHttpsManagement(String httpsAddr, int httpsPort) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.logHttpsManagement$str(), (Object)httpsAddr, (Object)httpsPort);
    }

    protected String logHttpsManagement$str() {
        return "WFLYSRV0061: Http management interface listening on https://%s:%d/management";
    }

    @Override
    public final void logHttpAndHttpsManagement(String httpAddr, int httpPort, String httpsAddr, int httpsPort) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.logHttpAndHttpsManagement$str(), new Object[]{httpAddr, httpPort, httpsAddr, httpsPort});
    }

    protected String logHttpAndHttpsManagement$str() {
        return "WFLYSRV0062: Http management interface listening on http://%s:%d/management and https://%s:%d/management";
    }

    @Override
    public final void logNoHttpManagement() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.logNoHttpManagement$str(), new Object[0]);
    }

    protected String logNoHttpManagement$str() {
        return "WFLYSRV0063: Http management interface is not enabled";
    }

    @Override
    public final void jbossDeploymentStructureNamespaceIgnored(String deploymentUnitName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.jbossDeploymentStructureNamespaceIgnored$str(), (Object)deploymentUnitName);
    }

    protected String jbossDeploymentStructureNamespaceIgnored$str() {
        return "WFLYSRV0064: urn:jboss:deployment-structure namespace found in jboss.xml for a sub deployment %s. This is only valid in a top level deployment.";
    }

    @Override
    public final void failedToUnmountContentOverride(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.failedToUnmountContentOverride$str(), new Object[0]);
    }

    protected String failedToUnmountContentOverride$str() {
        return "WFLYSRV0065: Failed to unmount deployment overlay";
    }

    @Override
    public final void deploymentDependenciesAreATopLevelElement(String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.deploymentDependenciesAreATopLevelElement$str(), (Object)name);
    }

    protected String deploymentDependenciesAreATopLevelElement$str() {
        return "WFLYSRV0067: jboss-deployment-dependencies cannot be used in a sub deployment, it must be specified at ear level: %s";
    }

    @Override
    public final void reportAdminOnlyMissingDeploymentOverlayContent(String contentHash, String deploymentName, String contentName) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.reportAdminOnlyMissingDeploymentOverlayContent$str(), (Object)contentHash, (Object)deploymentName, (Object)contentName);
    }

    protected String reportAdminOnlyMissingDeploymentOverlayContent$str() {
        return "WFLYSRV0068: No deployment overlay content with hash %s is available in the deployment content repository for deployment %s at location %s. Because this Host Controller is booting in ADMIN-ONLY mode, boot will be allowed to proceed to provide administrators an opportunity to correct this problem. If this Host Controller were not in ADMIN-ONLY mode this would be a fatal boot failure.";
    }

    @Override
    public final void deploymentRestartDetected(String deployment) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.deploymentRestartDetected$str(), (Object)deployment);
    }

    protected String deploymentRestartDetected$str() {
        return "WFLYSRV0070: Deployment restart detected for deployment %s, performing full redeploy instead.";
    }

    @Override
    public final void fdTooLow(long fdCount) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.fdTooLow$str(), (Object)fdCount);
    }

    protected String fdTooLow$str() {
        return "WFLYSRV0071: The operating system has limited the number of open files to %d for this process; a value of at least 4096 is recommended";
    }

    protected String argServerConfig$str() {
        return "Name of the server configuration file to use (default is \"standalone.xml\") (Same as -c)";
    }

    @Override
    public final String argServerConfig() {
        return String.format(this.getLoggingLocale(), this.argServerConfig$str(), new Object[0]);
    }

    protected String argShortServerConfig$str() {
        return "Name of the server configuration file to use (default is \"standalone.xml\") (Same as --server-config)";
    }

    @Override
    public final String argShortServerConfig() {
        return String.format(this.getLoggingLocale(), this.argShortServerConfig$str(), new Object[0]);
    }

    protected String argReadOnlyServerConfig$str() {
        return "Name of the server configuration file to use. This differs from '--server-config' and '-c' in that the original file is never overwritten.";
    }

    @Override
    public final String argReadOnlyServerConfig() {
        return String.format(this.getLoggingLocale(), this.argReadOnlyServerConfig$str(), new Object[0]);
    }

    protected String argHelp$str() {
        return "Display this message and exit";
    }

    @Override
    public final String argHelp() {
        return String.format(this.getLoggingLocale(), this.argHelp$str(), new Object[0]);
    }

    protected String argProperties$str() {
        return "Load system properties from the given url";
    }

    @Override
    public final String argProperties() {
        return String.format(this.getLoggingLocale(), this.argProperties$str(), new Object[0]);
    }

    protected String argSecurityProperty$str() {
        return "Set a security property";
    }

    @Override
    public final String argSecurityProperty() {
        return String.format(this.getLoggingLocale(), this.argSecurityProperty$str(), new Object[0]);
    }

    protected String argSystem$str() {
        return "Set a system property";
    }

    @Override
    public final String argSystem() {
        return String.format(this.getLoggingLocale(), this.argSystem$str(), new Object[0]);
    }

    protected String argVersion$str() {
        return "Print version and exit";
    }

    @Override
    public final String argVersion() {
        return String.format(this.getLoggingLocale(), this.argVersion$str(), new Object[0]);
    }

    protected String argPublicBindAddress$str() {
        return "Set system property jboss.bind.address to the given value";
    }

    @Override
    public final String argPublicBindAddress() {
        return String.format(this.getLoggingLocale(), this.argPublicBindAddress$str(), new Object[0]);
    }

    protected String argInterfaceBindAddress$str() {
        return "Set system property jboss.bind.address.<interface> to the given value";
    }

    @Override
    public final String argInterfaceBindAddress() {
        return String.format(this.getLoggingLocale(), this.argInterfaceBindAddress$str(), new Object[0]);
    }

    protected String argDefaultMulticastAddress$str() {
        return "Set system property jboss.default.multicast.address to the given value";
    }

    @Override
    public final String argDefaultMulticastAddress() {
        return String.format(this.getLoggingLocale(), this.argDefaultMulticastAddress$str(), new Object[0]);
    }

    protected String argAdminOnly$str() {
        return "Set the server's running type to ADMIN_ONLY causing it to open administrative interfaces and accept management requests but not start other runtime services or accept end user requests. Cannot be used in conjunction with --start-mode. Deprecated; use --start-mode=admin-only instead.";
    }

    @Override
    public final String argAdminOnly() {
        return String.format(this.getLoggingLocale(), this.argAdminOnly$str(), new Object[0]);
    }

    protected String argDebugPort$str() {
        return "Activate debug mode with an optional argument to specify the port. Only works if the launch script supports it.";
    }

    @Override
    public final String argDebugPort() {
        return String.format(this.getLoggingLocale(), this.argDebugPort$str(), new Object[0]);
    }

    protected String argSecMgr$str() {
        return "Runs the server with a security manager installed.";
    }

    @Override
    public final String argSecMgr() {
        return String.format(this.getLoggingLocale(), this.argSecMgr$str(), new Object[0]);
    }

    protected String argStartMode$str() {
        return "Sets the start mode of the server, it can be either 'normal','admin-only' or 'suspend'. If this is 'suspend' the server will start in suspended mode, and will not service requests until it has been resumed. If this is started in admin-only mode the server will only open administrative interfaces and accept management requests but not start other runtime services or accept end user requests. Cannot be used in conjunction with --admin-only.";
    }

    @Override
    public final String argStartMode() {
        return String.format(this.getLoggingLocale(), this.argStartMode$str(), new Object[0]);
    }

    protected String argGracefulStartup$str() {
        return "Start the server gracefully, queuing or cleanly rejecting requests until the server is fully started";
    }

    @Override
    public final String argGracefulStartup() {
        return String.format(this.getLoggingLocale(), this.argGracefulStartup$str(), new Object[0]);
    }

    protected String argGitRepo$str() {
        return "The git repository to clone to get the server configuration.";
    }

    @Override
    public final String argGitRepo() {
        return String.format(this.getLoggingLocale(), this.argGitRepo$str(), new Object[0]);
    }

    protected String argGitBranch$str() {
        return "The git branch to use to get the server configuration. Default is 'master'";
    }

    @Override
    public final String argGitBranch() {
        return String.format(this.getLoggingLocale(), this.argGitBranch$str(), new Object[0]);
    }

    protected String argGitAuth$str() {
        return "The elytron configuration file for managing git credentials. Default is 'null'";
    }

    @Override
    public final String argGitAuth() {
        return String.format(this.getLoggingLocale(), this.argGitAuth$str(), new Object[0]);
    }

    protected String valueExpectedForCommandLineOption$str() {
        return "WFLYSRV0072: Value expected for option %s";
    }

    @Override
    public final String valueExpectedForCommandLineOption(String option) {
        return String.format(this.getLoggingLocale(), this.valueExpectedForCommandLineOption$str(), option);
    }

    protected String invalidCommandLineOption$str() {
        return "WFLYSRV0073: Invalid option '%s'";
    }

    @Override
    public final String invalidCommandLineOption(String option) {
        return String.format(this.getLoggingLocale(), this.invalidCommandLineOption$str(), option);
    }

    protected String malformedCommandLineURL$str() {
        return "WFLYSRV0074: Malformed URL '%s' provided for option '%s'";
    }

    @Override
    public final String malformedCommandLineURL(String urlSpec, String option) {
        return String.format(this.getLoggingLocale(), this.malformedCommandLineURL$str(), urlSpec, option);
    }

    protected String unableToLoadProperties$str() {
        return "WFLYSRV0075: Unable to load properties from URL '%s'";
    }

    @Override
    public final String unableToLoadProperties(URL url) {
        return String.format(this.getLoggingLocale(), this.unableToLoadProperties$str(), url);
    }

    protected String cannotCreateVault$str() {
        return "WFLYSRV0076: Error initializing vault --  %s";
    }

    @Override
    public final VaultReaderException cannotCreateVault(Throwable cause, Throwable msg) {
        VaultReaderException result = new VaultReaderException(String.format(this.getLoggingLocale(), this.cannotCreateVault$str(), msg), cause);
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String hostControllerNameNonNullInStandalone$str() {
        return "WFLYSRV0079: hostControllerName must be null if the server is not in a managed domain";
    }

    @Override
    public final IllegalArgumentException hostControllerNameNonNullInStandalone() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.hostControllerNameNonNullInStandalone$str(), new Object[0]));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String hostControllerNameNullInDomain$str() {
        return "WFLYSRV0080: hostControllerName may not be null if the server is in a managed domain";
    }

    @Override
    public final IllegalArgumentException hostControllerNameNullInDomain() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.hostControllerNameNullInDomain$str(), new Object[0]));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotResolveInterface$str() {
        return "WFLYSRV0081: An IP address cannot be resolved using the given interface selection criteria. Failure was -- %s";
    }

    @Override
    public final OperationFailedException cannotResolveInterface(Exception msg, Exception cause) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotResolveInterface$str(), msg), (Throwable)cause);
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failedToResolveInterface$str() {
        return "WFLYSRV0082: failed to resolve interface %s";
    }

    @Override
    public final StartException failedToResolveInterface(String name) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.failedToResolveInterface$str(), name));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failedToStartHttpManagementService$str() {
        return "WFLYSRV0083: Failed to start the http-interface service";
    }

    @Override
    public final StartException failedToStartHttpManagementService(Exception e) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.failedToStartHttpManagementService$str(), new Object[0]), (Throwable)e);
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noSuchDeploymentContent$str() {
        return "WFLYSRV0084: No deployment content with hash %s is available in the deployment content repository.";
    }

    @Override
    public final OperationFailedException noSuchDeploymentContent(String hash) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.noSuchDeploymentContent$str(), hash));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noSuchDeployment$str() {
        return "WFLYSRV0085: No deployment with name %s found";
    }

    @Override
    public final OperationFailedException noSuchDeployment(String deploymentName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.noSuchDeployment$str(), deploymentName));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotReplaceDeployment$str() {
        return "WFLYSRV0086: Cannot use %s with the same value for parameters %s and %s. Use %s to redeploy the same content or %s to replace content with a new version with the same name.";
    }

    @Override
    public final OperationFailedException cannotReplaceDeployment(String replaceOperation, String name, String toReplace, String redeployOperation, String fullReplace) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotReplaceDeployment$str(), replaceOperation, name, toReplace, redeployOperation, fullReplace));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String deploymentAlreadyStarted$str() {
        return "WFLYSRV0087: Deployment %s is already started";
    }

    @Override
    public final OperationFailedException deploymentAlreadyStarted(String deploymentName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.deploymentAlreadyStarted$str(), deploymentName));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingHomeDirConfiguration$str() {
        return "WFLYSRV0088: Missing configuration value for: %s";
    }

    @Override
    public final IllegalStateException missingHomeDirConfiguration(String propertyName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.missingHomeDirConfiguration$str(), propertyName));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String caughtIOExceptionUploadingContent$str() {
        return "WFLYSRV0093: Caught IOException reading uploaded deployment content";
    }

    @Override
    public final OperationFailedException caughtIOExceptionUploadingContent(IOException cause) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.caughtIOExceptionUploadingContent$str(), new Object[0]), (Throwable)cause);
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String nullStreamAttachment$str() {
        return "WFLYSRV0094: Null stream at index [%d]";
    }

    @Override
    public final OperationFailedException nullStreamAttachment(int index) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.nullStreamAttachment$str(), index));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidDeploymentURL$str() {
        return "WFLYSRV0095: '%s' is not a valid URL";
    }

    @Override
    public final OperationFailedException invalidDeploymentURL(String urlSpec, MalformedURLException e) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidDeploymentURL$str(), urlSpec), (Throwable)e);
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String problemOpeningStreamFromDeploymentURL$str() {
        return "WFLYSRV0096: Error obtaining input stream from URL '%s'";
    }

    @Override
    public final OperationFailedException problemOpeningStreamFromDeploymentURL(String urlSpec, IOException e) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.problemOpeningStreamFromDeploymentURL$str(), urlSpec), (Throwable)e);
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String serviceModuleLoaderAlreadyStarted$str() {
        return "WFLYSRV0097: ServiceModuleLoader already started";
    }

    @Override
    public final IllegalStateException serviceModuleLoaderAlreadyStarted() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.serviceModuleLoaderAlreadyStarted$str(), new Object[0]));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String serviceModuleLoaderAlreadyStopped$str() {
        return "WFLYSRV0098: ServiceModuleLoader already stopped";
    }

    @Override
    public final IllegalStateException serviceModuleLoaderAlreadyStopped() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.serviceModuleLoaderAlreadyStopped$str(), new Object[0]));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingModulePrefix$str() {
        return "WFLYSRV0099: '%s' cannot be loaded from a ServiceModuleLoader as its name does not start with '%s'";
    }

    @Override
    public final IllegalArgumentException missingModulePrefix(ModuleIdentifier identifier, String prefix) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.missingModulePrefix$str(), identifier, prefix));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToReadVirtualFile$str() {
        return "WFLYSRV0100: Failed to read '%s'";
    }

    @Override
    public final DeploymentUnitProcessingException failedToReadVirtualFile(VirtualFile file, IOException cause) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failedToReadVirtualFile$str(), file), cause);
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String deploymentRootRequired$str() {
        return "WFLYSRV0101: Deployment root is required";
    }

    @Override
    public final IllegalArgumentException deploymentRootRequired() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.deploymentRootRequired$str(), new Object[0]));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String subdeploymentsRequireParent$str() {
        return "WFLYSRV0102: Sub-deployments require a parent deployment unit";
    }

    @Override
    public final IllegalArgumentException subdeploymentsRequireParent() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.subdeploymentsRequireParent$str(), new Object[0]));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noModuleIdentifier$str() {
        return "WFLYSRV0103: No Module Identifier attached to deployment '%s'";
    }

    @Override
    public final DeploymentUnitProcessingException noModuleIdentifier(String deploymentUnitName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.noModuleIdentifier$str(), deploymentUnitName));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToCreateVFSResourceLoader$str() {
        return "WFLYSRV0104: Failed to create VFSResourceLoader for root [%s]";
    }

    @Override
    public final DeploymentUnitProcessingException failedToCreateVFSResourceLoader(String resourceRoot, IOException cause) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failedToCreateVFSResourceLoader$str(), resourceRoot), cause);
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToGetFileFromRemoteRepository$str() {
        return "WFLYSRV0105: Failed to get file from remote repository";
    }

    @Override
    public final RuntimeException failedToGetFileFromRemoteRepository(Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToGetFileFromRemoteRepository$str(), new Object[0]), cause);
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotCreateLocalDirectory$str() {
        return "WFLYSRV0106: Unable to create local directory: %s";
    }

    @Override
    public final IOException cannotCreateLocalDirectory(File path) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.cannotCreateLocalDirectory$str(), path));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String didNotReadEntireFile$str() {
        return "WFLYSRV0107: Did not read the entire file. Missing: %d";
    }

    @Override
    public final IOException didNotReadEntireFile(long missing) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.didNotReadEntireFile$str(), missing));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noArgValue$str() {
        return "WFLYSRV0108: No value was provided for argument %s%n";
    }

    @Override
    public final String noArgValue(String argument) {
        return String.format(this.getLoggingLocale(), this.noArgValue$str(), argument);
    }

    protected String couldNotFindHcFileRepositoryConnection$str() {
        return "WFLYSRV0109: Could not find the file repository connection to the host controller.";
    }

    @Override
    public final IllegalStateException couldNotFindHcFileRepositoryConnection() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.couldNotFindHcFileRepositoryConnection$str(), new Object[0]));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownMountType$str() {
        return "WFLYSRV0112: Unknown mount type %s";
    }

    @Override
    public final IllegalArgumentException unknownMountType(MountType mountType) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownMountType$str(), new Object[]{mountType}));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedCreatingTempProvider$str() {
        return "WFLYSRV0113: Failed to create temp file provider";
    }

    @Override
    public final StartException failedCreatingTempProvider(Throwable cause) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.failedCreatingTempProvider$str(), new Object[0]), cause);
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String systemPropertyNotManageable$str() {
        return "WFLYSRV0115: System property %s cannot be set via the xml configuration file or from a management client; it's value must be known at initial process start so it can only set from the commmand line";
    }

    @Override
    public final OperationFailedException systemPropertyNotManageable(String propertyName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.systemPropertyNotManageable$str(), propertyName));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String systemPropertyCannotOverrideServerName$str() {
        return "WFLYSRV0116: System property %s cannot be set after the server name has been set via the xml configuration file or from a management client";
    }

    @Override
    public final OperationFailedException systemPropertyCannotOverrideServerName(String propertyName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.systemPropertyCannotOverrideServerName$str(), propertyName));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToInitialiseSSLContext$str() {
        return "WFLYSRV0117: Unable to initialise a basic SSLContext '%s'";
    }

    @Override
    public final IllegalStateException unableToInitialiseSSLContext(String message) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unableToInitialiseSSLContext$str(), message));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String homeDirectoryDoesNotExist$str() {
        return "WFLYSRV0119: Home directory does not exist: %s";
    }

    @Override
    public final IllegalStateException homeDirectoryDoesNotExist(File f) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.homeDirectoryDoesNotExist$str(), f));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String bundlesDirectoryDoesNotExist$str() {
        return "WFLYSRV0120: Bundles directory does not exist: %s";
    }

    @Override
    public final IllegalStateException bundlesDirectoryDoesNotExist(File f) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.bundlesDirectoryDoesNotExist$str(), f));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String configDirectoryDoesNotExist$str() {
        return "WFLYSRV0121: Configuration directory does not exist: %s";
    }

    @Override
    public final IllegalStateException configDirectoryDoesNotExist(File f) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.configDirectoryDoesNotExist$str(), f));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String serverBaseDirectoryDoesNotExist$str() {
        return "WFLYSRV0122: Server base directory does not exist: %s";
    }

    @Override
    public final IllegalStateException serverBaseDirectoryDoesNotExist(File f) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.serverBaseDirectoryDoesNotExist$str(), f));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String serverDataDirectoryIsNotDirectory$str() {
        return "WFLYSRV0123: Server data directory is not a directory: %s";
    }

    @Override
    public final IllegalStateException serverDataDirectoryIsNotDirectory(File file) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.serverDataDirectoryIsNotDirectory$str(), file));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotCreateServerDataDirectory$str() {
        return "WFLYSRV0124: Could not create server data directory: %s";
    }

    @Override
    public final IllegalStateException couldNotCreateServerDataDirectory(File file) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.couldNotCreateServerDataDirectory$str(), file));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String serverContentDirectoryIsNotDirectory$str() {
        return "WFLYSRV0125: Server content directory is not a directory: %s";
    }

    @Override
    public final IllegalStateException serverContentDirectoryIsNotDirectory(File file) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.serverContentDirectoryIsNotDirectory$str(), file));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotCreateServerContentDirectory$str() {
        return "WFLYSRV0126: Could not create server content directory: %s";
    }

    @Override
    public final IllegalStateException couldNotCreateServerContentDirectory(File file) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.couldNotCreateServerContentDirectory$str(), file));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String logDirectoryIsNotADirectory$str() {
        return "WFLYSRV0127: Log directory is not a directory: %s";
    }

    @Override
    public final IllegalStateException logDirectoryIsNotADirectory(File f) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.logDirectoryIsNotADirectory$str(), f));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotCreateLogDirectory$str() {
        return "WFLYSRV0128: Could not create log directory: %s";
    }

    @Override
    public final IllegalStateException couldNotCreateLogDirectory(File f) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.couldNotCreateLogDirectory$str(), f));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String serverTempDirectoryIsNotADirectory$str() {
        return "WFLYSRV0129: Server temp directory does not exist: %s";
    }

    @Override
    public final IllegalStateException serverTempDirectoryIsNotADirectory(File file) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.serverTempDirectoryIsNotADirectory$str(), file));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotCreateServerTempDirectory$str() {
        return "WFLYSRV0130: Could not create server temp directory: %s";
    }

    @Override
    public final IllegalStateException couldNotCreateServerTempDirectory(File file) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.couldNotCreateServerTempDirectory$str(), file));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String controllerTempDirectoryIsNotADirectory$str() {
        return "WFLYSRV0131: Controller temp directory does not exist: %s";
    }

    @Override
    public final IllegalStateException controllerTempDirectoryIsNotADirectory(File file) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.controllerTempDirectoryIsNotADirectory$str(), file));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotCreateControllerTempDirectory$str() {
        return "WFLYSRV0132: Could not create server temp directory: %s";
    }

    @Override
    public final IllegalStateException couldNotCreateControllerTempDirectory(File file) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.couldNotCreateControllerTempDirectory$str(), file));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String domainBaseDirDoesNotExist$str() {
        return "WFLYSRV0133: Domain base dir does not exist: %s";
    }

    @Override
    public final IllegalStateException domainBaseDirDoesNotExist(File file) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.domainBaseDirDoesNotExist$str(), file));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String domainConfigDirDoesNotExist$str() {
        return "WFLYSRV0134: Domain config dir does not exist: %s";
    }

    @Override
    public final IllegalStateException domainConfigDirDoesNotExist(File file) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.domainConfigDirDoesNotExist$str(), file));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String serverBaseDirectoryIsNotADirectory$str() {
        return "WFLYSRV0135: Server base directory is not a directory: %s";
    }

    @Override
    public final IllegalStateException serverBaseDirectoryIsNotADirectory(File file) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.serverBaseDirectoryIsNotADirectory$str(), file));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotCreateServerBaseDirectory$str() {
        return "WFLYSRV0136: Could not create server base directory: %s";
    }

    @Override
    public final IllegalStateException couldNotCreateServerBaseDirectory(File file) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.couldNotCreateServerBaseDirectory$str(), file));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noSuchDeploymentContentAtBoot$str() {
        return "WFLYSRV0137: No deployment content with hash %s is available in the deployment content repository for deployment '%s'. This is a fatal boot error. To correct the problem, either restart with the --admin-only switch set and use the CLI to install the missing content or remove it from the configuration, or remove the deployment from the xml configuration file and restart.";
    }

    @Override
    public final OperationFailedException noSuchDeploymentContentAtBoot(String contentHash, String deploymentName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.noSuchDeploymentContentAtBoot$str(), contentHash, deploymentName));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String configuredSystemPropertiesLabel$str() {
        return "Configured system properties:";
    }

    @Override
    public final String configuredSystemPropertiesLabel() {
        return String.format(this.getLoggingLocale(), this.configuredSystemPropertiesLabel$str(), new Object[0]);
    }

    protected String vmArgumentsLabel$str() {
        return "VM Arguments: %s";
    }

    @Override
    public final String vmArgumentsLabel(String arguments) {
        return String.format(this.getLoggingLocale(), this.vmArgumentsLabel$str(), arguments);
    }

    protected String configuredSystemEnvironmentLabel$str() {
        return "Configured system environment:";
    }

    @Override
    public final String configuredSystemEnvironmentLabel() {
        return String.format(this.getLoggingLocale(), this.configuredSystemEnvironmentLabel$str(), new Object[0]);
    }

    protected String vfsNotAvailable$str() {
        return "WFLYSRV0138: VFS is not available from the configured module loader";
    }

    @Override
    public final IllegalStateException vfsNotAvailable() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.vfsNotAvailable$str(), new Object[0]));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String serverControllerServiceRemoved$str() {
        return "WFLYSRV0139: Server controller service was removed";
    }

    @Override
    public final ServiceNotFoundException serverControllerServiceRemoved() {
        ServiceNotFoundException result = new ServiceNotFoundException(String.format(this.getLoggingLocale(), this.serverControllerServiceRemoved$str(), new Object[0]));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String rootServiceRemoved$str() {
        return "WFLYSRV0140: Root service was removed";
    }

    @Override
    public final IllegalStateException rootServiceRemoved() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.rootServiceRemoved$str(), new Object[0]));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotStartServer$str() {
        return "WFLYSRV0141: Cannot start server";
    }

    @Override
    public final IllegalStateException cannotStartServer(Exception e) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotStartServer$str(), new Object[0]), e);
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String embeddedServerDirectoryNotFound$str() {
        return "WFLYSRV0143: No directory called '%s' exists under '%s'";
    }

    @Override
    public final IllegalArgumentException embeddedServerDirectoryNotFound(String relativePath, String homePath) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.embeddedServerDirectoryNotFound$str(), relativePath, homePath));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String propertySpecifiedFileDoesNotExist$str() {
        return "WFLYSRV0144: -D%s=%s does not exist";
    }

    @Override
    public final IllegalArgumentException propertySpecifiedFileDoesNotExist(String property, String path) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.propertySpecifiedFileDoesNotExist$str(), property, path));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String propertySpecifiedFileIsNotADirectory$str() {
        return "WFLYSRV0145: -D%s=%s is not a directory";
    }

    @Override
    public final IllegalArgumentException propertySpecifiedFileIsNotADirectory(String property, String path) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.propertySpecifiedFileIsNotADirectory$str(), property, path));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorCopyingFile$str() {
        return "WFLYSRV0146: Error copying '%s' to '%s'";
    }

    @Override
    public final RuntimeException errorCopyingFile(String src, String dest, IOException e) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.errorCopyingFile$str(), src, dest), e);
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidObject$str() {
        return "WFLYSRV0147: %s is null";
    }

    @Override
    public final InvalidObjectException invalidObject(String field) {
        InvalidObjectException result = new InvalidObjectException(String.format(this.getLoggingLocale(), this.invalidObject$str(), field));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidPortOffset$str() {
        return "WFLYSRV0148: portOffset is out of range";
    }

    @Override
    public final InvalidObjectException invalidPortOffset() {
        InvalidObjectException result = new InvalidObjectException(String.format(this.getLoggingLocale(), this.invalidPortOffset$str(), new Object[0]));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidStreamIndex$str() {
        return "WFLYSRV0149: Invalid '%s' value: %d, the maximum index is %d";
    }

    @Override
    public final OperationFailedException invalidStreamIndex(String name, int value, int maxIndex) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidStreamIndex$str(), name, value, maxIndex));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidStreamURL$str() {
        return "WFLYSRV0150: Cannot create input stream from URL '%s'";
    }

    @Override
    public final OperationFailedException invalidStreamURL(Exception cause, String url) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidStreamURL$str(), url), (Throwable)cause);
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidStreamBytes$str() {
        return "WFLYSRV0151: No bytes available at param %s";
    }

    @Override
    public final OperationFailedException invalidStreamBytes(String param) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidStreamBytes$str(), param));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String multipleContentItemsNotSupported$str() {
        return "WFLYSRV0152: Only 1 piece of content is current supported (AS7-431)";
    }

    @Override
    public final OperationFailedException multipleContentItemsNotSupported() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.multipleContentItemsNotSupported$str(), new Object[0]));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String deploymentPhaseFailed$str() {
        return "WFLYSRV0153: Failed to process phase %s of %s";
    }

    @Override
    public final StartException deploymentPhaseFailed(Phase phase, DeploymentUnit deploymentUnit, Throwable cause) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.deploymentPhaseFailed$str(), new Object[]{phase, deploymentUnit}), cause);
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String deploymentIndexingFailed$str() {
        return "WFLYSRV0156: Failed to index deployment root for annotations";
    }

    @Override
    public final DeploymentUnitProcessingException deploymentIndexingFailed(Throwable cause) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.deploymentIndexingFailed$str(), new Object[0]), cause);
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noSeamIntegrationJarPresent$str() {
        return "WFLYSRV0157: No Seam Integration jar present: %s";
    }

    @Override
    public final DeploymentUnitProcessingException noSeamIntegrationJarPresent(Module module) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.noSeamIntegrationJarPresent$str(), module));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToInstantiateClassFileTransformer$str() {
        return "WFLYSRV0158: Failed to instantiate a %s";
    }

    @Override
    public final DeploymentUnitProcessingException failedToInstantiateClassFileTransformer(String clazz, Exception cause) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failedToInstantiateClassFileTransformer$str(), clazz), cause);
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noDeploymentRepositoryAvailable$str() {
        return "WFLYSRV0159: No deployment repository available.";
    }

    @Override
    public final DeploymentUnitProcessingException noDeploymentRepositoryAvailable() {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.noDeploymentRepositoryAvailable$str(), new Object[0]));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String deploymentMountFailed$str() {
        return "WFLYSRV0160: Failed to mount deployment content";
    }

    @Override
    public final DeploymentUnitProcessingException deploymentMountFailed(IOException cause) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.deploymentMountFailed$str(), new Object[0]), cause);
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToGetManifest$str() {
        return "WFLYSRV0161: Failed to get manifest for deployment %s";
    }

    @Override
    public final DeploymentUnitProcessingException failedToGetManifest(VirtualFile file, IOException cause) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failedToGetManifest$str(), file), cause);
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotMergeResourceRoot$str() {
        return "WFLYSRV0163: Cannot merge resource root for a different file. This: %s mergee: %s";
    }

    @Override
    public final IllegalArgumentException cannotMergeResourceRoot(VirtualFile file, VirtualFile mergee) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotMergeResourceRoot$str(), file, mergee));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToCreateTempFileProvider$str() {
        return "WFLYSRV0164: Failed to create temp file provider";
    }

    @Override
    public final RuntimeException failedToCreateTempFileProvider(IOException cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToCreateTempFileProvider$str(), new Object[0]), cause);
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String resourceTooLarge$str() {
        return "WFLYSRV0165: Resource is too large to be a valid class file";
    }

    @Override
    public final IOException resourceTooLarge() {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.resourceTooLarge$str(), new Object[0]));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String subdeploymentNotFound$str() {
        return "WFLYSRV0166: Sub deployment %s in jboss-deployment-structure.xml was not found. Available sub deployments: %s";
    }

    @Override
    public final DeploymentUnitProcessingException subdeploymentNotFound(String path, StringBuilder subdeployments) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.subdeploymentNotFound$str(), path, subdeployments));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String deploymentStructureFileNotFound$str() {
        return "WFLYSRV0167: No jboss-deployment-structure.xml file found at %s";
    }

    @Override
    public final DeploymentUnitProcessingException deploymentStructureFileNotFound(File file) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.deploymentStructureFileNotFound$str(), file));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorLoadingDeploymentStructureFile$str() {
        return "WFLYSRV0168: Error loading jboss-deployment-structure.xml from %s";
    }

    @Override
    public final DeploymentUnitProcessingException errorLoadingDeploymentStructureFile(String path, XMLStreamException cause) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.errorLoadingDeploymentStructureFile$str(), path), cause);
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateSubdeploymentListing$str() {
        return "WFLYSRV0169: Sub deployment '%s' is listed twice in jboss-deployment-structure.xml";
    }

    @Override
    public final XMLStreamException duplicateSubdeploymentListing(String name) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.duplicateSubdeploymentListing$str(), name));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidModuleName$str() {
        return "WFLYSRV0170: Additional module name '%s' is not valid. Names must start with 'deployment.'";
    }

    @Override
    public final XMLStreamException invalidModuleName(String name) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.invalidModuleName$str(), name));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String externalResourceRootsNotSupported$str() {
        return "WFLYSRV0171: External resource roots not supported, resource roots may not start with a '/' : %s";
    }

    @Override
    public final XMLStreamException externalResourceRootsNotSupported(String path) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.externalResourceRootsNotSupported$str(), path));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedEndOfDocument$str() {
        return "WFLYSRV0172: Unexpected end of document";
    }

    @Override
    public final XMLStreamException unexpectedEndOfDocument(Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.unexpectedEndOfDocument$str(), new Object[0]), location);
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingRequiredAttributes$str() {
        return "WFLYSRV0173: Missing one or more required attributes:%s";
    }

    @Override
    public final XMLStreamException missingRequiredAttributes(String missing, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.missingRequiredAttributes$str(), missing), location);
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedContent$str() {
        return "WFLYSRV0174: Unexpected content of type '%s', name is '%s', text is: '%s'";
    }

    @Override
    public final XMLStreamException unexpectedContent(String kind, QName name, String text, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.unexpectedContent$str(), kind, name, text), location);
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noMethodFound$str() {
        return "WFLYSRV0175: No method found with id: %s on class (or its super class) %s";
    }

    @Override
    public final DeploymentUnitProcessingException noMethodFound(MethodIdentifier method, Class<?> clazz) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.noMethodFound$str(), method, clazz));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorGettingReflectiveInformation$str() {
        return "WFLYSRV0177: Error getting reflective information for %s with ClassLoader %s";
    }

    @Override
    public final RuntimeException errorGettingReflectiveInformation(Class<?> clazz, ClassLoader cl, Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.errorGettingReflectiveInformation$str(), clazz, cl), cause);
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String externalModuleServiceAlreadyStarted$str() {
        return "WFLYSRV0178: External Module Service already started";
    }

    @Override
    public final IllegalStateException externalModuleServiceAlreadyStarted() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.externalModuleServiceAlreadyStarted$str(), new Object[0]));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToLoadModule$str() {
        return "WFLYSRV0179: Failed to load module: %s";
    }

    @Override
    public final StartException failedToLoadModule(ModuleIdentifier module, ModuleLoadException cause) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.failedToLoadModule$str(), module), (Throwable)cause);
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failedToResolveMulticastAddress$str() {
        return "WFLYSRV0187: Failed to get multicast address for %s";
    }

    @Override
    public final OperationFailedException failedToResolveMulticastAddress(UnknownHostException cause, String address) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.failedToResolveMulticastAddress$str(), address), (Throwable)cause);
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failedToResolveMulticastAddressForRollback$str() {
        return "WFLYSRV0188: Failed to get multicast address for %s";
    }

    @Override
    public final RuntimeException failedToResolveMulticastAddressForRollback(UnknownHostException cause, String address) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToResolveMulticastAddressForRollback$str(), address), cause);
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotAddMoreThanOneSocketBindingGroupForServerOrHost$str() {
        return "WFLYSRV0190: Cannot add more than one socket binding group. Add of '%s' attempted, but '%s' already exists";
    }

    @Override
    public final OperationFailedException cannotAddMoreThanOneSocketBindingGroupForServerOrHost(PathAddress wanted, PathAddress existing) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotAddMoreThanOneSocketBindingGroupForServerOrHost$str(), wanted, existing));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotHaveBothInitialServerConfigAndServerConfig$str() {
        return "WFLYSRV0191: Can't use both --server-config and --initial-server-config";
    }

    @Override
    public final IllegalArgumentException cannotHaveBothInitialServerConfigAndServerConfig() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotHaveBothInitialServerConfigAndServerConfig$str(), new Object[0]));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateJBossXmlNamespace$str() {
        return "WFLYSRV0192: Duplicate namespace %s in jboss-all.xml";
    }

    @Override
    public final XMLStreamException duplicateJBossXmlNamespace(QName namespace, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.duplicateJBossXmlNamespace$str(), namespace), location);
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String equivalentNamespacesInJBossXml$str() {
        return "WFLYSRV0193: Two different versions of the same namespaces are present in jboss-all.xml, %s and %s are both present";
    }

    @Override
    public final DeploymentUnitProcessingException equivalentNamespacesInJBossXml(QName key, QName s) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.equivalentNamespacesInJBossXml$str(), key, s));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorLoadingJBossXmlFile$str() {
        return "WFLYSRV0194: Error loading jboss-all.xml from %s";
    }

    @Override
    public final DeploymentUnitProcessingException errorLoadingJBossXmlFile(String path, XMLStreamException e) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.errorLoadingJBossXmlFile$str(), path), e);
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullModuleAttachment$str() {
        return "WFLYSRV0195: Cannot obtain required module for: %s";
    }

    @Override
    public final IllegalStateException nullModuleAttachment(DeploymentUnit depUnit) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.nullModuleAttachment$str(), depUnit));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String deploymentOverlayFailed$str() {
        return "WFLYSRV0196: Failed to get content for deployment overlay %s at %s";
    }

    @Override
    public final DeploymentUnitProcessingException deploymentOverlayFailed(Exception cause, String contentOverlay, String file) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.deploymentOverlayFailed$str(), contentOverlay, file), cause);
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noSuchDeploymentOverlayContentAtBoot$str() {
        return "WFLYSRV0198: No deployment overlay content with hash %s is available in the deployment content repository for deployment overlay '%s' at location %s. This is a fatal boot error. To correct the problem, either restart with the --admin-only switch set and use the CLI to install the missing content or remove it from the configuration, or remove the deployment overlay from the xml configuration file and restart.";
    }

    @Override
    public final OperationFailedException noSuchDeploymentOverlayContentAtBoot(String contentHash, String deploymentOverlayName, String contentFile) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.noSuchDeploymentOverlayContentAtBoot$str(), contentHash, deploymentOverlayName, contentFile));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noSuchDeploymentOverlayContent$str() {
        return "WFLYSRV0199: No deployment overlay content with hash %s is available in the deployment content repository.";
    }

    @Override
    public final OperationFailedException noSuchDeploymentOverlayContent(String hash) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.noSuchDeploymentOverlayContent$str(), hash));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failedToLoadFile$str() {
        return "WFLYSRV0200: Failed to read file %s";
    }

    @Override
    public final OperationFailedException failedToLoadFile(VirtualFile file, IOException e) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.failedToLoadFile$str(), file), (Throwable)e);
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotHaveMoreThanOneManagedContentItem$str() {
        return "WFLYSRV0201: Cannot have more than one of %s";
    }

    @Override
    public final OperationFailedException cannotHaveMoreThanOneManagedContentItem(Set<String> managedAttributes) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotHaveMoreThanOneManagedContentItem$str(), managedAttributes));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownContentItemKey$str() {
        return "WFLYSRV0202: Unknown content item key: %s";
    }

    @Override
    public final OperationFailedException unknownContentItemKey(String key) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unknownContentItemKey$str(), key));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotMixUnmanagedAndManagedContentItems$str() {
        return "WFLYSRV0203: Cannot use %s when %s are used";
    }

    @Override
    public final OperationFailedException cannotMixUnmanagedAndManagedContentItems(Set<String> usedManaged, Set<String> usedUnmanaged) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotMixUnmanagedAndManagedContentItems$str(), usedManaged, usedUnmanaged));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String nullParameter$str() {
        return "WFLYSRV0204: Null '%s'";
    }

    @Override
    public final OperationFailedException nullParameter(String name) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.nullParameter$str(), name));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String runtimeNameMustBeUnique$str() {
        return "WFLYSRV0205: There is already a deployment called %s with the same runtime name %s";
    }

    @Override
    public final OperationFailedException runtimeNameMustBeUnique(String existingDeployment, String runtimename) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.runtimeNameMustBeUnique$str(), existingDeployment, runtimename));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String duplicateDeploymentUnitProcessor$str() {
        return "WFLYSRV0206: Multiple deployment unit processors registered with priority %s and class %s";
    }

    @Override
    public final IllegalStateException duplicateDeploymentUnitProcessor(int priority, Class aClass) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.duplicateDeploymentUnitProcessor$str(), priority, aClass));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void startingSubDeployment(String deploymentUnitName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.startingSubDeployment$str(), (Object)deploymentUnitName);
    }

    protected String startingSubDeployment$str() {
        return "WFLYSRV0207: Starting subdeployment (runtime-name: \"%s\")";
    }

    @Override
    public final void stoppedSubDeployment(String deploymentUnitName, int elapsedTime) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.stoppedSubDeployment$str(), (Object)deploymentUnitName, (Object)elapsedTime);
    }

    protected String stoppedSubDeployment$str() {
        return "WFLYSRV0208: Stopped subdeployment (runtime-name: %s) in %dms";
    }

    protected String vaultModuleWithNoCode$str() {
        return "WFLYSRV0209: When specifying a 'module' you also need to specify the 'code'";
    }

    @Override
    public final OperationFailedException vaultModuleWithNoCode() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.vaultModuleWithNoCode$str(), new Object[0]));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String serverAlreadyPaused$str() {
        return "WFLYSRV0210: Server is already paused";
    }

    @Override
    public final IllegalStateException serverAlreadyPaused() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.serverAlreadyPaused$str(), new Object[0]));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void suspendingServer(long timeoutMillis) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.suspendingServer1$str(), (Object)timeoutMillis);
    }

    protected String suspendingServer1$str() {
        return "WFLYSRV0211: Suspending server with %d ms timeout.";
    }

    @Override
    public final void resumingServer() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.resumingServer$str(), new Object[0]);
    }

    protected String resumingServer$str() {
        return "WFLYSRV0212: Resuming server";
    }

    @Override
    public final void failedToConnectToHostController() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.failedToConnectToHostController$str(), new Object[0]);
    }

    protected String failedToConnectToHostController$str() {
        return "WFLYSRV0213: Failed to connect to host-controller, retrying.";
    }

    @Override
    public final void failedToResume(ServerActivity activity, Exception cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)cause, this.failedToResume$str(), (Object)activity);
    }

    protected String failedToResume$str() {
        return "WFLYSRV0215: Failed to resume activity %s. To resume normal operation it is recommended that you restart the server.";
    }

    @Override
    public final void failedToCleanObsoleteContent(String failure) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.failedToCleanObsoleteContent$str(), (Object)failure);
    }

    protected String failedToCleanObsoleteContent$str() {
        return "WFLYSRV0216: Error cleaning obsolete content %s ";
    }

    @Override
    public final void undeployingDeploymentHasBeenRedeployed(String deploymentName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.undeployingDeploymentHasBeenRedeployed$str(), (Object)deploymentName);
    }

    protected String undeployingDeploymentHasBeenRedeployed$str() {
        return "WFLYSRV0219: %s deployment has been re-deployed, its content will not be removed. You will need to restart it.";
    }

    @Override
    public final void shutdownHookInvoked() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.shutdownHookInvoked$str(), new Object[0]);
    }

    protected String shutdownHookInvoked$str() {
        return "WFLYSRV0220: Server shutdown has been requested via an OS signal";
    }

    @Override
    public final void deprecatedApiUsed(String name, ModuleIdentifier id) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.deprecatedApiUsed$str(), (Object)name, (Object)id);
    }

    protected String deprecatedApiUsed$str() {
        return "WFLYSRV0221: Deployment \"%s\" is using a deprecated module (\"%s\") which may be removed in future versions without notice.";
    }

    protected String illegalPermissionName$str() {
        return "WFLYSRV0222: Illegal permission name '%s'";
    }

    @Override
    public final IllegalArgumentException illegalPermissionName(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalPermissionName$str(), name));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalPermissionActions$str() {
        return "WFLYSRV0223: Illegal permission actions '%s'";
    }

    @Override
    public final IllegalArgumentException illegalPermissionActions(String actions) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalPermissionActions$str(), actions));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void couldNotMountOverlay(String path, VirtualFile parent) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.couldNotMountOverlay$str(), (Object)path, (Object)parent);
    }

    protected String couldNotMountOverlay$str() {
        return "WFLYSRV0224: Could not mount overlay %s as parent %s is not a directory";
    }

    protected String vaultReaderException$str() {
        return "WFLYSRV0227: Security exception accessing the vault";
    }

    @Override
    public final VaultReaderException vaultReaderException(Exception e) {
        VaultReaderException result = new VaultReaderException(String.format(this.getLoggingLocale(), this.vaultReaderException$str(), new Object[0]), e);
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void vaultNotInitializedException() {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.vaultNotInitializedException$str(), new Object[0]);
    }

    protected String vaultNotInitializedException$str() {
        return "WFLYSRV0230: Vault is not initialized; resolution of vault expressions is not possible";
    }

    protected String couldNotObtainServerUuidFile$str() {
        return "WFLYSRV0231: Could not read or create the server UUID in file: %s";
    }

    @Override
    public final IllegalStateException couldNotObtainServerUuidFile(Throwable cause, Path file) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.couldNotObtainServerUuidFile$str(), file), cause);
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotGetModuleInfo$str() {
        return "WFLYSRV0232: Could not get module info for module name: %s";
    }

    @Override
    public final OperationFailedException couldNotGetModuleInfo(String moduleName, Throwable cause) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.couldNotGetModuleInfo$str(), moduleName), cause);
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String deploymentUndeployedNotification$str() {
        return "WFLYSRV0233: Undeployed \"%s\" (runtime-name: \"%s\")";
    }

    @Override
    public final String deploymentUndeployedNotification(String managementName, String deploymentUnitName) {
        return String.format(this.getLoggingLocale(), this.deploymentUndeployedNotification$str(), managementName, deploymentUnitName);
    }

    protected String deploymentDeployedNotification$str() {
        return "WFLYSRV0234: Deployed \"%s\" (runtime-name : \"%s\")";
    }

    @Override
    public final String deploymentDeployedNotification(String managementName, String deploymentUnitName) {
        return String.format(this.getLoggingLocale(), this.deploymentDeployedNotification$str(), managementName, deploymentUnitName);
    }

    @Override
    public final void securityManagerEnabled() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.securityManagerEnabled$str(), new Object[0]);
    }

    protected String securityManagerEnabled$str() {
        return "WFLYSRV0235: Security Manager is enabled";
    }

    @Override
    public final void suspendingServerWithNoTimeout() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.suspendingServerWithNoTimeout$str(), new Object[0]);
    }

    protected String suspendingServerWithNoTimeout$str() {
        return "WFLYSRV0236: Suspending server with no timeout.";
    }

    protected String cannotBothHaveFalseUseCurrentConfigAndServerConfig$str() {
        return "WFLYSRV0237: It is not possible to use use-current-server-config=false while specifying a server-config";
    }

    @Override
    public final OperationFailedException cannotBothHaveFalseUseCurrentConfigAndServerConfig() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotBothHaveFalseUseCurrentConfigAndServerConfig$str(), new Object[0]));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String serverConfigForReloadNotFound$str() {
        return "WFLYSRV0238: server-config '%s' specified for reload could not be found";
    }

    @Override
    public final OperationFailedException serverConfigForReloadNotFound(String serverConfig) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.serverConfigForReloadNotFound$str(), serverConfig));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void aborting(int code) {
        this.log.logf(FQCN, Logger.Level.FATAL, null, this.aborting$str(), (Object)code);
    }

    protected String aborting$str() {
        return "WFLYSRV0239: Aborting with exit code %d";
    }

    @Override
    public final void shuttingDownInResponseToProcessControllerSignal() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.shuttingDownInResponseToProcessControllerSignal$str(), new Object[0]);
    }

    protected String shuttingDownInResponseToProcessControllerSignal$str() {
        return "WFLYSRV0240: ProcessController has signalled to shut down; shutting down";
    }

    @Override
    public final void shuttingDownInResponseToManagementRequest(String op) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.shuttingDownInResponseToManagementRequest$str(), (Object)op);
    }

    protected String shuttingDownInResponseToManagementRequest$str() {
        return "WFLYSRV0241: Shutting down in response to management operation '%s'";
    }

    protected String cannotExplodeDeploymentOfSelfContainedServer$str() {
        return "WFLYSRV0242: Cannot explode a deployment in a self-contained server";
    }

    @Override
    public final OperationFailedException cannotExplodeDeploymentOfSelfContainedServer() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotExplodeDeploymentOfSelfContainedServer$str(), new Object[0]));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotExplodeUnmanagedDeployment$str() {
        return "WFLYSRV0243: Cannot explode an unmanaged deployment";
    }

    @Override
    public final OperationFailedException cannotExplodeUnmanagedDeployment() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotExplodeUnmanagedDeployment$str(), new Object[0]));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotExplodeAlreadyExplodedDeployment$str() {
        return "WFLYSRV0244: Cannot explode an already exploded deployment";
    }

    @Override
    public final OperationFailedException cannotExplodeAlreadyExplodedDeployment() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotExplodeAlreadyExplodedDeployment$str(), new Object[0]));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotExplodeEnabledDeployment$str() {
        return "WFLYSRV0245: Cannot explode an already deployed deployment";
    }

    @Override
    public final OperationFailedException cannotExplodeEnabledDeployment() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotExplodeEnabledDeployment$str(), new Object[0]));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotAddContentToSelfContainedServer$str() {
        return "WFLYSRV0246: Cannot add content to a deployment in a self-contained server";
    }

    @Override
    public final OperationFailedException cannotAddContentToSelfContainedServer() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotAddContentToSelfContainedServer$str(), new Object[0]));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotAddContentToUnmanagedDeployment$str() {
        return "WFLYSRV0247: Cannot add content to an unmanaged deployment";
    }

    @Override
    public final OperationFailedException cannotAddContentToUnmanagedDeployment() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotAddContentToUnmanagedDeployment$str(), new Object[0]));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotAddContentToUnexplodedDeployment$str() {
        return "WFLYSRV0248: Cannot add content to an unexploded deployment";
    }

    @Override
    public final OperationFailedException cannotAddContentToUnexplodedDeployment() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotAddContentToUnexplodedDeployment$str(), new Object[0]));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void couldNotCopyFiles(Exception ex, String managementName) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)ex, this.couldNotCopyFiles$str(), (Object)managementName);
    }

    protected String couldNotCopyFiles$str() {
        return "WFLYSRV0249: Could not copy files from the managed content repository to the running deployment for %s";
    }

    protected String cannotRemoveContentFromSelfContainedServer$str() {
        return "WFLYSRV0250: Cannot remove content from a deployment in a self-contained server";
    }

    @Override
    public final OperationFailedException cannotRemoveContentFromSelfContainedServer() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotRemoveContentFromSelfContainedServer$str(), new Object[0]));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotRemoveContentFromUnmanagedDeployment$str() {
        return "WFLYSRV0251: Cannot remove content from an unmanaged deployment";
    }

    @Override
    public final OperationFailedException cannotRemoveContentFromUnmanagedDeployment() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotRemoveContentFromUnmanagedDeployment$str(), new Object[0]));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotRemoveContentFromUnexplodedDeployment$str() {
        return "WFLYSRV0252: Cannot remove content from an unexploded deployment";
    }

    @Override
    public final OperationFailedException cannotRemoveContentFromUnexplodedDeployment() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotRemoveContentFromUnexplodedDeployment$str(), new Object[0]));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void couldNotDeleteFile(Exception ex, String path, String managementName) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)ex, this.couldNotDeleteFile$str(), (Object)path, (Object)managementName);
    }

    protected String couldNotDeleteFile$str() {
        return "WFLYSRV0253: Could not delete file %s from the running deployment %s";
    }

    protected String cannotReadContentFromSelfContainedServer$str() {
        return "WFLYSRV0254: Cannot read content from a deployment in a self-contained server";
    }

    @Override
    public final OperationFailedException cannotReadContentFromSelfContainedServer() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotReadContentFromSelfContainedServer$str(), new Object[0]));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotReadContentFromUnmanagedDeployment$str() {
        return "WFLYSRV0255: Cannot read content from an unmanaged deployment";
    }

    @Override
    public final OperationFailedException cannotReadContentFromUnmanagedDeployment() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotReadContentFromUnmanagedDeployment$str(), new Object[0]));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String requiredSystemPropertyMissing$str() {
        return "WFLYSRV0257: Required system property '%s' not set";
    }

    @Override
    public final IllegalArgumentException requiredSystemPropertyMissing(String propName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.requiredSystemPropertyMissing$str(), propName));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotExplodeSubDeploymentOfUnexplodedDeployment$str() {
        return "WFLYSRV0258: Cannot explode a subdeployment of an unexploded deployment";
    }

    @Override
    public final OperationFailedException cannotExplodeSubDeploymentOfUnexplodedDeployment() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotExplodeSubDeploymentOfUnexplodedDeployment$str(), new Object[0]));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String secureSocketBindingRequiresSSLContext$str() {
        return "WFLYSRV0259: If attribute secure-socket-binding is defined one of ssl-context or security-realm must also be defined";
    }

    @Override
    public final OperationFailedException secureSocketBindingRequiresSSLContext() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.secureSocketBindingRequiresSSLContext$str(), new Object[0]));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void startingServerSuspended() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.startingServerSuspended$str(), new Object[0]);
    }

    protected String startingServerSuspended$str() {
        return "WFLYSRV0260: Starting server in suspended mode";
    }

    protected String bootComplete$str() {
        return "WFLYSRV0261: Boot complete";
    }

    @Override
    public final String bootComplete() {
        return String.format(this.getLoggingLocale(), this.bootComplete$str(), new Object[0]);
    }

    protected String cannotSetBothAdminOnlyAndStartMode$str() {
        return "WFLYSRV0262: You cannot set both --start-mode and --admin-only";
    }

    @Override
    public final String cannotSetBothAdminOnlyAndStartMode() {
        return String.format(this.getLoggingLocale(), this.cannotSetBothAdminOnlyAndStartMode$str(), new Object[0]);
    }

    protected String unknownStartMode$str() {
        return "WFLYSRV0263: Unknown start mode %s";
    }

    @Override
    public final String unknownStartMode(String value) {
        return String.format(this.getLoggingLocale(), this.unknownStartMode$str(), value);
    }

    protected String cannotSpecifyBothAdminOnlyAndStartMode$str() {
        return "WFLYSRV0264: Cannot specify both admin-only and start-mode";
    }

    @Override
    public final OperationFailedException cannotSpecifyBothAdminOnlyAndStartMode() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotSpecifyBothAdminOnlyAndStartMode$str(), new Object[0]));
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void invalidPoolCoreSize(String val, String configSysProp) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.invalidPoolCoreSize$str(), (Object)val, (Object)configSysProp);
    }

    protected String invalidPoolCoreSize$str() {
        return "WFLYSRV0265: Invalid value '%s' for system property '%s' -- value must be a non-negative integer";
    }

    protected String archiveMountFailed$str() {
        return "WFLYSRV0267: Cannot mount resource root '%s', is it really an archive?";
    }

    @Override
    public final XMLStreamException archiveMountFailed(String path, ZipException cause) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.archiveMountFailed$str(), path), cause);
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToPullRepository$str() {
        return "WFLYSRV0268: Failed to pull the repository %s";
    }

    @Override
    public final RuntimeException failedToPullRepository(Exception cause, String repository) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToPullRepository$str(), repository), cause);
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToInitRepository$str() {
        return "WFLYSRV0269: Failed to initialize the repository %s";
    }

    @Override
    public final RuntimeException failedToInitRepository(Exception cause, String repository) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToInitRepository$str(), repository), cause);
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void failedToPublishConfiguration(Throwable cause, String name) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToPublishConfiguration$str(), (Object)name);
    }

    protected String failedToPublishConfiguration$str() {
        return "WFLYSRV0270: Failed to publish configuration to %s";
    }

    @Override
    public final void errorUsingGit(Throwable cause, String message) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.errorUsingGit$str(), (Object)message);
    }

    protected String errorUsingGit$str() {
        return "WFLYSRV0271: Git error: %s";
    }

    @Override
    public final void suspendingServer() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.suspendingServer0$str(), new Object[0]);
    }

    protected String suspendingServer0$str() {
        return "WFLYSRV0272: Suspending server";
    }

    @Override
    public final void excludedSubSystemsNotExist(String subSystem) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.excludedSubSystemsNotExist$str(), (Object)subSystem);
    }

    protected String excludedSubSystemsNotExist$str() {
        return "WFLYSRV0273: Excluded subsystem %s via jboss-deployment-structure.xml does not exist.";
    }

    @Override
    public final void excludedDependenciesNotExist(String dependency) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.excludedDependenciesNotExist$str(), (Object)dependency);
    }

    protected String excludedDependenciesNotExist$str() {
        return "WFLYSRV0274: Excluded dependency %s via jboss-deployment-structure.xml does not exist.";
    }

    protected String maximumNumberOfJarResources$str() {
        return "WFLYSRV0275: Maximum number of allowed jar resources reached for global-directory module name '%s'. The maximum allowed is %d files";
    }

    @Override
    public final RuntimeException maximumNumberOfJarResources(String globalDirectory, long max) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.maximumNumberOfJarResources$str(), globalDirectory, max));
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorOpeningZipFile$str() {
        return "WFLYSRV0276: There is an error in opening zip file %s";
    }

    @Override
    public final StartException errorOpeningZipFile(String filename, Throwable throwable) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.errorOpeningZipFile$str(), filename), throwable);
        ServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failedToLoadSSHCredentials$str() {
        return "WFLYSRV0277: Failed to load SSH Credentials %s";
    }

    @Override
    public final RuntimeException failedToLoadSSHCredentials(Throwable cause, String message) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToLoadSSHCredentials$str(), message), cause);
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void usingGit() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.usingGit$str(), new Object[0]);
    }

    protected String usingGit$str() {
        return "WFLYSRV0278: The configuration history is managed through Git";
    }

    @Override
    public final void gitRespositoryInitialized(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.gitRespositoryInitialized$str(), (Object)name);
    }

    protected String gitRespositoryInitialized$str() {
        return "WFLYSRV0279: Git initialized in %s";
    }

    protected String unableToInitialiseGitRepository$str() {
        return "WFLYSRV0280: Unable to initialise the git repository.";
    }

    @Override
    public final IllegalArgumentException unableToInitialiseGitRepository(Throwable cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unableToInitialiseGitRepository$str(), new Object[0]), cause);
        ServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void wildflyConfigUrlIsSet(String property) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.wildflyConfigUrlIsSet$str(), (Object)property);
    }

    protected String wildflyConfigUrlIsSet$str() {
        return "WFLYSRV0281: System property %s is set. This should only be used for standalone clients. Setting this on the server will override your profile configuration.";
    }

    @Override
    public final void startingNonGraceful() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.startingNonGraceful$str(), new Object[0]);
    }

    protected String startingNonGraceful$str() {
        return "WFLYSRV0282: Server is starting with graceful startup disabled; external requests may receive failure responses until startup completes.";
    }

    @Override
    public final void disregardingNonGraceful() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.disregardingNonGraceful$str(), new Object[0]);
    }

    protected String disregardingNonGraceful$str() {
        return "WFLYSRV0283: A non-graceful startup was requested in conjunction with a suspended startup. The server will start suspended.";
    }

    protected String processStateChangeNotificationDescription$str() {
        return "Notification emitted when the process state changes";
    }

    @Override
    public final String processStateChangeNotificationDescription() {
        return String.format(this.getLoggingLocale(), this.processStateChangeNotificationDescription$str(), new Object[0]);
    }

    protected String jmxAttributeChange$str() {
        return "The attribute '%s' has changed from '%s' to '%s'";
    }

    @Override
    public final String jmxAttributeChange(String name, String oldState, String stateString) {
        return String.format(this.getLoggingLocale(), this.jmxAttributeChange$str(), name, oldState, stateString);
    }

    protected String repositoryInitialized$str() {
        return "Repository initialized";
    }

    @Override
    public final String repositoryInitialized() {
        return String.format(this.getLoggingLocale(), this.repositoryInitialized$str(), new Object[0]);
    }

    protected String addingIgnored$str() {
        return "Adding .gitignore";
    }

    @Override
    public final String addingIgnored() {
        return String.format(this.getLoggingLocale(), this.addingIgnored$str(), new Object[0]);
    }
}

