/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deploymentoverlay;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ParameterCorrector;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.operations.validation.BytesValidator;
import org.jboss.as.controller.operations.validation.MinMaxValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.DeploymentFileRepository;
import org.jboss.as.server.deploymentoverlay.DeploymentOverlayContentAdd;
import org.jboss.as.server.deploymentoverlay.DeploymentOverlayContentRemove;
import org.jboss.as.server.deploymentoverlay.DeploymentOverlayModel;
import org.jboss.as.server.deploymentoverlay.ReadContentHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DeploymentOverlayContentDefinition
extends SimpleResourceDefinition {
    public static final ObjectTypeAttributeDefinition CONTENT_PARAMETER = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("content", new AttributeDefinition[]{((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("input-stream-index", ModelType.INT, true).setValidator((ParameterValidator)new StringLengthValidator(0, true))).build(), ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("hash", ModelType.BYTES, true).setValidator((ParameterValidator)new HashValidator(true))).build(), ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("bytes", ModelType.BYTES, true).setValidator((ParameterValidator)new BytesValidator(1, Integer.MAX_VALUE, true))).build(), ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("url", ModelType.STRING, true).setValidator((ParameterValidator)new StringLengthValidator(1, true))).build()}).setCorrector(ContentCorrector.INSTANCE)).build();
    public static final SimpleAttributeDefinition CONTENT_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("content", ModelType.BYTES, false).setValidator((ParameterValidator)new HashValidator(true))).build();
    private final ContentRepository contentRepository;
    private final OperationStepHandler addHandler;
    private final SimpleOperationDefinition readContent;
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{CONTENT_ATTRIBUTE};

    public static AttributeDefinition[] attributes() {
        return (AttributeDefinition[])ATTRIBUTES.clone();
    }

    public DeploymentOverlayContentDefinition(ContentRepository contentRepository, DeploymentFileRepository remoteRepository) {
        super(DeploymentOverlayModel.CONTENT_PATH, ControllerResolver.getResolver((String[])new String[]{"deployment-overlay", "content"}), null, (OperationStepHandler)new DeploymentOverlayContentRemove(contentRepository));
        this.contentRepository = contentRepository;
        this.readContent = new SimpleOperationDefinition("read-content", this.getResourceDescriptionResolver());
        this.addHandler = new DeploymentOverlayContentAdd(contentRepository, remoteRepository);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition attr : ATTRIBUTES) {
            resourceRegistration.registerReadOnlyAttribute(attr, null);
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        ReadContentHandler handler = new ReadContentHandler(this.contentRepository);
        resourceRegistration.registerOperationHandler((OperationDefinition)this.readContent, (OperationStepHandler)handler);
        SimpleOperationDefinition addDefinition = new SimpleOperationDefinitionBuilder("add", ControllerResolver.getResolver((String[])new String[]{"deployment-overlay"})).setParameters(new AttributeDefinition[]{CONTENT_PARAMETER}).build();
        resourceRegistration.registerOperationHandler((OperationDefinition)addDefinition, this.addHandler);
    }

    private static class ContentCorrector
    implements ParameterCorrector {
        static final ParameterCorrector INSTANCE = new ContentCorrector();

        private ContentCorrector() {
        }

        public ModelNode correct(ModelNode newValue, ModelNode currentValue) {
            if (newValue.isDefined() && newValue.getType() == ModelType.BYTES) {
                ModelNode corrected = new ModelNode();
                corrected.get("hash").set(newValue);
                return corrected;
            }
            return newValue;
        }
    }

    private static class HashValidator
    extends ModelTypeValidator
    implements MinMaxValidator {
        public HashValidator(boolean nillable) {
            super(ModelType.BYTES, nillable);
        }

        public Long getMin() {
            return 20L;
        }

        public Long getMax() {
            return 20L;
        }
    }
}

