/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.deployment.DeploymentHandlerUtil;
import org.jboss.as.server.deployment.DeploymentHandlerUtils;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.ModelContentReference;
import org.jboss.as.server.deployment.Services;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;

public class DeploymentRemoveHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "remove";
    private final ContentRepository contentRepository;
    private final AbstractVaultReader vaultReader;

    public DeploymentRemoveHandler(ContentRepository contentRepository, AbstractVaultReader vaultReader) {
        this.contentRepository = contentRepository;
        this.vaultReader = vaultReader;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final String name = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        final List<byte[]> removedHashes = DeploymentUtils.getDeploymentHash(resource);
        final Resource deployment = context.removeResource(PathAddress.EMPTY_ADDRESS);
        final ImmutableManagementResourceRegistration registration = context.getResourceRegistration();
        final ManagementResourceRegistration mutableRegistration = context.getResourceRegistrationForUpdate();
        final ModelNode model = deployment.getModel();
        if (context.isNormalServer()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    String deploymentUnitName;
                    final boolean enabled = DeploymentAttributes.ENABLED.resolveModelAttribute(context, model).asBoolean();
                    if (enabled) {
                        deploymentUnitName = DeploymentAttributes.RUNTIME_NAME.resolveModelAttribute(context, model).asString();
                        ServiceName deploymentUnitServiceName = Services.deploymentUnitName(deploymentUnitName);
                        context.removeService(deploymentUnitServiceName);
                        context.removeService(deploymentUnitServiceName.append(new String[]{"contents"}));
                    } else {
                        deploymentUnitName = null;
                    }
                    final ModelNode contentNode = DeploymentAttributes.CONTENT_ALL.resolveModelAttribute(context, model);
                    context.completeStep(new OperationContext.ResultHandler(){

                        public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                            block10: {
                                Set<String> newHash;
                                String managementName;
                                block8: {
                                    block9: {
                                        ModelNode opAddr = operation.get("address");
                                        PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
                                        managementName = address.getLastElement().getValue();
                                        if (resultAction != OperationContext.ResultAction.ROLLBACK) break block8;
                                        if (enabled) {
                                            DeploymentRemoveHandler.this.recoverServices(context, model, deployment, deploymentUnitName, contentNode, registration, mutableRegistration, DeploymentRemoveHandler.this.vaultReader);
                                        }
                                        if (!enabled || !context.hasFailureDescription()) break block9;
                                        ServerLogger.ROOT_LOGGER.undeploymentRolledBack(deploymentUnitName, context.getFailureDescription().asString());
                                        break block10;
                                    }
                                    if (!enabled) break block10;
                                    ServerLogger.ROOT_LOGGER.undeploymentRolledBackWithNoMessage(deploymentUnitName);
                                    break block10;
                                }
                                if (enabled) {
                                    ServerLogger.ROOT_LOGGER.deploymentUndeployed(managementName, deploymentUnitName);
                                }
                                try {
                                    newHash = DeploymentUtils.getDeploymentHexHash(context.readResource(PathAddress.EMPTY_ADDRESS, false).getModel());
                                }
                                catch (Resource.NoSuchResourceException ex) {
                                    newHash = Collections.EMPTY_SET;
                                }
                                for (byte[] hash : removedHashes) {
                                    try {
                                        if (newHash.isEmpty() || !newHash.contains(HashUtil.bytesToHexString((byte[])hash))) {
                                            DeploymentRemoveHandler.this.contentRepository.removeContent(ModelContentReference.fromDeploymentName(name, hash));
                                            continue;
                                        }
                                        ServerLogger.ROOT_LOGGER.undeployingDeploymentHasBeenRedeployed(name);
                                    }
                                    catch (Exception e) {
                                        ServerLogger.ROOT_LOGGER.failedToRemoveDeploymentContent(e, HashUtil.bytesToHexString((byte[])hash));
                                    }
                                }
                            }
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    private void recoverServices(OperationContext context, ModelNode model, Resource deployment, String runtimeName, ModelNode contentNode, ImmutableManagementResourceRegistration registration, ManagementResourceRegistration mutableRegistration, AbstractVaultReader vaultReader) {
        String name = model.require("name").asString();
        DeploymentHandlerUtil.ContentItem[] contents = DeploymentHandlerUtils.getContents(contentNode);
        DeploymentHandlerUtil.doDeploy(context, runtimeName, name, deployment, registration, mutableRegistration, vaultReader, contents);
    }
}

