/*
 * Copyright 2023 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.as.server.deployment.jbossallxml;

import java.util.Set;

import org.jboss.as.controller.xml.VersionedSchema;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.staxmapper.IntVersion;
import org.jboss.staxmapper.Versioned;

/**
 * A versioned schema for an XML element contained within <code>jboss-all.xml</code>,
 * @author Paul Ferraro
 * @param S the schema type
 * @param T the type upon which this parser operates
 */
public interface JBossAllSchema<S extends Versioned<IntVersion, S>, T> extends VersionedSchema<IntVersion, S>, JBossAllXMLParser<T> {

    /**
     * Creates a deployment unit processor that registers parsers for the specified <code>jboss-all.xml</code> schemas.
     * @param <T> the deployment unit attachment type, generated by the parser
     * @param <S> the schema type
     * @param schemas a set of XML element schemas
     * @param key a deployment unit attachment key
     * @return a deployment unit processor
     */
    static <T, S extends JBossAllSchema<S, T>> DeploymentUnitProcessor createDeploymentUnitProcessor(Set<S> schemas, AttachmentKey<T> key) {
        JBossAllXmlParserRegisteringProcessor.Builder builder = JBossAllXmlParserRegisteringProcessor.builder();
        for (S schema : schemas) {
            builder.addParser(schema.getQualifiedName(), key, schema);
        }
        return builder.build();
    }
}
