/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.security.sasl;

import java.util.Collections;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.jboss.as.server.security.sasl.DomainServerSaslClient;
import org.wildfly.common.Assert;

public final class DomainServerSaslClientFactory
implements SaslClientFactory {
    public static final SaslClientFactory INSTANCE = new DomainServerSaslClientFactory();

    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        Assert.checkNotNullParam((String)"cbh", (Object)cbh);
        if (props == null) {
            props = Collections.emptyMap();
        }
        for (String mechanism : mechanisms) {
            if (!"JBOSS-DOMAIN-SERVER".equals(mechanism)) continue;
            return new DomainServerSaslClient(cbh);
        }
        return null;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        return new String[]{"JBOSS-DOMAIN-SERVER"};
    }

    public static SaslClientFactory getInstance() {
        return INSTANCE;
    }
}

