/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.server.services.net.LocalDestinationOutboundSocketBindingAddHandler;
import org.jboss.as.server.services.net.OutboundSocketBindingResourceDefinition;
import org.jboss.as.server.services.net.RemoteDestinationOutboundSocketBindingAddHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

class OutboundSocketBindingWriteHandler
extends AbstractWriteAttributeHandler<Boolean> {
    private final boolean remoteDestination;

    OutboundSocketBindingWriteHandler(boolean remoteDestination) {
        this.remoteDestination = remoteDestination;
    }

    protected boolean requiresRuntime(OperationContext context) {
        if (context.getProcessType().isServer()) {
            return super.requiresRuntime(context);
        }
        PathAddress pathAddress = context.getCurrentAddress();
        return pathAddress.size() > 0 && pathAddress.getElement(0).getKey().equals("host");
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Boolean> handbackHolder) throws OperationFailedException {
        boolean bound;
        String bindingName = context.getCurrentAddressValue();
        ModelNode bindingModel = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        ServiceName serviceName = OutboundSocketBindingResourceDefinition.OUTBOUND_SOCKET_BINDING_CAPABILITY.getCapabilityServiceName(bindingName, OutboundSocketBinding.class);
        ServiceController controller = context.getServiceRegistry(true).getRequiredService(serviceName);
        OutboundSocketBinding binding = controller.getState() == ServiceController.State.UP ? (OutboundSocketBinding)OutboundSocketBinding.class.cast(controller.getValue()) : null;
        boolean bl = bound = binding != null && binding.isConnected();
        if (binding == null) {
            this.handleBindingReinstall(context, bindingModel, serviceName);
            handbackHolder.setHandback((Object)Boolean.TRUE);
        } else {
            context.reloadRequired();
        }
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Boolean handback) throws OperationFailedException {
        if (handback != null && handback.booleanValue()) {
            String bindingName = context.getCurrentAddressValue();
            ModelNode bindingModel = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
            this.revertBindingReinstall(context, bindingName, bindingModel, attributeName, valueToRestore);
        } else {
            context.revertReloadRequired();
        }
    }

    private void handleBindingReinstall(OperationContext context, ModelNode bindingModel, ServiceName serviceName) throws OperationFailedException {
        context.removeService(serviceName);
        if (this.remoteDestination) {
            RemoteDestinationOutboundSocketBindingAddHandler.installOutboundSocketBindingService(context, bindingModel);
        } else {
            LocalDestinationOutboundSocketBindingAddHandler.installOutboundSocketBindingService(context, bindingModel);
        }
    }

    private void revertBindingReinstall(OperationContext context, String bindingName, ModelNode bindingModel, String attributeName, ModelNode previousValue) {
        ServiceName serviceName = OutboundSocketBindingResourceDefinition.OUTBOUND_SOCKET_BINDING_CAPABILITY.getCapabilityServiceName(bindingName, OutboundSocketBinding.class);
        context.removeService(serviceName);
        ModelNode unresolvedConfig = bindingModel.clone();
        unresolvedConfig.get(attributeName).set(previousValue);
        try {
            if (this.remoteDestination) {
                RemoteDestinationOutboundSocketBindingAddHandler.installOutboundSocketBindingService(context, unresolvedConfig);
            } else {
                LocalDestinationOutboundSocketBindingAddHandler.installOutboundSocketBindingService(context, unresolvedConfig);
            }
        }
        catch (OperationFailedException e) {
            throw new RuntimeException(e);
        }
    }
}

