/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.moduleservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.moduleservice.ModuleDefinition;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleNotFoundException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class ModuleLoadService
implements Service<Module> {
    private final InjectedValue<ServiceModuleLoader> serviceModuleLoader = new InjectedValue();
    private final InjectedValue<ModuleDefinition> moduleDefinitionInjectedValue = new InjectedValue();
    private final List<ModuleDependency> allDependencies;
    private final Collection<ModuleDependency> systemDependencies;
    private final Collection<ModuleDependency> userDependencies;
    private final Collection<ModuleDependency> localDependencies;
    private volatile Module module;

    private ModuleLoadService(Collection<ModuleDependency> systemDependencies, Collection<ModuleDependency> localDependencies, Collection<ModuleDependency> userDependencies) {
        this.systemDependencies = systemDependencies;
        this.localDependencies = localDependencies;
        this.userDependencies = userDependencies;
        this.allDependencies = new ArrayList<ModuleDependency>();
        this.allDependencies.addAll(systemDependencies);
        this.allDependencies.addAll(localDependencies);
        this.allDependencies.addAll(userDependencies);
    }

    private ModuleLoadService(List<ModuleDependency> aliasDependencies) {
        this.systemDependencies = Collections.emptyList();
        this.localDependencies = Collections.emptyList();
        this.userDependencies = Collections.emptyList();
        this.allDependencies = new ArrayList<ModuleDependency>(aliasDependencies);
    }

    private ModuleLoadService() {
        this.systemDependencies = Collections.emptyList();
        this.localDependencies = Collections.emptyList();
        this.userDependencies = Collections.emptyList();
        this.allDependencies = Collections.emptyList();
    }

    public synchronized void start(StartContext context) throws StartException {
        try {
            ServiceModuleLoader moduleLoader = (ServiceModuleLoader)((Object)this.serviceModuleLoader.getValue());
            Module module = moduleLoader.loadModule(((ModuleDefinition)this.moduleDefinitionInjectedValue.getValue()).getModuleIdentifier());
            moduleLoader.relinkModule(module);
            for (ModuleDependency dependency : this.allDependencies) {
                if (!dependency.isUserSpecified()) continue;
                String id = dependency.getDependencyModule();
                try {
                    String val = moduleLoader.loadModule(id).getProperty("jboss.api");
                    if (val == null) continue;
                    if (val.equals("private")) {
                        ServerLogger.PRIVATE_DEP_LOGGER.privateApiUsed(((ModuleDefinition)this.moduleDefinitionInjectedValue.getValue()).getModuleIdentifier().getName(), id);
                        continue;
                    }
                    if (val.equals("unsupported")) {
                        ServerLogger.UNSUPPORTED_DEP_LOGGER.unsupportedApiUsed(((ModuleDefinition)this.moduleDefinitionInjectedValue.getValue()).getModuleIdentifier().getName(), id);
                        continue;
                    }
                    if (!val.equals("deprecated")) continue;
                    ServerLogger.DEPRECATED_DEP_LOGGER.deprecatedApiUsed(((ModuleDefinition)this.moduleDefinitionInjectedValue.getValue()).getModuleIdentifier().getName(), id);
                }
                catch (ModuleNotFoundException moduleNotFoundException) {}
            }
            this.module = module;
        }
        catch (ModuleLoadException e) {
            throw ServerLogger.ROOT_LOGGER.failedToLoadModule(((ModuleDefinition)this.moduleDefinitionInjectedValue.getValue()).getModuleIdentifier(), e);
        }
    }

    public synchronized void stop(StopContext context) {
        this.module = null;
    }

    public Module getValue() throws IllegalStateException, IllegalArgumentException {
        return this.module;
    }

    private static ServiceName install(ServiceTarget target, String identifier, ModuleLoadService service) {
        ServiceName serviceName = ServiceModuleLoader.moduleServiceName(identifier);
        ServiceBuilder builder = target.addService(serviceName, (Service)service);
        builder.addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ServiceModuleLoader.class, service.getServiceModuleLoader());
        builder.addDependency(ServiceModuleLoader.moduleSpecServiceName(identifier.toString()), ModuleDefinition.class, service.getModuleDefinitionInjectedValue());
        builder.requires(ServiceModuleLoader.moduleResolvedServiceName(identifier.toString()));
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
        return serviceName;
    }

    public static ServiceName install(ServiceTarget target, ModuleIdentifier identifier) {
        ModuleLoadService service = new ModuleLoadService();
        return ModuleLoadService.install(target, identifier.toString(), service);
    }

    public static ServiceName install(ServiceTarget target, String identifier, Collection<ModuleDependency> systemDependencies, Collection<ModuleDependency> localDependencies, Collection<ModuleDependency> userDependencies) {
        ModuleLoadService service = new ModuleLoadService(systemDependencies, localDependencies, userDependencies);
        return ModuleLoadService.install(target, identifier, service);
    }

    public static ServiceName installAliases(ServiceTarget target, ModuleIdentifier identifier, List<String> aliases) {
        ArrayList<ModuleDependency> dependencies = new ArrayList<ModuleDependency>(aliases.size());
        for (String i : aliases) {
            dependencies.add(ModuleDependency.Builder.of(null, i).build());
        }
        ModuleLoadService service = new ModuleLoadService(dependencies);
        return ModuleLoadService.install(target, identifier.toString(), service);
    }

    public InjectedValue<ServiceModuleLoader> getServiceModuleLoader() {
        return this.serviceModuleLoader;
    }

    public InjectedValue<ModuleDefinition> getModuleDefinitionInjectedValue() {
        return this.moduleDefinitionInjectedValue;
    }

    public List<ModuleDependency> getSystemDependencies() {
        return new ArrayList<ModuleDependency>(this.systemDependencies);
    }

    public List<ModuleDependency> getUserDependencies() {
        return new ArrayList<ModuleDependency>(this.userDependencies);
    }

    public List<ModuleDependency> getLocalDependencies() {
        return new ArrayList<ModuleDependency>(this.localDependencies);
    }
}

