/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.controller.resources;

import java.lang.reflect.Field;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.client.helpers.JBossModulesNameUtil;
import org.jboss.as.server.controller.resources.ModuleLoadingResourceDefinition;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.management.DependencyInfo;
import org.jboss.modules.management.ModuleInfo;
import org.jboss.modules.management.ModuleLoaderMXBean;
import org.jboss.modules.management.ResourceLoaderInfo;

public class ModuleInfoHandler
implements OperationStepHandler {
    static final AttributeDefinition MODULE_NAME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"name", (ModelType)ModelType.STRING).setRequired(true)).build();
    static final AttributeDefinition MODULE_SLOT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"slot", (ModelType)ModelType.STRING).setDefaultValue(new ModelNode("main"))).setRequired(false)).build();
    static final AttributeDefinition MAIN_CLASS = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"main-class", (ModelType)ModelType.STRING, (boolean)true).setStorageRuntime()).build();
    static final AttributeDefinition FALLBACK_LOADER = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"fallback-loader", (ModelType)ModelType.STRING, (boolean)true).setStorageRuntime()).build();
    static final ObjectTypeAttributeDefinition DEPENDENCY = ((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)"dependency", (AttributeDefinition[])new AttributeDefinition[]{SimpleAttributeDefinitionBuilder.create((String)"dependency-name", (ModelType)ModelType.STRING).build(), SimpleAttributeDefinitionBuilder.create((String)"module-name", (ModelType)ModelType.STRING).build(), SimpleAttributeDefinitionBuilder.create((String)"export-filter", (ModelType)ModelType.STRING).build(), SimpleAttributeDefinitionBuilder.create((String)"import-filter", (ModelType)ModelType.STRING).build(), SimpleAttributeDefinitionBuilder.create((String)"optional", (ModelType)ModelType.BOOLEAN).build(), SimpleAttributeDefinitionBuilder.create((String)"local-loader-class", (ModelType)ModelType.STRING, (boolean)true).build(), new StringListAttributeDefinition.Builder("local-loader-paths").build()}).setStorageRuntime()).build();
    static final AttributeDefinition DEPENDENCIES = ((ObjectListAttributeDefinition.Builder)ObjectListAttributeDefinition.Builder.of((String)"dependencies", (ObjectTypeAttributeDefinition)DEPENDENCY).setStorageRuntime()).build();
    static final ObjectTypeAttributeDefinition RESOURCE_LOADER = ((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)"resource-loader", (AttributeDefinition[])new AttributeDefinition[]{SimpleAttributeDefinitionBuilder.create((String)"type", (ModelType)ModelType.STRING).build(), new StringListAttributeDefinition.Builder("paths").build()}).setStorageRuntime()).build();
    static final AttributeDefinition RESOURCE_LOADERS = ((ObjectListAttributeDefinition.Builder)ObjectListAttributeDefinition.Builder.of((String)"resource-loaders", (ObjectTypeAttributeDefinition)RESOURCE_LOADER).setStorageRuntime()).build();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("module-info", ModuleLoadingResourceDefinition.INSTANCE.getResourceDescriptionResolver()).setParameters(new AttributeDefinition[]{MODULE_NAME, MODULE_SLOT}).setRuntimeOnly().setReadOnly().setReplyType(ModelType.OBJECT).setReplyParameters(new AttributeDefinition[]{MODULE_NAME, MAIN_CLASS, FALLBACK_LOADER, DEPENDENCIES, RESOURCE_LOADERS}).build();
    public static ModuleInfoHandler INSTANCE = new ModuleInfoHandler();

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attr : DEFINITION.getParameters()) {
            attr.validateAndSet(operation, model);
        }
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode model = new ModelNode();
        this.populateModel(operation, model);
        String moduleName = MODULE_NAME.resolveModelAttribute(context, model).asString();
        String slot = MODULE_SLOT.resolveModelAttribute(context, model).asString();
        String id = JBossModulesNameUtil.canonicalModuleIdentifier((String)moduleName, (String)slot);
        ModuleLoader loader = Module.getBootModuleLoader();
        try {
            ModuleLoaderMXBean mxBean = this.getMxBean(loader);
            ModuleInfo moduleInfo = mxBean.getModuleDescription(id);
            context.getResult().set(this.populateModuleInfo(moduleInfo));
        }
        catch (Exception e) {
            throw ServerLogger.ROOT_LOGGER.couldNotGetModuleInfo(id, e);
        }
    }

    protected ModuleLoaderMXBean getMxBean(ModuleLoader loader) throws ReflectiveOperationException {
        Field mxBeanField = ModuleLoader.class.getDeclaredField("mxBean");
        mxBeanField.setAccessible(true);
        return (ModuleLoaderMXBean)mxBeanField.get(loader);
    }

    private ModelNode populateModuleInfo(ModuleInfo module) throws Exception {
        ModelNode result = new ModelNode();
        result.get("name").set(module.getName());
        ModelNode value = result.get("main-class");
        if (module.getMainClass() != null) {
            value.set(module.getMainClass());
        }
        value = result.get("fallback-loader");
        if (module.getFallbackLoader() != null) {
            value.set(module.getFallbackLoader());
        }
        ModelNode dependencies = result.get("dependencies").setEmptyList();
        for (DependencyInfo dependencySpec : module.getDependencies()) {
            if (dependencySpec.getModuleName() == null) continue;
            ModelNode dependency = dependencies.add();
            dependency.get("dependency-name").set(dependencySpec.getDependencyType());
            dependency.get("module-name").set(dependencySpec.getModuleName());
            dependency.get("export-filter").set(dependencySpec.getExportFilter());
            dependency.get("import-filter").set(dependencySpec.getImportFilter());
            dependency.get("optional").set(dependencySpec.isOptional());
            value = result.get("local-loader-class");
            if (dependencySpec.getLocalLoader() != null) {
                value.set(dependencySpec.getLocalLoader());
            }
            if (dependencySpec.getLocalLoaderPaths() == null) continue;
            ModelNode paths = dependency.get("local-loader-paths");
            for (String path : dependencySpec.getLocalLoaderPaths()) {
                paths.add(path);
            }
        }
        ModelNode resourceLoaders = result.get("resource-loaders").setEmptyList();
        for (ResourceLoaderInfo loaderInfo : module.getResourceLoaders()) {
            ModelNode loader = resourceLoaders.add();
            loader.get("type").set(loaderInfo.getType());
            ModelNode paths = loader.get("paths");
            for (String path : loaderInfo.getPaths()) {
                paths.add(path);
            }
        }
        return result;
    }
}

