/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.mgmt;

import io.undertow.server.ListenerRegistry;
import io.undertow.server.handlers.ChannelUpgradeHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Executor;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.domain.http.server.ConsoleMode;
import org.jboss.as.domain.http.server.ManagementHttpRequestProcessor;
import org.jboss.as.domain.http.server.ManagementHttpServer;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.network.ManagedBinding;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.mgmt.domain.ExtensibleHttpManagement;
import org.jboss.as.server.mgmt.domain.HttpManagement;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.common.Assert;
import org.xnio.XnioWorker;

public class UndertowHttpManagementService
implements Service<HttpManagement> {
    public static final RuntimeCapability<Void> EXTENSIBLE_HTTP_MANAGEMENT_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.management.http.extensible", ExtensibleHttpManagement.class).build();
    public static final ServiceName SERVICE_NAME = EXTENSIBLE_HTTP_MANAGEMENT_CAPABILITY.getCapabilityServiceName();
    public static final String SERVER_NAME = "wildfly-managment";
    public static final String HTTP_MANAGEMENT = "http-management";
    public static final String HTTPS_MANAGEMENT = "https-management";
    public static final ServiceName HTTP_UPGRADE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"http-upgrade-registry", "http-management"});
    public static final ServiceName HTTPS_UPGRADE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"http-upgrade-registry", "https-management"});
    public static final String JBOSS_REMOTING = "jboss-remoting";
    public static final String MANAGEMENT_ENDPOINT = "management-endpoint";
    private final InjectedValue<ListenerRegistry> listenerRegistry = new InjectedValue();
    private final InjectedValue<ModelController> modelControllerValue = new InjectedValue();
    private final InjectedValue<SocketBinding> injectedSocketBindingValue = new InjectedValue();
    private final InjectedValue<SocketBinding> injectedSecureSocketBindingValue = new InjectedValue();
    private final InjectedValue<NetworkInterfaceBinding> interfaceBindingValue = new InjectedValue();
    private final InjectedValue<NetworkInterfaceBinding> secureInterfaceBindingValue = new InjectedValue();
    private final InjectedValue<SocketBindingManager> injectedSocketBindingManager = new InjectedValue();
    private final InjectedValue<Integer> portValue = new InjectedValue();
    private final InjectedValue<Integer> securePortValue = new InjectedValue();
    private final InjectedValue<SecurityRealm> securityRealmServiceValue = new InjectedValue();
    private final InjectedValue<ControlledProcessStateService> controlledProcessStateServiceValue = new InjectedValue();
    private final InjectedValue<ManagementHttpRequestProcessor> requestProcessorValue = new InjectedValue();
    private final InjectedValue<Collection<String>> allowedOriginsValue = new InjectedValue();
    private final InjectedValue<XnioWorker> worker = new InjectedValue();
    private final InjectedValue<Executor> managementExecutor = new InjectedValue();
    private final ConsoleMode consoleMode;
    private final String consoleSlot;
    private ManagementHttpServer serverManagement;
    private SocketBindingManager socketBindingManager;
    private boolean useUnmanagedBindings = false;
    private ManagedBinding basicManagedBinding;
    private ManagedBinding secureManagedBinding;
    private ExtensibleHttpManagement httpManagement = new ExtensibleHttpManagement(){

        @Override
        public void addStaticContext(String contextName, ResourceManager resourceManager) {
            Assert.assertNotNull((Object)UndertowHttpManagementService.this.serverManagement);
            UndertowHttpManagementService.this.serverManagement.addStaticContext(contextName, resourceManager);
        }

        @Override
        public void addManagementGetRemapContext(String contextName, final ExtensibleHttpManagement.PathRemapper remapper) {
            Assert.assertNotNull((Object)UndertowHttpManagementService.this.serverManagement);
            UndertowHttpManagementService.this.serverManagement.addManagementGetRemapContext(contextName, new ManagementHttpServer.PathRemapper(){

                public String remapPath(String originalPath) {
                    return remapper.remapPath(originalPath);
                }
            });
        }

        @Override
        public void removeContext(String contextName) {
            Assert.assertNotNull((Object)UndertowHttpManagementService.this.serverManagement);
            UndertowHttpManagementService.this.serverManagement.removeContext(contextName);
        }

        public InetSocketAddress getHttpSocketAddress() {
            return UndertowHttpManagementService.this.basicManagedBinding == null ? null : UndertowHttpManagementService.this.basicManagedBinding.getBindAddress();
        }

        public InetSocketAddress getHttpsSocketAddress() {
            return UndertowHttpManagementService.this.secureManagedBinding == null ? null : UndertowHttpManagementService.this.secureManagedBinding.getBindAddress();
        }

        @Override
        public int getHttpPort() {
            if (UndertowHttpManagementService.this.basicManagedBinding != null) {
                return UndertowHttpManagementService.this.basicManagedBinding.getBindAddress().getPort();
            }
            Integer port = (Integer)UndertowHttpManagementService.this.portValue.getOptionalValue();
            if (port != null) {
                return port;
            }
            return -1;
        }

        @Override
        public NetworkInterfaceBinding getHttpNetworkInterfaceBinding() {
            SocketBinding socketBinding;
            NetworkInterfaceBinding binding = (NetworkInterfaceBinding)UndertowHttpManagementService.this.interfaceBindingValue.getOptionalValue();
            if (binding == null && (socketBinding = (SocketBinding)UndertowHttpManagementService.this.injectedSocketBindingValue.getOptionalValue()) != null) {
                binding = socketBinding.getNetworkInterfaceBinding();
            }
            return binding;
        }

        @Override
        public int getHttpsPort() {
            if (UndertowHttpManagementService.this.secureManagedBinding != null) {
                return UndertowHttpManagementService.this.secureManagedBinding.getBindAddress().getPort();
            }
            Integer securePort = (Integer)UndertowHttpManagementService.this.securePortValue.getOptionalValue();
            if (securePort != null) {
                // empty if block
            }
            return -1;
        }

        @Override
        public NetworkInterfaceBinding getHttpsNetworkInterfaceBinding() {
            SocketBinding socketBinding;
            NetworkInterfaceBinding binding = (NetworkInterfaceBinding)UndertowHttpManagementService.this.interfaceBindingValue.getOptionalValue();
            if (binding == null && (socketBinding = (SocketBinding)UndertowHttpManagementService.this.injectedSecureSocketBindingValue.getOptionalValue()) != null) {
                binding = socketBinding.getNetworkInterfaceBinding();
            }
            return binding;
        }

        @Override
        public boolean hasConsole() {
            return UndertowHttpManagementService.this.consoleMode.hasConsole();
        }
    };

    public UndertowHttpManagementService(ConsoleMode consoleMode, String consoleSlot) {
        this.consoleMode = consoleMode;
        this.consoleSlot = consoleSlot;
    }

    public synchronized void start(StartContext context) throws StartException {
        ModelController modelController = (ModelController)this.modelControllerValue.getValue();
        ControlledProcessStateService controlledProcessStateService = (ControlledProcessStateService)this.controlledProcessStateServiceValue.getValue();
        this.socketBindingManager = (SocketBindingManager)this.injectedSocketBindingManager.getOptionalValue();
        SecurityRealm securityRealmService = (SecurityRealm)this.securityRealmServiceValue.getOptionalValue();
        InetSocketAddress bindAddress = null;
        InetSocketAddress secureBindAddress = null;
        SocketBinding basicBinding = (SocketBinding)this.injectedSocketBindingValue.getOptionalValue();
        SocketBinding secureBinding = (SocketBinding)this.injectedSecureSocketBindingValue.getOptionalValue();
        NetworkInterfaceBinding interfaceBinding = (NetworkInterfaceBinding)this.interfaceBindingValue.getOptionalValue();
        NetworkInterfaceBinding secureInterfaceBinding = (NetworkInterfaceBinding)this.secureInterfaceBindingValue.getOptionalValue();
        if (interfaceBinding != null) {
            int securePort;
            this.useUnmanagedBindings = true;
            int port = (Integer)this.portValue.getOptionalValue();
            if (port > 0) {
                bindAddress = new InetSocketAddress(interfaceBinding.getAddress(), port);
            }
            if ((securePort = ((Integer)this.securePortValue.getOptionalValue()).intValue()) > 0) {
                Iterator secureAddress = secureInterfaceBinding == null ? interfaceBinding.getAddress() : secureInterfaceBinding.getAddress();
                secureBindAddress = new InetSocketAddress((InetAddress)((Object)secureAddress), securePort);
            }
        } else {
            if (basicBinding != null) {
                bindAddress = basicBinding.getSocketAddress();
            }
            if (secureBinding != null) {
                secureBindAddress = secureBinding.getSocketAddress();
            }
        }
        ArrayList<ListenerRegistry.Listener> listeners = new ArrayList<ListenerRegistry.Listener>();
        if (bindAddress != null) {
            ListenerRegistry.Listener http = new ListenerRegistry.Listener("http", HTTP_MANAGEMENT, SERVER_NAME, bindAddress);
            http.setContextInformation("socket-binding", (Object)basicBinding);
            listeners.add(http);
        }
        if (secureBindAddress != null) {
            ListenerRegistry.Listener https = new ListenerRegistry.Listener("https", HTTPS_MANAGEMENT, SERVER_NAME, bindAddress);
            https.setContextInformation("socket-binding", (Object)secureBinding);
            listeners.add(https);
        }
        ChannelUpgradeHandler upgradeHandler = new ChannelUpgradeHandler();
        context.getChildTarget().addService(HTTP_UPGRADE_SERVICE_NAME, (Service)new ValueService((Value)new ImmediateValue((Object)upgradeHandler))).addAliases(new ServiceName[]{HTTPS_UPGRADE_SERVICE_NAME}).install();
        for (ListenerRegistry.Listener listener : listeners) {
            listener.addHttpUpgradeMetadata(new ListenerRegistry.HttpUpgradeMetadata(JBOSS_REMOTING, MANAGEMENT_ENDPOINT));
        }
        if (this.listenerRegistry.getOptionalValue() != null) {
            for (ListenerRegistry.Listener listener : listeners) {
                ((ListenerRegistry)this.listenerRegistry.getOptionalValue()).addListener(listener);
            }
        }
        ManagementHttpRequestProcessor requestProcessor = (ManagementHttpRequestProcessor)this.requestProcessorValue.getValue();
        try {
            this.serverManagement = ManagementHttpServer.create((InetSocketAddress)bindAddress, (InetSocketAddress)secureBindAddress, (int)50, (ModelController)modelController, (SecurityRealm)securityRealmService, (ControlledProcessStateService)controlledProcessStateService, (ConsoleMode)this.consoleMode, (String)this.consoleSlot, (ChannelUpgradeHandler)upgradeHandler, (ManagementHttpRequestProcessor)requestProcessor, (Collection)((Collection)this.allowedOriginsValue.getOptionalValue()), (XnioWorker)((XnioWorker)this.worker.getValue()), (Executor)((Executor)this.managementExecutor.getValue()));
            this.serverManagement.start();
            if (this.socketBindingManager != null) {
                SocketBindingManager.UnnamedBindingRegistry registry;
                if (this.useUnmanagedBindings) {
                    registry = this.socketBindingManager.getUnnamedRegistry();
                    if (bindAddress != null) {
                        this.basicManagedBinding = ManagedBinding.Factory.createSimpleManagedBinding((String)"management-http", (InetSocketAddress)bindAddress, null);
                        registry.registerBinding(this.basicManagedBinding);
                    }
                    if (secureBindAddress != null) {
                        this.secureManagedBinding = ManagedBinding.Factory.createSimpleManagedBinding((String)"management-https", (InetSocketAddress)secureBindAddress, null);
                        registry.registerBinding(this.secureManagedBinding);
                    }
                } else {
                    registry = this.socketBindingManager.getNamedRegistry();
                    if (basicBinding != null) {
                        this.basicManagedBinding = ManagedBinding.Factory.createSimpleManagedBinding((SocketBinding)basicBinding);
                        registry.registerBinding(this.basicManagedBinding);
                    }
                    if (secureBinding != null) {
                        this.secureManagedBinding = ManagedBinding.Factory.createSimpleManagedBinding((SocketBinding)secureBinding);
                        registry.registerBinding(this.secureManagedBinding);
                    }
                }
            }
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (e instanceof BindException || cause instanceof BindException) {
                StringBuilder sb = new StringBuilder().append(e.getLocalizedMessage());
                if (bindAddress != null) {
                    sb.append(" ").append(bindAddress);
                }
                if (secureBindAddress != null) {
                    sb.append(" ").append(secureBindAddress);
                }
                throw new StartException(sb.toString());
            }
            throw ServerLogger.ROOT_LOGGER.failedToStartHttpManagementService(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(StopContext context) {
        block9: {
            ListenerRegistry lr = (ListenerRegistry)this.listenerRegistry.getOptionalValue();
            if (lr != null) {
                lr.removeListener(HTTP_MANAGEMENT);
                lr.removeListener(HTTPS_MANAGEMENT);
            }
            if (this.serverManagement != null) {
                SocketBindingManager.UnnamedBindingRegistry registry;
                try {
                    this.serverManagement.stop();
                    this.serverManagement = null;
                    if (this.socketBindingManager == null) break block9;
                    Object object = registry = this.useUnmanagedBindings ? this.socketBindingManager.getUnnamedRegistry() : this.socketBindingManager.getNamedRegistry();
                }
                catch (Throwable throwable) {
                    this.serverManagement = null;
                    if (this.socketBindingManager != null) {
                        SocketBindingManager.UnnamedBindingRegistry registry2;
                        Object object = registry2 = this.useUnmanagedBindings ? this.socketBindingManager.getUnnamedRegistry() : this.socketBindingManager.getNamedRegistry();
                        if (this.basicManagedBinding != null) {
                            registry2.unregisterBinding(this.basicManagedBinding);
                            this.basicManagedBinding = null;
                        }
                        if (this.secureManagedBinding != null) {
                            registry2.unregisterBinding(this.secureManagedBinding);
                            this.secureManagedBinding = null;
                        }
                        this.socketBindingManager = null;
                        this.useUnmanagedBindings = false;
                    }
                    throw throwable;
                }
                if (this.basicManagedBinding != null) {
                    registry.unregisterBinding(this.basicManagedBinding);
                    this.basicManagedBinding = null;
                }
                if (this.secureManagedBinding != null) {
                    registry.unregisterBinding(this.secureManagedBinding);
                    this.secureManagedBinding = null;
                }
                this.socketBindingManager = null;
                this.useUnmanagedBindings = false;
            }
        }
    }

    public HttpManagement getValue() throws IllegalStateException {
        return this.httpManagement;
    }

    public Injector<NetworkInterfaceBinding> getInterfaceInjector() {
        return this.interfaceBindingValue;
    }

    public Injector<NetworkInterfaceBinding> getSecureInterfaceInjector() {
        return this.secureInterfaceBindingValue;
    }

    public Injector<SocketBindingManager> getSocketBindingManagerInjector() {
        return this.injectedSocketBindingManager;
    }

    public Injector<SocketBinding> getSocketBindingInjector() {
        return this.injectedSocketBindingValue;
    }

    public Injector<SocketBinding> getSecureSocketBindingInjector() {
        return this.injectedSecureSocketBindingValue;
    }

    public Injector<Integer> getPortInjector() {
        return this.portValue;
    }

    public Injector<Integer> getSecurePortInjector() {
        return this.securePortValue;
    }

    public Injector<ModelController> getModelControllerInjector() {
        return this.modelControllerValue;
    }

    public InjectedValue<SecurityRealm> getSecurityRealmInjector() {
        return this.securityRealmServiceValue;
    }

    public InjectedValue<ControlledProcessStateService> getControlledProcessStateServiceInjector() {
        return this.controlledProcessStateServiceValue;
    }

    public InjectedValue<ListenerRegistry> getListenerRegistry() {
        return this.listenerRegistry;
    }

    public InjectedValue<ManagementHttpRequestProcessor> getRequestProcessorValue() {
        return this.requestProcessorValue;
    }

    public InjectedValue<Collection<String>> getAllowedOriginsInjector() {
        return this.allowedOriginsValue;
    }

    public InjectedValue<XnioWorker> getWorker() {
        return this.worker;
    }

    public InjectedValue<Executor> getManagementExecutor() {
        return this.managementExecutor;
    }
}

