/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.operations.common.ProcessReloadHandler;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.controller.descriptions.ServerDescriptions;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;

public class ServerProcessReloadHandler
extends ProcessReloadHandler<RunningModeControl> {
    private static final AttributeDefinition USE_CURRENT_SERVER_CONFIG = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("use-current-server-config", ModelType.BOOLEAN, true).setAlternatives(new String[]{"server-config"})).setDefaultValue(new ModelNode(true))).build();
    private static final AttributeDefinition SERVER_CONFIG = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("server-config", ModelType.STRING, true).setAlternatives(new String[]{"use-current-server-config"})).build();
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{ADMIN_ONLY, USE_CURRENT_SERVER_CONFIG, SERVER_CONFIG};
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("reload", ServerDescriptions.getResourceDescriptionResolver("server")).setParameters(ATTRIBUTES).setRuntimeOnly().build();
    private final ServerEnvironment environment;

    public ServerProcessReloadHandler(ServiceName rootService, RunningModeControl runningModeControl, ControlledProcessState processState, ServerEnvironment environment) {
        super(rootService, runningModeControl, processState);
        this.environment = environment;
    }

    protected ProcessReloadHandler.ReloadContext<RunningModeControl> initializeReloadContext(OperationContext context, ModelNode operation) throws OperationFailedException {
        String serverConfig;
        boolean unmanaged = context.getProcessType() != ProcessType.DOMAIN_SERVER;
        final boolean adminOnly = unmanaged && ADMIN_ONLY.resolveModelAttribute(context, operation).asBoolean(false);
        final boolean useCurrentConfig = unmanaged && USE_CURRENT_SERVER_CONFIG.resolveModelAttribute(context, operation).asBoolean(true);
        String string = serverConfig = unmanaged && operation.hasDefined(SERVER_CONFIG.getName()) ? SERVER_CONFIG.resolveModelAttribute(context, operation).asString() : null;
        if (operation.hasDefined(USE_CURRENT_SERVER_CONFIG.getName()) && serverConfig != null) {
            throw ServerLogger.ROOT_LOGGER.cannotBothHaveFalseUseCurrentConfigAndServerConfig();
        }
        if (serverConfig != null && !this.environment.getServerConfigurationFile().checkCanFindNewBootFile(serverConfig)) {
            throw ServerLogger.ROOT_LOGGER.serverConfigForReloadNotFound(serverConfig);
        }
        return new ProcessReloadHandler.ReloadContext<RunningModeControl>(){

            public void reloadInitiated(RunningModeControl runningModeControl) {
            }

            public void doReload(RunningModeControl runningModeControl) {
                runningModeControl.setRunningMode(adminOnly ? RunningMode.ADMIN_ONLY : RunningMode.NORMAL);
                runningModeControl.setReloaded();
                runningModeControl.setUseCurrentConfig(useCurrentConfig);
                runningModeControl.setNewBootFileName(serverConfig);
            }
        };
    }
}

