/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.mgmt.domain;

import java.io.Closeable;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutorService;
import org.jboss.as.controller.AbstractControllerService;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.protocol.mgmt.AbstractManagementRequest;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.repository.RemoteFileRequestAndHandler;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.mgmt.domain.HostControllerConnection;
import org.jboss.as.server.mgmt.domain.RemoteFileRepositoryExecutor;
import org.jboss.as.server.mgmt.domain.ServerToHostRemoteFileRequestAndHandler;
import org.jboss.dmr.ModelNode;

public class HostControllerClient
implements AbstractControllerService.ControllerInstabilityListener,
Closeable {
    private final String serverName;
    private final HostControllerConnection connection;
    private final ManagementChannelHandler channelHandler;
    private final RemoteFileRepositoryExecutorImpl repositoryExecutor;
    private volatile ModelController controller;
    private final boolean managementSubsystemEndpoint;
    private final ExecutorService executorService;
    private final Runnable unstableNotificationRunnable;

    HostControllerClient(String serverName, final ManagementChannelHandler channelHandler, HostControllerConnection connection, boolean managementSubsystemEndpoint, ExecutorService executorService) {
        this.serverName = serverName;
        this.connection = connection;
        this.channelHandler = channelHandler;
        this.repositoryExecutor = new RemoteFileRepositoryExecutorImpl();
        this.managementSubsystemEndpoint = managementSubsystemEndpoint;
        this.executorService = executorService;
        final ControllerInstabilityNotificationRequest request = new ControllerInstabilityNotificationRequest();
        this.unstableNotificationRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    channelHandler.executeRequest((ManagementRequest)request, null);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
    }

    public String getServerName() {
        return this.serverName;
    }

    void resolveBootUpdates(ModelController controller, ActiveOperation.CompletedCallback<ModelNode> callback) throws Exception {
        this.connection.openConnection(controller, callback);
        this.controller = controller;
    }

    public void reconnect(URI uri, String authKey, boolean mgmtSubsystemEndpoint) throws IOException, URISyntaxException {
        final boolean mgmtEndpointChanged = this.managementSubsystemEndpoint != mgmtSubsystemEndpoint;
        this.connection.asyncReconnect(uri, authKey, new HostControllerConnection.ReconnectCallback(){

            @Override
            public void reconnected(boolean inSync) {
                if (!inSync || mgmtEndpointChanged) {
                    ModelNode operation = new ModelNode();
                    operation.get("operation").set("server-set-reload-required");
                    operation.get("address").setEmptyList();
                    HostControllerClient.this.controller.execute(operation, OperationMessageHandler.DISCARD, ModelController.OperationTransactionControl.COMMIT, OperationAttachments.EMPTY);
                }
            }
        });
    }

    RemoteFileRepositoryExecutor getRemoteFileRepository() {
        return this.repositoryExecutor;
    }

    @Override
    public void close() throws IOException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public void controllerUnstable() {
        try {
            this.executorService.submit(this.unstableNotificationRunnable);
        }
        catch (Throwable t) {
            this.unstableNotificationRunnable.run();
        }
    }

    private static class ControllerInstabilityNotificationRequest
    extends AbstractManagementRequest<Void, Void> {
        private ControllerInstabilityNotificationRequest() {
        }

        public byte getOperationType() {
            return 4;
        }

        protected void sendRequest(ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<Void> context, FlushableDataOutput output) throws IOException {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<Void> context) throws IOException {
            resultHandler.done(null);
        }
    }

    private class RemoteFileRepositoryExecutorImpl
    implements RemoteFileRepositoryExecutor {
        private RemoteFileRepositoryExecutorImpl() {
        }

        @Override
        public File getFile(String relativePath, byte repoId, File localDeploymentFolder) {
            try {
                return (File)HostControllerClient.this.channelHandler.executeRequest((ManagementRequest)new GetFileRequest(relativePath, localDeploymentFolder), null).getResult().get();
            }
            catch (Exception e) {
                throw ServerLogger.ROOT_LOGGER.failedToGetFileFromRemoteRepository(e);
            }
        }
    }

    private static class GetFileRequest
    extends AbstractManagementRequest<File, Void> {
        private final String hash;
        private final File localDeploymentFolder;

        private GetFileRequest(String hash, File localDeploymentFolder) {
            this.hash = hash;
            this.localDeploymentFolder = localDeploymentFolder;
        }

        public byte getOperationType() {
            return 36;
        }

        protected void sendRequest(ActiveOperation.ResultHandler<File> resultHandler, ManagementRequestContext<Void> context, FlushableDataOutput output) throws IOException {
            ServerToHostRemoteFileRequestAndHandler.INSTANCE.sendRequest(output, (byte)0, this.hash);
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<File> resultHandler, ManagementRequestContext<Void> context) throws IOException {
            try {
                File first = new File(this.localDeploymentFolder, this.hash.substring(0, 2));
                File localPath = new File(first, this.hash.substring(2));
                ServerToHostRemoteFileRequestAndHandler.INSTANCE.handleResponse(input, localPath, ServerLogger.ROOT_LOGGER, resultHandler, context);
                resultHandler.done(null);
            }
            catch (RemoteFileRequestAndHandler.CannotCreateLocalDirectoryException e) {
                resultHandler.failed((Throwable)ServerLogger.ROOT_LOGGER.cannotCreateLocalDirectory(e.getDir()));
            }
            catch (RemoteFileRequestAndHandler.DidNotReadEntireFileException e) {
                resultHandler.failed((Throwable)ServerLogger.ROOT_LOGGER.didNotReadEntireFile(e.getMissing()));
            }
        }
    }
}

