/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.ExplodedContent;
import org.jboss.as.repository.ExplodedContentException;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.Services;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.deployment.DeploymentHandlerUtil;
import org.jboss.as.server.deployment.DeploymentHandlerUtils;
import org.jboss.as.server.deployment.ModelContentReference;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.dmr.ModelNode;

public class ExplodedDeploymentAddContentHandler
implements OperationStepHandler {
    private final ContentRepository contentRepository;
    private final ServerEnvironment serverEnvironment;

    public ExplodedDeploymentAddContentHandler(ContentRepository contentRepository, ServerEnvironment serverEnvironment) {
        assert (contentRepository != null) : "Null contentRepository";
        this.contentRepository = contentRepository;
        this.serverEnvironment = serverEnvironment;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        byte[] newHash;
        if (context.getProcessType() == ProcessType.SELF_CONTAINED) {
            throw ServerLogger.ROOT_LOGGER.cannotAddContentToSelfContainedServer();
        }
        Resource deploymentResource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        ModelNode contentItemNode = DeploymentHandlerUtil.getContentItem(deploymentResource);
        if (!DeploymentHandlerUtil.isManaged(contentItemNode)) {
            throw ServerLogger.ROOT_LOGGER.cannotAddContentToUnmanagedDeployment();
        }
        if (DeploymentHandlerUtil.isArchive(contentItemNode)) {
            throw ServerLogger.ROOT_LOGGER.cannotAddContentToUnexplodedDeployment();
        }
        final String managementName = context.getCurrentAddress().getLastElement().getValue();
        final PathAddress address = PathAddress.pathAddress((String)"deployment", (String)managementName);
        final byte[] oldHash = DeploymentAttributes.CONTENT_HASH.resolveModelAttribute(context, contentItemNode).asBytes();
        boolean overwrite = DeploymentAttributes.OVERWRITE.resolveModelAttribute(context, contentItemNode).asBoolean(true);
        List contents = DeploymentAttributes.EXPLODED_CONTENT.resolveModelAttribute(context, operation).asList();
        ArrayList<ExplodedContent> addedFiles = new ArrayList<ExplodedContent>(contents.size());
        if (contents.size() == 1 && ((ModelNode)contents.get(0)).hasDefined("hash")) {
            newHash = DeploymentHandlerUtil.addFromHash(this.contentRepository, (ModelNode)contents.get(0), managementName, address, context);
            if (operation.hasDefined(DeploymentAttributes.UPDATED_PATHS.getName())) {
                for (ModelNode addedFile : DeploymentAttributes.UPDATED_PATHS.resolveModelAttribute(context, operation).asList()) {
                    addedFiles.add(new ExplodedContent(addedFile.asString()));
                }
            }
        } else {
            for (ModelNode content : contents) {
                InputStream in = DeploymentHandlerUtils.hasValidContentAdditionParameterDefined(content) ? DeploymentHandlerUtils.getInputStream(context, content) : null;
                String path = DeploymentAttributes.TARGET_PATH.resolveModelAttribute(context, content).asString();
                addedFiles.add(new ExplodedContent(path, in));
            }
            try {
                newHash = this.contentRepository.addContentToExploded(oldHash, addedFiles, overwrite);
            }
            catch (ExplodedContentException e) {
                throw DeploymentHandlerUtils.createFailureException(e.toString());
            }
        }
        final List relativePaths = addedFiles.stream().map(ExplodedContent::getRelativePath).collect(Collectors.toList());
        contentItemNode.get(DeploymentAttributes.CONTENT_HASH.getName()).set(newHash);
        contentItemNode.get(DeploymentAttributes.CONTENT_ARCHIVE.getName()).set(false);
        if (!addedFiles.isEmpty() && DeploymentAttributes.ENABLED.resolveModelAttribute(context, deploymentResource.getModel()).asBoolean()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    block5: {
                        try {
                            ExecutorService executor = (ExecutorService)context.getServiceRegistry(false).getRequiredService(Services.JBOSS_SERVER_EXECUTOR).getValue();
                            CountDownLatch latch = ExplodedDeploymentAddContentHandler.this.copy(executor, relativePaths, managementName, newHash);
                            if (latch == null) break block5;
                            try {
                                if (!latch.await(60L, TimeUnit.SECONDS)) {
                                    return;
                                }
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                throw DeploymentHandlerUtils.createFailureException(e.toString());
                            }
                        }
                        catch (IOException e) {
                            throw DeploymentHandlerUtils.createFailureException(e.toString());
                        }
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep(new OperationContext.ResultHandler(){

            public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                if (resultAction == OperationContext.ResultAction.KEEP) {
                    if (!(oldHash == null || newHash != null && Arrays.equals(oldHash, newHash))) {
                        ExplodedDeploymentAddContentHandler.this.contentRepository.removeContent(ModelContentReference.fromModelAddress(address, oldHash));
                    }
                    if (newHash != null) {
                        ExplodedDeploymentAddContentHandler.this.contentRepository.addContentReference(ModelContentReference.fromModelAddress(address, newHash));
                    }
                } else if (!(newHash == null || oldHash != null && Arrays.equals(oldHash, newHash))) {
                    ExplodedDeploymentAddContentHandler.this.contentRepository.removeContent(ModelContentReference.fromModelAddress(address, newHash));
                }
            }
        });
    }

    private CountDownLatch copy(ExecutorService executor, final List<String> relativePaths, final String managementName, final byte[] newHash) throws IOException {
        CountDownLatch result;
        final Path runtimeDeployedPath = DeploymentHandlerUtil.getExplodedDeploymentRoot(this.serverEnvironment, managementName);
        if (Files.exists(runtimeDeployedPath, new LinkOption[0])) {
            result = new CountDownLatch(1);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        ExplodedDeploymentAddContentHandler.this.contentRepository.copyExplodedContentFiles(newHash, relativePaths, runtimeDeployedPath);
                    }
                    catch (ExplodedContentException ex) {
                        ServerLogger.DEPLOYMENT_LOGGER.couldNotCopyFiles((Exception)((Object)ex), managementName);
                    }
                    finally {
                        result.countDown();
                    }
                }
            };
            executor.submit(r);
        } else {
            result = null;
        }
        return result;
    }
}

