/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.controller.resources;

import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.controller.resources.DeploymentResourceDefinition;
import org.jboss.as.server.deployment.DeploymentAddHandler;
import org.jboss.as.server.deployment.DeploymentDeployHandler;
import org.jboss.as.server.deployment.DeploymentExplodeHandler;
import org.jboss.as.server.deployment.DeploymentRedeployHandler;
import org.jboss.as.server.deployment.DeploymentRemoveHandler;
import org.jboss.as.server.deployment.DeploymentUndeployHandler;
import org.jboss.as.server.deployment.ExplodedDeploymentAddContentHandler;
import org.jboss.as.server.deployment.ExplodedDeploymentBrowseContentHandler;
import org.jboss.as.server.deployment.ExplodedDeploymentReadContentHandler;
import org.jboss.as.server.deployment.ExplodedDeploymentRemoveContentHandler;
import org.jboss.as.server.services.security.AbstractVaultReader;

public class ServerDeploymentResourceDefinition
extends DeploymentResourceDefinition {
    private final ContentRepository contentRepository;
    private final AbstractVaultReader vaultReader;
    private final ServerEnvironment serverEnvironment;

    private ServerDeploymentResourceDefinition(ContentRepository contentRepository, AbstractVaultReader vaultReader, ServerEnvironment serverEnvironment, OperationStepHandler addHandler, OperationStepHandler removeHandler) {
        super(DeploymentResourceDefinition.DeploymentResourceParent.SERVER, addHandler, removeHandler);
        this.vaultReader = vaultReader;
        this.contentRepository = contentRepository;
        this.serverEnvironment = serverEnvironment;
    }

    public static ServerDeploymentResourceDefinition create(ContentRepository contentRepository, AbstractVaultReader vaultReader, ServerEnvironment serverEnvironment) {
        return new ServerDeploymentResourceDefinition(contentRepository, vaultReader, serverEnvironment, DeploymentAddHandler.create(contentRepository, vaultReader), new DeploymentRemoveHandler(contentRepository, vaultReader));
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler(DeploymentAttributes.DEPLOY_DEFINITION, (OperationStepHandler)new DeploymentDeployHandler(this.vaultReader));
        resourceRegistration.registerOperationHandler(DeploymentAttributes.UNDEPLOY_DEFINITION, (OperationStepHandler)new DeploymentUndeployHandler(this.vaultReader));
        resourceRegistration.registerOperationHandler(DeploymentAttributes.REDEPLOY_DEFINITION, (OperationStepHandler)new DeploymentRedeployHandler(this.vaultReader));
        resourceRegistration.registerOperationHandler(DeploymentAttributes.EXPLODE_DEFINITION, (OperationStepHandler)new DeploymentExplodeHandler(this.contentRepository));
        resourceRegistration.registerOperationHandler(DeploymentAttributes.DEPLOYMENT_ADD_CONTENT_DEFINITION, (OperationStepHandler)new ExplodedDeploymentAddContentHandler(this.contentRepository, this.serverEnvironment));
        resourceRegistration.registerOperationHandler(DeploymentAttributes.DEPLOYMENT_REMOVE_CONTENT_DEFINITION, (OperationStepHandler)new ExplodedDeploymentRemoveContentHandler(this.contentRepository, this.serverEnvironment));
        resourceRegistration.registerOperationHandler(DeploymentAttributes.DEPLOYMENT_READ_CONTENT_DEFINITION, (OperationStepHandler)new ExplodedDeploymentReadContentHandler(this.contentRepository));
        resourceRegistration.registerOperationHandler(DeploymentAttributes.DEPLOYMENT_BROWSE_CONTENT_DEFINITION, (OperationStepHandler)new ExplodedDeploymentBrowseContentHandler(this.contentRepository));
    }

    @Override
    protected void registerAddOperation(ManagementResourceRegistration registration, OperationStepHandler handler, OperationEntry.Flag ... flags) {
        registration.registerOperationHandler(DeploymentAttributes.SERVER_DEPLOYMENT_ADD_DEFINITION, handler);
    }
}

