package org.jboss.as.server.logging;

import java.util.Locale;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.vfs.VirtualFile;
import org.jboss.modules.ModuleLoadException;
import java.lang.IllegalStateException;
import java.io.Serializable;
import java.net.MalformedURLException;
import org.jboss.as.server.deployment.Phase;
import java.lang.StringBuilder;
import org.jboss.as.server.services.security.VaultReaderException;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import java.net.URISyntaxException;
import org.jboss.logging.Logger;
import java.net.URL;
import java.util.jar.Attributes.Name;
import org.jboss.as.server.deployment.module.ResourceRoot;
import java.lang.RuntimeException;
import org.jboss.logging.BasicLogger;
import java.lang.ClassLoader;
import org.jboss.msc.service.StartException;
import java.io.InvalidObjectException;
import org.jboss.modules.ModuleIdentifier;
import java.lang.IllegalArgumentException;
import java.nio.file.Path;
import javax.annotation.Generated;
import org.jboss.as.server.deployment.MountType;
import java.net.UnknownHostException;
import javax.xml.namespace.QName;
import org.jboss.as.controller.OperationFailedException;
import java.io.IOException;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.as.server.suspend.ServerActivity;
import java.lang.Exception;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ExtensionListEntry;
import javax.xml.stream.XMLStreamException;
import org.jboss.msc.service.ServiceNotFoundException;
import org.jboss.as.controller.PathAddress;
import java.lang.Throwable;
import java.lang.Class;
import java.util.Arrays;
import org.jboss.modules.Module;
import org.jboss.as.server.deployment.DeploymentUnit;
import java.io.File;
import javax.xml.stream.Location;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.FATAL;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2018-05-25T12:47:45+0200")
public class ServerLogger_$logger extends DelegatingBasicLogger implements ServerLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ServerLogger_$logger.class.getName();
    public ServerLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void jbossDeploymentStructureIgnored(final String file) {
        super.log.logf(FQCN, WARN, null, jbossDeploymentStructureIgnored$str(), file);
    }
    private static final String jbossDeploymentStructureIgnored = "WFLYSRV0001: %s in subdeployment ignored. jboss-deployment-structure.xml is only parsed for top level deployments.";
    protected String jbossDeploymentStructureIgnored$str() {
        return jbossDeploymentStructureIgnored;
    }
    @Override
    public final void cannotLoadAnnotationIndex(final String index) {
        super.log.logf(FQCN, ERROR, null, cannotLoadAnnotationIndex$str(), index);
    }
    private static final String cannotLoadAnnotationIndex = "WFLYSRV0002: Could not read provided index: %s";
    protected String cannotLoadAnnotationIndex$str() {
        return cannotLoadAnnotationIndex;
    }
    @Override
    public final void cannotIndexClass(final String className, final String resourceRoot, final Throwable throwable) {
        super.log.logf(FQCN, WARN, throwable, cannotIndexClass$str(), className, resourceRoot);
    }
    private static final String cannotIndexClass = "WFLYSRV0003: Could not index class %s at %s";
    protected String cannotIndexClass$str() {
        return cannotIndexClass;
    }
    @Override
    public final void undeploymentRolledBack(final String deployment, final String message) {
        super.log.logf(FQCN, ERROR, null, undeploymentRolledBack$str(), deployment, message);
    }
    private static final String undeploymentRolledBack = "WFLYSRV0007: Undeploy of deployment \"%s\" was rolled back with the following failure message: %s";
    protected String undeploymentRolledBack$str() {
        return undeploymentRolledBack;
    }
    @Override
    public final void undeploymentRolledBackWithNoMessage(final String deployment) {
        super.log.logf(FQCN, ERROR, null, undeploymentRolledBackWithNoMessage$str(), deployment);
    }
    private static final String undeploymentRolledBackWithNoMessage = "WFLYSRV0008: Undeploy of deployment \"%s\" was rolled back with no failure message";
    protected String undeploymentRolledBackWithNoMessage$str() {
        return undeploymentRolledBackWithNoMessage;
    }
    @Override
    public final void deploymentUndeployed(final String managementName, final String deploymentUnitName) {
        super.log.logf(FQCN, INFO, null, deploymentUndeployed$str(), managementName, deploymentUnitName);
    }
    private static final String deploymentUndeployed = "WFLYSRV0009: Undeployed \"%s\" (runtime-name: \"%s\")";
    protected String deploymentUndeployed$str() {
        return deploymentUndeployed;
    }
    @Override
    public final void deploymentDeployed(final String managementName, final String deploymentUnitName) {
        super.log.logf(FQCN, INFO, null, deploymentDeployed$str(), managementName, deploymentUnitName);
    }
    private static final String deploymentDeployed = "WFLYSRV0010: Deployed \"%s\" (runtime-name : \"%s\")";
    protected String deploymentDeployed$str() {
        return deploymentDeployed;
    }
    @Override
    public final void redeployRolledBack(final String deployment, final String message) {
        super.log.logf(FQCN, ERROR, null, redeployRolledBack$str(), deployment, message);
    }
    private static final String redeployRolledBack = "WFLYSRV0011: Redeploy of deployment \"%s\" was rolled back with the following failure message: %s";
    protected String redeployRolledBack$str() {
        return redeployRolledBack;
    }
    @Override
    public final void redeployRolledBackWithNoMessage(final String deployment) {
        super.log.logf(FQCN, ERROR, null, redeployRolledBackWithNoMessage$str(), deployment);
    }
    private static final String redeployRolledBackWithNoMessage = "WFLYSRV0012: Redeploy of deployment \"%s\" was rolled back with no failure message";
    protected String redeployRolledBackWithNoMessage$str() {
        return redeployRolledBackWithNoMessage;
    }
    @Override
    public final void deploymentRedeployed(final String deploymentName) {
        super.log.logf(FQCN, INFO, null, deploymentRedeployed$str(), deploymentName);
    }
    private static final String deploymentRedeployed = "WFLYSRV0013: Redeployed \"%s\"";
    protected String deploymentRedeployed$str() {
        return deploymentRedeployed;
    }
    @Override
    public final void replaceRolledBack(final String replaced, final String deployment, final String message) {
        super.log.logf(FQCN, ERROR, null, replaceRolledBack$str(), replaced, deployment, message);
    }
    private static final String replaceRolledBack = "WFLYSRV0014: Replacement of deployment \"%s\" by deployment \"%s\" was rolled back with the following failure message: %s";
    protected String replaceRolledBack$str() {
        return replaceRolledBack;
    }
    @Override
    public final void replaceRolledBackWithNoMessage(final String replaced, final String deployment) {
        super.log.logf(FQCN, ERROR, null, replaceRolledBackWithNoMessage$str(), replaced, deployment);
    }
    private static final String replaceRolledBackWithNoMessage = "WFLYSRV0015: Replacement of deployment \"%s\" by deployment \"%s\" was rolled back with no failure message";
    protected String replaceRolledBackWithNoMessage$str() {
        return replaceRolledBackWithNoMessage;
    }
    @Override
    public final void deploymentReplaced(final String replaced, final String deployment) {
        super.log.logf(FQCN, INFO, null, deploymentReplaced$str(), replaced, deployment);
    }
    private static final String deploymentReplaced = "WFLYSRV0016: Replaced deployment \"%s\" with deployment \"%s\"";
    protected String deploymentReplaced$str() {
        return deploymentReplaced;
    }
    @Override
    public final void annotationImportIgnored(final ModuleIdentifier annotationModuleId, final ModuleIdentifier additionalModuleId) {
        super.log.logf(FQCN, WARN, null, annotationImportIgnored$str(), annotationModuleId, additionalModuleId);
    }
    private static final String annotationImportIgnored = "WFLYSRV0017: Annotations import option %s specified in jboss-deployment-structure.xml for additional module %s has been ignored. Additional modules cannot import annotations.";
    protected String annotationImportIgnored$str() {
        return annotationImportIgnored;
    }
    @Override
    public final void privateApiUsed(final String deployment, final ModuleIdentifier dependency) {
        super.log.logf(FQCN, WARN, null, privateApiUsed$str(), deployment, dependency);
    }
    private static final String privateApiUsed = "WFLYSRV0018: Deployment \"%s\" is using a private module (\"%s\") which may be changed or removed in future versions without notice.";
    protected String privateApiUsed$str() {
        return privateApiUsed;
    }
    @Override
    public final void unsupportedApiUsed(final String deployment, final ModuleIdentifier dependency) {
        super.log.logf(FQCN, WARN, null, unsupportedApiUsed$str(), deployment, dependency);
    }
    private static final String unsupportedApiUsed = "WFLYSRV0019: Deployment \"%s\" is using an unsupported module (\"%s\") which may be changed or removed in future versions without notice.";
    protected String unsupportedApiUsed$str() {
        return unsupportedApiUsed;
    }
    @Override
    public final void failedToRemoveDeploymentContent(final Throwable cause, final String hash) {
        super.log.logf(FQCN, WARN, cause, failedToRemoveDeploymentContent$str(), hash);
    }
    private static final String failedToRemoveDeploymentContent = "WFLYSRV0020: Exception occurred removing deployment content %s";
    protected String failedToRemoveDeploymentContent$str() {
        return failedToRemoveDeploymentContent;
    }
    @Override
    public final void deploymentRolledBack(final String deployment, final String message) {
        super.log.logf(FQCN, ERROR, null, deploymentRolledBack$str(), deployment, message);
    }
    private static final String deploymentRolledBack = "WFLYSRV0021: Deploy of deployment \"%s\" was rolled back with the following failure message: %s";
    protected String deploymentRolledBack$str() {
        return deploymentRolledBack;
    }
    @Override
    public final void deploymentRolledBackWithNoMessage(final String deployment) {
        super.log.logf(FQCN, ERROR, null, deploymentRolledBackWithNoMessage$str(), deployment);
    }
    private static final String deploymentRolledBackWithNoMessage = "WFLYSRV0022: Deploy of deployment \"%s\" was rolled back with no failure message";
    protected String deploymentRolledBackWithNoMessage$str() {
        return deploymentRolledBackWithNoMessage;
    }
    @Override
    public final void failedToParseCommandLineInteger(final String property, final String value) {
        super.log.logf(FQCN, WARN, null, failedToParseCommandLineInteger$str(), property, value);
    }
    private static final String failedToParseCommandLineInteger = "WFLYSRV0023: Failed to parse property (%s), value (%s) as an integer";
    protected String failedToParseCommandLineInteger$str() {
        return failedToParseCommandLineInteger;
    }
    @Override
    public final void cannotAddURLStreamHandlerFactory(final Exception cause, final String moduleID) {
        super.log.logf(FQCN, ERROR, cause, cannotAddURLStreamHandlerFactory$str(), moduleID);
    }
    private static final String cannotAddURLStreamHandlerFactory = "WFLYSRV0024: Cannot add module '%s' as URLStreamHandlerFactory provider";
    protected String cannotAddURLStreamHandlerFactory$str() {
        return cannotAddURLStreamHandlerFactory;
    }
    @Override
    public final void startedClean(final String prettyVersionString, final long time, final int startedServices, final int allServices, final int passiveOnDemandServices) {
        super.log.logf(FQCN, INFO, null, startedClean$str(), prettyVersionString, time, startedServices, allServices, passiveOnDemandServices);
    }
    private static final String startedClean = "WFLYSRV0025: %s started in %dms - Started %d of %d services (%d services are lazy, passive or on-demand)";
    protected String startedClean$str() {
        return startedClean;
    }
    @Override
    public final void startedWitErrors(final String prettyVersionString, final long time, final int startedServices, final int allServices, final int problemServices, final int passiveOnDemandServices) {
        super.log.logf(FQCN, ERROR, null, startedWitErrors$str(), prettyVersionString, time, startedServices, allServices, problemServices, passiveOnDemandServices);
    }
    private static final String startedWitErrors = "WFLYSRV0026: %s started (with errors) in %dms - Started %d of %d services (%d services failed or missing dependencies, %d services are lazy, passive or on-demand)";
    protected String startedWitErrors$str() {
        return startedWitErrors;
    }
    @Override
    public final void startingDeployment(final String managementName, final String deploymentUnitName) {
        super.log.logf(FQCN, INFO, null, startingDeployment$str(), managementName, deploymentUnitName);
    }
    private static final String startingDeployment = "WFLYSRV0027: Starting deployment of \"%s\" (runtime-name: \"%s\")";
    protected String startingDeployment$str() {
        return startingDeployment;
    }
    @Override
    public final void stoppedDeployment(final String managementName, final String deploymentUnitName, final int elapsedTime) {
        super.log.logf(FQCN, INFO, null, stoppedDeployment$str(), managementName, deploymentUnitName, elapsedTime);
    }
    private static final String stoppedDeployment = "WFLYSRV0028: Stopped deployment %s (runtime-name: %s) in %dms";
    protected String stoppedDeployment$str() {
        return stoppedDeployment;
    }
    @Override
    public final void nativeManagementInterfaceIsUnsecured() {
        super.log.logf(FQCN, WARN, null, nativeManagementInterfaceIsUnsecured$str());
    }
    private static final String nativeManagementInterfaceIsUnsecured = "WFLYSRV0034: No security realm or sasl server authentication defined for native management service; all access will be unrestricted.";
    protected String nativeManagementInterfaceIsUnsecured$str() {
        return nativeManagementInterfaceIsUnsecured;
    }
    @Override
    public final void httpManagementInterfaceIsUnsecured() {
        super.log.logf(FQCN, WARN, null, httpManagementInterfaceIsUnsecured$str());
    }
    private static final String httpManagementInterfaceIsUnsecured = "WFLYSRV0035: No security realm or http server authentication defined for http management service; all access will be unrestricted.";
    protected String httpManagementInterfaceIsUnsecured$str() {
        return httpManagementInterfaceIsUnsecured;
    }
    @Override
    public final void creatingHttpManagementServiceOnSocket(final String socketName) {
        super.log.logf(FQCN, INFO, null, creatingHttpManagementServiceOnSocket$str(), socketName);
    }
    private static final String creatingHttpManagementServiceOnSocket = "WFLYSRV0039: Creating http management service using socket-binding (%s)";
    protected String creatingHttpManagementServiceOnSocket$str() {
        return creatingHttpManagementServiceOnSocket;
    }
    @Override
    public final void creatingHttpManagementServiceOnSecureSocket(final String secureSocketName) {
        super.log.logf(FQCN, INFO, null, creatingHttpManagementServiceOnSecureSocket$str(), secureSocketName);
    }
    private static final String creatingHttpManagementServiceOnSecureSocket = "WFLYSRV0040: Creating http management service using secure-socket-binding (%s)";
    protected String creatingHttpManagementServiceOnSecureSocket$str() {
        return creatingHttpManagementServiceOnSecureSocket;
    }
    @Override
    public final void creatingHttpManagementServiceOnSocketAndSecureSocket(final String socketName, final String secureSocketName) {
        super.log.logf(FQCN, INFO, null, creatingHttpManagementServiceOnSocketAndSecureSocket$str(), socketName, secureSocketName);
    }
    private static final String creatingHttpManagementServiceOnSocketAndSecureSocket = "WFLYSRV0041: Creating http management service using socket-binding (%s) and secure-socket-binding (%s)";
    protected String creatingHttpManagementServiceOnSocketAndSecureSocket$str() {
        return creatingHttpManagementServiceOnSocketAndSecureSocket;
    }
    @Override
    public final void caughtExceptionClosingContentInputStream(final Exception cause) {
        super.log.logf(FQCN, WARN, cause, caughtExceptionClosingContentInputStream$str());
    }
    private static final String caughtExceptionClosingContentInputStream = "WFLYSRV0042: Caught exception closing input stream for uploaded deployment content";
    protected String caughtExceptionClosingContentInputStream$str() {
        return caughtExceptionClosingContentInputStream;
    }
    @Override
    public final void caughtExceptionUndeploying(final Throwable cause, final DeploymentUnitProcessor dup, final Phase phase, final DeploymentUnit unit) {
        super.log.logf(FQCN, ERROR, cause, caughtExceptionUndeploying$str(), dup, phase, unit);
    }
    private static final String caughtExceptionUndeploying = "WFLYSRV0043: Deployment unit processor %s unexpectedly threw an exception during undeploy phase %s of %s";
    protected String caughtExceptionUndeploying$str() {
        return caughtExceptionUndeploying;
    }
    @Override
    public final void extensionMissingManifestAttribute(final String item, final String again, final Name suffix) {
        super.log.logf(FQCN, WARN, null, extensionMissingManifestAttribute$str(), item, again, suffix);
    }
    private static final String extensionMissingManifestAttribute = "WFLYSRV0045: Extension %s is missing the required manifest attribute %s-%s (skipping extension)";
    protected String extensionMissingManifestAttribute$str() {
        return extensionMissingManifestAttribute;
    }
    @Override
    public final void invalidExtensionURI(final String item, final URISyntaxException e) {
        super.log.logf(FQCN, WARN, null, invalidExtensionURI$str(), item, e);
    }
    private static final String invalidExtensionURI = "WFLYSRV0046: Extension %s URI syntax is invalid: %s";
    protected String invalidExtensionURI$str() {
        return invalidExtensionURI;
    }
    @Override
    public final void cannotFindExtensionListEntry(final ExtensionListEntry entry, final ResourceRoot resourceRoot) {
        super.log.logf(FQCN, WARN, null, cannotFindExtensionListEntry$str(), entry, resourceRoot);
    }
    private static final String cannotFindExtensionListEntry = "WFLYSRV0047: Could not find Extension-List entry %s referenced from %s";
    protected String cannotFindExtensionListEntry$str() {
        return cannotFindExtensionListEntry;
    }
    @Override
    public final void duplicateServerNameConfiguration(final String systemProperty, final String rawServerProp, final String processName) {
        super.log.logf(FQCN, WARN, null, duplicateServerNameConfiguration$str(), systemProperty, rawServerProp, processName);
    }
    private static final String duplicateServerNameConfiguration = "WFLYSRV0048: A server name configuration was provided both via system property %s ('%s') and via the xml configuration ('%s'). The xml configuration value will be used.";
    protected String duplicateServerNameConfiguration$str() {
        return duplicateServerNameConfiguration;
    }
    @Override
    public final void serverStarting(final String prettyVersion) {
        super.log.logf(FQCN, INFO, null, serverStarting$str(), prettyVersion);
    }
    private static final String serverStarting = "WFLYSRV0049: %s starting";
    protected String serverStarting$str() {
        return serverStarting;
    }
    @Override
    public final void serverStopped(final String prettyVersion, final int time) {
        super.log.logf(FQCN, INFO, null, serverStopped$str(), prettyVersion, time);
    }
    private static final String serverStopped = "WFLYSRV0050: %s stopped in %dms";
    protected String serverStopped$str() {
        return serverStopped;
    }
    @Override
    public final void logHttpConsole(final String httpAddr, final int httpPort) {
        super.log.logf(FQCN, INFO, null, logHttpConsole$str(), httpAddr, httpPort);
    }
    private static final String logHttpConsole = "WFLYSRV0051: Admin console listening on http://%s:%d";
    protected String logHttpConsole$str() {
        return logHttpConsole;
    }
    @Override
    public final void logHttpsConsole(final String httpsAddr, final int httpsPort) {
        super.log.logf(FQCN, INFO, null, logHttpsConsole$str(), httpsAddr, httpsPort);
    }
    private static final String logHttpsConsole = "WFLYSRV0052: Admin console listening on https://%s:%d";
    protected String logHttpsConsole$str() {
        return logHttpsConsole;
    }
    @Override
    public final void logHttpAndHttpsConsole(final String httpAddr, final int httpPort, final String httpsAddr, final int httpsPort) {
        super.log.logf(FQCN, INFO, null, logHttpAndHttpsConsole$str(), httpAddr, httpPort, httpsAddr, httpsPort);
    }
    private static final String logHttpAndHttpsConsole = "WFLYSRV0053: Admin console listening on http://%s:%d and https://%s:%d";
    protected String logHttpAndHttpsConsole$str() {
        return logHttpAndHttpsConsole;
    }
    @Override
    public final void logNoConsole() {
        super.log.logf(FQCN, INFO, null, logNoConsole$str());
    }
    private static final String logNoConsole = "WFLYSRV0054: Admin console is not enabled";
    protected String logNoConsole$str() {
        return logNoConsole;
    }
    @Override
    public final void caughtExceptionDuringBoot(final Exception e) {
        super.log.logf(FQCN, ERROR, e, caughtExceptionDuringBoot$str());
    }
    private static final String caughtExceptionDuringBoot = "WFLYSRV0055: Caught exception during boot";
    protected String caughtExceptionDuringBoot$str() {
        return caughtExceptionDuringBoot;
    }
    private static final String unsuccessfulBoot = "WFLYSRV0056: Server boot has failed in an unrecoverable manner; exiting. See previous messages for details.";
    protected String unsuccessfulBoot$str() {
        return unsuccessfulBoot;
    }
    @Override
    public final String unsuccessfulBoot() {
        return String.format(getLoggingLocale(), unsuccessfulBoot$str());
    }
    @Override
    public final void reportAdminOnlyMissingDeploymentContent(final String contentHash, final String deploymentName) {
        super.log.logf(FQCN, ERROR, null, reportAdminOnlyMissingDeploymentContent$str(), contentHash, deploymentName);
    }
    private static final String reportAdminOnlyMissingDeploymentContent = "WFLYSRV0057: No deployment content with hash %s is available in the deployment content repository for deployment %s. Because this Host Controller is booting in ADMIN-ONLY mode, boot will be allowed to proceed to provide administrators an opportunity to correct this problem. If this Host Controller were not in ADMIN-ONLY mode this would be a fatal boot failure.";
    protected String reportAdminOnlyMissingDeploymentContent$str() {
        return reportAdminOnlyMissingDeploymentContent;
    }
    @Override
    public final void additionalResourceRootDoesNotExist(final String resourceRoot) {
        super.log.logf(FQCN, WARN, null, additionalResourceRootDoesNotExist$str(), resourceRoot);
    }
    private static final String additionalResourceRootDoesNotExist = "WFLYSRV0058: Additional resource root %s added via jboss-deployment-structure.xml does not exist";
    protected String additionalResourceRootDoesNotExist$str() {
        return additionalResourceRootDoesNotExist;
    }
    @Override
    public final void classPathEntryNotValid(final String classPathEntry, final String resourceRoot) {
        super.log.logf(FQCN, WARN, null, classPathEntryNotValid$str(), classPathEntry, resourceRoot);
    }
    private static final String classPathEntryNotValid = "WFLYSRV0059: Class Path entry %s in %s  does not point to a valid jar for a Class-Path reference.";
    protected String classPathEntryNotValid$str() {
        return classPathEntryNotValid;
    }
    @Override
    public final void logHttpManagement(final String httpAddr, final int httpPort) {
        super.log.logf(FQCN, INFO, null, logHttpManagement$str(), httpAddr, httpPort);
    }
    private static final String logHttpManagement = "WFLYSRV0060: Http management interface listening on http://%s:%d/management";
    protected String logHttpManagement$str() {
        return logHttpManagement;
    }
    @Override
    public final void logHttpsManagement(final String httpsAddr, final int httpsPort) {
        super.log.logf(FQCN, INFO, null, logHttpsManagement$str(), httpsAddr, httpsPort);
    }
    private static final String logHttpsManagement = "WFLYSRV0061: Http management interface listening on https://%s:%d/management";
    protected String logHttpsManagement$str() {
        return logHttpsManagement;
    }
    @Override
    public final void logHttpAndHttpsManagement(final String httpAddr, final int httpPort, final String httpsAddr, final int httpsPort) {
        super.log.logf(FQCN, INFO, null, logHttpAndHttpsManagement$str(), httpAddr, httpPort, httpsAddr, httpsPort);
    }
    private static final String logHttpAndHttpsManagement = "WFLYSRV0062: Http management interface listening on http://%s:%d/management and https://%s:%d/management";
    protected String logHttpAndHttpsManagement$str() {
        return logHttpAndHttpsManagement;
    }
    @Override
    public final void logNoHttpManagement() {
        super.log.logf(FQCN, INFO, null, logNoHttpManagement$str());
    }
    private static final String logNoHttpManagement = "WFLYSRV0063: Http management interface is not enabled";
    protected String logNoHttpManagement$str() {
        return logNoHttpManagement;
    }
    @Override
    public final void jbossDeploymentStructureNamespaceIgnored(final String deploymentUnitName) {
        super.log.logf(FQCN, WARN, null, jbossDeploymentStructureNamespaceIgnored$str(), deploymentUnitName);
    }
    private static final String jbossDeploymentStructureNamespaceIgnored = "WFLYSRV0064: urn:jboss:deployment-structure namespace found in jboss.xml for a sub deployment %s. This is only valid in a top level deployment.";
    protected String jbossDeploymentStructureNamespaceIgnored$str() {
        return jbossDeploymentStructureNamespaceIgnored;
    }
    @Override
    public final void failedToUnmountContentOverride(final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, failedToUnmountContentOverride$str());
    }
    private static final String failedToUnmountContentOverride = "WFLYSRV0065: Failed to unmount deployment overlay";
    protected String failedToUnmountContentOverride$str() {
        return failedToUnmountContentOverride;
    }
    @Override
    public final void deploymentDependenciesAreATopLevelElement(final String name) {
        super.log.logf(FQCN, WARN, null, deploymentDependenciesAreATopLevelElement$str(), name);
    }
    private static final String deploymentDependenciesAreATopLevelElement = "WFLYSRV0067: jboss-deployment-dependencies cannot be used in a sub deployment, it must be specified at ear level: %s";
    protected String deploymentDependenciesAreATopLevelElement$str() {
        return deploymentDependenciesAreATopLevelElement;
    }
    @Override
    public final void reportAdminOnlyMissingDeploymentOverlayContent(final String contentHash, final String deploymentName, final String contentName) {
        super.log.logf(FQCN, ERROR, null, reportAdminOnlyMissingDeploymentOverlayContent$str(), contentHash, deploymentName, contentName);
    }
    private static final String reportAdminOnlyMissingDeploymentOverlayContent = "WFLYSRV0068: No deployment overlay content with hash %s is available in the deployment content repository for deployment %s at location %s. Because this Host Controller is booting in ADMIN-ONLY mode, boot will be allowed to proceed to provide administrators an opportunity to correct this problem. If this Host Controller were not in ADMIN-ONLY mode this would be a fatal boot failure.";
    protected String reportAdminOnlyMissingDeploymentOverlayContent$str() {
        return reportAdminOnlyMissingDeploymentOverlayContent;
    }
    @Override
    public final void deploymentRestartDetected(final String deployment) {
        super.log.logf(FQCN, INFO, null, deploymentRestartDetected$str(), deployment);
    }
    private static final String deploymentRestartDetected = "WFLYSRV0070: Deployment restart detected for deployment %s, performing full redeploy instead.";
    protected String deploymentRestartDetected$str() {
        return deploymentRestartDetected;
    }
    @Override
    public final void fdTooLow(final long fdCount) {
        super.log.logf(FQCN, WARN, null, fdTooLow$str(), fdCount);
    }
    private static final String fdTooLow = "WFLYSRV0071: The operating system has limited the number of open files to %d for this process; a value of at least 4096 is recommended";
    protected String fdTooLow$str() {
        return fdTooLow;
    }
    private static final String argServerConfig = "Name of the server configuration file to use (default is \"standalone.xml\") (Same as -c)";
    protected String argServerConfig$str() {
        return argServerConfig;
    }
    @Override
    public final String argServerConfig() {
        return String.format(getLoggingLocale(), argServerConfig$str());
    }
    private static final String argShortServerConfig = "Name of the server configuration file to use (default is \"standalone.xml\") (Same as --server-config)";
    protected String argShortServerConfig$str() {
        return argShortServerConfig;
    }
    @Override
    public final String argShortServerConfig() {
        return String.format(getLoggingLocale(), argShortServerConfig$str());
    }
    private static final String argReadOnlyServerConfig = "Name of the server configuration file to use. This differs from '--server-config' and '-c' in that the original file is never overwritten.";
    protected String argReadOnlyServerConfig$str() {
        return argReadOnlyServerConfig;
    }
    @Override
    public final String argReadOnlyServerConfig() {
        return String.format(getLoggingLocale(), argReadOnlyServerConfig$str());
    }
    private static final String argHelp = "Display this message and exit";
    protected String argHelp$str() {
        return argHelp;
    }
    @Override
    public final String argHelp() {
        return String.format(getLoggingLocale(), argHelp$str());
    }
    private static final String argProperties = "Load system properties from the given url";
    protected String argProperties$str() {
        return argProperties;
    }
    @Override
    public final String argProperties() {
        return String.format(getLoggingLocale(), argProperties$str());
    }
    private static final String argSecurityProperty = "Set a security property";
    protected String argSecurityProperty$str() {
        return argSecurityProperty;
    }
    @Override
    public final String argSecurityProperty() {
        return String.format(getLoggingLocale(), argSecurityProperty$str());
    }
    private static final String argSystem = "Set a system property";
    protected String argSystem$str() {
        return argSystem;
    }
    @Override
    public final String argSystem() {
        return String.format(getLoggingLocale(), argSystem$str());
    }
    private static final String argVersion = "Print version and exit";
    protected String argVersion$str() {
        return argVersion;
    }
    @Override
    public final String argVersion() {
        return String.format(getLoggingLocale(), argVersion$str());
    }
    private static final String argPublicBindAddress = "Set system property jboss.bind.address to the given value";
    protected String argPublicBindAddress$str() {
        return argPublicBindAddress;
    }
    @Override
    public final String argPublicBindAddress() {
        return String.format(getLoggingLocale(), argPublicBindAddress$str());
    }
    private static final String argInterfaceBindAddress = "Set system property jboss.bind.address.<interface> to the given value";
    protected String argInterfaceBindAddress$str() {
        return argInterfaceBindAddress;
    }
    @Override
    public final String argInterfaceBindAddress() {
        return String.format(getLoggingLocale(), argInterfaceBindAddress$str());
    }
    private static final String argDefaultMulticastAddress = "Set system property jboss.default.multicast.address to the given value";
    protected String argDefaultMulticastAddress$str() {
        return argDefaultMulticastAddress;
    }
    @Override
    public final String argDefaultMulticastAddress() {
        return String.format(getLoggingLocale(), argDefaultMulticastAddress$str());
    }
    private static final String argAdminOnly = "Set the server's running type to ADMIN_ONLY causing it to open administrative interfaces and accept management requests but not start other runtime services or accept end user requests. Cannot be used in conjunction with --start-mode.";
    protected String argAdminOnly$str() {
        return argAdminOnly;
    }
    @Override
    public final String argAdminOnly() {
        return String.format(getLoggingLocale(), argAdminOnly$str());
    }
    private static final String argDebugPort = "Activate debug mode with an optional argument to specify the port. Only works if the launch script supports it.";
    protected String argDebugPort$str() {
        return argDebugPort;
    }
    @Override
    public final String argDebugPort() {
        return String.format(getLoggingLocale(), argDebugPort$str());
    }
    private static final String argSecMgr = "Runs the server with a security manager installed.";
    protected String argSecMgr$str() {
        return argSecMgr;
    }
    @Override
    public final String argSecMgr() {
        return String.format(getLoggingLocale(), argSecMgr$str());
    }
    private static final String argStartMode = "Sets the start mode of the server, it can be either 'normal','admin-only' or 'suspend'. If this is 'suspend' the server will start in suspended mode, and will not service requests until it has been resumed. If this is started in admin-only mode the server will only open administrative interfaces and accept management requests but not start other runtime services or accept end user requests. Cannot be used in conjunction with --admin-only.";
    protected String argStartMode$str() {
        return argStartMode;
    }
    @Override
    public final String argStartMode() {
        return String.format(getLoggingLocale(), argStartMode$str());
    }
    private static final String valueExpectedForCommandLineOption = "WFLYSRV0072: Value expected for option %s";
    protected String valueExpectedForCommandLineOption$str() {
        return valueExpectedForCommandLineOption;
    }
    @Override
    public final String valueExpectedForCommandLineOption(final String option) {
        return String.format(getLoggingLocale(), valueExpectedForCommandLineOption$str(), option);
    }
    private static final String invalidCommandLineOption = "WFLYSRV0073: Invalid option '%s'";
    protected String invalidCommandLineOption$str() {
        return invalidCommandLineOption;
    }
    @Override
    public final String invalidCommandLineOption(final String option) {
        return String.format(getLoggingLocale(), invalidCommandLineOption$str(), option);
    }
    private static final String malformedCommandLineURL = "WFLYSRV0074: Malformed URL '%s' provided for option '%s'";
    protected String malformedCommandLineURL$str() {
        return malformedCommandLineURL;
    }
    @Override
    public final String malformedCommandLineURL(final String urlSpec, final String option) {
        return String.format(getLoggingLocale(), malformedCommandLineURL$str(), urlSpec, option);
    }
    private static final String unableToLoadProperties = "WFLYSRV0075: Unable to load properties from URL '%s'";
    protected String unableToLoadProperties$str() {
        return unableToLoadProperties;
    }
    @Override
    public final String unableToLoadProperties(final URL url) {
        return String.format(getLoggingLocale(), unableToLoadProperties$str(), url);
    }
    private static final String cannotCreateVault = "WFLYSRV0076: Error initializing vault --  %s";
    protected String cannotCreateVault$str() {
        return cannotCreateVault;
    }
    @Override
    public final VaultReaderException cannotCreateVault(final Throwable cause, final Throwable msg) {
        final VaultReaderException result = new VaultReaderException(String.format(getLoggingLocale(), cannotCreateVault$str(), msg), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String hostControllerNameNonNullInStandalone = "WFLYSRV0079: hostControllerName must be null if the server is not in a managed domain";
    protected String hostControllerNameNonNullInStandalone$str() {
        return hostControllerNameNonNullInStandalone;
    }
    @Override
    public final IllegalArgumentException hostControllerNameNonNullInStandalone() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), hostControllerNameNonNullInStandalone$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String hostControllerNameNullInDomain = "WFLYSRV0080: hostControllerName may not be null if the server is in a managed domain";
    protected String hostControllerNameNullInDomain$str() {
        return hostControllerNameNullInDomain;
    }
    @Override
    public final IllegalArgumentException hostControllerNameNullInDomain() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), hostControllerNameNullInDomain$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotResolveInterface = "WFLYSRV0081: An IP address cannot be resolved using the given interface selection criteria. Failure was -- %s";
    protected String cannotResolveInterface$str() {
        return cannotResolveInterface;
    }
    @Override
    public final OperationFailedException cannotResolveInterface(final Exception msg, final Exception cause) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotResolveInterface$str(), msg), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToResolveInterface = "WFLYSRV0082: failed to resolve interface %s";
    protected String failedToResolveInterface$str() {
        return failedToResolveInterface;
    }
    @Override
    public final StartException failedToResolveInterface(final String name) {
        final StartException result = new StartException(String.format(getLoggingLocale(), failedToResolveInterface$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToStartHttpManagementService = "WFLYSRV0083: Failed to start the http-interface service";
    protected String failedToStartHttpManagementService$str() {
        return failedToStartHttpManagementService;
    }
    @Override
    public final StartException failedToStartHttpManagementService(final Exception e) {
        final StartException result = new StartException(String.format(getLoggingLocale(), failedToStartHttpManagementService$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSuchDeploymentContent = "WFLYSRV0084: No deployment content with hash %s is available in the deployment content repository.";
    protected String noSuchDeploymentContent$str() {
        return noSuchDeploymentContent;
    }
    @Override
    public final OperationFailedException noSuchDeploymentContent(final String hash) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), noSuchDeploymentContent$str(), hash));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSuchDeployment = "WFLYSRV0085: No deployment with name %s found";
    protected String noSuchDeployment$str() {
        return noSuchDeployment;
    }
    @Override
    public final OperationFailedException noSuchDeployment(final String deploymentName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), noSuchDeployment$str(), deploymentName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotReplaceDeployment = "WFLYSRV0086: Cannot use %s with the same value for parameters %s and %s. Use %s to redeploy the same content or %s to replace content with a new version with the same name.";
    protected String cannotReplaceDeployment$str() {
        return cannotReplaceDeployment;
    }
    @Override
    public final OperationFailedException cannotReplaceDeployment(final String replaceOperation, final String name, final String toReplace, final String redeployOperation, final String fullReplace) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotReplaceDeployment$str(), replaceOperation, name, toReplace, redeployOperation, fullReplace));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String deploymentAlreadyStarted = "WFLYSRV0087: Deployment %s is already started";
    protected String deploymentAlreadyStarted$str() {
        return deploymentAlreadyStarted;
    }
    @Override
    public final OperationFailedException deploymentAlreadyStarted(final String deploymentName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), deploymentAlreadyStarted$str(), deploymentName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingHomeDirConfiguration = "WFLYSRV0088: Missing configuration value for: %s";
    protected String missingHomeDirConfiguration$str() {
        return missingHomeDirConfiguration;
    }
    @Override
    public final IllegalStateException missingHomeDirConfiguration(final String propertyName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), missingHomeDirConfiguration$str(), propertyName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String caughtIOExceptionUploadingContent = "WFLYSRV0093: Caught IOException reading uploaded deployment content";
    protected String caughtIOExceptionUploadingContent$str() {
        return caughtIOExceptionUploadingContent;
    }
    @Override
    public final OperationFailedException caughtIOExceptionUploadingContent(final IOException cause) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), caughtIOExceptionUploadingContent$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullStreamAttachment = "WFLYSRV0094: Null stream at index [%d]";
    protected String nullStreamAttachment$str() {
        return nullStreamAttachment;
    }
    @Override
    public final OperationFailedException nullStreamAttachment(final int index) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), nullStreamAttachment$str(), index));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidDeploymentURL = "WFLYSRV0095: '%s' is not a valid URL";
    protected String invalidDeploymentURL$str() {
        return invalidDeploymentURL;
    }
    @Override
    public final OperationFailedException invalidDeploymentURL(final String urlSpec, final MalformedURLException e) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), invalidDeploymentURL$str(), urlSpec), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String problemOpeningStreamFromDeploymentURL = "WFLYSRV0096: Error obtaining input stream from URL '%s'";
    protected String problemOpeningStreamFromDeploymentURL$str() {
        return problemOpeningStreamFromDeploymentURL;
    }
    @Override
    public final OperationFailedException problemOpeningStreamFromDeploymentURL(final String urlSpec, final IOException e) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), problemOpeningStreamFromDeploymentURL$str(), urlSpec), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serviceModuleLoaderAlreadyStarted = "WFLYSRV0097: ServiceModuleLoader already started";
    protected String serviceModuleLoaderAlreadyStarted$str() {
        return serviceModuleLoaderAlreadyStarted;
    }
    @Override
    public final IllegalStateException serviceModuleLoaderAlreadyStarted() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), serviceModuleLoaderAlreadyStarted$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serviceModuleLoaderAlreadyStopped = "WFLYSRV0098: ServiceModuleLoader already stopped";
    protected String serviceModuleLoaderAlreadyStopped$str() {
        return serviceModuleLoaderAlreadyStopped;
    }
    @Override
    public final IllegalStateException serviceModuleLoaderAlreadyStopped() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), serviceModuleLoaderAlreadyStopped$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingModulePrefix = "WFLYSRV0099: '%s' cannot be loaded from a ServiceModuleLoader as its name does not start with '%s'";
    protected String missingModulePrefix$str() {
        return missingModulePrefix;
    }
    @Override
    public final IllegalArgumentException missingModulePrefix(final ModuleIdentifier identifier, final String prefix) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), missingModulePrefix$str(), identifier, prefix));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToReadVirtualFile = "WFLYSRV0100: Failed to read '%s'";
    protected String failedToReadVirtualFile$str() {
        return failedToReadVirtualFile;
    }
    @Override
    public final DeploymentUnitProcessingException failedToReadVirtualFile(final VirtualFile file, final IOException cause) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failedToReadVirtualFile$str(), file), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String deploymentRootRequired = "WFLYSRV0101: Deployment root is required";
    protected String deploymentRootRequired$str() {
        return deploymentRootRequired;
    }
    @Override
    public final IllegalArgumentException deploymentRootRequired() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), deploymentRootRequired$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String subdeploymentsRequireParent = "WFLYSRV0102: Sub-deployments require a parent deployment unit";
    protected String subdeploymentsRequireParent$str() {
        return subdeploymentsRequireParent;
    }
    @Override
    public final IllegalArgumentException subdeploymentsRequireParent() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), subdeploymentsRequireParent$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noModuleIdentifier = "WFLYSRV0103: No Module Identifier attached to deployment '%s'";
    protected String noModuleIdentifier$str() {
        return noModuleIdentifier;
    }
    @Override
    public final DeploymentUnitProcessingException noModuleIdentifier(final String deploymentUnitName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), noModuleIdentifier$str(), deploymentUnitName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToCreateVFSResourceLoader = "WFLYSRV0104: Failed to create VFSResourceLoader for root [%s]";
    protected String failedToCreateVFSResourceLoader$str() {
        return failedToCreateVFSResourceLoader;
    }
    @Override
    public final DeploymentUnitProcessingException failedToCreateVFSResourceLoader(final String resourceRoot, final IOException cause) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failedToCreateVFSResourceLoader$str(), resourceRoot), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToGetFileFromRemoteRepository = "WFLYSRV0105: Failed to get file from remote repository";
    protected String failedToGetFileFromRemoteRepository$str() {
        return failedToGetFileFromRemoteRepository;
    }
    @Override
    public final RuntimeException failedToGetFileFromRemoteRepository(final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failedToGetFileFromRemoteRepository$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotCreateLocalDirectory = "WFLYSRV0106: Unable to create local directory: %s";
    protected String cannotCreateLocalDirectory$str() {
        return cannotCreateLocalDirectory;
    }
    @Override
    public final IOException cannotCreateLocalDirectory(final File path) {
        final IOException result = new IOException(String.format(getLoggingLocale(), cannotCreateLocalDirectory$str(), path));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String didNotReadEntireFile = "WFLYSRV0107: Did not read the entire file. Missing: %d";
    protected String didNotReadEntireFile$str() {
        return didNotReadEntireFile;
    }
    @Override
    public final IOException didNotReadEntireFile(final long missing) {
        final IOException result = new IOException(String.format(getLoggingLocale(), didNotReadEntireFile$str(), missing));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noArgValue = "WFLYSRV0108: No value was provided for argument %s%n";
    protected String noArgValue$str() {
        return noArgValue;
    }
    @Override
    public final String noArgValue(final String argument) {
        return String.format(getLoggingLocale(), noArgValue$str(), argument);
    }
    private static final String couldNotFindHcFileRepositoryConnection = "WFLYSRV0109: Could not find the file repository connection to the host controller.";
    protected String couldNotFindHcFileRepositoryConnection$str() {
        return couldNotFindHcFileRepositoryConnection;
    }
    @Override
    public final IllegalStateException couldNotFindHcFileRepositoryConnection() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), couldNotFindHcFileRepositoryConnection$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownMountType = "WFLYSRV0112: Unknown mount type %s";
    protected String unknownMountType$str() {
        return unknownMountType;
    }
    @Override
    public final IllegalArgumentException unknownMountType(final MountType mountType) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownMountType$str(), mountType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedCreatingTempProvider = "WFLYSRV0113: Failed to create temp file provider";
    protected String failedCreatingTempProvider$str() {
        return failedCreatingTempProvider;
    }
    @Override
    public final StartException failedCreatingTempProvider(final Throwable cause) {
        final StartException result = new StartException(String.format(getLoggingLocale(), failedCreatingTempProvider$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String systemPropertyNotManageable = "WFLYSRV0115: System property %s cannot be set via the xml configuration file or from a management client; it's value must be known at initial process start so it can only set from the commmand line";
    protected String systemPropertyNotManageable$str() {
        return systemPropertyNotManageable;
    }
    @Override
    public final OperationFailedException systemPropertyNotManageable(final String propertyName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), systemPropertyNotManageable$str(), propertyName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String systemPropertyCannotOverrideServerName = "WFLYSRV0116: System property %s cannot be set after the server name has been set via the xml configuration file or from a management client";
    protected String systemPropertyCannotOverrideServerName$str() {
        return systemPropertyCannotOverrideServerName;
    }
    @Override
    public final OperationFailedException systemPropertyCannotOverrideServerName(final String propertyName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), systemPropertyCannotOverrideServerName$str(), propertyName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToInitialiseSSLContext = "WFLYSRV0117: Unable to initialise a basic SSLContext '%s'";
    protected String unableToInitialiseSSLContext$str() {
        return unableToInitialiseSSLContext;
    }
    @Override
    public final IllegalStateException unableToInitialiseSSLContext(final String message) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unableToInitialiseSSLContext$str(), message));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String homeDirectoryDoesNotExist = "WFLYSRV0119: Home directory does not exist: %s";
    protected String homeDirectoryDoesNotExist$str() {
        return homeDirectoryDoesNotExist;
    }
    @Override
    public final IllegalStateException homeDirectoryDoesNotExist(final File f) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), homeDirectoryDoesNotExist$str(), f));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String bundlesDirectoryDoesNotExist = "WFLYSRV0120: Bundles directory does not exist: %s";
    protected String bundlesDirectoryDoesNotExist$str() {
        return bundlesDirectoryDoesNotExist;
    }
    @Override
    public final IllegalStateException bundlesDirectoryDoesNotExist(final File f) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), bundlesDirectoryDoesNotExist$str(), f));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String configDirectoryDoesNotExist = "WFLYSRV0121: Configuration directory does not exist: %s";
    protected String configDirectoryDoesNotExist$str() {
        return configDirectoryDoesNotExist;
    }
    @Override
    public final IllegalStateException configDirectoryDoesNotExist(final File f) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), configDirectoryDoesNotExist$str(), f));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serverBaseDirectoryDoesNotExist = "WFLYSRV0122: Server base directory does not exist: %s";
    protected String serverBaseDirectoryDoesNotExist$str() {
        return serverBaseDirectoryDoesNotExist;
    }
    @Override
    public final IllegalStateException serverBaseDirectoryDoesNotExist(final File f) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), serverBaseDirectoryDoesNotExist$str(), f));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serverDataDirectoryIsNotDirectory = "WFLYSRV0123: Server data directory is not a directory: %s";
    protected String serverDataDirectoryIsNotDirectory$str() {
        return serverDataDirectoryIsNotDirectory;
    }
    @Override
    public final IllegalStateException serverDataDirectoryIsNotDirectory(final File file) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), serverDataDirectoryIsNotDirectory$str(), file));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotCreateServerDataDirectory = "WFLYSRV0124: Could not create server data directory: %s";
    protected String couldNotCreateServerDataDirectory$str() {
        return couldNotCreateServerDataDirectory;
    }
    @Override
    public final IllegalStateException couldNotCreateServerDataDirectory(final File file) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), couldNotCreateServerDataDirectory$str(), file));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serverContentDirectoryIsNotDirectory = "WFLYSRV0125: Server content directory is not a directory: %s";
    protected String serverContentDirectoryIsNotDirectory$str() {
        return serverContentDirectoryIsNotDirectory;
    }
    @Override
    public final IllegalStateException serverContentDirectoryIsNotDirectory(final File file) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), serverContentDirectoryIsNotDirectory$str(), file));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotCreateServerContentDirectory = "WFLYSRV0126: Could not create server content directory: %s";
    protected String couldNotCreateServerContentDirectory$str() {
        return couldNotCreateServerContentDirectory;
    }
    @Override
    public final IllegalStateException couldNotCreateServerContentDirectory(final File file) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), couldNotCreateServerContentDirectory$str(), file));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String logDirectoryIsNotADirectory = "WFLYSRV0127: Log directory is not a directory: %s";
    protected String logDirectoryIsNotADirectory$str() {
        return logDirectoryIsNotADirectory;
    }
    @Override
    public final IllegalStateException logDirectoryIsNotADirectory(final File f) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), logDirectoryIsNotADirectory$str(), f));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotCreateLogDirectory = "WFLYSRV0128: Could not create log directory: %s";
    protected String couldNotCreateLogDirectory$str() {
        return couldNotCreateLogDirectory;
    }
    @Override
    public final IllegalStateException couldNotCreateLogDirectory(final File f) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), couldNotCreateLogDirectory$str(), f));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serverTempDirectoryIsNotADirectory = "WFLYSRV0129: Server temp directory does not exist: %s";
    protected String serverTempDirectoryIsNotADirectory$str() {
        return serverTempDirectoryIsNotADirectory;
    }
    @Override
    public final IllegalStateException serverTempDirectoryIsNotADirectory(final File file) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), serverTempDirectoryIsNotADirectory$str(), file));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotCreateServerTempDirectory = "WFLYSRV0130: Could not create server temp directory: %s";
    protected String couldNotCreateServerTempDirectory$str() {
        return couldNotCreateServerTempDirectory;
    }
    @Override
    public final IllegalStateException couldNotCreateServerTempDirectory(final File file) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), couldNotCreateServerTempDirectory$str(), file));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String controllerTempDirectoryIsNotADirectory = "WFLYSRV0131: Controller temp directory does not exist: %s";
    protected String controllerTempDirectoryIsNotADirectory$str() {
        return controllerTempDirectoryIsNotADirectory;
    }
    @Override
    public final IllegalStateException controllerTempDirectoryIsNotADirectory(final File file) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), controllerTempDirectoryIsNotADirectory$str(), file));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotCreateControllerTempDirectory = "WFLYSRV0132: Could not create server temp directory: %s";
    protected String couldNotCreateControllerTempDirectory$str() {
        return couldNotCreateControllerTempDirectory;
    }
    @Override
    public final IllegalStateException couldNotCreateControllerTempDirectory(final File file) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), couldNotCreateControllerTempDirectory$str(), file));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String domainBaseDirDoesNotExist = "WFLYSRV0133: Domain base dir does not exist: %s";
    protected String domainBaseDirDoesNotExist$str() {
        return domainBaseDirDoesNotExist;
    }
    @Override
    public final IllegalStateException domainBaseDirDoesNotExist(final File file) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), domainBaseDirDoesNotExist$str(), file));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String domainConfigDirDoesNotExist = "WFLYSRV0134: Domain config dir does not exist: %s";
    protected String domainConfigDirDoesNotExist$str() {
        return domainConfigDirDoesNotExist;
    }
    @Override
    public final IllegalStateException domainConfigDirDoesNotExist(final File file) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), domainConfigDirDoesNotExist$str(), file));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serverBaseDirectoryIsNotADirectory = "WFLYSRV0135: Server base directory is not a directory: %s";
    protected String serverBaseDirectoryIsNotADirectory$str() {
        return serverBaseDirectoryIsNotADirectory;
    }
    @Override
    public final IllegalStateException serverBaseDirectoryIsNotADirectory(final File file) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), serverBaseDirectoryIsNotADirectory$str(), file));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotCreateServerBaseDirectory = "WFLYSRV0136: Could not create server base directory: %s";
    protected String couldNotCreateServerBaseDirectory$str() {
        return couldNotCreateServerBaseDirectory;
    }
    @Override
    public final IllegalStateException couldNotCreateServerBaseDirectory(final File file) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), couldNotCreateServerBaseDirectory$str(), file));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSuchDeploymentContentAtBoot = "WFLYSRV0137: No deployment content with hash %s is available in the deployment content repository for deployment '%s'. This is a fatal boot error. To correct the problem, either restart with the --admin-only switch set and use the CLI to install the missing content or remove it from the configuration, or remove the deployment from the xml configuration file and restart.";
    protected String noSuchDeploymentContentAtBoot$str() {
        return noSuchDeploymentContentAtBoot;
    }
    @Override
    public final OperationFailedException noSuchDeploymentContentAtBoot(final String contentHash, final String deploymentName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), noSuchDeploymentContentAtBoot$str(), contentHash, deploymentName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String configuredSystemPropertiesLabel = "Configured system properties:";
    protected String configuredSystemPropertiesLabel$str() {
        return configuredSystemPropertiesLabel;
    }
    @Override
    public final String configuredSystemPropertiesLabel() {
        return String.format(getLoggingLocale(), configuredSystemPropertiesLabel$str());
    }
    private static final String vmArgumentsLabel = "VM Arguments: %s";
    protected String vmArgumentsLabel$str() {
        return vmArgumentsLabel;
    }
    @Override
    public final String vmArgumentsLabel(final String arguments) {
        return String.format(getLoggingLocale(), vmArgumentsLabel$str(), arguments);
    }
    private static final String configuredSystemEnvironmentLabel = "Configured system environment:";
    protected String configuredSystemEnvironmentLabel$str() {
        return configuredSystemEnvironmentLabel;
    }
    @Override
    public final String configuredSystemEnvironmentLabel() {
        return String.format(getLoggingLocale(), configuredSystemEnvironmentLabel$str());
    }
    private static final String vfsNotAvailable = "WFLYSRV0138: VFS is not available from the configured module loader";
    protected String vfsNotAvailable$str() {
        return vfsNotAvailable;
    }
    @Override
    public final IllegalStateException vfsNotAvailable() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), vfsNotAvailable$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serverControllerServiceRemoved = "WFLYSRV0139: Server controller service was removed";
    protected String serverControllerServiceRemoved$str() {
        return serverControllerServiceRemoved;
    }
    @Override
    public final ServiceNotFoundException serverControllerServiceRemoved() {
        final ServiceNotFoundException result = new ServiceNotFoundException(String.format(getLoggingLocale(), serverControllerServiceRemoved$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String rootServiceRemoved = "WFLYSRV0140: Root service was removed";
    protected String rootServiceRemoved$str() {
        return rootServiceRemoved;
    }
    @Override
    public final IllegalStateException rootServiceRemoved() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), rootServiceRemoved$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotStartServer = "WFLYSRV0141: Cannot start server";
    protected String cannotStartServer$str() {
        return cannotStartServer;
    }
    @Override
    public final IllegalStateException cannotStartServer(final Exception e) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotStartServer$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String embeddedServerDirectoryNotFound = "WFLYSRV0143: No directory called '%s' exists under '%s'";
    protected String embeddedServerDirectoryNotFound$str() {
        return embeddedServerDirectoryNotFound;
    }
    @Override
    public final IllegalArgumentException embeddedServerDirectoryNotFound(final String relativePath, final String homePath) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), embeddedServerDirectoryNotFound$str(), relativePath, homePath));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String propertySpecifiedFileDoesNotExist = "WFLYSRV0144: -D%s=%s does not exist";
    protected String propertySpecifiedFileDoesNotExist$str() {
        return propertySpecifiedFileDoesNotExist;
    }
    @Override
    public final IllegalArgumentException propertySpecifiedFileDoesNotExist(final String property, final String path) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), propertySpecifiedFileDoesNotExist$str(), property, path));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String propertySpecifiedFileIsNotADirectory = "WFLYSRV0145: -D%s=%s is not a directory";
    protected String propertySpecifiedFileIsNotADirectory$str() {
        return propertySpecifiedFileIsNotADirectory;
    }
    @Override
    public final IllegalArgumentException propertySpecifiedFileIsNotADirectory(final String property, final String path) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), propertySpecifiedFileIsNotADirectory$str(), property, path));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorCopyingFile = "WFLYSRV0146: Error copying '%s' to '%s'";
    protected String errorCopyingFile$str() {
        return errorCopyingFile;
    }
    @Override
    public final RuntimeException errorCopyingFile(final String src, final String dest, final IOException e) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), errorCopyingFile$str(), src, dest), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidObject = "WFLYSRV0147: %s is null";
    protected String invalidObject$str() {
        return invalidObject;
    }
    @Override
    public final InvalidObjectException invalidObject(final String field) {
        final InvalidObjectException result = new InvalidObjectException(String.format(getLoggingLocale(), invalidObject$str(), field));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidPortOffset = "WFLYSRV0148: portOffset is out of range";
    protected String invalidPortOffset$str() {
        return invalidPortOffset;
    }
    @Override
    public final InvalidObjectException invalidPortOffset() {
        final InvalidObjectException result = new InvalidObjectException(String.format(getLoggingLocale(), invalidPortOffset$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidStreamIndex = "WFLYSRV0149: Invalid '%s' value: %d, the maximum index is %d";
    protected String invalidStreamIndex$str() {
        return invalidStreamIndex;
    }
    @Override
    public final OperationFailedException invalidStreamIndex(final String name, final int value, final int maxIndex) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), invalidStreamIndex$str(), name, value, maxIndex));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidStreamURL = "WFLYSRV0150: Cannot create input stream from URL '%s'";
    protected String invalidStreamURL$str() {
        return invalidStreamURL;
    }
    @Override
    public final OperationFailedException invalidStreamURL(final Exception cause, final String url) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), invalidStreamURL$str(), url), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidStreamBytes = "WFLYSRV0151: No bytes available at param %s";
    protected String invalidStreamBytes$str() {
        return invalidStreamBytes;
    }
    @Override
    public final OperationFailedException invalidStreamBytes(final String param) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), invalidStreamBytes$str(), param));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multipleContentItemsNotSupported = "WFLYSRV0152: Only 1 piece of content is current supported (AS7-431)";
    protected String multipleContentItemsNotSupported$str() {
        return multipleContentItemsNotSupported;
    }
    @Override
    public final OperationFailedException multipleContentItemsNotSupported() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), multipleContentItemsNotSupported$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String deploymentPhaseFailed = "WFLYSRV0153: Failed to process phase %s of %s";
    protected String deploymentPhaseFailed$str() {
        return deploymentPhaseFailed;
    }
    @Override
    public final StartException deploymentPhaseFailed(final Phase phase, final DeploymentUnit deploymentUnit, final Throwable cause) {
        final StartException result = new StartException(String.format(getLoggingLocale(), deploymentPhaseFailed$str(), phase, deploymentUnit), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String deploymentIndexingFailed = "WFLYSRV0156: Failed to index deployment root for annotations";
    protected String deploymentIndexingFailed$str() {
        return deploymentIndexingFailed;
    }
    @Override
    public final DeploymentUnitProcessingException deploymentIndexingFailed(final Throwable cause) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), deploymentIndexingFailed$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSeamIntegrationJarPresent = "WFLYSRV0157: No Seam Integration jar present: %s";
    protected String noSeamIntegrationJarPresent$str() {
        return noSeamIntegrationJarPresent;
    }
    @Override
    public final DeploymentUnitProcessingException noSeamIntegrationJarPresent(final Module module) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), noSeamIntegrationJarPresent$str(), module));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToInstantiateClassFileTransformer = "WFLYSRV0158: Failed to instantiate a %s";
    protected String failedToInstantiateClassFileTransformer$str() {
        return failedToInstantiateClassFileTransformer;
    }
    @Override
    public final DeploymentUnitProcessingException failedToInstantiateClassFileTransformer(final String clazz, final Exception cause) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failedToInstantiateClassFileTransformer$str(), clazz), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noDeploymentRepositoryAvailable = "WFLYSRV0159: No deployment repository available.";
    protected String noDeploymentRepositoryAvailable$str() {
        return noDeploymentRepositoryAvailable;
    }
    @Override
    public final DeploymentUnitProcessingException noDeploymentRepositoryAvailable() {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), noDeploymentRepositoryAvailable$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String deploymentMountFailed = "WFLYSRV0160: Failed to mount deployment content";
    protected String deploymentMountFailed$str() {
        return deploymentMountFailed;
    }
    @Override
    public final DeploymentUnitProcessingException deploymentMountFailed(final IOException cause) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), deploymentMountFailed$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToGetManifest = "WFLYSRV0161: Failed to get manifest for deployment %s";
    protected String failedToGetManifest$str() {
        return failedToGetManifest;
    }
    @Override
    public final DeploymentUnitProcessingException failedToGetManifest(final VirtualFile file, final IOException cause) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failedToGetManifest$str(), file), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotMergeResourceRoot = "WFLYSRV0163: Cannot merge resource root for a different file. This: %s mergee: %s";
    protected String cannotMergeResourceRoot$str() {
        return cannotMergeResourceRoot;
    }
    @Override
    public final IllegalArgumentException cannotMergeResourceRoot(final VirtualFile file, final VirtualFile mergee) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotMergeResourceRoot$str(), file, mergee));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToCreateTempFileProvider = "WFLYSRV0164: Failed to create temp file provider";
    protected String failedToCreateTempFileProvider$str() {
        return failedToCreateTempFileProvider;
    }
    @Override
    public final RuntimeException failedToCreateTempFileProvider(final IOException cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failedToCreateTempFileProvider$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String resourceTooLarge = "WFLYSRV0165: Resource is too large to be a valid class file";
    protected String resourceTooLarge$str() {
        return resourceTooLarge;
    }
    @Override
    public final IOException resourceTooLarge() {
        final IOException result = new IOException(String.format(getLoggingLocale(), resourceTooLarge$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String subdeploymentNotFound = "WFLYSRV0166: Sub deployment %s in jboss-deployment-structure.xml was not found. Available sub deployments: %s";
    protected String subdeploymentNotFound$str() {
        return subdeploymentNotFound;
    }
    @Override
    public final DeploymentUnitProcessingException subdeploymentNotFound(final String path, final StringBuilder subdeployments) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), subdeploymentNotFound$str(), path, subdeployments));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String deploymentStructureFileNotFound = "WFLYSRV0167: No jboss-deployment-structure.xml file found at %s";
    protected String deploymentStructureFileNotFound$str() {
        return deploymentStructureFileNotFound;
    }
    @Override
    public final DeploymentUnitProcessingException deploymentStructureFileNotFound(final File file) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), deploymentStructureFileNotFound$str(), file));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorLoadingDeploymentStructureFile = "WFLYSRV0168: Error loading jboss-deployment-structure.xml from %s";
    protected String errorLoadingDeploymentStructureFile$str() {
        return errorLoadingDeploymentStructureFile;
    }
    @Override
    public final DeploymentUnitProcessingException errorLoadingDeploymentStructureFile(final String path, final XMLStreamException cause) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), errorLoadingDeploymentStructureFile$str(), path), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateSubdeploymentListing = "WFLYSRV0169: Sub deployment '%s' is listed twice in jboss-deployment-structure.xml";
    protected String duplicateSubdeploymentListing$str() {
        return duplicateSubdeploymentListing;
    }
    @Override
    public final XMLStreamException duplicateSubdeploymentListing(final String name) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), duplicateSubdeploymentListing$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidModuleName = "WFLYSRV0170: Additional module name '%s' is not valid. Names must start with 'deployment.'";
    protected String invalidModuleName$str() {
        return invalidModuleName;
    }
    @Override
    public final XMLStreamException invalidModuleName(final String name) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), invalidModuleName$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String externalResourceRootsNotSupported = "WFLYSRV0171: External resource roots not supported, resource roots may not start with a '/' : %s";
    protected String externalResourceRootsNotSupported$str() {
        return externalResourceRootsNotSupported;
    }
    @Override
    public final XMLStreamException externalResourceRootsNotSupported(final String path) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), externalResourceRootsNotSupported$str(), path));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedEndOfDocument = "WFLYSRV0172: Unexpected end of document";
    protected String unexpectedEndOfDocument$str() {
        return unexpectedEndOfDocument;
    }
    @Override
    public final XMLStreamException unexpectedEndOfDocument(final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), unexpectedEndOfDocument$str()), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingRequiredAttributes = "WFLYSRV0173: Missing one or more required attributes:%s";
    protected String missingRequiredAttributes$str() {
        return missingRequiredAttributes;
    }
    @Override
    public final XMLStreamException missingRequiredAttributes(final String missing, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), missingRequiredAttributes$str(), missing), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedContent = "WFLYSRV0174: Unexpected content of type '%s', name is '%s', text is: '%s'";
    protected String unexpectedContent$str() {
        return unexpectedContent;
    }
    @Override
    public final XMLStreamException unexpectedContent(final String kind, final QName name, final String text, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), unexpectedContent$str(), kind, name, text), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noMethodFound = "WFLYSRV0175: No method found with id: %s on class (or its super class) %s";
    protected String noMethodFound$str() {
        return noMethodFound;
    }
    @Override
    public final DeploymentUnitProcessingException noMethodFound(final MethodIdentifier method, final Class<?> clazz) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), noMethodFound$str(), method, clazz));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorGettingReflectiveInformation = "WFLYSRV0177: Error getting reflective information for %s with ClassLoader %s";
    protected String errorGettingReflectiveInformation$str() {
        return errorGettingReflectiveInformation;
    }
    @Override
    public final RuntimeException errorGettingReflectiveInformation(final Class<?> clazz, final ClassLoader cl, final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), errorGettingReflectiveInformation$str(), clazz, cl), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String externalModuleServiceAlreadyStarted = "WFLYSRV0178: External Module Service already started";
    protected String externalModuleServiceAlreadyStarted$str() {
        return externalModuleServiceAlreadyStarted;
    }
    @Override
    public final IllegalStateException externalModuleServiceAlreadyStarted() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), externalModuleServiceAlreadyStarted$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToLoadModule = "WFLYSRV0179: Failed to load module: %s";
    protected String failedToLoadModule$str() {
        return failedToLoadModule;
    }
    @Override
    public final StartException failedToLoadModule(final ModuleIdentifier module, final ModuleLoadException cause) {
        final StartException result = new StartException(String.format(getLoggingLocale(), failedToLoadModule$str(), module), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToResolveMulticastAddress = "WFLYSRV0187: Failed to get multicast address for %s";
    protected String failedToResolveMulticastAddress$str() {
        return failedToResolveMulticastAddress;
    }
    @Override
    public final OperationFailedException failedToResolveMulticastAddress(final UnknownHostException cause, final String address) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), failedToResolveMulticastAddress$str(), address), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToResolveMulticastAddressForRollback = "WFLYSRV0188: Failed to get multicast address for %s";
    protected String failedToResolveMulticastAddressForRollback$str() {
        return failedToResolveMulticastAddressForRollback;
    }
    @Override
    public final RuntimeException failedToResolveMulticastAddressForRollback(final UnknownHostException cause, final String address) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failedToResolveMulticastAddressForRollback$str(), address), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotAddMoreThanOneSocketBindingGroupForServerOrHost = "WFLYSRV0190: Cannot add more than one socket binding group. Add of '%s' attempted, but '%s' already exists";
    protected String cannotAddMoreThanOneSocketBindingGroupForServerOrHost$str() {
        return cannotAddMoreThanOneSocketBindingGroupForServerOrHost;
    }
    @Override
    public final OperationFailedException cannotAddMoreThanOneSocketBindingGroupForServerOrHost(final PathAddress wanted, final PathAddress existing) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotAddMoreThanOneSocketBindingGroupForServerOrHost$str(), wanted, existing));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotHaveBothInitialServerConfigAndServerConfig = "WFLYSRV0191: Can't use both --server-config and --initial-server-config";
    protected String cannotHaveBothInitialServerConfigAndServerConfig$str() {
        return cannotHaveBothInitialServerConfigAndServerConfig;
    }
    @Override
    public final IllegalArgumentException cannotHaveBothInitialServerConfigAndServerConfig() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotHaveBothInitialServerConfigAndServerConfig$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateJBossXmlNamespace = "WFLYSRV0192: Duplicate namespace %s in jboss-all.xml";
    protected String duplicateJBossXmlNamespace$str() {
        return duplicateJBossXmlNamespace;
    }
    @Override
    public final XMLStreamException duplicateJBossXmlNamespace(final QName namespace, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), duplicateJBossXmlNamespace$str(), namespace), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String equivalentNamespacesInJBossXml = "WFLYSRV0193: Two different versions of the same namespaces are present in jboss-all.xml, %s and %s are both present";
    protected String equivalentNamespacesInJBossXml$str() {
        return equivalentNamespacesInJBossXml;
    }
    @Override
    public final DeploymentUnitProcessingException equivalentNamespacesInJBossXml(final QName key, final QName s) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), equivalentNamespacesInJBossXml$str(), key, s));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorLoadingJBossXmlFile = "WFLYSRV0194: Error loading jboss-all.xml from %s";
    protected String errorLoadingJBossXmlFile$str() {
        return errorLoadingJBossXmlFile;
    }
    @Override
    public final DeploymentUnitProcessingException errorLoadingJBossXmlFile(final String path, final XMLStreamException e) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), errorLoadingJBossXmlFile$str(), path), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullModuleAttachment = "WFLYSRV0195: Cannot obtain required module for: %s";
    protected String nullModuleAttachment$str() {
        return nullModuleAttachment;
    }
    @Override
    public final IllegalStateException nullModuleAttachment(final DeploymentUnit depUnit) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), nullModuleAttachment$str(), depUnit));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String deploymentOverlayFailed = "WFLYSRV0196: Failed to get content for deployment overlay %s at %s";
    protected String deploymentOverlayFailed$str() {
        return deploymentOverlayFailed;
    }
    @Override
    public final DeploymentUnitProcessingException deploymentOverlayFailed(final Exception cause, final String contentOverlay, final String file) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), deploymentOverlayFailed$str(), contentOverlay, file), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSuchDeploymentOverlayContentAtBoot = "WFLYSRV0198: No deployment overlay content with hash %s is available in the deployment content repository for deployment overlay '%s' at location %s. This is a fatal boot error. To correct the problem, either restart with the --admin-only switch set and use the CLI to install the missing content or remove it from the configuration, or remove the deployment overlay from the xml configuration file and restart.";
    protected String noSuchDeploymentOverlayContentAtBoot$str() {
        return noSuchDeploymentOverlayContentAtBoot;
    }
    @Override
    public final OperationFailedException noSuchDeploymentOverlayContentAtBoot(final String contentHash, final String deploymentOverlayName, final String contentFile) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), noSuchDeploymentOverlayContentAtBoot$str(), contentHash, deploymentOverlayName, contentFile));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSuchDeploymentOverlayContent = "WFLYSRV0199: No deployment overlay content with hash %s is available in the deployment content repository.";
    protected String noSuchDeploymentOverlayContent$str() {
        return noSuchDeploymentOverlayContent;
    }
    @Override
    public final OperationFailedException noSuchDeploymentOverlayContent(final String hash) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), noSuchDeploymentOverlayContent$str(), hash));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToLoadFile = "WFLYSRV0200: Failed to read file %s";
    protected String failedToLoadFile$str() {
        return failedToLoadFile;
    }
    @Override
    public final OperationFailedException failedToLoadFile(final VirtualFile file, final IOException e) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), failedToLoadFile$str(), file), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotHaveMoreThanOneManagedContentItem = "WFLYSRV0201: Cannot have more than one of %s";
    protected String cannotHaveMoreThanOneManagedContentItem$str() {
        return cannotHaveMoreThanOneManagedContentItem;
    }
    @Override
    public final OperationFailedException cannotHaveMoreThanOneManagedContentItem(final java.util.Set<String> managedAttributes) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotHaveMoreThanOneManagedContentItem$str(), managedAttributes));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownContentItemKey = "WFLYSRV0202: Unknown content item key: %s";
    protected String unknownContentItemKey$str() {
        return unknownContentItemKey;
    }
    @Override
    public final OperationFailedException unknownContentItemKey(final String key) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), unknownContentItemKey$str(), key));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotMixUnmanagedAndManagedContentItems = "WFLYSRV0203: Cannot use %s when %s are used";
    protected String cannotMixUnmanagedAndManagedContentItems$str() {
        return cannotMixUnmanagedAndManagedContentItems;
    }
    @Override
    public final OperationFailedException cannotMixUnmanagedAndManagedContentItems(final java.util.Set<String> usedManaged, final java.util.Set<String> usedUnmanaged) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotMixUnmanagedAndManagedContentItems$str(), usedManaged, usedUnmanaged));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullParameter = "WFLYSRV0204: Null '%s'";
    protected String nullParameter$str() {
        return nullParameter;
    }
    @Override
    public final OperationFailedException nullParameter(final String name) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), nullParameter$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String runtimeNameMustBeUnique = "WFLYSRV0205: There is already a deployment called %s with the same runtime name %s";
    protected String runtimeNameMustBeUnique$str() {
        return runtimeNameMustBeUnique;
    }
    @Override
    public final OperationFailedException runtimeNameMustBeUnique(final String existingDeployment, final String runtimename) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), runtimeNameMustBeUnique$str(), existingDeployment, runtimename));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateDeploymentUnitProcessor = "WFLYSRV0206: Multiple deployment unit processors registered with priority %s and class %s";
    protected String duplicateDeploymentUnitProcessor$str() {
        return duplicateDeploymentUnitProcessor;
    }
    @Override
    public final IllegalStateException duplicateDeploymentUnitProcessor(final int priority, final Class aClass) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), duplicateDeploymentUnitProcessor$str(), priority, aClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void startingSubDeployment(final String deploymentUnitName) {
        super.log.logf(FQCN, INFO, null, startingSubDeployment$str(), deploymentUnitName);
    }
    private static final String startingSubDeployment = "WFLYSRV0207: Starting subdeployment (runtime-name: \"%s\")";
    protected String startingSubDeployment$str() {
        return startingSubDeployment;
    }
    @Override
    public final void stoppedSubDeployment(final String deploymentUnitName, final int elapsedTime) {
        super.log.logf(FQCN, INFO, null, stoppedSubDeployment$str(), deploymentUnitName, elapsedTime);
    }
    private static final String stoppedSubDeployment = "WFLYSRV0208: Stopped subdeployment (runtime-name: %s) in %dms";
    protected String stoppedSubDeployment$str() {
        return stoppedSubDeployment;
    }
    private static final String vaultModuleWithNoCode = "WFLYSRV0209: When specifying a 'module' you also need to specify the 'code'";
    protected String vaultModuleWithNoCode$str() {
        return vaultModuleWithNoCode;
    }
    @Override
    public final OperationFailedException vaultModuleWithNoCode() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), vaultModuleWithNoCode$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serverAlreadyPaused = "WFLYSRV0210: Server is already paused";
    protected String serverAlreadyPaused$str() {
        return serverAlreadyPaused;
    }
    @Override
    public final IllegalStateException serverAlreadyPaused() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), serverAlreadyPaused$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void suspendingServer(final long timeoutMillis) {
        super.log.logf(FQCN, INFO, null, suspendingServer$str(), timeoutMillis);
    }
    private static final String suspendingServer = "WFLYSRV0211: Suspending server with %d ms timeout.";
    protected String suspendingServer$str() {
        return suspendingServer;
    }
    @Override
    public final void resumingServer() {
        super.log.logf(FQCN, INFO, null, resumingServer$str());
    }
    private static final String resumingServer = "WFLYSRV0212: Resuming server";
    protected String resumingServer$str() {
        return resumingServer;
    }
    @Override
    public final void failedToConnectToHostController() {
        super.log.logf(FQCN, WARN, null, failedToConnectToHostController$str());
    }
    private static final String failedToConnectToHostController = "WFLYSRV0213: Failed to connect to host-controller, retrying.";
    protected String failedToConnectToHostController$str() {
        return failedToConnectToHostController;
    }
    @Override
    public final void failedToResume(final ServerActivity activity, final Exception cause) {
        super.log.logf(FQCN, ERROR, cause, failedToResume$str(), activity);
    }
    private static final String failedToResume = "WFLYSRV0215: Failed to resume activity %s. To resume normal operation it is recommended that you restart the server.";
    protected String failedToResume$str() {
        return failedToResume;
    }
    @Override
    public final void failedToCleanObsoleteContent(final String failure) {
        super.log.logf(FQCN, ERROR, null, failedToCleanObsoleteContent$str(), failure);
    }
    private static final String failedToCleanObsoleteContent = "WFLYSRV0216: Error cleaning obsolete content %s ";
    protected String failedToCleanObsoleteContent$str() {
        return failedToCleanObsoleteContent;
    }
    @Override
    public final void undeployingDeploymentHasBeenRedeployed(final String deploymentName) {
        super.log.logf(FQCN, WARN, null, undeployingDeploymentHasBeenRedeployed$str(), deploymentName);
    }
    private static final String undeployingDeploymentHasBeenRedeployed = "WFLYSRV0219: %s deployment has been re-deployed, its content will not be removed. You will need to restart it.";
    protected String undeployingDeploymentHasBeenRedeployed$str() {
        return undeployingDeploymentHasBeenRedeployed;
    }
    @Override
    public final void shutdownHookInvoked() {
        super.log.logf(FQCN, INFO, null, shutdownHookInvoked$str());
    }
    private static final String shutdownHookInvoked = "WFLYSRV0220: Server shutdown has been requested via an OS signal";
    protected String shutdownHookInvoked$str() {
        return shutdownHookInvoked;
    }
    @Override
    public final void deprecatedApiUsed(final String name, final ModuleIdentifier id) {
        super.log.logf(FQCN, WARN, null, deprecatedApiUsed$str(), name, id);
    }
    private static final String deprecatedApiUsed = "WFLYSRV0221: Deployment \"%s\" is using a deprecated module (\"%s\") which may be removed in future versions without notice.";
    protected String deprecatedApiUsed$str() {
        return deprecatedApiUsed;
    }
    private static final String illegalPermissionName = "WFLYSRV0222: Illegal permission name '%s'";
    protected String illegalPermissionName$str() {
        return illegalPermissionName;
    }
    @Override
    public final IllegalArgumentException illegalPermissionName(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalPermissionName$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String illegalPermissionActions = "WFLYSRV0223: Illegal permission actions '%s'";
    protected String illegalPermissionActions$str() {
        return illegalPermissionActions;
    }
    @Override
    public final IllegalArgumentException illegalPermissionActions(final String actions) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalPermissionActions$str(), actions));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void couldNotMountOverlay(final String path, final VirtualFile parent) {
        super.log.logf(FQCN, ERROR, null, couldNotMountOverlay$str(), path, parent);
    }
    private static final String couldNotMountOverlay = "WFLYSRV0224: Could not mount overlay %s as parent %s is not a directory";
    protected String couldNotMountOverlay$str() {
        return couldNotMountOverlay;
    }
    private static final String vaultReaderException = "WFLYSRV0227: Security exception accessing the vault";
    protected String vaultReaderException$str() {
        return vaultReaderException;
    }
    @Override
    public final VaultReaderException vaultReaderException(final Exception e) {
        final VaultReaderException result = new VaultReaderException(String.format(getLoggingLocale(), vaultReaderException$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void vaultNotInitializedException() {
        super.log.logf(FQCN, DEBUG, null, vaultNotInitializedException$str());
    }
    private static final String vaultNotInitializedException = "WFLYSRV0230: Vault is not initialized; resolution of vault expressions is not possible";
    protected String vaultNotInitializedException$str() {
        return vaultNotInitializedException;
    }
    private static final String couldNotObtainServerUuidFile = "WFLYSRV0231: Could not read or create the server UUID in file: %s";
    protected String couldNotObtainServerUuidFile$str() {
        return couldNotObtainServerUuidFile;
    }
    @Override
    public final IllegalStateException couldNotObtainServerUuidFile(final Throwable cause, final Path file) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), couldNotObtainServerUuidFile$str(), file), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotGetModuleInfo = "WFLYSRV0232: Could not get module info for module name: %s";
    protected String couldNotGetModuleInfo$str() {
        return couldNotGetModuleInfo;
    }
    @Override
    public final OperationFailedException couldNotGetModuleInfo(final String moduleName, final Throwable cause) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), couldNotGetModuleInfo$str(), moduleName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String deploymentUndeployedNotification = "WFLYSRV0233: Undeployed \"%s\" (runtime-name: \"%s\")";
    protected String deploymentUndeployedNotification$str() {
        return deploymentUndeployedNotification;
    }
    @Override
    public final String deploymentUndeployedNotification(final String managementName, final String deploymentUnitName) {
        return String.format(getLoggingLocale(), deploymentUndeployedNotification$str(), managementName, deploymentUnitName);
    }
    private static final String deploymentDeployedNotification = "WFLYSRV0234: Deployed \"%s\" (runtime-name : \"%s\")";
    protected String deploymentDeployedNotification$str() {
        return deploymentDeployedNotification;
    }
    @Override
    public final String deploymentDeployedNotification(final String managementName, final String deploymentUnitName) {
        return String.format(getLoggingLocale(), deploymentDeployedNotification$str(), managementName, deploymentUnitName);
    }
    @Override
    public final void securityManagerEnabled() {
        super.log.logf(FQCN, INFO, null, securityManagerEnabled$str());
    }
    private static final String securityManagerEnabled = "WFLYSRV0235: Security Manager is enabled";
    protected String securityManagerEnabled$str() {
        return securityManagerEnabled;
    }
    @Override
    public final void suspendingServerWithNoTimeout() {
        super.log.logf(FQCN, INFO, null, suspendingServerWithNoTimeout$str());
    }
    private static final String suspendingServerWithNoTimeout = "WFLYSRV0236: Suspending server with no timeout.";
    protected String suspendingServerWithNoTimeout$str() {
        return suspendingServerWithNoTimeout;
    }
    private static final String cannotBothHaveFalseUseCurrentConfigAndServerConfig = "WFLYSRV0237: It is not possible to use use-current-server-config=false while specifying a server-config";
    protected String cannotBothHaveFalseUseCurrentConfigAndServerConfig$str() {
        return cannotBothHaveFalseUseCurrentConfigAndServerConfig;
    }
    @Override
    public final OperationFailedException cannotBothHaveFalseUseCurrentConfigAndServerConfig() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotBothHaveFalseUseCurrentConfigAndServerConfig$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serverConfigForReloadNotFound = "WFLYSRV0238: server-config '%s' specified for reload could not be found";
    protected String serverConfigForReloadNotFound$str() {
        return serverConfigForReloadNotFound;
    }
    @Override
    public final OperationFailedException serverConfigForReloadNotFound(final String serverConfig) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), serverConfigForReloadNotFound$str(), serverConfig));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void aborting(final int code) {
        super.log.logf(FQCN, FATAL, null, aborting$str(), code);
    }
    private static final String aborting = "WFLYSRV0239: Aborting with exit code %d";
    protected String aborting$str() {
        return aborting;
    }
    @Override
    public final void shuttingDownInResponseToProcessControllerSignal() {
        super.log.logf(FQCN, INFO, null, shuttingDownInResponseToProcessControllerSignal$str());
    }
    private static final String shuttingDownInResponseToProcessControllerSignal = "WFLYSRV0240: ProcessController has signalled to shut down; shutting down";
    protected String shuttingDownInResponseToProcessControllerSignal$str() {
        return shuttingDownInResponseToProcessControllerSignal;
    }
    @Override
    public final void shuttingDownInResponseToManagementRequest(final String op) {
        super.log.logf(FQCN, INFO, null, shuttingDownInResponseToManagementRequest$str(), op);
    }
    private static final String shuttingDownInResponseToManagementRequest = "WFLYSRV0241: Shutting down in response to management operation '%s'";
    protected String shuttingDownInResponseToManagementRequest$str() {
        return shuttingDownInResponseToManagementRequest;
    }
    private static final String cannotExplodeDeploymentOfSelfContainedServer = "WFLYSRV0242: Cannot explode a deployment in a self-contained server";
    protected String cannotExplodeDeploymentOfSelfContainedServer$str() {
        return cannotExplodeDeploymentOfSelfContainedServer;
    }
    @Override
    public final OperationFailedException cannotExplodeDeploymentOfSelfContainedServer() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotExplodeDeploymentOfSelfContainedServer$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotExplodeUnmanagedDeployment = "WFLYSRV0243: Cannot explode an unmanaged deployment";
    protected String cannotExplodeUnmanagedDeployment$str() {
        return cannotExplodeUnmanagedDeployment;
    }
    @Override
    public final OperationFailedException cannotExplodeUnmanagedDeployment() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotExplodeUnmanagedDeployment$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotExplodeAlreadyExplodedDeployment = "WFLYSRV0244: Cannot explode an already exploded deployment";
    protected String cannotExplodeAlreadyExplodedDeployment$str() {
        return cannotExplodeAlreadyExplodedDeployment;
    }
    @Override
    public final OperationFailedException cannotExplodeAlreadyExplodedDeployment() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotExplodeAlreadyExplodedDeployment$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotExplodeEnabledDeployment = "WFLYSRV0245: Cannot explode an already deployed deployment";
    protected String cannotExplodeEnabledDeployment$str() {
        return cannotExplodeEnabledDeployment;
    }
    @Override
    public final OperationFailedException cannotExplodeEnabledDeployment() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotExplodeEnabledDeployment$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotAddContentToSelfContainedServer = "WFLYSRV0246: Cannot add content to a deployment in a self-contained server";
    protected String cannotAddContentToSelfContainedServer$str() {
        return cannotAddContentToSelfContainedServer;
    }
    @Override
    public final OperationFailedException cannotAddContentToSelfContainedServer() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotAddContentToSelfContainedServer$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotAddContentToUnmanagedDeployment = "WFLYSRV0247: Cannot add content to an unmanaged deployment";
    protected String cannotAddContentToUnmanagedDeployment$str() {
        return cannotAddContentToUnmanagedDeployment;
    }
    @Override
    public final OperationFailedException cannotAddContentToUnmanagedDeployment() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotAddContentToUnmanagedDeployment$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotAddContentToUnexplodedDeployment = "WFLYSRV0248: Cannot add content to an unexploded deployment";
    protected String cannotAddContentToUnexplodedDeployment$str() {
        return cannotAddContentToUnexplodedDeployment;
    }
    @Override
    public final OperationFailedException cannotAddContentToUnexplodedDeployment() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotAddContentToUnexplodedDeployment$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void couldNotCopyFiles(final Exception ex, final String managementName) {
        super.log.logf(FQCN, ERROR, ex, couldNotCopyFiles$str(), managementName);
    }
    private static final String couldNotCopyFiles = "WFLYSRV0249: Could not copy files from the managed content repository to the running deployment for %s";
    protected String couldNotCopyFiles$str() {
        return couldNotCopyFiles;
    }
    private static final String cannotRemoveContentFromSelfContainedServer = "WFLYSRV0250: Cannot remove content from a deployment in a self-contained server";
    protected String cannotRemoveContentFromSelfContainedServer$str() {
        return cannotRemoveContentFromSelfContainedServer;
    }
    @Override
    public final OperationFailedException cannotRemoveContentFromSelfContainedServer() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotRemoveContentFromSelfContainedServer$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotRemoveContentFromUnmanagedDeployment = "WFLYSRV0251: Cannot remove content from an unmanaged deployment";
    protected String cannotRemoveContentFromUnmanagedDeployment$str() {
        return cannotRemoveContentFromUnmanagedDeployment;
    }
    @Override
    public final OperationFailedException cannotRemoveContentFromUnmanagedDeployment() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotRemoveContentFromUnmanagedDeployment$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotRemoveContentFromUnexplodedDeployment = "WFLYSRV0252: Cannot remove content from an unexploded deployment";
    protected String cannotRemoveContentFromUnexplodedDeployment$str() {
        return cannotRemoveContentFromUnexplodedDeployment;
    }
    @Override
    public final OperationFailedException cannotRemoveContentFromUnexplodedDeployment() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotRemoveContentFromUnexplodedDeployment$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void couldNotDeleteFile(final Exception ex, final String path, final String managementName) {
        super.log.logf(FQCN, ERROR, ex, couldNotDeleteFile$str(), path, managementName);
    }
    private static final String couldNotDeleteFile = "WFLYSRV0253: Could not delete file %s from the running deployment %s";
    protected String couldNotDeleteFile$str() {
        return couldNotDeleteFile;
    }
    private static final String cannotReadContentFromSelfContainedServer = "WFLYSRV0254: Cannot read content from a deployment in a self-contained server";
    protected String cannotReadContentFromSelfContainedServer$str() {
        return cannotReadContentFromSelfContainedServer;
    }
    @Override
    public final OperationFailedException cannotReadContentFromSelfContainedServer() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotReadContentFromSelfContainedServer$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotReadContentFromUnmanagedDeployment = "WFLYSRV0255: Cannot read content from an unmanaged deployment";
    protected String cannotReadContentFromUnmanagedDeployment$str() {
        return cannotReadContentFromUnmanagedDeployment;
    }
    @Override
    public final OperationFailedException cannotReadContentFromUnmanagedDeployment() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotReadContentFromUnmanagedDeployment$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String requiredSystemPropertyMissing = "WFLYSRV0257: Required system property '%s' not set";
    protected String requiredSystemPropertyMissing$str() {
        return requiredSystemPropertyMissing;
    }
    @Override
    public final IllegalArgumentException requiredSystemPropertyMissing(final String propName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), requiredSystemPropertyMissing$str(), propName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotExplodeSubDeploymentOfUnexplodedDeployment = "WFLYSRV0258: Cannot explode a subdeployment of an unexploded deployment";
    protected String cannotExplodeSubDeploymentOfUnexplodedDeployment$str() {
        return cannotExplodeSubDeploymentOfUnexplodedDeployment;
    }
    @Override
    public final OperationFailedException cannotExplodeSubDeploymentOfUnexplodedDeployment() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotExplodeSubDeploymentOfUnexplodedDeployment$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String secureSocketBindingRequiresSSLContext = "WFLYSRV0259: If attribute secure-socket-binding is defined one of ssl-context or security-realm must also be defined";
    protected String secureSocketBindingRequiresSSLContext$str() {
        return secureSocketBindingRequiresSSLContext;
    }
    @Override
    public final OperationFailedException secureSocketBindingRequiresSSLContext() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), secureSocketBindingRequiresSSLContext$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void startingServerSuspended() {
        super.log.logf(FQCN, INFO, null, startingServerSuspended$str());
    }
    private static final String startingServerSuspended = "WFLYSRV0260: Starting server in suspended mode";
    protected String startingServerSuspended$str() {
        return startingServerSuspended;
    }
    private static final String bootComplete = "WFLYSRV0261: Boot complete";
    protected String bootComplete$str() {
        return bootComplete;
    }
    @Override
    public final String bootComplete() {
        return String.format(getLoggingLocale(), bootComplete$str());
    }
    private static final String cannotSetBothAdminOnlyAndStartMode = "WFLYSRV0262: You cannot set both --start-mode and --admin-only";
    protected String cannotSetBothAdminOnlyAndStartMode$str() {
        return cannotSetBothAdminOnlyAndStartMode;
    }
    @Override
    public final String cannotSetBothAdminOnlyAndStartMode() {
        return String.format(getLoggingLocale(), cannotSetBothAdminOnlyAndStartMode$str());
    }
    private static final String unknownStartMode = "WFLYSRV0263: Unknown start mode %s";
    protected String unknownStartMode$str() {
        return unknownStartMode;
    }
    @Override
    public final String unknownStartMode(final String value) {
        return String.format(getLoggingLocale(), unknownStartMode$str(), value);
    }
    private static final String cannotSpecifyBothAdminOnlyAndStartMode = "WFLYSRV0264: Cannot specify both admin-only and start-mode";
    protected String cannotSpecifyBothAdminOnlyAndStartMode$str() {
        return cannotSpecifyBothAdminOnlyAndStartMode;
    }
    @Override
    public final OperationFailedException cannotSpecifyBothAdminOnlyAndStartMode() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotSpecifyBothAdminOnlyAndStartMode$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void invalidPoolCoreSize(final String val, final String configSysProp) {
        super.log.logf(FQCN, WARN, null, invalidPoolCoreSize$str(), val, configSysProp);
    }
    private static final String invalidPoolCoreSize = "WFLYSRV0265: Invalid value '%s' for system property '%s' -- value must be a non-negative integer";
    protected String invalidPoolCoreSize$str() {
        return invalidPoolCoreSize;
    }
    @Override
    public final void serverHomeMismatch(final Path passed, final Path real) {
        super.log.logf(FQCN, WARN, null, serverHomeMismatch$str(), passed, real);
    }
    private static final String serverHomeMismatch = "WFLYSRV0266: Server home is set to '%s', but server real home is '%s' - unpredictable results may occur.";
    protected String serverHomeMismatch$str() {
        return serverHomeMismatch;
    }
    private static final String processStateChangeNotificationDescription = "Notification emitted when the process state changes";
    protected String processStateChangeNotificationDescription$str() {
        return processStateChangeNotificationDescription;
    }
    @Override
    public final String processStateChangeNotificationDescription() {
        return String.format(getLoggingLocale(), processStateChangeNotificationDescription$str());
    }
    private static final String jmxAttributeChange = "The attribute '%s' has changed from '%s' to '%s'";
    protected String jmxAttributeChange$str() {
        return jmxAttributeChange;
    }
    @Override
    public final String jmxAttributeChange(final String name, final String oldState, final String stateString) {
        return String.format(getLoggingLocale(), jmxAttributeChange$str(), name, oldState, stateString);
    }
}
