/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.parsing;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.server.controller.resources.VaultResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

class VaultXml {
    VaultXml() {
    }

    void parseVault(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        switch (expectedNs) {
            case DOMAIN_1_0: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            case DOMAIN_1_1: 
            case DOMAIN_1_2: 
            case DOMAIN_1_3: 
            case DOMAIN_1_4: 
            case DOMAIN_1_5: {
                this.parseVault_1_1(reader, address, expectedNs, list);
                break;
            }
            default: {
                if (expectedNs.getMajorVersion() == 2) {
                    this.parseVault_1_1(reader, address, expectedNs, list);
                    break;
                }
                this.parseVault_1_6_and_3_0(reader, address, expectedNs, list);
            }
        }
    }

    private void parseVault_1_1(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        int vaultAttribCount = reader.getAttributeCount();
        ModelNode vault = new ModelNode();
        String code = null;
        block6: for (int i = 0; i < vaultAttribCount; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case CODE: {
                    VaultResourceDefinition.CODE.parseAndSetParameter(value, vault, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ModelNode vaultAddress = address.clone();
        vaultAddress.add("core-service", "vault");
        if (code != null) {
            vault.get(Attribute.CODE.getLocalName()).set(code);
        }
        vault.get("address").set(vaultAddress);
        vault.get("operation").set("add");
        while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case VAULT_OPTION: {
                    this.parseModuleOption(reader, vault.get("vault-options"));
                }
            }
        }
        list.add(vault);
    }

    private void parseVault_1_6_and_3_0(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        int vaultAttribCount = reader.getAttributeCount();
        ModelNode vault = new ModelNode();
        String code = null;
        block7: for (int i = 0; i < vaultAttribCount; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case CODE: {
                    VaultResourceDefinition.CODE.parseAndSetParameter(value, vault, (XMLStreamReader)reader);
                    continue block7;
                }
                case MODULE: {
                    VaultResourceDefinition.MODULE.parseAndSetParameter(value, vault, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ModelNode vaultAddress = address.clone();
        vaultAddress.add("core-service", "vault");
        if (code != null) {
            vault.get(Attribute.CODE.getLocalName()).set(code);
        }
        vault.get("address").set(vaultAddress);
        vault.get("operation").set("add");
        while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case VAULT_OPTION: {
                    this.parseModuleOption(reader, vault.get("vault-options"));
                }
            }
        }
        list.add(vault);
    }

    private void parseVaultOption(XMLExtendedStreamReader reader, ModelNode vaultOptions) throws XMLStreamException {
        String name = null;
        String val = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.VALUE);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block4;
                }
                case VALUE: {
                    val = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        vaultOptions.get(name).set(val);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseModuleOption(XMLExtendedStreamReader reader, ModelNode moduleOptions) throws XMLStreamException {
        String name = null;
        String val = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.VALUE);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block4;
                }
                case VALUE: {
                    val = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        moduleOptions.add(name, val);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    void writeVault(XMLExtendedStreamWriter writer, ModelNode vault) throws XMLStreamException {
        writer.writeStartElement(Element.VAULT.getLocalName());
        VaultResourceDefinition.CODE.marshallAsAttribute(vault, (XMLStreamWriter)writer);
        VaultResourceDefinition.MODULE.marshallAsAttribute(vault, (XMLStreamWriter)writer);
        if (vault.hasDefined("vault-options")) {
            ModelNode properties = vault.get("vault-options");
            for (Property prop : properties.asPropertyList()) {
                writer.writeEmptyElement(Element.VAULT_OPTION.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), prop.getName());
                writer.writeAttribute(Attribute.VALUE.getLocalName(), prop.getValue().asString());
            }
        }
        writer.writeEndElement();
    }
}

