/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.jboss.as.threads.ManagedExecutorService;
import org.jboss.as.threads.TimeSpec;
import org.jboss.threads.EnhancedQueueExecutor;
import org.jboss.threads.EventListener;
import org.jboss.threads.SimpleShutdownListenable;

class ManagedEnhancedQueueExecutor
extends ManagedExecutorService {
    private final EnhancedQueueExecutor executor;
    private final SimpleShutdownListenable shutdownListenable = new SimpleShutdownListenable();

    ManagedEnhancedQueueExecutor(EnhancedQueueExecutor executor) {
        super((ExecutorService)executor);
        this.executor = executor;
    }

    @Override
    void internalShutdown() {
        this.executor.shutdown();
        this.shutdownListenable.shutdown();
    }

    int getCoreThreads() {
        return this.executor.getCorePoolSize();
    }

    void setCoreThreads(int coreThreads) {
        this.executor.setCorePoolSize(coreThreads);
    }

    boolean isAllowCoreTimeout() {
        return this.executor.allowsCoreThreadTimeOut();
    }

    void setAllowCoreTimeout(boolean allowCoreTimeout) {
        this.executor.allowCoreThreadTimeOut(allowCoreTimeout);
    }

    int getMaxThreads() {
        return this.executor.getMaximumPoolSize();
    }

    void setMaxThreads(int maxThreads) {
        this.executor.setMaximumPoolSize(maxThreads);
    }

    long getKeepAlive() {
        return this.executor.getKeepAliveTime(TimeUnit.MILLISECONDS);
    }

    void setKeepAlive(TimeSpec keepAlive) {
        this.executor.setKeepAliveTime(keepAlive.getDuration(), keepAlive.getUnit());
    }

    int getRejectedCount() {
        return (int)this.executor.getRejectedTaskCount();
    }

    long getTaskCount() {
        return this.executor.getSubmittedTaskCount();
    }

    int getLargestThreadCount() {
        return this.executor.getLargestPoolSize();
    }

    int getLargestPoolSize() {
        return this.executor.getLargestPoolSize();
    }

    int getCurrentThreadCount() {
        return this.executor.getPoolSize();
    }

    long getCompletedTaskCount() {
        return this.executor.getCompletedTaskCount();
    }

    int getActiveCount() {
        return this.executor.getActiveCount();
    }

    int getQueueSize() {
        return this.executor.getQueueSize();
    }

    <A> void addShutdownListener(EventListener<A> shutdownListener, A attachment) {
        this.shutdownListenable.addShutdownListener(shutdownListener, attachment);
    }
}

