/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.as.threads.ManagedEnhancedQueueExecutor;
import org.jboss.as.threads.ManagedQueueExecutorService;
import org.jboss.as.threads.ThreadsLogger;
import org.jboss.as.threads.TimeSpec;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.EnhancedQueueExecutor;

class EnhancedQueueExecutorService
implements Service<ManagedQueueExecutorService> {
    private final InjectedValue<ThreadFactory> threadFactoryValue = new InjectedValue();
    private final InjectedValue<Executor> handoffExecutorValue = new InjectedValue();
    private ManagedEnhancedQueueExecutor executor;
    private int maxThreads;
    private int coreThreads;
    private final int queueLength;
    private TimeSpec keepAlive;
    private boolean allowCoreThreadTimeout;
    private final boolean blocking;

    EnhancedQueueExecutorService(int maxThreads, TimeSpec keepAlive, boolean blocking) {
        this(false, maxThreads, 0, Integer.MAX_VALUE, keepAlive, blocking);
    }

    EnhancedQueueExecutorService(boolean allowCoreThreadTimeout, int maxThreads, int coreThreads, int queueLength, TimeSpec keepAlive, boolean blocking) {
        this.maxThreads = maxThreads;
        this.coreThreads = coreThreads;
        this.queueLength = queueLength;
        this.keepAlive = keepAlive;
        this.allowCoreThreadTimeout = allowCoreThreadTimeout;
        this.blocking = blocking;
    }

    public synchronized void start(StartContext context) {
        TimeSpec keepAliveSpec = this.keepAlive;
        long keepAliveTime = keepAliveSpec == null ? Long.MAX_VALUE : keepAliveSpec.getUnit().toNanos(keepAliveSpec.getDuration());
        EnhancedQueueExecutor.Builder executorBuilder = new EnhancedQueueExecutor.Builder().setMaximumPoolSize(this.maxThreads).setCorePoolSize(this.coreThreads > 0 ? this.coreThreads : this.maxThreads).setMaximumQueueSize(this.queueLength).setKeepAliveTime(keepAliveTime, TimeUnit.NANOSECONDS).setThreadFactory((ThreadFactory)this.threadFactoryValue.getValue()).allowCoreThreadTimeOut(this.allowCoreThreadTimeout);
        Executor handoffExecutor = (Executor)this.handoffExecutorValue.getOptionalValue();
        if (handoffExecutor != null) {
            executorBuilder.setHandoffExecutor(handoffExecutor);
        }
        EnhancedQueueExecutor enhancedQueueExecutor = executorBuilder.build();
        this.executor = new ManagedEnhancedQueueExecutor(enhancedQueueExecutor, this.blocking);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(StopContext context) {
        ManagedEnhancedQueueExecutor executor;
        EnhancedQueueExecutorService enhancedQueueExecutorService = this;
        synchronized (enhancedQueueExecutorService) {
            executor = this.executor;
            this.executor = null;
        }
        context.asynchronous();
        executor.internalShutdown(context);
    }

    public synchronized ManagedQueueExecutorService getValue() throws IllegalStateException {
        ManagedEnhancedQueueExecutor value = this.executor;
        if (value == null) {
            throw ThreadsLogger.ROOT_LOGGER.enhancedQueueExecutorUninitialized();
        }
        return value;
    }

    Injector<ThreadFactory> getThreadFactoryInjector() {
        return this.threadFactoryValue;
    }

    Injector<Executor> getHandoffExecutorInjector() {
        return this.handoffExecutorValue;
    }

    synchronized void setMaxThreads(int maxThreads) {
        ManagedEnhancedQueueExecutor executor = this.executor;
        if (executor != null) {
            executor.setMaxThreads(maxThreads);
        }
        this.maxThreads = maxThreads;
    }

    synchronized void setCoreThreads(int coreThreads) {
        ManagedEnhancedQueueExecutor executor = this.executor;
        if (executor != null) {
            executor.setCoreThreads(coreThreads);
        }
        this.coreThreads = coreThreads;
    }

    synchronized void setKeepAlive(TimeSpec keepAlive) {
        this.keepAlive = keepAlive;
        ManagedEnhancedQueueExecutor executor = this.executor;
        if (executor != null) {
            executor.setKeepAlive(keepAlive);
        }
    }

    synchronized void setAllowCoreTimeout(boolean allowCoreThreadTimeout) {
        ManagedEnhancedQueueExecutor executor = this.executor;
        if (executor != null) {
            executor.setAllowCoreTimeout(allowCoreThreadTimeout);
        }
        this.allowCoreThreadTimeout = allowCoreThreadTimeout;
    }

    int getActiveCount() {
        ManagedQueueExecutorService executor = this.getValue();
        return executor.getActiveCount();
    }

    long getCompletedTaskCount() {
        ManagedQueueExecutorService executor = this.getValue();
        return executor.getCompletedTaskCount();
    }

    int getCurrentThreadCount() {
        ManagedQueueExecutorService executor = this.getValue();
        return executor.getCurrentThreadCount();
    }

    int getLargestPoolSize() {
        ManagedQueueExecutorService executor = this.getValue();
        return executor.getLargestPoolSize();
    }

    int getLargestThreadCount() {
        ManagedQueueExecutorService executor = this.getValue();
        return executor.getLargestThreadCount();
    }

    int getRejectedCount() {
        ManagedQueueExecutorService executor = this.getValue();
        return executor.getRejectedCount();
    }

    long getTaskCount() {
        ManagedQueueExecutorService executor = this.getValue();
        return executor.getTaskCount();
    }

    int getQueueSize() {
        ManagedQueueExecutorService executor = this.getValue();
        return executor.getQueueSize();
    }

    TimeUnit getKeepAliveUnit() {
        return this.keepAlive == null ? TimeSpec.DEFAULT_KEEPALIVE.getUnit() : this.keepAlive.getUnit();
    }
}

