/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.transformer;

import java.io.IOException;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.extras.transformer.ArchiveTransformer;
import org.wildfly.extras.transformer.Config;

public abstract class TransformerBuilder {
    private final Thread thread = Thread.currentThread();
    protected final Map<Config, String> configs = new HashMap<Config, String>();
    protected Boolean verbose;
    private boolean built;

    protected TransformerBuilder() {
    }

    public final TransformerBuilder setConfiguration(Config configType, String configLocation) {
        if (this.thread != Thread.currentThread()) {
            throw new ConcurrentModificationException("Builder instance used by multiple threads");
        }
        if (this.built) {
            throw new IllegalStateException("Builder instance have been already closed");
        }
        if (configType == null) {
            throw new IllegalArgumentException("Parameter cannot be null");
        }
        if (configLocation == null || "".equals(configLocation)) {
            throw new IllegalArgumentException("Parameter cannot be neither null nor empty string");
        }
        if (this.configs.containsKey((Object)configType)) {
            throw new IllegalStateException("This method can be called only once for given configuration type");
        }
        this.configs.put(configType, configLocation);
        return this;
    }

    public final TransformerBuilder setVerbose(boolean verbose) {
        if (this.thread != Thread.currentThread()) {
            throw new ConcurrentModificationException("Builder instance used by multiple threads");
        }
        if (this.built) {
            throw new IllegalStateException("Builder instance have been already closed");
        }
        if (this.verbose != null) {
            throw new IllegalStateException("This method can be called only once");
        }
        this.verbose = verbose;
        return this;
    }

    public final ArchiveTransformer build() throws IOException {
        if (this.thread != Thread.currentThread()) {
            throw new ConcurrentModificationException("Builder instance used by multiple threads");
        }
        if (this.built) {
            throw new IllegalStateException("Builder instance have been already closed");
        }
        this.built = true;
        return this.buildInternal();
    }

    protected abstract ArchiveTransformer buildInternal() throws IOException;
}

