/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.transformer;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.wildfly.extras.transformer.Config;
import org.wildfly.extras.transformer.ResourceTransformer;

public abstract class ArchiveTransformer {
    protected final Map<Config, String> configs;
    protected final boolean verbose;

    protected ArchiveTransformer(Map<Config, String> configs, boolean verbose) {
        this.configs = configs;
        this.verbose = verbose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transform(File inJarFile, File outJarFile) throws IOException {
        boolean transformed = false;
        File dir = outJarFile.getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Couldn't create directory: " + dir.getAbsolutePath());
        }
        if (!outJarFile.createNewFile()) {
            throw new IOException("Couldn't create file: " + outJarFile.getAbsolutePath());
        }
        ResourceTransformer t = this.newResourceTransformer();
        Calendar calendar = Calendar.getInstance();
        JarFile jar = null;
        JarOutputStream jarOutputStream = null;
        try {
            jar = new JarFile(inJarFile);
            jarOutputStream = new JarOutputStream(new FileOutputStream(outJarFile));
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                JarEntry inJarEntry = e.nextElement();
                if (inJarEntry.getSize() == 0L) continue;
                if (inJarEntry.getSize() < 0L) {
                    throw new UnsupportedOperationException("File size " + inJarEntry.getName() + " unknown! File size must be positive number");
                }
                if (inJarEntry.getSize() > Integer.MAX_VALUE) {
                    throw new UnsupportedOperationException("File " + inJarEntry.getName() + " too big! Maximum allowed file size is " + Integer.MAX_VALUE + " bytes");
                }
                byte[] buffer = new byte[(int)inJarEntry.getSize()];
                ArchiveTransformer.readBytes(jar.getInputStream(inJarEntry), buffer, true);
                ResourceTransformer.Resource oldResource = new ResourceTransformer.Resource(inJarEntry.getName(), buffer);
                ResourceTransformer.Resource[] newResources = t.transform(oldResource);
                if (newResources.length == 0) {
                    newResources = new ResourceTransformer.Resource[]{oldResource};
                } else {
                    transformed = true;
                }
                for (ResourceTransformer.Resource newResource : newResources) {
                    JarEntry outJarEntry = new JarEntry(newResource.getName());
                    outJarEntry.setSize(newResource.getData().length);
                    outJarEntry.setTime(calendar.getTimeInMillis());
                    jarOutputStream.putNextEntry(outJarEntry);
                    ArchiveTransformer.writeBytes(jarOutputStream, newResource.getData(), false);
                    jarOutputStream.closeEntry();
                }
            }
        }
        catch (Throwable throwable) {
            ArchiveTransformer.safeClose(jar);
            ArchiveTransformer.safeClose(jarOutputStream);
            throw throwable;
        }
        ArchiveTransformer.safeClose(jar);
        ArchiveTransformer.safeClose(jarOutputStream);
        return transformed;
    }

    protected ResourceTransformer newResourceTransformer() throws IOException {
        throw new UnsupportedOperationException();
    }

    private static void safeClose(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readBytes(InputStream is, byte[] clazz, boolean closeStream) throws IOException {
        try {
            for (int offset = 0; offset < clazz.length; offset += is.read(clazz, offset, clazz.length - offset)) {
            }
        }
        finally {
            if (closeStream) {
                ArchiveTransformer.safeClose(is);
            }
        }
    }

    private static void writeBytes(OutputStream os, byte[] clazz, boolean closeStream) throws IOException {
        try {
            os.write(clazz);
        }
        finally {
            if (closeStream) {
                ArchiveTransformer.safeClose(os);
            }
        }
    }
}

