/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.transformer.asm;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.ConstantDynamic;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.wildfly.extras.transformer.ResourceTransformer;
import org.wildfly.extras.transformer.asm.ReflectionModel;

final class ResourceTransformerImpl
extends ResourceTransformer {
    private static final ResourceTransformer.Resource[] EMPTY_ARRAY = new ResourceTransformer.Resource[0];
    private static final String CLASS_SUFFIX = ".class";
    private static final int CLASS_SUFFIX_LENGTH = ".class".length();
    private static final String XML_SUFFIX = ".xml";
    private static final String TLD_SUFFIX = ".tld";
    private static final String JSP_SUFFIX = ".jsp";
    private static final String META_INF_SERVICES_PREFIX = "META-INF/services/";
    private static final String CLASS_FOR_NAME_PRIVATE_METHOD = "org_wildfly_tranformer_asm_classForName_String__boolean_ClassLoader";
    private static final String REFLECTIONMODEL_INTERNAL_NAME = ReflectionModel.class.getName().replace('.', '/');
    private static final String CLASS_OBJECT = "java/lang/Class";
    private static final String FORNAME_METHOD = "forName";
    private static final String MAP_OBJECT = "java/util/Map";
    private static final String MAP_PUT_METHOD = "put";
    private static final String MAP_PUT_METHOD_DESC = "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;";
    private static final String MAP_GET_METHOD = "get";
    private boolean classTransformed;
    private String changeClassName;
    final Set<String> generatedReflectionModelHandlingCode = new CopyOnWriteArraySet<String>();

    ResourceTransformerImpl(File configsDir, boolean verbose, boolean invert) throws IOException {
        super(configsDir, verbose, invert);
    }

    private ResourceTransformer.Resource[] transform(String newResourceName, byte[] clazz) {
        ResourceTransformer.Resource[] resourceArray;
        final Object[] generatedExtraClass = new Object[2];
        final ClassReader classReader = new ClassReader(clazz);
        ClassWriter classWriter = new ClassWriter(classReader, 0);
        classReader.accept(new ClassVisitor(458752, (ClassVisitor)classWriter){

            public void visitOuterClass(String owner, String name, String descriptor) {
                super.visitOuterClass(owner, name, ResourceTransformerImpl.this.replaceJavaXwithJakarta(descriptor));
            }

            public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
                AnnotationVisitor av = super.visitTypeAnnotation(typeRef, typePath, ResourceTransformerImpl.this.replaceJavaXwithJakarta(descriptor), visible);
                return new MyAnnotationVisitor(av);
            }

            public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                AnnotationVisitor av = super.visitAnnotation(ResourceTransformerImpl.this.replaceJavaXwithJakarta(descriptor), visible);
                return new MyAnnotationVisitor(av);
            }

            public void visitAttribute(Attribute attribute) {
                super.visitAttribute(attribute);
            }

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                signature = ResourceTransformerImpl.this.replaceJavaXwithJakarta(signature);
                if (ResourceTransformerImpl.this.changeClassName != null) {
                    name = ResourceTransformerImpl.this.changeClassName;
                    ResourceTransformerImpl.this.changeClassName = null;
                }
                superName = ResourceTransformerImpl.this.replaceJavaXwithJakarta(superName);
                for (int index = 0; index < interfaces.length; ++index) {
                    interfaces[index] = ResourceTransformerImpl.this.replaceJavaXwithJakarta(interfaces[index]);
                }
                super.visit(version, access, name, signature, superName, interfaces);
            }

            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                signature = ResourceTransformerImpl.this.replaceJavaXwithJakarta(signature);
                desc = ResourceTransformerImpl.this.replaceJavaXwithJakarta(desc);
                FieldVisitor fv = super.visitField(access, name, desc, signature, value);
                return new FieldVisitor(this.api, fv){

                    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                        descriptor = ResourceTransformerImpl.this.replaceJavaXwithJakarta(descriptor);
                        AnnotationVisitor av = this.fv.visitAnnotation(descriptor, visible);
                        return new MyAnnotationVisitor(av);
                    }

                    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
                        descriptor = ResourceTransformerImpl.this.replaceJavaXwithJakarta(descriptor);
                        AnnotationVisitor av = this.fv.visitTypeAnnotation(typeRef, typePath, descriptor, visible);
                        return new MyAnnotationVisitor(av);
                    }
                };
            }

            public void visitEnd() {
                super.visitEnd();
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if (signature != null) {
                    signature = ResourceTransformerImpl.this.replaceJavaXwithJakarta(signature);
                }
                desc = ResourceTransformerImpl.this.replaceJavaXwithJakarta(desc);
                if (exceptions != null) {
                    for (int looper = 0; looper < exceptions.length; ++looper) {
                        exceptions[looper] = ResourceTransformerImpl.this.replaceJavaXwithJakarta(exceptions[looper]);
                    }
                }
                return new MethodVisitor(393216, super.visitMethod(access, name, desc, signature, exceptions)){

                    public void visitFrame(int type, int numLocal, Object[] local, int numStack, Object[] stack) {
                        int innerLooper;
                        String value;
                        int looper;
                        Object[] modifiedLocal = null;
                        Object[] modifiedStack = null;
                        for (looper = 0; looper < numLocal; ++looper) {
                            if (!(local[looper] instanceof String)) continue;
                            value = ResourceTransformerImpl.this.replaceJavaXwithJakarta((String)local[looper]);
                            if (local[looper] == null || local[looper].equals(value)) continue;
                            if (modifiedLocal == null) {
                                modifiedLocal = new Object[numLocal];
                                for (innerLooper = 0; innerLooper < numLocal; ++innerLooper) {
                                    modifiedLocal[innerLooper] = local[innerLooper];
                                }
                            }
                            modifiedLocal[looper] = value;
                        }
                        for (looper = 0; looper < numStack; ++looper) {
                            if (!(stack[looper] instanceof String)) continue;
                            value = ResourceTransformerImpl.this.replaceJavaXwithJakarta((String)stack[looper]);
                            if (stack[looper] == null || stack[looper].equals(value)) continue;
                            if (modifiedStack == null) {
                                modifiedStack = new Object[numStack];
                                for (innerLooper = 0; innerLooper < numStack; ++innerLooper) {
                                    modifiedStack[innerLooper] = stack[innerLooper];
                                }
                            }
                            modifiedStack[looper] = value;
                        }
                        super.visitFrame(type, numLocal, modifiedLocal != null ? modifiedLocal : local, numStack, modifiedStack != null ? modifiedStack : stack);
                    }

                    public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
                        return super.visitParameterAnnotation(parameter, ResourceTransformerImpl.this.replaceJavaXwithJakarta(descriptor), visible);
                    }

                    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
                        super.visitTryCatchBlock(start, end, handler, ResourceTransformerImpl.this.replaceJavaXwithJakarta(type));
                    }

                    public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
                        descriptor = ResourceTransformerImpl.this.replaceJavaXwithJakarta(descriptor);
                        return new MyAnnotationVisitor(this.mv.visitInsnAnnotation(typeRef, typePath, descriptor, visible));
                    }

                    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String descriptor, boolean visible) {
                        descriptor = ResourceTransformerImpl.this.replaceJavaXwithJakarta(descriptor);
                        return new MyAnnotationVisitor(this.mv.visitLocalVariableAnnotation(typeRef, typePath, start, end, index, descriptor, visible));
                    }

                    public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
                        descriptor = ResourceTransformerImpl.this.replaceJavaXwithJakarta(descriptor);
                        super.visitMultiANewArrayInsn(descriptor, numDimensions);
                    }

                    public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
                        descriptor = ResourceTransformerImpl.this.replaceJavaXwithJakarta(descriptor);
                        return new MyAnnotationVisitor(this.mv.visitTryCatchAnnotation(typeRef, typePath, descriptor, visible));
                    }

                    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
                        descriptor = ResourceTransformerImpl.this.replaceJavaXwithJakarta(descriptor);
                        AnnotationVisitor av = this.mv.visitTypeAnnotation(typeRef, typePath, descriptor, visible);
                        return new MyAnnotationVisitor(av);
                    }

                    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                        descriptor = ResourceTransformerImpl.this.replaceJavaXwithJakarta(descriptor);
                        AnnotationVisitor av = this.mv.visitAnnotation(descriptor, visible);
                        return new MyAnnotationVisitor(av);
                    }

                    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                        desc = ResourceTransformerImpl.this.replaceJavaXwithJakarta(desc);
                        owner = ResourceTransformerImpl.this.replaceJavaXwithJakarta(owner);
                        if (opcode == 184 && owner.equals(ResourceTransformerImpl.CLASS_OBJECT) && name.equals(ResourceTransformerImpl.FORNAME_METHOD)) {
                            owner = this.transformerClassPackageName();
                            owner = owner != null ? owner + "/" + ResourceTransformerImpl.CLASS_FOR_NAME_PRIVATE_METHOD : ResourceTransformerImpl.CLASS_FOR_NAME_PRIVATE_METHOD;
                            this.generateReflectionHandlingModelCode(owner);
                            System.out.println("changing call to Class#" + name + " to instead call " + owner + "/" + ResourceTransformerImpl.CLASS_FOR_NAME_PRIVATE_METHOD + "#" + name);
                            ResourceTransformerImpl.this.setClassTransformed(true);
                        }
                        this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
                    }

                    private void generateReflectionHandlingModelCode(final String handlingClassName) {
                        if (!ResourceTransformerImpl.this.generatedReflectionModelHandlingCode.contains(handlingClassName)) {
                            if (!ResourceTransformerImpl.this.generatedReflectionModelHandlingCode.add(handlingClassName)) {
                                return;
                            }
                            System.out.println("Generating reflection handling code " + handlingClassName);
                            try {
                                int read;
                                InputStream inputStream = ReflectionModel.class.getClassLoader().getResourceAsStream(ReflectionModel.class.getName().replace('.', '/') + ResourceTransformerImpl.CLASS_SUFFIX);
                                ByteArrayOutputStream out = new ByteArrayOutputStream();
                                byte[] byteArray = new byte[3000];
                                while ((read = inputStream.read(byteArray, 0, byteArray.length)) != -1) {
                                    out.write(byteArray, 0, read);
                                }
                                out.flush();
                                byte[] bataviaReflectionModel = out.toByteArray();
                                ClassReader bataviaReflectionModelClassReader = new ClassReader(bataviaReflectionModel);
                                ClassWriter bataviaReflectionModelClassWriter = new ClassWriter(bataviaReflectionModelClassReader, 2);
                                bataviaReflectionModelClassReader.accept(new ClassVisitor(458752, (ClassVisitor)bataviaReflectionModelClassWriter){

                                    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                                        System.out.println("change ReflectionModel class name from " + name + " to " + handlingClassName + " keep superName = " + superName);
                                        name = handlingClassName;
                                        super.visit(version, access, name, signature, superName, interfaces);
                                    }

                                    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                                        return new MethodVisitor(393216, super.visitMethod(access, name, desc, signature, exceptions)){

                                            public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                                                if (owner.equals(REFLECTIONMODEL_INTERNAL_NAME)) {
                                                    owner = handlingClassName;
                                                }
                                                super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
                                                if (ResourceTransformerImpl.MAP_OBJECT.equals(owner) && ResourceTransformerImpl.MAP_GET_METHOD.equals(name)) {
                                                    System.out.println("Injecting transformation rules");
                                                    super.visitInsn(87);
                                                    for (Map.Entry possibleReplacement : ResourceTransformerImpl.this.mappingWithSeps.entrySet()) {
                                                        super.visitFieldInsn(178, handlingClassName, "mapping", "Ljava/util/Map;");
                                                        super.visitLdcInsn(possibleReplacement.getKey());
                                                        super.visitLdcInsn(possibleReplacement.getValue());
                                                        super.visitMethodInsn(185, ResourceTransformerImpl.MAP_OBJECT, ResourceTransformerImpl.MAP_PUT_METHOD, ResourceTransformerImpl.MAP_PUT_METHOD_DESC, true);
                                                        super.visitInsn(87);
                                                    }
                                                    int setIterationCount = 0;
                                                    for (Map.Entry possibleReplacement : ResourceTransformerImpl.this.mappingWithDots.entrySet()) {
                                                        super.visitFieldInsn(178, handlingClassName, "mapping", "Ljava/util/Map;");
                                                        super.visitLdcInsn(possibleReplacement.getKey());
                                                        super.visitLdcInsn(possibleReplacement.getValue());
                                                        super.visitMethodInsn(185, ResourceTransformerImpl.MAP_OBJECT, ResourceTransformerImpl.MAP_PUT_METHOD, ResourceTransformerImpl.MAP_PUT_METHOD_DESC, true);
                                                        if (++setIterationCount == ResourceTransformerImpl.this.mappingWithDots.entrySet().size()) continue;
                                                        super.visitInsn(87);
                                                    }
                                                }
                                            }

                                            public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
                                                if (owner.equals(REFLECTIONMODEL_INTERNAL_NAME)) {
                                                    owner = handlingClassName;
                                                }
                                                super.visitFieldInsn(opcode, owner, name, descriptor);
                                            }
                                        };
                                    }
                                }, 0);
                                byte[] result = bataviaReflectionModelClassWriter.toByteArray();
                                generatedExtraClass[0] = result;
                                generatedExtraClass[1] = handlingClassName + ResourceTransformerImpl.CLASS_SUFFIX;
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }

                    private String transformerClassPackageName() {
                        String transformedPackage = classReader.getClassName();
                        int index = transformedPackage.lastIndexOf(47);
                        if (index <= -1) {
                            return null;
                        }
                        transformedPackage = transformedPackage.substring(0, index);
                        return transformedPackage;
                    }

                    public void visitInvokeDynamicInsn(String name, String desc, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
                        String descOrig = desc;
                        desc = ResourceTransformerImpl.this.replaceJavaXwithJakarta(desc);
                        String ownerOrig = bootstrapMethodHandle.getOwner();
                        String bootstrapMethodHandleOwner = ResourceTransformerImpl.this.replaceJavaXwithJakarta(ownerOrig);
                        String bootstrapMethodHandleDescOrig = bootstrapMethodHandle.getDesc();
                        String bootstrapMethodHandleDesc = ResourceTransformerImpl.this.replaceJavaXwithJakarta(bootstrapMethodHandleDescOrig);
                        if (!descOrig.equals(desc)) {
                            ResourceTransformerImpl.this.setClassTransformed(true);
                        }
                        if (!ownerOrig.equals(bootstrapMethodHandleOwner) || !bootstrapMethodHandleDescOrig.equals(bootstrapMethodHandleDesc)) {
                            bootstrapMethodHandle = new Handle(bootstrapMethodHandle.getTag(), bootstrapMethodHandleOwner, bootstrapMethodHandle.getName(), bootstrapMethodHandleDesc, bootstrapMethodHandle.isInterface());
                        }
                        Object[] copyBootstrapMethodArguments = null;
                        for (int looper = 0; looper < bootstrapMethodArguments.length; ++looper) {
                            String updatedDesc;
                            Object argument = bootstrapMethodArguments[looper];
                            if (argument instanceof Type && (((Type)argument).getSort() == 9 || ((Type)argument).getSort() == 10 || ((Type)argument).getSort() == 11)) {
                                Type type = (Type)argument;
                                String oldDesc = type.getDescriptor();
                                updatedDesc = ResourceTransformerImpl.this.replaceJavaXwithJakarta(type.getDescriptor());
                                if (type.getSort() == 9) {
                                    Type[] elementType = type.getElementType();
                                    String internalName = type.getInternalName();
                                    System.out.println("TODO: https://github.com/wildfly-extras/batavia/issues/28 for Type.ARRAY " + internalName + " elementType = " + elementType);
                                } else if (type.getSort() == 11) {
                                    System.out.println("TODO: https://github.com/wildfly-extras/batavia/issues/28 for Type.METHOD " + type.getDescriptor() + " updatedDesc=" + updatedDesc);
                                    for (Type argTypes : type.getArgumentTypes()) {
                                        System.out.println("argumentTypes:  argTypes.getInternalName() = " + argTypes.getInternalName() + " argTypes.getDescriptor() = " + argTypes.getDescriptor());
                                        System.out.println("argTypes to string = " + argTypes.toString());
                                    }
                                } else {
                                    System.out.println("TODO: https://github.com/wildfly-extras/batavia/issues/28 for Type.OBJECT " + type.getInternalName() + " type.getClassName() = " + type.getClassName());
                                }
                                if (oldDesc.equals(updatedDesc)) continue;
                                ResourceTransformerImpl.this.setClassTransformed(true);
                                if (copyBootstrapMethodArguments == null) {
                                    copyBootstrapMethodArguments = this.cloneBootstrapMethodArguments(bootstrapMethodArguments);
                                }
                                copyBootstrapMethodArguments[looper] = Type.getMethodType((String)updatedDesc);
                                System.out.println("Updated type descriptor for BootstrapMethodArguments[" + looper + "] = " + ((Type)copyBootstrapMethodArguments[looper]).getDescriptor());
                                continue;
                            }
                            if (argument instanceof Handle) {
                                Handle handle = (Handle)argument;
                                String origDesc = handle.getDesc();
                                updatedDesc = ResourceTransformerImpl.this.replaceJavaXwithJakarta(handle.getDesc());
                                String origOwner = handle.getOwner();
                                String updatedOwner = ResourceTransformerImpl.this.replaceJavaXwithJakarta(handle.getOwner());
                                if (origDesc.equals(updatedDesc) && origOwner.equals(updatedOwner)) continue;
                                handle = new Handle(handle.getTag(), updatedOwner, handle.getName(), updatedDesc, handle.isInterface());
                                if (copyBootstrapMethodArguments == null) {
                                    copyBootstrapMethodArguments = this.cloneBootstrapMethodArguments(bootstrapMethodArguments);
                                }
                                copyBootstrapMethodArguments[looper] = handle;
                                continue;
                            }
                            if (!(argument instanceof ConstantDynamic)) continue;
                            ConstantDynamic constantDynamic = (ConstantDynamic)argument;
                            Thread.dumpStack();
                            throw new IllegalStateException("ConstantDynamic is not handled " + constantDynamic.toString());
                        }
                        if (copyBootstrapMethodArguments != null) {
                            bootstrapMethodArguments = copyBootstrapMethodArguments;
                        }
                        super.visitInvokeDynamicInsn(name, desc, bootstrapMethodHandle, bootstrapMethodArguments);
                    }

                    private Object[] cloneBootstrapMethodArguments(Object[] bootstrapMethodArguments) {
                        Object[] copyBootstrapMethodArguments = new Object[bootstrapMethodArguments.length];
                        for (int copyIdx = 0; copyIdx < bootstrapMethodArguments.length; ++copyIdx) {
                            copyBootstrapMethodArguments[copyIdx] = bootstrapMethodArguments[copyIdx];
                        }
                        return copyBootstrapMethodArguments;
                    }

                    public void visitLdcInsn(Object value) {
                        String replacement;
                        String typeOrig;
                        String desc;
                        Type type;
                        String descOrig;
                        if (value instanceof Type && !(descOrig = (type = (Type)value).getDescriptor()).equals(desc = ResourceTransformerImpl.this.replaceJavaXwithJakarta(descOrig))) {
                            this.mv.visitLdcInsn((Object)Type.getType((String)desc));
                            return;
                        }
                        if (value instanceof String && !(typeOrig = (String)value).equals(replacement = ResourceTransformerImpl.this.replaceJavaXwithJakarta((String)value))) {
                            this.mv.visitLdcInsn((Object)replacement);
                            return;
                        }
                        this.mv.visitLdcInsn(value);
                    }

                    public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
                        this.mv.visitLocalVariable(name, ResourceTransformerImpl.this.replaceJavaXwithJakarta(descriptor), ResourceTransformerImpl.this.replaceJavaXwithJakarta(signature), start, end, index);
                    }

                    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                        this.mv.visitFieldInsn(opcode, ResourceTransformerImpl.this.replaceJavaXwithJakarta(owner), name, ResourceTransformerImpl.this.replaceJavaXwithJakarta(desc));
                    }

                    public void visitTypeInsn(int opcode, String type) {
                        this.mv.visitTypeInsn(opcode, ResourceTransformerImpl.this.replaceJavaXwithJakarta(type));
                    }
                };
            }
        }, 0);
        if (!this.transformationsMade()) {
            return EMPTY_ARRAY;
        }
        if (generatedExtraClass[0] == null) {
            ResourceTransformer.Resource[] resourceArray2 = new ResourceTransformer.Resource[1];
            resourceArray = resourceArray2;
            resourceArray2[0] = new ResourceTransformer.Resource(newResourceName, classWriter.toByteArray());
        } else {
            ResourceTransformer.Resource[] resourceArray3 = new ResourceTransformer.Resource[2];
            resourceArray3[0] = new ResourceTransformer.Resource(newResourceName, classWriter.toByteArray());
            resourceArray = resourceArray3;
            resourceArray3[1] = new ResourceTransformer.Resource((String)generatedExtraClass[1], (byte[])generatedExtraClass[0]);
        }
        return resourceArray;
    }

    private String replaceJavaXwithJakarta(String desc) {
        int next;
        int length;
        int pos;
        String value;
        String key;
        if (desc == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(desc);
        for (Map.Entry possibleReplacement : this.mappingWithSeps.entrySet()) {
            key = (String)possibleReplacement.getKey();
            value = (String)possibleReplacement.getValue();
            pos = stringBuilder.indexOf(key, 0);
            while (pos > -1) {
                length = pos + key.length();
                next = pos + value.length();
                stringBuilder.replace(pos, length, value);
                pos = stringBuilder.indexOf(key, next);
            }
        }
        for (Map.Entry possibleReplacement : this.mappingWithDots.entrySet()) {
            key = (String)possibleReplacement.getKey();
            value = (String)possibleReplacement.getValue();
            pos = stringBuilder.indexOf(key, 0);
            while (pos > -1) {
                length = pos + key.length();
                next = pos + value.length();
                stringBuilder.replace(pos, length, value);
                pos = stringBuilder.indexOf(key, next);
            }
        }
        String result = stringBuilder.toString();
        if (!result.equals(desc)) {
            this.setClassTransformed(true);
        }
        return result;
    }

    public void setClassTransformed(boolean classTransformed) {
        this.classTransformed = classTransformed;
    }

    public boolean transformationsMade() {
        return this.classTransformed;
    }

    public void clearTransformationState() {
        this.classTransformed = false;
    }

    public ResourceTransformer.Resource[] transform(ResourceTransformer.Resource r) {
        ResourceTransformer.Resource[] resourceArray;
        ResourceTransformer.Resource retVal = null;
        String oldResourceName = r.getName();
        String newResourceName = this.replacePackageName(oldResourceName, false);
        if (oldResourceName.endsWith(CLASS_SUFFIX)) {
            this.clearTransformationState();
            if (!newResourceName.equals(oldResourceName)) {
                this.setClassTransformed(true);
                this.setNewClassName(newResourceName);
            }
            return this.transform(newResourceName, r.getData());
        }
        if (oldResourceName.endsWith(XML_SUFFIX)) {
            retVal = new ResourceTransformer.Resource(newResourceName, ResourceTransformerImpl.textFile(r.getData()));
        } else if (oldResourceName.endsWith(TLD_SUFFIX)) {
            retVal = new ResourceTransformer.Resource(newResourceName, ResourceTransformerImpl.textFile(r.getData()));
        } else if (oldResourceName.endsWith(JSP_SUFFIX)) {
            retVal = new ResourceTransformer.Resource(newResourceName, ResourceTransformerImpl.textFile(r.getData()));
        } else if (oldResourceName.startsWith(META_INF_SERVICES_PREFIX)) {
            newResourceName = this.replacePackageName(oldResourceName, true);
            if (!newResourceName.equals(oldResourceName)) {
                retVal = new ResourceTransformer.Resource(newResourceName, r.getData());
            }
        } else if (!newResourceName.equals(oldResourceName)) {
            retVal = new ResourceTransformer.Resource(newResourceName, r.getData());
        }
        if (retVal == null) {
            resourceArray = EMPTY_ARRAY;
        } else {
            ResourceTransformer.Resource[] resourceArray2 = new ResourceTransformer.Resource[1];
            resourceArray = resourceArray2;
            resourceArray2[0] = retVal;
        }
        return resourceArray;
    }

    private void setNewClassName(String newClassName) {
        if (newClassName.endsWith(CLASS_SUFFIX)) {
            newClassName = newClassName.substring(0, newClassName.length() - CLASS_SUFFIX_LENGTH);
        }
        this.changeClassName = newClassName;
    }

    private String replacePackageName(String resourceName, boolean dotFormat) {
        for (Map.Entry mapping : (dotFormat ? this.mappingWithDots : this.mappingWithSeps).entrySet()) {
            int startIndex = resourceName.indexOf((String)mapping.getKey());
            if (startIndex == -1) continue;
            return resourceName.substring(0, startIndex) + (String)mapping.getValue() + resourceName.substring(startIndex + ((String)mapping.getKey()).length());
        }
        return resourceName;
    }

    private static byte[] textFile(byte[] data) {
        try {
            return new String(data, "UTF-8").replace("javax.", "jakarta.").getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private class MyAnnotationVisitor
    extends AnnotationVisitor {
        public MyAnnotationVisitor(AnnotationVisitor av) {
            super(458752, av);
        }

        public void visit(String name, Object value) {
            this.av.visit(name, value);
        }

        public void visitEnum(String name, String descriptor, String value) {
            this.av.visitEnum(name, ResourceTransformerImpl.this.replaceJavaXwithJakarta(descriptor), value);
        }

        public AnnotationVisitor visitAnnotation(String name, String descriptor) {
            AnnotationVisitor av2 = this.av.visitAnnotation(name, ResourceTransformerImpl.this.replaceJavaXwithJakarta(descriptor));
            return new MyAnnotationVisitor(av2);
        }

        public AnnotationVisitor visitArray(String name) {
            AnnotationVisitor av2 = this.av.visitArray(name);
            return new MyAnnotationVisitor(av2);
        }
    }
}

