/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.transformer.nodeps;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.wildfly.extras.transformer.Config;
import org.wildfly.extras.transformer.ResourceTransformer;
import org.wildfly.extras.transformer.nodeps.AddMappingPatch;
import org.wildfly.extras.transformer.nodeps.ClassFileRefs;
import org.wildfly.extras.transformer.nodeps.ClassFileUtils;
import org.wildfly.extras.transformer.nodeps.CodeAttributeRefs;
import org.wildfly.extras.transformer.nodeps.ConstantPoolRefs;
import org.wildfly.extras.transformer.nodeps.MethodInfoRefs;
import org.wildfly.extras.transformer.nodeps.MethodsPatch;
import org.wildfly.extras.transformer.nodeps.MethodsRedirectPatch;
import org.wildfly.extras.transformer.nodeps.OpcodeUtils;
import org.wildfly.extras.transformer.nodeps.Utf8InfoMapping;
import org.wildfly.extras.transformer.nodeps.Utf8ItemsPatch;

final class ResourceTransformerImpl
extends ResourceTransformer {
    private static final ResourceTransformer.Resource[] EMPTY_ARRAY = new ResourceTransformer.Resource[0];
    private static final String CLASS_SUFFIX = ".class";
    private static final String XML_SUFFIX = ".xml";
    private static final String META_INF_SERVICES_PREFIX = "META-INF/services/";
    private static final String OUR_PACKAGE;
    final Utf8InfoMapping utf8Mapping;

    ResourceTransformerImpl(Map<Config, String> configs, boolean verbose) throws IOException {
        super(configs, verbose);
        int arraySize = this.mappingWithSeps.size() + this.mappingWithDots.size() + 1;
        byte[][] mappingFrom = new byte[arraySize][];
        byte[][] mappingTo = new byte[arraySize][];
        int minimum = Integer.MAX_VALUE;
        int i = 1;
        for (Map.Entry mappingEntry : this.mappingWithSeps.entrySet()) {
            mappingFrom[i] = ClassFileUtils.stringToUtf8((String)mappingEntry.getKey());
            mappingTo[i] = ClassFileUtils.stringToUtf8((String)mappingEntry.getValue());
            if (minimum > mappingFrom[i].length) {
                minimum = mappingFrom[i].length;
            }
            ++i;
        }
        for (Map.Entry mappingEntry : this.mappingWithDots.entrySet()) {
            mappingFrom[i] = ClassFileUtils.stringToUtf8((String)mappingEntry.getKey());
            mappingTo[i] = ClassFileUtils.stringToUtf8((String)mappingEntry.getValue());
            if (minimum > mappingFrom[i].length) {
                minimum = mappingFrom[i].length;
            }
            ++i;
        }
        this.utf8Mapping = new Utf8InfoMapping(mappingFrom, mappingTo, minimum);
    }

    public ResourceTransformer.Resource[] transform(ResourceTransformer.Resource r) {
        ResourceTransformer.Resource[] retVal = null;
        String oldResourceName = r.getName();
        String newResourceName = this.replacePackageName(oldResourceName, false);
        if (oldResourceName.endsWith(CLASS_SUFFIX)) {
            retVal = this.transform(r.getData(), this.utf8Mapping, newResourceName);
        } else if (oldResourceName.endsWith(XML_SUFFIX)) {
            retVal = new ResourceTransformer.Resource[]{new ResourceTransformer.Resource(newResourceName, ResourceTransformerImpl.xmlFile(r.getData()))};
        } else if (oldResourceName.startsWith(META_INF_SERVICES_PREFIX)) {
            newResourceName = this.replacePackageName(oldResourceName, true);
            if (!newResourceName.equals(oldResourceName)) {
                retVal = new ResourceTransformer.Resource[]{new ResourceTransformer.Resource(newResourceName, r.getData())};
            }
        } else if (!newResourceName.equals(oldResourceName)) {
            retVal = new ResourceTransformer.Resource[]{new ResourceTransformer.Resource(newResourceName, r.getData())};
        }
        return retVal == null ? EMPTY_ARRAY : retVal;
    }

    private String replacePackageName(String resourceName, boolean dotFormat) {
        for (Map.Entry mapping : (dotFormat ? this.mappingWithDots : this.mappingWithSeps).entrySet()) {
            int startIndex = resourceName.indexOf((String)mapping.getKey());
            if (startIndex == -1) continue;
            return resourceName.substring(0, startIndex) + (String)mapping.getValue() + resourceName.substring(startIndex + ((String)mapping.getKey()).length());
        }
        return resourceName;
    }

    private static byte[] xmlFile(byte[] data) {
        try {
            return new String(data, "UTF-8").replace("javax.", "jakarta.").getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private ResourceTransformer.Resource[] transform(byte[] clazz, Utf8InfoMapping utf8Mapping, String newResourceName) {
        boolean patchesNotAvailable;
        ClassFileRefs cfRefs = ClassFileRefs.of(clazz);
        ConstantPoolRefs cpRefs = cfRefs.getConstantPool();
        String transformedClassName = cfRefs.getThisClassAsString();
        int diffInBytes = 0;
        Utf8ItemsPatch utf8ItemsPatch = Utf8ItemsPatch.of(clazz, cpRefs, utf8Mapping);
        if (utf8ItemsPatch != null) {
            diffInBytes += utf8ItemsPatch.diffInBytes;
        }
        MethodsRedirectPatch methodsRedirectPatch = null;
        if (!transformedClassName.startsWith(OUR_PACKAGE) && (methodsRedirectPatch = MethodsRedirectPatch.of(clazz, cfRefs)) != null) {
            diffInBytes += methodsRedirectPatch.diffInBytes;
        }
        if (diffInBytes > 0 && Integer.MAX_VALUE - diffInBytes < clazz.length) {
            throw new UnsupportedOperationException("Couldn't patch class file. The transformed class file would exceed max allowed size 2147483647 bytes");
        }
        boolean bl = patchesNotAvailable = utf8ItemsPatch == null && methodsRedirectPatch == null;
        if (patchesNotAvailable) {
            return null;
        }
        byte[] patchedClass = this.applyPatches(clazz, utf8Mapping, clazz.length + diffInBytes, cfRefs, utf8ItemsPatch, methodsRedirectPatch, null);
        ResourceTransformer.Resource patchedClassResource = new ResourceTransformer.Resource(newResourceName, patchedClass);
        MethodsRedirectPatch.UtilityClasses utilClasses = methodsRedirectPatch != null ? methodsRedirectPatch.utilClasses : null;
        ResourceTransformer.Resource[] retVal = new ResourceTransformer.Resource[(utilClasses != null ? utilClasses.utilClassesRefactoring.to.length - 1 : 0) + 1];
        retVal[0] = patchedClassResource;
        if (utilClasses != null) {
            byte[][] oldClassNames = utilClasses.utilClassesRefactoring.from;
            byte[][] newClassNames = utilClasses.utilClassesRefactoring.to;
            for (int i = 1; i < oldClassNames.length; ++i) {
                String oldClassName = ClassFileUtils.utf8ToString(oldClassNames[i], 0, oldClassNames[i].length) + CLASS_SUFFIX;
                String newClassName = ClassFileUtils.utf8ToString(newClassNames[i], 0, newClassNames[i].length) + CLASS_SUFFIX;
                byte[] oldUtilClassBytes = ResourceTransformerImpl.getResourceBytes(oldClassName);
                byte[] newUtilClassBytes = this.transformUtilityClass(oldUtilClassBytes, utilClasses.utilClassesRefactoring, utf8Mapping);
                retVal[i] = new ResourceTransformer.Resource(newClassName, newUtilClassBytes);
            }
        }
        return retVal;
    }

    private byte[] transformUtilityClass(byte[] clazz, Utf8InfoMapping renameMapping, Utf8InfoMapping mappingRules) {
        ClassFileRefs cfRefs = ClassFileRefs.of(clazz);
        ConstantPoolRefs cpRefs = cfRefs.getConstantPool();
        int diffInBytes = 0;
        Utf8ItemsPatch renamePatch = Utf8ItemsPatch.of(clazz, cpRefs, renameMapping);
        diffInBytes += renamePatch.diffInBytes;
        AddMappingPatch applyMappingsPatch = AddMappingPatch.of(clazz, cfRefs, mappingRules);
        return this.applyPatches(clazz, renameMapping, clazz.length + (diffInBytes += applyMappingsPatch.diffInBytes), cfRefs, renamePatch, null, applyMappingsPatch);
    }

    private static byte[] toByteArray(InputStream is) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int c = -1;
            while ((c = is.read()) != -1) {
                baos.write(c);
            }
            return baos.toByteArray();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            return null;
        }
    }

    private static byte[] getResourceBytes(String resourceName) {
        return ResourceTransformerImpl.toByteArray(ResourceTransformerImpl.class.getClassLoader().getResourceAsStream(resourceName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] applyPatches(byte[] oldClass, Utf8InfoMapping utf8Mapping, int newClassSize, ClassFileRefs oldClassRefs, Utf8ItemsPatch utf8ItemsPatch, MethodsRedirectPatch methodsRedirectPatch, AddMappingPatch applyMappingsPatch) {
        MethodsPatch methodsPatch;
        int patchOffset;
        int mappingIndex;
        int length;
        if (this.verbose) {
            PrintStream printStream = System.out;
            synchronized (printStream) {
                System.out.println("[" + Thread.currentThread() + "] Patching class " + oldClassRefs.getThisClassAsString() + " - START");
            }
        }
        byte[] newClass = new byte[newClassSize];
        int oldClassOffset = 0;
        int newClassOffset = 0;
        int debugOldUtf8ItemOffset = -1;
        int debugNewUtf8ItemOffset = -1;
        int debugOldUtf8ItemLength = -1;
        int debugNewUtf8ItemLength = -1;
        System.arraycopy(oldClass, oldClassOffset, newClass, newClassOffset, oldClassRefs.getConstantPool().getItemsStartRef());
        oldClassOffset = newClassOffset = oldClassRefs.getConstantPool().getItemsStartRef();
        if (methodsRedirectPatch != null) {
            ClassFileUtils.writeUnsignedShort(newClass, oldClassRefs.getConstantPool().getSizeStartRef(), methodsRedirectPatch.currentPoolSize);
        } else if (applyMappingsPatch != null) {
            ClassFileUtils.writeUnsignedShort(newClass, oldClassRefs.getConstantPool().getSizeStartRef(), applyMappingsPatch.currentPoolSize);
        }
        if (utf8ItemsPatch != null) {
            for (int[] utf8ItemPatch : utf8ItemsPatch.utf8ItemPatches) {
                if (utf8ItemPatch == null) break;
                int oldUtf8ItemBytesSectionOffset = oldClassRefs.getConstantPool().getItemRefs()[utf8ItemPatch[0]] + 3;
                length = oldUtf8ItemBytesSectionOffset - oldClassOffset;
                System.arraycopy(oldClass, oldClassOffset, newClass, newClassOffset, length);
                oldClassOffset += length;
                newClassOffset += length;
                if (this.verbose) {
                    debugOldUtf8ItemOffset = oldClassOffset;
                    debugNewUtf8ItemOffset = newClassOffset;
                }
                int oldUtf8ItemLength = ClassFileUtils.readUnsignedShort(oldClass, oldClassOffset - 2);
                ClassFileUtils.writeUnsignedShort(newClass, newClassOffset - 2, oldUtf8ItemLength + utf8ItemPatch[1]);
                int i22 = 2;
                while (i22 < utf8ItemPatch.length && (mappingIndex = utf8ItemPatch[i22++]) != 0) {
                    patchOffset = utf8ItemPatch[i22++];
                    length = patchOffset - (oldClassOffset - oldUtf8ItemBytesSectionOffset);
                    System.arraycopy(oldClass, oldClassOffset, newClass, newClassOffset, length);
                    oldClassOffset += length;
                    System.arraycopy(utf8Mapping.to[mappingIndex], 0, newClass, newClassOffset += length, utf8Mapping.to[mappingIndex].length);
                    oldClassOffset += utf8Mapping.from[mappingIndex].length;
                    newClassOffset += utf8Mapping.to[mappingIndex].length;
                }
                length = oldUtf8ItemBytesSectionOffset + oldUtf8ItemLength - oldClassOffset;
                System.arraycopy(oldClass, oldClassOffset, newClass, newClassOffset, length);
                oldClassOffset += length;
                newClassOffset += length;
                if (!this.verbose) continue;
                PrintStream i22 = System.out;
                synchronized (i22) {
                    System.out.println("[" + Thread.currentThread() + "] Patching UTF-8 constant pool item on position: " + utf8ItemPatch[0]);
                    debugOldUtf8ItemLength = ClassFileUtils.readUnsignedShort(oldClass, debugOldUtf8ItemOffset - 2);
                    System.out.println("[" + Thread.currentThread() + "] old value: " + ClassFileUtils.utf8ToString(oldClass, debugOldUtf8ItemOffset, debugOldUtf8ItemOffset + debugOldUtf8ItemLength));
                    debugNewUtf8ItemLength = ClassFileUtils.readUnsignedShort(newClass, debugNewUtf8ItemOffset - 2);
                    System.out.println("[" + Thread.currentThread() + "] new value: " + ClassFileUtils.utf8ToString(newClass, debugNewUtf8ItemOffset, debugNewUtf8ItemOffset + debugNewUtf8ItemLength));
                }
            }
        }
        length = oldClassRefs.getConstantPool().getItemsEndRef() - oldClassOffset;
        System.arraycopy(oldClass, oldClassOffset, newClass, newClassOffset, length);
        oldClassOffset += length;
        newClassOffset += length;
        if (methodsRedirectPatch != null) {
            System.arraycopy(methodsRedirectPatch.poolEndPatch, 0, newClass, newClassOffset, methodsRedirectPatch.poolEndPatch.length);
            newClassOffset += methodsRedirectPatch.poolEndPatch.length;
        } else if (applyMappingsPatch != null) {
            System.arraycopy(applyMappingsPatch.poolEndPatch, 0, newClass, newClassOffset, applyMappingsPatch.poolEndPatch.length);
            newClassOffset += applyMappingsPatch.poolEndPatch.length;
        }
        int debugOldCodeAttributeCodeOffset = -1;
        int debugNewCodeAttributeCodeOffset = -1;
        int debugOldCodeAttributeCodeLength = -1;
        int debugNewCodeAttributeCodeLength = -1;
        MethodsPatch methodsPatch2 = methodsPatch = methodsRedirectPatch != null ? methodsRedirectPatch.methodsPatch : null;
        MethodsPatch methodsPatch3 = methodsPatch == null ? (applyMappingsPatch != null ? applyMappingsPatch.methodsPatch : null) : (methodsPatch = null);
        if (methodsPatch != null) {
            for (int[] methodPatch : methodsPatch.methodPatches) {
                if (methodPatch == null) break;
                MethodInfoRefs methodInfo = oldClassRefs.getMethod(methodPatch[0]);
                CodeAttributeRefs codeAttribute = methodInfo.getCodeAttribute();
                int oldMethodInfoCodeAttributeCodeOffset = codeAttribute.getCodeStartRef();
                length = oldMethodInfoCodeAttributeCodeOffset - oldClassOffset;
                System.arraycopy(oldClass, oldClassOffset, newClass, newClassOffset, length);
                oldClassOffset += length;
                newClassOffset += length;
                if (this.verbose) {
                    debugOldCodeAttributeCodeOffset = oldClassOffset;
                    debugNewCodeAttributeCodeOffset = newClassOffset;
                }
                int oldCodeAttributeLength = ClassFileUtils.readUnsignedInt(oldClass, oldClassOffset - 12);
                ClassFileUtils.writeUnsignedInt(newClass, newClassOffset - 12, oldCodeAttributeLength + methodPatch[1]);
                int oldCodeAttributeCodeLength = ClassFileUtils.readUnsignedInt(oldClass, oldClassOffset - 4);
                ClassFileUtils.writeUnsignedInt(newClass, newClassOffset - 4, oldCodeAttributeCodeLength + methodPatch[1]);
                int i = 4;
                while (i < methodPatch.length && (mappingIndex = methodPatch[i++]) != 0) {
                    patchOffset = methodPatch[i++];
                    length = patchOffset - (oldClassOffset - oldMethodInfoCodeAttributeCodeOffset);
                    System.arraycopy(oldClass, oldClassOffset, newClass, newClassOffset, length);
                    oldClassOffset += length;
                    System.arraycopy(methodsPatch.mappingTo[mappingIndex], 0, newClass, newClassOffset += length, methodsPatch.mappingTo[mappingIndex].length);
                    oldClassOffset += methodsPatch.mappingFrom[mappingIndex].length;
                    newClassOffset += methodsPatch.mappingTo[mappingIndex].length;
                }
                length = oldMethodInfoCodeAttributeCodeOffset + oldCodeAttributeLength - oldClassOffset;
                System.arraycopy(oldClass, oldClassOffset, newClass, newClassOffset, length);
                oldClassOffset += length;
                newClassOffset += length;
                if (!this.verbose) continue;
                PrintStream printStream = System.out;
                synchronized (printStream) {
                    System.out.println("[" + Thread.currentThread() + "] Patching method implementation '" + oldClassRefs.getConstantPool().getUtf8AsString(methodInfo.getNameIndex()) + "' on position: " + methodPatch[0]);
                    debugOldCodeAttributeCodeLength = ClassFileUtils.readUnsignedInt(oldClass, debugOldCodeAttributeCodeOffset - 4);
                    System.out.print("[" + Thread.currentThread() + "] Old implementation bytecode: ");
                    OpcodeUtils.printMethodByteCode(oldClass, debugOldCodeAttributeCodeOffset, debugOldCodeAttributeCodeLength);
                    System.out.println();
                    debugNewCodeAttributeCodeLength = ClassFileUtils.readUnsignedInt(newClass, debugNewCodeAttributeCodeOffset - 4);
                    System.out.print("[" + Thread.currentThread() + "] New implementation bytecode: ");
                    OpcodeUtils.printMethodByteCode(newClass, debugNewCodeAttributeCodeOffset, debugNewCodeAttributeCodeLength);
                    System.out.println();
                }
            }
        }
        System.arraycopy(oldClass, oldClassOffset, newClass, newClassOffset, oldClass.length - oldClassOffset);
        if (this.verbose) {
            PrintStream printStream = System.out;
            synchronized (printStream) {
                System.out.println("[" + Thread.currentThread() + "] Patching class " + oldClassRefs.getThisClassAsString() + " - END");
            }
        }
        return newClass;
    }

    static {
        String ourClass = ResourceTransformerImpl.class.getName().replace(".", "/");
        OUR_PACKAGE = ourClass.substring(0, ourClass.lastIndexOf(47) + 1);
    }
}

