/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.transformer.nodeps;

import org.wildfly.extras.transformer.nodeps.ClassFileUtils;
import org.wildfly.extras.transformer.nodeps.CodeAttributeRefs;
import org.wildfly.extras.transformer.nodeps.MethodInfoRefs;

final class OpcodeUtils {
    static final int MASK_FF = 255;
    private static final int MASK_F0 = 240;
    private static final int[] OP_CODES_SIZE = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 2, 3, 3, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 3, 3, 3, 3, 3, 3, 2, 0, 0, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 5, 5, 3, 2, 3, 1, 1, 3, 3, 1, 1, 0, 4, 3, 3, 5, 5};

    private OpcodeUtils() {
    }

    static void printMethodByteCode(byte[] clazz, MethodInfoRefs method) {
        if (method == null) {
            return;
        }
        CodeAttributeRefs codeAttr = method.getCodeAttribute();
        if (codeAttr == null) {
            return;
        }
        System.out.print("Method implementation byte code: ");
        for (int i = codeAttr.getCodeStartRef(); i < codeAttr.getCodeEndRef(); ++i) {
            if (i != codeAttr.getCodeStartRef()) {
                System.out.print("_");
            }
            int unsignedByte = 0xFF & clazz[i];
            System.out.print(((unsignedByte & 0xF0) == 0 ? "0" : "") + Integer.toHexString(unsignedByte));
        }
        System.out.println();
    }

    static void printMethodByteCode(byte[] clazz, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            if (i != offset) {
                System.out.print("_");
            }
            int unsignedByte = 0xFF & clazz[i];
            System.out.print(((unsignedByte & 0xF0) == 0 ? "0" : "") + Integer.toHexString(unsignedByte));
        }
    }

    static void printMethodOpcodes(byte[] clazz, MethodInfoRefs method) {
        if (method == null) {
            return;
        }
        CodeAttributeRefs codeAttr = method.getCodeAttribute();
        if (codeAttr == null) {
            return;
        }
        System.out.println("Method implementation opcodes: ");
        for (int i = codeAttr.getCodeStartRef(); i < codeAttr.getCodeEndRef(); i += OpcodeUtils.instructionBytesCount(clazz, i)) {
            int unsignedByte = 0xFF & clazz[i];
            System.out.println(i + ": " + ((unsignedByte & 0xF0) == 0 ? "0" : "") + Integer.toHexString(unsignedByte));
        }
    }

    static int instructionBytesCount(byte[] clazz, int position) {
        int opCode = 0xFF & clazz[position];
        int retVal = OP_CODES_SIZE[opCode];
        if (retVal != 0) {
            return retVal;
        }
        if (opCode == 170) {
            int paddingSize = 3 - position % 4;
            int lowIdx = position + paddingSize + 4;
            int low = ClassFileUtils.readUnsignedInt(clazz, lowIdx);
            int highIdx = lowIdx + 4;
            int high = ClassFileUtils.readUnsignedInt(clazz, highIdx);
            return 1 + paddingSize + 4 + 4 + 4 + 4 * (high - low + 1);
        }
        if (opCode == 171) {
            int paddingSize = 3 - position % 4;
            int npairsIdx = position + paddingSize + 4;
            int npairs = ClassFileUtils.readUnsignedInt(clazz, npairsIdx);
            return 1 + paddingSize + 4 + 4 + 8 * npairs;
        }
        if (opCode == 196) {
            int nextOpCode = 0xFF & clazz[position + 1];
            return nextOpCode == 132 ? 5 : 3;
        }
        throw new UnsupportedOperationException();
    }
}

