/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.transformer.nodeps;

import org.wildfly.extras.transformer.nodeps.ClassFileRefs;
import org.wildfly.extras.transformer.nodeps.ClassFileUtils;
import org.wildfly.extras.transformer.nodeps.MethodsPatch;
import org.wildfly.extras.transformer.nodeps.Utf8InfoMapping;

final class AddMappingPatch {
    final int diffInBytes;
    final int currentPoolSize;
    final byte[] poolEndPatch;
    final MethodsPatch methodsPatch;

    private AddMappingPatch(int currentPoolSize, byte[] poolEndPatch, MethodsPatch methodsPatch) {
        this.currentPoolSize = currentPoolSize;
        this.poolEndPatch = poolEndPatch;
        this.methodsPatch = methodsPatch;
        this.diffInBytes = poolEndPatch.length + methodsPatch.diffInBytes;
    }

    static AddMappingPatch of(byte[] clazz, ClassFileRefs cfRefs, Utf8InfoMapping mapping) {
        int i;
        int previousPoolSize;
        int currentPoolSize = previousPoolSize = cfRefs.getConstantPool().getSize();
        int mappingSize = mapping.from.length;
        int patchSize = 0;
        patchSize += (mappingSize - 1) * 3;
        patchSize += (mappingSize - 1) * 3;
        for (i = 1; i < mappingSize; ++i) {
            patchSize += 3 + mapping.from[i].length;
        }
        for (i = 1; i < mappingSize; ++i) {
            patchSize += 3 + mapping.to[i].length;
        }
        byte[] poolEndPatch = new byte[patchSize];
        int index = 0;
        int[][] mappingStrings = new int[mappingSize - 1][2];
        for (int i2 = 1; i2 < mappingSize; ++i2) {
            poolEndPatch[index++] = 8;
            ClassFileUtils.writeUnsignedShort(poolEndPatch, index, currentPoolSize + 2);
            index += 2;
            mappingStrings[i2 - 1][0] = currentPoolSize++;
            poolEndPatch[index++] = 8;
            ClassFileUtils.writeUnsignedShort(poolEndPatch, index, currentPoolSize + 2);
            index += 2;
            mappingStrings[i2 - 1][1] = currentPoolSize++;
            poolEndPatch[index++] = 1;
            ClassFileUtils.writeUnsignedShort(poolEndPatch, index, mapping.from[i2].length);
            System.arraycopy(mapping.from[i2], 0, poolEndPatch, index += 2, mapping.from[i2].length);
            index += mapping.from[i2].length;
            ++currentPoolSize;
            poolEndPatch[index++] = 1;
            ClassFileUtils.writeUnsignedShort(poolEndPatch, index, mapping.to[i2].length);
            System.arraycopy(mapping.to[i2], 0, poolEndPatch, index += 2, mapping.to[i2].length);
            index += mapping.to[i2].length;
            ++currentPoolSize;
        }
        MethodsPatch methodsPatch = MethodsPatch.getPatchForAddingMappingToUtilityClass(clazz, cfRefs, mappingStrings);
        return new AddMappingPatch(currentPoolSize, poolEndPatch, methodsPatch);
    }
}

