/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.transformer.nodeps;

import org.wildfly.extras.transformer.nodeps.ClassFileUtils;

final class CodeAttributeRefs {
    static final String ATTRIBUTE_NAME = "Code";
    private final int attributeStartRef;
    private final int attributeEndRef;
    private final int attributeNameIndexRef;
    private final int attributeNameIndex;
    private final int attributeLengthRef;
    private final int attributeLength;
    private final int maxStackRef;
    private final int maxStack;
    private final int maxLocalsRef;
    private final int maxLocals;
    private final int codeLengthRef;
    private final int codeLength;
    private final int codeStartRef;
    private final int codeEndRef;

    private CodeAttributeRefs(byte[] clazz, int attributeStartRef) {
        this.attributeStartRef = attributeStartRef;
        this.attributeNameIndexRef = attributeStartRef;
        this.attributeNameIndex = ClassFileUtils.readUnsignedShort(clazz, this.attributeNameIndexRef);
        this.attributeLengthRef = this.attributeNameIndexRef + 2;
        this.attributeLength = ClassFileUtils.readUnsignedInt(clazz, this.attributeLengthRef);
        this.maxStackRef = this.attributeLengthRef + 4;
        this.maxStack = ClassFileUtils.readUnsignedShort(clazz, this.maxStackRef);
        this.maxLocalsRef = this.maxStackRef + 2;
        this.maxLocals = ClassFileUtils.readUnsignedShort(clazz, this.maxLocalsRef);
        this.codeLengthRef = this.maxLocalsRef + 2;
        this.codeLength = ClassFileUtils.readUnsignedInt(clazz, this.codeLengthRef);
        this.codeStartRef = this.codeLengthRef + 4;
        this.codeEndRef = this.codeStartRef + this.codeLength;
        this.attributeEndRef = attributeStartRef + this.attributeLength;
    }

    int getAttributeStartRef() {
        return this.attributeStartRef;
    }

    int getAttributeEndRef() {
        return this.attributeEndRef;
    }

    int getAttributeNameIndexRef() {
        return this.attributeNameIndexRef;
    }

    int getAttributeNameIndex() {
        return this.attributeNameIndex;
    }

    int getAttributeLengthRef() {
        return this.attributeLengthRef;
    }

    int getAttributeLength() {
        return this.attributeLength;
    }

    int getMaxStackRef() {
        return this.maxStackRef;
    }

    int getMaxStack() {
        return this.maxStack;
    }

    int getMaxLocalsRef() {
        return this.maxLocalsRef;
    }

    int getMaxLocals() {
        return this.maxLocals;
    }

    int getCodeLengthRef() {
        return this.codeLengthRef;
    }

    int getCodeLength() {
        return this.codeLength;
    }

    int getCodeStartRef() {
        return this.codeStartRef;
    }

    int getCodeEndRef() {
        return this.codeEndRef;
    }

    static CodeAttributeRefs of(byte[] clazz, int attributeStartRef) {
        return new CodeAttributeRefs(clazz, attributeStartRef);
    }
}

