/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.transformer.nodeps;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.extras.transformer.nodeps.ClassFileRefs;
import org.wildfly.extras.transformer.nodeps.ClassFileUtils;
import org.wildfly.extras.transformer.nodeps.CodeAttributeRefs;
import org.wildfly.extras.transformer.nodeps.ConstantPoolRefs;
import org.wildfly.extras.transformer.nodeps.MethodDescriptor;
import org.wildfly.extras.transformer.nodeps.MethodInfoRefs;
import org.wildfly.extras.transformer.nodeps.MethodRedirection;
import org.wildfly.extras.transformer.nodeps.OpcodeUtils;

final class MethodsPatch {
    private static final byte[] JAVA_UTIL_MAP_CLASS = ClassFileUtils.stringToUtf8("java/util/Map");
    private static final byte[] PUT_METHOD_NAME = ClassFileUtils.stringToUtf8("put");
    private static final byte[] PUT_METHOD_DESCRIPTOR = ClassFileUtils.stringToUtf8("(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
    private static final byte[] KEY_CONSTANT = ClassFileUtils.stringToUtf8("KEY");
    private static final byte[] VALUE_CONSTANT = ClassFileUtils.stringToUtf8("VALUE");
    private static final int MINIMUM = 3;
    final int diffInBytes;
    final List<int[]> methodPatches;
    final byte[][] mappingFrom;
    final byte[][] mappingTo;

    private MethodsPatch(int diffInBytes, List<int[]> methodPatches, byte[][] mappingFrom, byte[][] mappingTo) {
        this.diffInBytes = diffInBytes;
        this.methodPatches = methodPatches;
        this.mappingFrom = mappingFrom;
        this.mappingTo = mappingTo;
    }

    static MethodsPatch getPatchForMethodRedirects(byte[] clazz, ClassFileRefs cfRefs, int[][] methodRefRedirects) {
        int diffInBytes = 0;
        ArrayList<int[]> methodPatches = null;
        byte[][] mappingFrom = MethodsPatch.generateMappingFrom(methodRefRedirects, MethodRedirection.MAPPING);
        byte[][] mappingTo = MethodsPatch.generateMappingTo(methodRefRedirects, MethodRedirection.MAPPING);
        for (int i = 0; i < cfRefs.getMethodsCount(); ++i) {
            int[] patch;
            MethodInfoRefs methodInfo = cfRefs.getMethod(i);
            CodeAttributeRefs codeAttribute = methodInfo.getCodeAttribute();
            if (codeAttribute == null || (patch = MethodsPatch.getMethodPatch(clazz, codeAttribute, i, mappingFrom, mappingTo)) == null) continue;
            if (methodPatches == null) {
                methodPatches = new ArrayList<int[]>(cfRefs.getMethodsCount());
            }
            diffInBytes += patch[1];
            methodPatches.add(patch);
        }
        return methodPatches != null ? new MethodsPatch(diffInBytes, methodPatches, mappingFrom, mappingTo) : null;
    }

    static MethodsPatch getPatchForAddingMappingToUtilityClass(byte[] clazz, ClassFileRefs cfRefs, int[][] mappingStrings) {
        int diffInBytes = 0;
        ArrayList<int[]> methodPatches = new ArrayList<int[]>(cfRefs.getMethodsCount());
        byte[][] mappingFrom = MethodsPatch.generateMappingFrom(cfRefs.getConstantPool());
        byte[][] mappingTo = MethodsPatch.generateMappingTo(cfRefs.getConstantPool(), mappingStrings);
        MethodInfoRefs classInitMethodInfo = cfRefs.getMethod(clazz, MethodDescriptor.STATIC_INIT);
        CodeAttributeRefs codeAttribute = classInitMethodInfo.getCodeAttribute();
        int[] patch = MethodsPatch.getMethodPatch(clazz, codeAttribute, classInitMethodInfo.getIndex(), mappingFrom, mappingTo);
        methodPatches.add(patch);
        return new MethodsPatch(diffInBytes += patch[1], methodPatches, mappingFrom, mappingTo);
    }

    private static byte[][] generateMappingFrom(ConstantPoolRefs cpRefs) {
        int mapPutInterfaceMethodrefIndex = 0;
        int keyConstantIndex = 0;
        int valueConstantIndex = 0;
        int classIndex = 0;
        int classNameIndex = 0;
        int nameAndTypeIndex = 0;
        int nameAndTypeNameIndex = 0;
        int nameAndTypeDescriptorIndex = 0;
        for (int i = 1; i < cpRefs.getSize(); ++i) {
            if (cpRefs.isInterfaceMethodRef(i)) {
                classIndex = cpRefs.getInterfaceMethodRef_ClassIndex(i);
                classNameIndex = cpRefs.getClass_NameIndex(classIndex);
                if (!cpRefs.utf8EqualsTo(classNameIndex, JAVA_UTIL_MAP_CLASS) || !cpRefs.utf8EqualsTo(nameAndTypeNameIndex = cpRefs.getNameAndType_NameIndex(nameAndTypeIndex = cpRefs.getInterfaceMethodRef_NameAndTypeIndex(i)), PUT_METHOD_NAME)) continue;
                nameAndTypeDescriptorIndex = cpRefs.getNameAndType_DescriptorIndex(nameAndTypeIndex);
                if (cpRefs.utf8EqualsTo(nameAndTypeDescriptorIndex, PUT_METHOD_DESCRIPTOR)) {
                    mapPutInterfaceMethodrefIndex = i;
                }
            }
            if (cpRefs.isString(i)) {
                if (cpRefs.utf8EqualsTo(cpRefs.getString_Index(i), KEY_CONSTANT)) {
                    keyConstantIndex = i;
                }
                if (cpRefs.utf8EqualsTo(cpRefs.getString_Index(i), VALUE_CONSTANT)) {
                    valueConstantIndex = i;
                }
            }
            if (keyConstantIndex > 0 && valueConstantIndex > 0 && mapPutInterfaceMethodrefIndex > 0) break;
        }
        int index = 0;
        int mappingTableSize = 2;
        byte[][] mappingFrom = new byte[mappingTableSize][];
        mappingFrom[1] = new byte[9];
        mappingFrom[1][index++] = 18;
        mappingFrom[1][index++] = (byte)keyConstantIndex;
        mappingFrom[1][index++] = 18;
        mappingFrom[1][index++] = (byte)valueConstantIndex;
        mappingFrom[1][index++] = -71;
        ClassFileUtils.writeUnsignedShort(mappingFrom[1], index, mapPutInterfaceMethodrefIndex);
        index += 2;
        mappingFrom[1][index++] = 3;
        mappingFrom[1][index++] = 0;
        return mappingFrom;
    }

    private static byte[][] generateMappingFrom(int[][] methodRefRedirects, MethodDescriptor[][] methodMapping) {
        int mappingTableSize = 1;
        for (int i = 0; i < methodRefRedirects.length; ++i) {
            if (methodRefRedirects[i][0] == 0) continue;
            ++mappingTableSize;
        }
        byte[][] mappingFrom = new byte[mappingTableSize][];
        int mappingIndex = 0;
        for (int i = 0; i < methodMapping.length; ++i) {
            int methodRefIndex = methodRefRedirects[i][0];
            if (methodRefIndex == 0) continue;
            mappingFrom[++mappingIndex] = new byte[3];
            mappingFrom[mappingIndex][0] = (byte)(methodMapping[i][0].isStatic ? 184 : 182);
            ClassFileUtils.writeUnsignedShort(mappingFrom[mappingIndex], 1, methodRefIndex);
        }
        return mappingFrom;
    }

    private static byte[][] generateMappingTo(ConstantPoolRefs cpRefs, int[][] stringMappings) {
        int mapPutInterfaceMethodrefIndex = 0;
        int classIndex = 0;
        int classNameIndex = 0;
        int nameAndTypeIndex = 0;
        int nameAndTypeNameIndex = 0;
        int nameAndTypeDescriptorIndex = 0;
        for (int i = 1; i < cpRefs.getSize(); ++i) {
            if (cpRefs.isInterfaceMethodRef(i)) {
                classIndex = cpRefs.getInterfaceMethodRef_ClassIndex(i);
                classNameIndex = cpRefs.getClass_NameIndex(classIndex);
                if (!cpRefs.utf8EqualsTo(classNameIndex, JAVA_UTIL_MAP_CLASS) || !cpRefs.utf8EqualsTo(nameAndTypeNameIndex = cpRefs.getNameAndType_NameIndex(nameAndTypeIndex = cpRefs.getInterfaceMethodRef_NameAndTypeIndex(i)), PUT_METHOD_NAME)) continue;
                nameAndTypeDescriptorIndex = cpRefs.getNameAndType_DescriptorIndex(nameAndTypeIndex);
                if (cpRefs.utf8EqualsTo(nameAndTypeDescriptorIndex, PUT_METHOD_DESCRIPTOR)) {
                    mapPutInterfaceMethodrefIndex = i;
                }
            }
            if (mapPutInterfaceMethodrefIndex > 0) break;
        }
        int index = 0;
        int mappingTableSize = 2;
        byte[][] mappingTo = new byte[mappingTableSize][];
        int countOfMappings = stringMappings.length;
        mappingTo[1] = new byte[11 * countOfMappings];
        for (int i = 0; i < stringMappings.length; ++i) {
            mappingTo[1][index++] = 19;
            ClassFileUtils.writeUnsignedShort(mappingTo[1], index, stringMappings[i][0]);
            index += 2;
            mappingTo[1][index++] = 19;
            ClassFileUtils.writeUnsignedShort(mappingTo[1], index, stringMappings[i][1]);
            index += 2;
            mappingTo[1][index++] = -71;
            ClassFileUtils.writeUnsignedShort(mappingTo[1], index, mapPutInterfaceMethodrefIndex);
            index += 2;
            mappingTo[1][index++] = 3;
            mappingTo[1][index++] = 0;
        }
        return mappingTo;
    }

    private static byte[][] generateMappingTo(int[][] methodRefRedirects, MethodDescriptor[][] methodMapping) {
        int mappingTableSize = 1;
        for (int i = 0; i < methodRefRedirects.length; ++i) {
            if (methodRefRedirects[i][1] == 0) continue;
            ++mappingTableSize;
        }
        byte[][] mappingTo = new byte[mappingTableSize][];
        int mappingIndex = 0;
        for (int i = 0; i < methodMapping.length; ++i) {
            int methodRefIndex = methodRefRedirects[i][1];
            if (methodRefIndex == 0) continue;
            mappingTo[++mappingIndex] = new byte[3];
            mappingTo[mappingIndex][0] = (byte)(methodMapping[i][1].isStatic ? 184 : 182);
            ClassFileUtils.writeUnsignedShort(mappingTo[mappingIndex], 1, methodRefIndex);
        }
        return mappingTo;
    }

    private static int[] getMethodPatch(byte[] clazz, CodeAttributeRefs codeAttribute, int methodIndex, byte[][] mappingFrom, byte[][] mappingTo) {
        int codeLength = codeAttribute.getCodeLength();
        int offset = codeAttribute.getCodeStartRef();
        int limit = offset + codeLength;
        int[] retVal = null;
        int patchIndex = 4;
        block0: for (int i = offset; i <= limit - 3; i += OpcodeUtils.instructionBytesCount(clazz, i, offset)) {
            int opcode = 0xFF & clazz[i];
            if (opcode != 184 && opcode != 182 && opcode != 18) continue;
            for (int j = 1; j < mappingFrom.length; ++j) {
                if (limit - i < mappingFrom[j].length) continue;
                int mappingIndex = j;
                for (int k = 0; k < mappingFrom[j].length; ++k) {
                    if (clazz[i + k] == mappingFrom[j][k]) continue;
                    mappingIndex = 0;
                    break;
                }
                if (mappingIndex == 0) continue;
                if (retVal == null) {
                    retVal = new int[((limit - i) / 3 + 2) * 2];
                    retVal[0] = methodIndex;
                }
                retVal[1] = retVal[1] + (mappingTo[mappingIndex].length - mappingFrom[mappingIndex].length);
                retVal[2] = codeAttribute.getMaxStack();
                retVal[3] = codeAttribute.getMaxLocals();
                retVal[patchIndex++] = mappingIndex;
                retVal[patchIndex++] = i - offset;
                continue block0;
            }
        }
        return retVal;
    }
}

