/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.transformer.nodeps;

import org.wildfly.extras.transformer.nodeps.ClassFileUtils;
import org.wildfly.extras.transformer.nodeps.ConstantPoolRefs;
import org.wildfly.extras.transformer.nodeps.MethodDescriptor;
import org.wildfly.extras.transformer.nodeps.MethodInfoRefs;

final class ClassFileRefs {
    private static final int MINOR_VERSION_REF = 4;
    private static final int MAJOR_VERSION_REF = 6;
    private final ConstantPoolRefs constantPool;
    private final int minorVersion;
    private final int majorVersion;
    private final int accessFlagsRef;
    private final int accessFlags;
    private final int thisClassIndexRef;
    private final int thisClassIndex;
    private final int superClassIndexRef;
    private final int superClassIndex;
    private final int interfacesCountRef;
    private final int interfacesStartRef;
    private final int interfacesEndRef;
    private final int[] interfaces;
    private final int methodsCountRef;
    private final int methodsStartRef;
    private final int methodsEndRef;
    private final MethodInfoRefs[] methods;

    ClassFileRefs(byte[] clazz, ConstantPoolRefs constantPool, int[] interfaces, MethodInfoRefs[] methods) {
        this.minorVersion = ClassFileUtils.readUnsignedShort(clazz, 4);
        this.majorVersion = ClassFileUtils.readUnsignedShort(clazz, 6);
        this.constantPool = constantPool;
        this.accessFlagsRef = constantPool.getItemsEndRef();
        this.accessFlags = ClassFileUtils.readUnsignedShort(clazz, this.accessFlagsRef);
        this.thisClassIndexRef = this.accessFlagsRef + 2;
        this.thisClassIndex = ClassFileUtils.readUnsignedShort(clazz, this.thisClassIndexRef);
        this.superClassIndexRef = this.thisClassIndexRef + 2;
        this.superClassIndex = ClassFileUtils.readUnsignedShort(clazz, this.superClassIndexRef);
        this.interfacesCountRef = this.superClassIndexRef + 2;
        this.interfaces = interfaces;
        this.interfacesStartRef = this.interfacesCountRef + 2;
        this.methodsCountRef = this.interfacesEndRef = this.interfacesStartRef + interfaces.length * 2;
        this.methods = methods;
        this.methodsStartRef = this.methodsCountRef + 2;
        this.methodsEndRef = methods.length > 0 ? methods[methods.length - 1].getMethodInfoEndRef() : this.methodsStartRef;
    }

    ConstantPoolRefs getConstantPool() {
        return this.constantPool;
    }

    int getMinorVersionRef() {
        return 4;
    }

    int getMinorVersion() {
        return this.minorVersion;
    }

    int getMajorVersionRef() {
        return 6;
    }

    int getMajorVersion() {
        return this.majorVersion;
    }

    int getAccessFlagsRef() {
        return this.accessFlagsRef;
    }

    int getAccessFlags() {
        return this.accessFlags;
    }

    int getThisClassIndexRef() {
        return this.thisClassIndexRef;
    }

    int getThisClassIndex() {
        return this.thisClassIndex;
    }

    String getThisClassAsString() {
        int classNameIndex = this.constantPool.getClass_NameIndex(this.getThisClassIndex());
        return this.constantPool.getUtf8AsString(classNameIndex);
    }

    int getSuperClassIndexRef() {
        return this.superClassIndexRef;
    }

    int getSuperClassIndex() {
        return this.superClassIndex;
    }

    String getSuperClassAsString() {
        int classIndex = this.getSuperClassIndex();
        if (classIndex == 0) {
            return null;
        }
        int classNameIndex = this.constantPool.getClass_NameIndex(classIndex);
        return this.constantPool.getUtf8AsString(classNameIndex);
    }

    int getInterfacesCountRef() {
        return this.interfacesCountRef;
    }

    int getInterfacesCount() {
        return this.interfaces.length;
    }

    int getInterfaceClassIndex(int index) {
        return this.interfaces[index];
    }

    int getInterfacesStartRef() {
        return this.interfacesStartRef;
    }

    int getInterfacesEndRef() {
        return this.interfacesEndRef;
    }

    int getMethodsCountRef() {
        return this.methodsCountRef;
    }

    int getMethodsCount() {
        return this.methods.length;
    }

    int getMethodsStartRef() {
        return this.methodsStartRef;
    }

    int getMethodsEndRef() {
        return this.methodsEndRef;
    }

    MethodInfoRefs getMethod(byte[] clazz, MethodDescriptor methodDescriptor) {
        for (MethodInfoRefs method : this.methods) {
            if (!this.constantPool.utf8EqualsTo(method.getNameIndex(), methodDescriptor.methodName) || !this.constantPool.utf8EqualsTo(method.getDescriptorIndex(), methodDescriptor.methodDescriptor)) continue;
            return method;
        }
        return null;
    }

    MethodInfoRefs getMethod(int index) {
        return this.methods[index];
    }

    static ClassFileRefs of(byte[] clazz) {
        ConstantPoolRefs cpRefs = ConstantPoolRefs.of(clazz);
        int position = cpRefs.getItemsEndRef() + 6;
        int interfacesCount = ClassFileUtils.readUnsignedShort(clazz, position);
        position += 2;
        int[] interfaces = new int[interfacesCount];
        for (int i = 0; i < interfacesCount; ++i) {
            interfaces[i] = ClassFileUtils.readUnsignedShort(clazz, position);
            position += 2;
        }
        int fieldsCount = ClassFileUtils.readUnsignedShort(clazz, position);
        position += 2;
        for (int i = 0; i < fieldsCount; ++i) {
            int attributesCount = ClassFileUtils.readUnsignedShort(clazz, position += 6);
            position += 2;
            for (int j = 0; j < attributesCount; ++j) {
                int attributeLength = ClassFileUtils.readUnsignedInt(clazz, position += 2);
                position += 4;
                position += attributeLength;
            }
        }
        int methodsCount = ClassFileUtils.readUnsignedShort(clazz, position);
        position += 2;
        MethodInfoRefs[] methods = new MethodInfoRefs[methodsCount];
        for (int i = 0; i < methods.length; ++i) {
            methods[i] = MethodInfoRefs.of(clazz, cpRefs, position, i);
            position = methods[i].getMethodInfoEndRef();
        }
        return new ClassFileRefs(clazz, cpRefs, interfaces, methods);
    }
}

