/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.transformer.nodeps;

import org.wildfly.extras.transformer.nodeps.ClassFileRefs;
import org.wildfly.extras.transformer.nodeps.ClassFileUtils;
import org.wildfly.extras.transformer.nodeps.ConstantPoolRefs;
import org.wildfly.extras.transformer.nodeps.MethodRedirection;
import org.wildfly.extras.transformer.nodeps.MethodsPatch;
import org.wildfly.extras.transformer.nodeps.Utf8InfoMapping;

final class MethodsRedirectPatch {
    final int diffInBytes;
    final int currentPoolSize;
    final byte[] poolEndPatch;
    final MethodsPatch methodsPatch;
    final int[][] methodRefRedirects;
    final UtilityClasses utilClasses;

    MethodsRedirectPatch(int currentPoolSize, byte[] poolEndPatch, int[][] methodRefRedirects, MethodsPatch methodsPatch, UtilityClasses utilClasses) {
        this.currentPoolSize = currentPoolSize;
        this.poolEndPatch = poolEndPatch;
        this.methodRefRedirects = methodRefRedirects;
        this.methodsPatch = methodsPatch;
        this.diffInBytes = poolEndPatch.length + (methodsPatch != null ? methodsPatch.diffInBytes : 0);
        this.utilClasses = utilClasses;
    }

    private static UtilityClasses generateUtilityClassNames(byte[] clazz, ClassFileRefs cfRefs, int[] matches, int matchesCount, Utf8InfoMapping utf8Mapping) {
        byte[][] tempFrom = new byte[matches.length][];
        byte[][] tempTo = new byte[matches.length][];
        int[] poolIndicesMapping = new int[matches.length];
        int[] generatedClassPoolIndices = new int[matches.length];
        int countOfGeneratedClasses = 0;
        int classPoolIndex = cfRefs.getConstantPool().getSize() + matchesCount * 4;
        ConstantPoolRefs cpRefs = cfRefs.getConstantPool();
        int classNameLength = cpRefs.getUtf8_Length(cpRefs.getClass_NameIndex(cfRefs.getThisClassIndex()));
        int classNameBytesRef = cpRefs.getUtf8_BytesRef(cpRefs.getClass_NameIndex(cfRefs.getThisClassIndex()));
        byte[] processedClassName = new byte[classNameLength];
        System.arraycopy(clazz, classNameBytesRef, processedClassName, 0, classNameLength);
        processedClassName = MethodsRedirectPatch.renameClass(processedClassName, utf8Mapping);
        block0: for (int i = 0; i < matches.length; ++i) {
            if (matches[i] == 0) continue;
            byte[] oldUtilityClassName = MethodRedirection.MAPPING[i][1].className;
            byte[] newUtilityClassName = MethodsRedirectPatch.renameUtilityClassName(processedClassName, oldUtilityClassName);
            for (int j = 0; j < tempTo.length; ++j) {
                if (tempTo[j] != null) {
                    if (tempTo[j].length != newUtilityClassName.length) continue;
                    boolean utilClassExists = true;
                    for (int k = 0; k < tempTo[j].length; ++k) {
                        if (tempTo[j][k] == newUtilityClassName[k]) continue;
                        utilClassExists = false;
                        break;
                    }
                    if (!utilClassExists) continue;
                    generatedClassPoolIndices[i] = generatedClassPoolIndices[poolIndicesMapping[j]];
                    continue block0;
                }
                tempFrom[countOfGeneratedClasses] = oldUtilityClassName;
                tempTo[countOfGeneratedClasses] = newUtilityClassName;
                poolIndicesMapping[countOfGeneratedClasses] = i;
                generatedClassPoolIndices[i] = countOfGeneratedClasses * 2 + classPoolIndex;
                ++countOfGeneratedClasses;
                continue block0;
            }
        }
        Utf8InfoMapping utilClassesRefactoring = MethodsRedirectPatch.getMappingForUtilityClassesRefactoring(countOfGeneratedClasses + 1, tempFrom, tempTo);
        return new UtilityClasses(utilClassesRefactoring, generatedClassPoolIndices);
    }

    private static byte[] renameClass(byte[] oldClassName, Utf8InfoMapping mapping) {
        byte[] retVal = oldClassName;
        block0: for (int i = 0; i <= oldClassName.length - mapping.min; ++i) {
            for (int j = 1; j < mapping.from.length; ++j) {
                if (oldClassName.length - i < mapping.from[j].length) continue;
                int mappingIndex = j;
                for (int k = 0; k < mapping.from[j].length; ++k) {
                    if (oldClassName[i + k] == mapping.from[j][k]) continue;
                    mappingIndex = 0;
                    break;
                }
                if (mappingIndex == 0) continue;
                retVal = new byte[retVal.length - mapping.from[mappingIndex].length + mapping.to[mappingIndex].length];
                System.arraycopy(mapping.to[mappingIndex], 0, retVal, 0, mapping.to[mappingIndex].length);
                System.arraycopy(oldClassName, mapping.from[mappingIndex].length, retVal, mapping.to[mappingIndex].length, oldClassName.length - mapping.from[mappingIndex].length);
                continue block0;
            }
        }
        return retVal;
    }

    private static int getLastPathSeparatorIndex(byte[] buffer) {
        for (int i = buffer.length - 1; i >= 0; --i) {
            if (buffer[i] != 47) continue;
            return i;
        }
        return -1;
    }

    static MethodsRedirectPatch of(byte[] clazz, ClassFileRefs cfRefs, Utf8InfoMapping utf8Mapping) {
        int i;
        int[] matches = MethodsRedirectPatch.getMatches(cfRefs.getConstantPool());
        if (matches == null) {
            return null;
        }
        int matchesCount = 0;
        for (int i2 = 0; i2 < matches.length; ++i2) {
            if (matches[i2] == 0) continue;
            ++matchesCount;
        }
        UtilityClasses utilClasses = MethodsRedirectPatch.generateUtilityClassNames(clazz, cfRefs, matches, matchesCount, utf8Mapping);
        int patchSize = MethodsRedirectPatch.getPoolEndPatchSize(matches, matchesCount, utilClasses);
        byte[] poolEndPatch = new byte[patchSize];
        int[][] methodRefRedirects = new int[MethodRedirection.MAPPING.length][2];
        int currentPoolSize = cfRefs.getConstantPool().getSize();
        int position = 0;
        for (i = 0; i < matches.length; ++i) {
            if (matches[i] == 0) continue;
            methodRefRedirects[i][0] = matches[i];
            methodRefRedirects[i][1] = currentPoolSize++;
            poolEndPatch[position++] = 10;
            ClassFileUtils.writeUnsignedShort(poolEndPatch, position, utilClasses.generatedClassPoolIndices[i]);
            ClassFileUtils.writeUnsignedShort(poolEndPatch, position += 2, currentPoolSize);
            position += 2;
            poolEndPatch[position++] = 12;
            ClassFileUtils.writeUnsignedShort(poolEndPatch, position, ++currentPoolSize);
            ClassFileUtils.writeUnsignedShort(poolEndPatch, position += 2, currentPoolSize + 1);
            position += 2;
            ++currentPoolSize;
            poolEndPatch[position++] = 1;
            ClassFileUtils.writeUnsignedShort(poolEndPatch, position, MethodRedirection.MAPPING[i][1].methodName.length);
            System.arraycopy(MethodRedirection.MAPPING[i][1].methodName, 0, poolEndPatch, position += 2, MethodRedirection.MAPPING[i][1].methodName.length);
            position += MethodRedirection.MAPPING[i][1].methodName.length;
            ++currentPoolSize;
            poolEndPatch[position++] = 1;
            ClassFileUtils.writeUnsignedShort(poolEndPatch, position, MethodRedirection.MAPPING[i][1].methodDescriptor.length);
            System.arraycopy(MethodRedirection.MAPPING[i][1].methodDescriptor, 0, poolEndPatch, position += 2, MethodRedirection.MAPPING[i][1].methodDescriptor.length);
            position += MethodRedirection.MAPPING[i][1].methodDescriptor.length;
        }
        for (i = 1; i < utilClasses.utilClassesRefactoring.to.length; ++i) {
            poolEndPatch[position++] = 7;
            ClassFileUtils.writeUnsignedShort(poolEndPatch, position, ++currentPoolSize);
            position += 2;
            ++currentPoolSize;
            poolEndPatch[position++] = 1;
            ClassFileUtils.writeUnsignedShort(poolEndPatch, position, utilClasses.utilClassesRefactoring.to[i].length);
            System.arraycopy(utilClasses.utilClassesRefactoring.to[i], 0, poolEndPatch, position += 2, utilClasses.utilClassesRefactoring.to[i].length);
            position += utilClasses.utilClassesRefactoring.to[i].length;
        }
        MethodsPatch methodsPatch = MethodsPatch.getPatchForMethodRedirects(clazz, cfRefs, methodRefRedirects);
        return new MethodsRedirectPatch(currentPoolSize, poolEndPatch, methodRefRedirects, methodsPatch, utilClasses);
    }

    public static int[] getMatches(ConstantPoolRefs cpRefs) {
        int[] retVal = null;
        for (int j = 0; j < MethodRedirection.MAPPING.length; ++j) {
            for (int i = 1; i < cpRefs.getSize(); ++i) {
                int methodDescriptorIndex;
                int methodNameAndTypeIndex;
                int methodNameIndex;
                int classIndex;
                int classNameIndex;
                if (!cpRefs.isMethodRef(i) || !cpRefs.utf8EqualsTo(classNameIndex = cpRefs.getClass_NameIndex(classIndex = cpRefs.getMethodRef_ClassIndex(i)), MethodRedirection.MAPPING[j][0].className) || !cpRefs.utf8EqualsTo(methodNameIndex = cpRefs.getNameAndType_NameIndex(methodNameAndTypeIndex = cpRefs.getMethodRef_NameAndTypeIndex(i)), MethodRedirection.MAPPING[j][0].methodName) || !cpRefs.utf8EqualsTo(methodDescriptorIndex = cpRefs.getNameAndType_DescriptorIndex(methodNameAndTypeIndex), MethodRedirection.MAPPING[j][0].methodDescriptor)) continue;
                if (retVal == null) {
                    retVal = new int[MethodRedirection.MAPPING.length];
                }
                retVal[j] = i;
            }
        }
        return retVal;
    }

    private static int getPoolEndPatchSize(int[] matches, int matchesCount, UtilityClasses utilClasses) {
        int i;
        int patchSize = 3 * (utilClasses.utilClassesRefactoring.to.length - 1);
        for (i = 1; i < utilClasses.utilClassesRefactoring.to.length; ++i) {
            patchSize += 3 + utilClasses.utilClassesRefactoring.to[i].length;
        }
        patchSize += 5 * matchesCount;
        patchSize += 5 * matchesCount;
        for (i = 0; i < matches.length; ++i) {
            if (matches[i] == 0) continue;
            patchSize += MethodRedirection.MAPPING[i][1].methodName.length + 3;
            patchSize += MethodRedirection.MAPPING[i][1].methodDescriptor.length + 3;
        }
        return patchSize;
    }

    private static byte[] renameUtilityClassName(byte[] processedClassName, byte[] oldUtilityClassName) {
        int packageLastPS = MethodsRedirectPatch.getLastPathSeparatorIndex(processedClassName);
        int packageLength = packageLastPS == -1 ? 0 : packageLastPS + 1;
        int oldUtilityClassNameLastPS = MethodsRedirectPatch.getLastPathSeparatorIndex(oldUtilityClassName);
        int oldUtilityClassSimpleNameLength = oldUtilityClassNameLastPS == -1 ? oldUtilityClassName.length : oldUtilityClassName.length - oldUtilityClassNameLastPS - 1;
        byte[] newUtilityClassName = new byte[packageLength + oldUtilityClassSimpleNameLength];
        if (packageLength > 0) {
            System.arraycopy(processedClassName, 0, newUtilityClassName, 0, packageLength);
        }
        System.arraycopy(oldUtilityClassName, oldUtilityClassNameLastPS + 1, newUtilityClassName, packageLength, oldUtilityClassSimpleNameLength);
        return newUtilityClassName;
    }

    private static Utf8InfoMapping getMappingForUtilityClassesRefactoring(int size, byte[][] tempFrom, byte[][] tempTo) {
        byte[][] from = new byte[size][];
        byte[][] to = new byte[size][];
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < tempTo.length; ++i) {
            if (tempTo[i] == null) continue;
            from[i + 1] = tempFrom[i];
            to[i + 1] = tempTo[i];
            if (min <= from[i + 1].length) continue;
            min = from[i + 1].length;
        }
        return new Utf8InfoMapping(from, to, min);
    }

    static class UtilityClasses {
        final Utf8InfoMapping utilClassesRefactoring;
        final int[] generatedClassPoolIndices;

        private UtilityClasses(Utf8InfoMapping utilClassesRefactoring, int[] generatedClassPoolIndices) {
            this.utilClassesRefactoring = utilClassesRefactoring;
            this.generatedClassPoolIndices = generatedClassPoolIndices;
        }
    }
}

