/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.transformer.nodeps;

import org.wildfly.extras.transformer.nodeps.ClassFileUtils;

final class ConstantPoolRefs {
    private static final int CONSTANT_POOL_SIZE_START_INDEX = 8;
    private static final int CONSTANT_POOL_ITEMS_START_INDEX = 10;
    private final byte[] clazz;
    private final int[] constantPool;
    private final int sizeStartRef;
    private final int itemsStartRef;
    private final int itemsEndRef;

    ConstantPoolRefs(byte[] clazz, int[] constantPool, int sizeStartRef, int itemsStartRef, int itemsEndRef) {
        this.clazz = clazz;
        this.constantPool = constantPool;
        this.sizeStartRef = sizeStartRef;
        this.itemsStartRef = itemsStartRef;
        this.itemsEndRef = itemsEndRef;
    }

    int[] getItemRefs() {
        return this.constantPool;
    }

    int getSizeStartRef() {
        return this.sizeStartRef;
    }

    int getSize() {
        return this.constantPool.length;
    }

    int getItemsStartRef() {
        return this.itemsStartRef;
    }

    int getItemsEndRef() {
        return this.itemsEndRef;
    }

    boolean isUtf8(int index) {
        return 1 == this.clazz[this.constantPool[index]];
    }

    boolean isString(int index) {
        return 8 == this.clazz[this.constantPool[index]];
    }

    int getString_IndexRef(int index) {
        if (!this.isString(index)) {
            throw new IllegalArgumentException();
        }
        return this.constantPool[index] + 1;
    }

    int getString_Index(int index) {
        return ClassFileUtils.readUnsignedShort(this.clazz, this.getString_IndexRef(index));
    }

    String getUtf8AsString(int index) {
        int utf8Length = this.getUtf8_Length(index);
        int utf8BytesStart = this.getUtf8_BytesRef(index);
        return ClassFileUtils.utf8ToString(this.clazz, utf8BytesStart, utf8BytesStart + utf8Length);
    }

    boolean utf8EqualsTo(int index, byte[] otherUtf8) {
        if (this.getUtf8_Length(index) != otherUtf8.length) {
            return false;
        }
        int utf8BytesRef = this.getUtf8_BytesRef(index);
        for (int i = 0; i < otherUtf8.length; ++i) {
            if (this.clazz[utf8BytesRef + i] == otherUtf8[i]) continue;
            return false;
        }
        return true;
    }

    int getUtf8_LengthRef(int index) {
        if (!this.isUtf8(index)) {
            throw new IllegalArgumentException();
        }
        return this.constantPool[index] + 1;
    }

    int getUtf8_BytesRef(int index) {
        if (!this.isUtf8(index)) {
            throw new IllegalArgumentException();
        }
        return this.constantPool[index] + 3;
    }

    int getUtf8_Length(int index) {
        return ClassFileUtils.readUnsignedShort(this.clazz, this.getUtf8_LengthRef(index));
    }

    boolean isNameAndType(int index) {
        return 12 == this.clazz[this.constantPool[index]];
    }

    int getNameAndType_NameIndexRef(int index) {
        if (!this.isNameAndType(index)) {
            throw new IllegalArgumentException();
        }
        return this.constantPool[index] + 1;
    }

    int getNameAndType_DescriptorIndexRef(int index) {
        if (!this.isNameAndType(index)) {
            throw new IllegalArgumentException();
        }
        return this.constantPool[index] + 3;
    }

    int getNameAndType_NameIndex(int index) {
        return ClassFileUtils.readUnsignedShort(this.clazz, this.getNameAndType_NameIndexRef(index));
    }

    int getNameAndType_DescriptorIndex(int index) {
        return ClassFileUtils.readUnsignedShort(this.clazz, this.getNameAndType_DescriptorIndexRef(index));
    }

    boolean isInterfaceMethodRef(int index) {
        return 11 == this.clazz[this.constantPool[index]];
    }

    int getInterfaceMethodRef_ClassIndexRef(int index) {
        if (!this.isInterfaceMethodRef(index)) {
            throw new IllegalArgumentException();
        }
        return this.constantPool[index] + 1;
    }

    int getInterfaceMethodRef_NameAndTypeIndexRef(int index) {
        if (!this.isInterfaceMethodRef(index)) {
            throw new IllegalArgumentException();
        }
        return this.constantPool[index] + 3;
    }

    int getInterfaceMethodRef_ClassIndex(int index) {
        return ClassFileUtils.readUnsignedShort(this.clazz, this.getInterfaceMethodRef_ClassIndexRef(index));
    }

    int getInterfaceMethodRef_NameAndTypeIndex(int index) {
        return ClassFileUtils.readUnsignedShort(this.clazz, this.getInterfaceMethodRef_NameAndTypeIndexRef(index));
    }

    boolean isMethodRef(int index) {
        return 10 == this.clazz[this.constantPool[index]];
    }

    int getMethodRef_ClassIndexRef(int index) {
        if (!this.isMethodRef(index)) {
            throw new IllegalArgumentException();
        }
        return this.constantPool[index] + 1;
    }

    int getMethodRef_NameAndTypeIndexRef(int index) {
        if (!this.isMethodRef(index)) {
            throw new IllegalArgumentException();
        }
        return this.constantPool[index] + 3;
    }

    int getMethodRef_ClassIndex(int index) {
        return ClassFileUtils.readUnsignedShort(this.clazz, this.getMethodRef_ClassIndexRef(index));
    }

    int getMethodRef_NameAndTypeIndex(int index) {
        return ClassFileUtils.readUnsignedShort(this.clazz, this.getMethodRef_NameAndTypeIndexRef(index));
    }

    boolean isClassInfo(int index) {
        return 7 == this.clazz[this.constantPool[index]];
    }

    int getClass_NameIndexRef(int index) {
        if (!this.isClassInfo(index)) {
            throw new IllegalArgumentException();
        }
        return this.constantPool[index] + 1;
    }

    int getClass_NameIndex(int index) {
        return ClassFileUtils.readUnsignedShort(this.clazz, this.getClass_NameIndexRef(index));
    }

    static ConstantPoolRefs of(byte[] clazz) {
        int constantPoolSize = ClassFileUtils.readUnsignedShort(clazz, 8);
        int cpItemsStartIndex = 10;
        int[] constantPool = new int[constantPoolSize];
        int position = 10;
        for (int i = 1; i < constantPoolSize; ++i) {
            byte tag;
            constantPool[i] = position;
            if ((tag = clazz[position++]) == 1) {
                int utf8Length = ClassFileUtils.readUnsignedShort(clazz, position);
                position += 2 + utf8Length;
                continue;
            }
            if (tag == 7 || tag == 8 || tag == 16 || tag == 19 || tag == 20) {
                position += 2;
                continue;
            }
            if (tag == 5 || tag == 6) {
                position += 8;
                ++i;
                continue;
            }
            if (tag == 3 || tag == 4 || tag == 9 || tag == 10 || tag == 11 || tag == 12 || tag == 17 || tag == 18) {
                position += 4;
                continue;
            }
            if (tag == 15) {
                position += 3;
                continue;
            }
            throw new UnsupportedClassVersionError();
        }
        int cpItemsEndIndex = position;
        return new ConstantPoolRefs(clazz, constantPool, 8, 10, cpItemsEndIndex);
    }
}

