/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.transformer.nodeps;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

final class JavaLangTransformUtils {
    private static final Map<String, String> MAPPINGS = new HashMap<String, String>();

    private JavaLangTransformUtils() {
    }

    private static String transform(String old) {
        if (old != null) {
            for (Map.Entry<String, String> mapping : MAPPINGS.entrySet()) {
                if (!old.startsWith(mapping.getKey())) continue;
                return mapping.getValue() + old.substring(mapping.getKey().length());
            }
        }
        return old;
    }

    static Class<?> Class_forName(String oldClassName) throws ClassNotFoundException {
        return Class.forName(JavaLangTransformUtils.transform(oldClassName));
    }

    static Class<?> Class_forName(String oldClassName, boolean initialize, ClassLoader loader) throws ClassNotFoundException {
        return Class.forName(JavaLangTransformUtils.transform(oldClassName), initialize, loader);
    }

    static URL ClassLoader_getResource(ClassLoader classLoader, String oldName) {
        return classLoader.getResource(JavaLangTransformUtils.transform(oldName));
    }

    static InputStream ClassLoader_getResourceAsStream(ClassLoader classLoader, String oldName) {
        return classLoader.getResourceAsStream(JavaLangTransformUtils.transform(oldName));
    }

    static Enumeration<URL> ClassLoader_getResources(ClassLoader classLoader, String oldName) throws IOException {
        return classLoader.getResources(JavaLangTransformUtils.transform(oldName));
    }

    static Class<?> ClassLoader_loadClass(ClassLoader classLoader, String oldName) throws ClassNotFoundException {
        return classLoader.loadClass(JavaLangTransformUtils.transform(oldName));
    }

    static URL ClassLoader_getSystemResource(String oldName) {
        return ClassLoader.getSystemResource(JavaLangTransformUtils.transform(oldName));
    }

    static InputStream ClassLoader_getSystemResourceAsStream(String oldName) {
        return ClassLoader.getSystemResourceAsStream(JavaLangTransformUtils.transform(oldName));
    }

    static Enumeration<URL> ClassLoader_getSystemResources(String oldName) throws IOException {
        return ClassLoader.getSystemResources(JavaLangTransformUtils.transform(oldName));
    }

    static {
        MAPPINGS.put("KEY", "VALUE");
    }
}

